/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillOrderUpdateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderUpdateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderUpdateAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderUpdateBusiRspBO;
import com.tydic.fsc.bo.FscOrderItemReqBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.common.ability.api.FscBusinessPendingTodoAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncEntrustNotificationAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSendNotificationService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncEntrustNotificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSendNotificationReqBO;
import com.tydic.fsc.common.ability.bo.FscTodoBusinessWaitDoneAddReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.TaxUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderUpdateAbilityService"})
public class FscBillOrderUpdateAbilityServiceImpl
implements FscBillOrderUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderUpdateAbilityServiceImpl.class);
    @Autowired
    private FscBillOrderUpdateBusiService fscBillOrderUpdateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscBusinessPendingTodoAbilityService fscBusinessPendingTodoAbilityService;
    private static final Integer DEALTYPE = 2;
    @Autowired
    private FscSyncSendNotificationService fscSyncSendNotificationService;
    @Autowired
    private FscSyncEntrustNotificationAbilityService fscSyncEntrustNotificationAbilityService;

    @PostMapping(value={"dealUpdate"})
    public FscBillOrderUpdateAbilityRspBO dealUpdate(@RequestBody FscBillOrderUpdateAbilityReqBO reqBO) {
        FscBillOrderUpdateAbilityRspBO rspBO = new FscBillOrderUpdateAbilityRspBO();
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (fscOrderPO == null) {
            rspBO.setRespDesc("198888");
            rspBO.setRespDesc("\u672a\u627e\u5230\u8be5\u7ed3\u7b97\u5355");
            return rspBO;
        }
        if (!FscConstants.FscInvoiceOrderState.DRAFT.equals(fscOrderPO.getOrderState())) {
            if ("1".equals(reqBO.getIsprofess()) && !FscConstants.FscInvoiceOrderState.ROLL_BACK.equals(fscOrderPO.getOrderState())) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u53ea\u6709\u8fd0\u8425\u9000\u56de\u72b6\u6001\u53ef\u4ee5\u4fee\u6539");
                return rspBO;
            }
            if ("0".equals(reqBO.getIsprofess()) && !FscConstants.FscInvoiceOrderState.APPROVAL_REJECT.equals(fscOrderPO.getOrderState())) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u53ea\u6709\u5ba1\u6279\u9a73\u56de\u72b6\u6001\u53ef\u4ee5\u4fee\u6539");
                return rspBO;
            }
        }
        FscBillOrderUpdateBusiReqBO fscBillOrderUpdateBusiReqBO = (FscBillOrderUpdateBusiReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillOrderUpdateBusiReqBO.class));
        this.dealInvoiceCheck(reqBO, fscBillOrderUpdateBusiReqBO);
        fscBillOrderUpdateBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        fscBillOrderUpdateBusiReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
        fscBillOrderUpdateBusiReqBO.setOrderSource(fscOrderPO.getOrderSource().toString());
        fscBillOrderUpdateBusiReqBO.setMakeType(fscOrderPO.getMakeType());
        fscBillOrderUpdateBusiReqBO.setReceiveType(fscOrderPO.getReceiveType());
        fscBillOrderUpdateBusiReqBO.setOrderType(fscOrderPO.getOrderType());
        fscBillOrderUpdateBusiReqBO.setPayType(fscOrderPO.getPayType());
        fscBillOrderUpdateBusiReqBO.setSettleType(fscOrderPO.getSettleType());
        FscBillOrderUpdateBusiRspBO fscBillOrderUpdateBusiRspBO = this.fscBillOrderUpdateBusiService.dealUpdate(fscBillOrderUpdateBusiReqBO);
        if (!CollectionUtils.isEmpty(fscBillOrderUpdateBusiRspBO.getNoticeOrderIds())) {
            for (Long noticeOrderId : fscBillOrderUpdateBusiRspBO.getNoticeOrderIds()) {
                FscSyncSendNotificationReqBO notificationReqBO = new FscSyncSendNotificationReqBO();
                notificationReqBO.setObjId(noticeOrderId);
                notificationReqBO.setUserId(reqBO.getUserId());
                notificationReqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.SALE_WAIT_AUDIT);
                this.fscSyncSendNotificationService.syncSendNotification(notificationReqBO);
            }
        }
        if (!CollectionUtils.isEmpty(fscBillOrderUpdateBusiRspBO.getAuditNoticeList())) {
            FscSyncEntrustNotificationAbilityReqBO abilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
            abilityReqBO.setApproveEntrustType(Integer.valueOf(1));
            abilityReqBO.setAuditNoticeList(fscBillOrderUpdateBusiRspBO.getAuditNoticeList());
            this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(abilityReqBO);
        }
        this.sendMq(reqBO);
        this.syncOrderStatus(reqBO);
        rspBO = (FscBillOrderUpdateAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)fscBillOrderUpdateBusiRspBO)), FscBillOrderUpdateAbilityRspBO.class);
        if ("0000".equals(fscBillOrderUpdateBusiRspBO.getRespCode())) {
            try {
                if (FscConstants.FscInvoiceOrderState.ROLL_BACK.equals(fscOrderPO.getOrderState())) {
                    this.addWaitDone(reqBO);
                }
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u63a8\u9001\u5f85\u529e\u5931\u8d25", (Throwable)e);
            }
        }
        return rspBO;
    }

    private void addWaitDone(FscBillOrderUpdateAbilityReqBO reqBO) {
        FscTodoBusinessWaitDoneAddReqBo fscTodoBusinessWaitDoneAddReqBo = new FscTodoBusinessWaitDoneAddReqBo();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if ("0".equals(fscOrderPO.getOrderType().toString())) {
            fscTodoBusinessWaitDoneAddReqBo.setBusiCode("1034");
        } else if ("2".equals(fscOrderPO.getOrderType().toString())) {
            fscTodoBusinessWaitDoneAddReqBo.setBusiCode("1035");
        }
        fscTodoBusinessWaitDoneAddReqBo.setObjId(String.valueOf(fscOrderPO.getFscOrderId()));
        fscTodoBusinessWaitDoneAddReqBo.setHandleOrgName(reqBO.getOrgName());
        fscTodoBusinessWaitDoneAddReqBo.setHandleOrgNo(reqBO.getOrgCodeIn());
        fscTodoBusinessWaitDoneAddReqBo.setHandleUserNo(String.valueOf(reqBO.getUserName()));
        fscTodoBusinessWaitDoneAddReqBo.setHandleUserName(reqBO.getName());
        fscTodoBusinessWaitDoneAddReqBo.setSubmitUserNo(String.valueOf(reqBO.getUserId()));
        fscTodoBusinessWaitDoneAddReqBo.setSubmitUserName(reqBO.getName());
        fscTodoBusinessWaitDoneAddReqBo.setUserId(reqBO.getUserId());
        this.fscBusinessPendingTodoAbilityService.addWaitDone(fscTodoBusinessWaitDoneAddReqBo);
    }

    private void syncOrderStatus(FscBillOrderUpdateAbilityReqBO reqBO) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        fscUocOrderRelUpdateAtomReqBO.setDealType(DEALTYPE);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }

    private void dealInvoiceCheck(FscBillOrderUpdateAbilityReqBO reqBO, FscBillOrderUpdateBusiReqBO busiReqBO) {
        ArrayList<FscOrderItemPO> fscOrderItemList = new ArrayList<FscOrderItemPO>();
        HashSet<Long> orderItemIdList = new HashSet<Long>();
        HashMap<Long, FscOrderItemPO> itemMap = new HashMap<Long, FscOrderItemPO>();
        ArrayList fscOrderRelationPOS = new ArrayList();
        ArrayList<Long> acceptOrderIds = new ArrayList<Long>();
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                boolean needUpdateAmt = false;
                for (FscOrderItemReqBO fscOrderItemReqBO : relOrderBO.getFscOrderItemBOList()) {
                    FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
                    BeanUtils.copyProperties((Object)fscOrderItemReqBO, (Object)fscOrderItemPO);
                    fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
                    fscOrderItemPO.setOrderItemId(fscOrderItemReqBO.getInspectionItemId());
                    fscOrderItemPO.setAcceptOrderId(relOrderBO.getAcceptOrderId());
                    fscOrderItemPO.setOrderId(relOrderBO.getOrderId());
                    if (fscOrderItemPO.getTaxRate() == null) {
                        throw new FscBusinessException("198888", "\u5165\u53c2\u7a0e\u7387[taxRate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    fscOrderItemPO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemPO.getAmt(), (BigDecimal)fscOrderItemPO.getTaxRate().divide(new BigDecimal(100))));
                    fscOrderItemPO.setUntaxAmt(fscOrderItemPO.getAmt().subtract(fscOrderItemPO.getTaxAmt()));
                    fscOrderItemList.add(fscOrderItemPO);
                    if (fscOrderItemReqBO.getNum() != null) {
                        needUpdateAmt = true;
                        itemMap.put(fscOrderItemReqBO.getInspectionItemId(), fscOrderItemPO);
                        orderItemIdList.add(fscOrderItemReqBO.getInspectionItemId());
                    }
                    if (fscOrderItemReqBO.getSalesUnitRate() == null) continue;
                    fscOrderItemPO.setSettleNum(fscOrderItemPO.getNum().multiply(fscOrderItemPO.getSalesUnitRate()));
                }
                if (!needUpdateAmt) continue;
                acceptOrderIds.add(relOrderBO.getAcceptOrderId());
            }
        }
        busiReqBO.setFscOrderItemPoList(fscOrderItemList);
        busiReqBO.setAcceptOrderIds(acceptOrderIds);
        if (CollectionUtils.isEmpty(itemMap)) {
            return;
        }
        BigDecimal totalCharge = ((SplitOrderBO)reqBO.getSplitOrderList().get(0)).getAmount();
        busiReqBO.setTotalCharge(totalCharge);
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setOrderItemIdSets(orderItemIdList);
        orderItemPO.setExceptFscOrderId(reqBO.getFscOrderId());
        List checkList = this.fscOrderItemMapper.getCheckList(orderItemPO);
        for (FscOrderItemPO itemPO : checkList) {
            FscOrderItemPO fscOrderItemPO = (FscOrderItemPO)itemMap.get(itemPO.getOrderItemId());
            if (fscOrderItemPO == null) {
                throw new FscBusinessException("198888", "\u65e0\u5339\u914d\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\uff01");
            }
            if (fscOrderItemPO.getTotalNum().subtract(itemPO.getNum()).compareTo(fscOrderItemPO.getNum()) < 0) {
                throw new FscBusinessException("198888", "\u8ba2\u5355\u660e\u7ec6\u884c[" + itemPO.getOrderItemId() + "]\u672c\u6b21\u63d0\u7968\u6570\u91cf\u8d85\u8fc7\u53ef\u63d0\u7968\u6570\u91cf\uff01");
            }
            if (fscOrderItemPO.getTotalAmt().subtract(itemPO.getAmt()).compareTo(fscOrderItemPO.getAmt()) >= 0) continue;
            throw new FscBusinessException("198888", "\u8ba2\u5355\u660e\u7ec6\u884c[" + itemPO.getOrderItemId() + "]\u672c\u6b21\u63d0\u7968\u6570\u91cf\u8d85\u8fc7\u53ef\u63d0\u7968\u6570\u91cf\uff01");
        }
    }

    private void val(FscBillOrderUpdateAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType() || reqBO.getOperType() != 0 && reqBO.getOperType() != 1) {
            throw new FscBusinessException("191000", "\u5165\u53c2[operType]\u64cd\u4f5c\u7c7b\u578b\u53ea\u80fd\u4e3a0\u62161");
        }
    }

    private void sendMq(FscBillOrderUpdateAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

