/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundCreateAbilityRspBO;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceRefundPayTempQryAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceRefundPayTempQryAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceRefundPayTempQryAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundCreateBusiService;
import com.tydic.fsc.bill.busi.api.finance.FscFinanceRefundDeleteTempBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundCreateBusiRspBO;
import com.tydic.fsc.bill.busi.bo.finance.FscFinanceDeleteRefundTempBusiBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscFinanceRefundItemBO;
import com.tydic.fsc.bo.FscPayRefundShouldBO;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscBusinessPendingTodoAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPushTodoAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncEntrustNotificationAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSendNotificationService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushTodoAbilityServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscPushTodoAbilityServiceRspBO;
import com.tydic.fsc.common.ability.bo.FscSyncEntrustNotificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSendNotificationReqBO;
import com.tydic.fsc.common.ability.bo.FscTodoBusinessWaitDoneAddReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPayRefundCreateAbilityService"})
public class FscBillPayRefundCreateAbilityServiceImpl
implements FscBillPayRefundCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundCreateAbilityServiceImpl.class);
    @Autowired
    private FscBillPayRefundCreateBusiService fscBillPayRefundCreateBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscFinanceRefundPayTempQryAtomService fscFinanceRefundPayTempQryAtomService;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long operationSupId;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscBusinessPendingTodoAbilityService fscBusinessPendingTodoAbilityService;
    @Autowired
    private FscPushTodoAbilityService fscPushTodoAbilityService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscSyncSendNotificationService fscSyncSendNotificationService;
    @Autowired
    private FscSyncEntrustNotificationAbilityService fscSyncEntrustNotificationAbilityService;
    @Autowired
    private FscFinanceRefundDeleteTempBusiService fscFinanceRefundDeleteTempBusiService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;

    @PostMapping(value={"dealPayRefundCreate"})
    public FscBillPayRefundCreateAbilityRspBO dealPayRefundCreate(@RequestBody FscBillPayRefundCreateAbilityReqBO reqBO) {
        if (reqBO.getTempId() != null) {
            this.qryTempInfo(reqBO);
        }
        this.valid(reqBO);
        FscBillPayRefundCreateBusiReqBO fscBillPayRefundCreateBusiReqBO = (FscBillPayRefundCreateBusiReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillPayRefundCreateBusiReqBO.class));
        FscBillPayRefundCreateBusiRspBO fscBillPayRefundCreateBusiRspBO = this.fscBillPayRefundCreateBusiService.dealPayRefundCreate(fscBillPayRefundCreateBusiReqBO);
        if (!"0000".equals(fscBillPayRefundCreateBusiRspBO.getRespCode())) {
            return (FscBillPayRefundCreateAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)fscBillPayRefundCreateBusiRspBO)), FscBillPayRefundCreateAbilityRspBO.class);
        }
        if (fscBillPayRefundCreateBusiRspBO.getRefundId() != null) {
            this.syncEs(fscBillPayRefundCreateBusiRspBO);
        }
        if (reqBO.getTempId() != null) {
            FscFinanceDeleteRefundTempBusiBO fscFinanceDeleteRefundTempBusiBO = new FscFinanceDeleteRefundTempBusiBO();
            fscFinanceDeleteRefundTempBusiBO.setTempId(reqBO.getTempId());
            this.fscFinanceRefundDeleteTempBusiService.deleteFinanceRefundTemp(fscFinanceDeleteRefundTempBusiBO);
        }
        if (reqBO.getOperationType() == 1) {
            try {
                this.sendTodoNotice(reqBO, fscBillPayRefundCreateBusiRspBO);
            }
            catch (Exception e) {
                log.error("\u9000\u6b3e\u7533\u8bf7\u5355\u5f85\u529e\u63a8\u9001\u5931\u8d25", (Throwable)e);
            }
        }
        FscBillPayRefundCreateAbilityRspBO rspBO = new FscBillPayRefundCreateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendTodoNotice(FscBillPayRefundCreateAbilityReqBO reqBO, FscBillPayRefundCreateBusiRspBO busiRspBO) {
        try {
            FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
            fscOrderRefundPO.setRefundId(busiRspBO.getRefundId());
            fscOrderRefundPO = this.fscOrderRefundMapper.getModelBy(fscOrderRefundPO);
            this.inboxNotify(reqBO, fscOrderRefundPO);
            this.todoNotify(fscOrderRefundPO);
            this.sendDelegationNotify(reqBO, busiRspBO);
            this.addWaitDone(reqBO, busiRspBO);
        }
        catch (Exception e) {
            log.error("dealPayBillCreate -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Object)e.getMessage());
        }
    }

    private void sendDelegationNotify(FscBillPayRefundCreateAbilityReqBO reqBO, FscBillPayRefundCreateBusiRspBO busiRspBO) {
        for (Long fscOrderId : busiRspBO.getFscOrderIds()) {
            FscSyncSendNotificationReqBO notificationReqBO = new FscSyncSendNotificationReqBO();
            notificationReqBO.setUserId(reqBO.getUserId());
            notificationReqBO.setObjId(fscOrderId);
            notificationReqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.FINANCE_REFUND);
            this.fscSyncSendNotificationService.syncSendNotification(notificationReqBO);
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList())) {
            FscSyncEntrustNotificationAbilityReqBO abilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
            abilityReqBO.setApproveEntrustType(Integer.valueOf(17));
            abilityReqBO.setAuditNoticeList(busiRspBO.getAuditNoticeList());
            this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(abilityReqBO);
        }
    }

    private void todoNotify(FscOrderRefundPO fscOrderRefundPO) {
        log.info("\u91c7\u8d2d\u9000\u6b3e\u7533\u8bf7\u5355\u5f85\u529e\u63a8\u9001===========>obj_id:{}", (Object)fscOrderRefundPO.getFscOrderId());
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderRefundPO.getSettlePlatform())) {
            return;
        }
        try {
            FscPushTodoAbilityServiceReqBO fscPushTodoAbilityServiceReqBO = new FscPushTodoAbilityServiceReqBO();
            fscPushTodoAbilityServiceReqBO.setBusiCode("1310");
            fscPushTodoAbilityServiceReqBO.setBusiName("\u91c7\u8d2d\u9000\u6b3e\u5ba1\u6279\u5355");
            fscPushTodoAbilityServiceReqBO.setObjId(fscOrderRefundPO.getRefundId());
            fscPushTodoAbilityServiceReqBO.setOperatorType(TaskWaitDoneEnum.PUSH_TODO_OPERATOR_SUBMIT);
            FscPushTodoAbilityServiceRspBO fscPushTodoAbilityServiceRspBO = this.taskTodoWaitService.dealPushTodoHandler(fscPushTodoAbilityServiceReqBO);
            if (!"0000".equals(fscPushTodoAbilityServiceRspBO.getRespCode())) {
                throw new FscBusinessException(fscPushTodoAbilityServiceRspBO.getRespCode(), fscPushTodoAbilityServiceRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u9000\u6b3e\u7533\u8bf7\u63d0\u4ea4|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u9000\u6b3e\u7533\u8bf7\u63d0\u4ea4\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void inboxNotify(FscBillPayRefundCreateAbilityReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderRefundPO.getSettlePlatform())) {
            return;
        }
        Map busiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_TYPE");
        String busiTypeStr = (String)busiTypeMap.get(String.valueOf(fscOrderRefundPO.getOrderType()));
        FscTaskCandidatePO taskCandidatePO = new FscTaskCandidatePO();
        taskCandidatePO.setFscOrderId(fscOrderRefundPO.getFscOrderId());
        List fscApprovalTaskQueryBOList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskCandidatePO);
        if (CollectionUtils.isEmpty((Collection)fscApprovalTaskQueryBOList)) {
            return;
        }
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)fscApprovalTaskQueryBOList.get(0)).getTaskOperId()));
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO.setTitel(fscOrderRefundPO.getRefundNo() + "\u9000\u6b3e\u7533\u8bf7\u5355_" + "_" + busiTypeStr + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9000\u6b3e\u7533\u8bf7\u5355" + fscOrderRefundPO.getRefundNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u9000\u6b3e\u7533\u8bf7|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u9000\u6b3e\u7533\u8bf7\u901a\u77e5\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void addWaitDone(FscBillPayRefundCreateAbilityReqBO reqBO, FscBillPayRefundCreateBusiRspBO busiRspBO) {
        FscTodoBusinessWaitDoneAddReqBo fscTodoBusinessWaitDoneAddReqBo = new FscTodoBusinessWaitDoneAddReqBo();
        fscTodoBusinessWaitDoneAddReqBo.setBusiCode("2003");
        fscTodoBusinessWaitDoneAddReqBo.setHandleOrgName(reqBO.getOrgName());
        fscTodoBusinessWaitDoneAddReqBo.setHandleOrgNo(reqBO.getOrgCodeIn());
        fscTodoBusinessWaitDoneAddReqBo.setHandleUserNo(String.valueOf(reqBO.getUserName()));
        fscTodoBusinessWaitDoneAddReqBo.setHandleUserName(reqBO.getName());
        fscTodoBusinessWaitDoneAddReqBo.setSubmitUserNo(String.valueOf(reqBO.getUserId()));
        fscTodoBusinessWaitDoneAddReqBo.setSubmitUserName(reqBO.getName());
        fscTodoBusinessWaitDoneAddReqBo.setObjId(String.valueOf(busiRspBO.getRefundId()));
        this.fscBusinessPendingTodoAbilityService.addWaitDone(fscTodoBusinessWaitDoneAddReqBo);
    }

    private void qryTempInfo(FscBillPayRefundCreateAbilityReqBO reqBO) {
        FscFinanceRefundPayTempQryAtomReqBO atomReqBO = new FscFinanceRefundPayTempQryAtomReqBO();
        atomReqBO.setTempId(reqBO.getTempId());
        FscFinanceRefundPayTempQryAtomRspBO atomRspBO = this.fscFinanceRefundPayTempQryAtomService.qryTempInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4e34\u65f6\u8868\u4fe1\u606f\u5931\u8d25:" + atomRspBO.getRespDesc());
        }
        reqBO.setFinanceItemList(atomRspBO.getFinanceItemList());
        reqBO.setFileList(atomRspBO.getFileList());
        reqBO.setFscRefundShouldPayBOS(atomRspBO.getFscRefundShouldPayBOS());
        reqBO.setRefundAmount(atomRspBO.getFinanceItemList().stream().map(FscFinanceRefundItemBO::getRefundAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    private void syncEs(FscBillPayRefundCreateBusiRspBO busiRspBO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(busiRspBO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private void valid(FscBillPayRefundCreateAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getCwOrgId())) {
            throw new FscBusinessException("191000", "erp\u7f16\u7801[cwOrgid]\u4e0d\u80fd\u7a7a");
        }
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRefundNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundDate() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundReasonType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundReasonType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundAmount() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u6b3e\u91d1\u989d[refundAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getUserType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[userType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (FscConstants.RefundUserType.PURCHASE.equals(reqBO.getUserType()) && ("0".equals(reqBO.getIsprofess()) || this.operationSupId.equals(reqBO.getOrgId()))) {
            if (reqBO.getAgentUserId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getAgentUserName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getAgentDeptId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getAgentDeptName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscRefundShouldPayBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscRefundShouldPayBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFinanceItemList())) {
            BigDecimal refundAmt = BigDecimal.ZERO;
            for (FscFinanceRefundItemBO itemBO : reqBO.getFinanceItemList()) {
                refundAmt = refundAmt.add(itemBO.getRefundAmt());
                if (itemBO.getRefundAmt() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u6b3e\u660e\u7ec6\u7533\u8bf7\u9000\u6b3e\u91d1\u989d[fscFinanceRefundItemBO.refundAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (itemBO.getRefundAmt().compareTo(BigDecimal.ZERO) == 0) {
                    throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u6b3e\u660e\u7ec6\u7533\u8bf7\u9000\u6b3e\u91d1\u989d[fscFinanceRefundItemBO.refundAmt]\u4e0d\u80fd\u4e3a0\uff01");
                }
                if (itemBO.getRefundAmtLocal() != null) continue;
                throw new FscBusinessException("198888", "\u5165\u53c2[fscFinanceRefundItemBO.refundAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (refundAmt.compareTo(((FscPayRefundShouldBO)reqBO.getFscRefundShouldPayBOS().get(0)).getRefundAmt()) != 0 || refundAmt.compareTo(reqBO.getRefundAmount()) != 0) {
                throw new FscBusinessException("198888", "\u9000\u6b3e\u660e\u7ec6\u884c\u5408\u8ba1\u9000\u6b3e\u91d1\u989d\u548c\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getFinanceOrgId()) && CollectionUtils.isEmpty((Collection)reqBO.getFinanceItemList())) {
            throw new FscBusinessException("198888", "\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u9000\u6b3e\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

