/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.contract.ability.FscFinanceSelectContractAmountAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountReqBO;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBoList;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundDetailAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPayOrderBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundDetailAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundDetailAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscOrderRefundBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscContractPlanItemBO;
import com.tydic.fsc.bo.FscPayClaimRefundBO;
import com.tydic.fsc.bo.FscPayRefundDetailBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComRefundDetailAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundDetailAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundDetailAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscContractInfoBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceCapitalPlanQryRefundDetailRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayClaimRefundDetailMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscPlanPayItemMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.enums.FscPostingStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanTempPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPayClaimRefundDetailPO;
import com.tydic.fsc.po.FscPayClaimRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscPlanPayItemPo;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPayRefundDetailAbilityService"})
public class FscBillPayRefundDetailAbilityServiceImpl
implements FscBillPayRefundDetailAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundDetailAbilityServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscPayClaimRefundDetailMapper fscPayClaimRefundDetailMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscComRefundDetailAbilityService fscComRefundDetailAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscPlanPayItemMapper fscPlanPayItemMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscFinanceSelectContractAmountAbilityService fscFinanceSelectContractAmountAbilityService;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;

    @PostMapping(value={"dealPayRefundDetail"})
    public FscBillPayRefundDetailAbilityRspBO dealPayRefundDetail(@RequestBody FscBillPayRefundDetailAbilityReqBO reqBO) {
        FscBillPayRefundDetailAbilityRspBO rspBO = new FscBillPayRefundDetailAbilityRspBO();
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderRefundPO fscOrderRefundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        if (fscOrderRefundPO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355");
        }
        List fscPayRefundDetailList = this.fscPayRefundDetailMapper.queryByRefundId(reqBO.getRefundId());
        Long refundShouldPayId = ((FscPayRefundDetailPO)fscPayRefundDetailList.get(0)).getRefundShouldPayId();
        FscPayShouldRefundPO fscPayShouldRefundPO = this.fscPayShouldRefundMapper.queryById(refundShouldPayId);
        for (FscPayRefundDetailPO fscPayRefundDetailPO : fscPayRefundDetailList) {
            fscPayRefundDetailPO.setTotalRefundAmt(fscPayShouldRefundPO.getRefundAmount());
            if (fscPayRefundDetailPO.getClaimType() != null) {
                fscPayRefundDetailPO.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)fscPayRefundDetailPO.getClaimType()));
            }
            FscPlanPayItemPo fscPlanPayItemPo = new FscPlanPayItemPo();
            fscPlanPayItemPo.setShouldPayId(fscPayRefundDetailPO.getRefundShouldPayId());
            fscPlanPayItemPo.setFscOrderId(reqBO.getRefundId());
            Object planPayItemList = new ArrayList();
            planPayItemList = this.fscPlanPayItemMapper.getOperatePlanPayList(fscPlanPayItemPo);
            if (CollectionUtils.isEmpty(planPayItemList)) continue;
            fscPayRefundDetailPO.setPlanItemBOs(JSON.parseArray((String)JSONObject.toJSONString(planPayItemList), FscContractPlanItemBO.class));
        }
        List refundDetailBOList = JSON.parseArray((String)JSONObject.toJSONString((Object)fscPayRefundDetailList), FscPayRefundDetailBO.class);
        if (FscConstants.OrderFlow.ENGINEERING_SERVICE_REFUND.equals(fscOrderRefundPO.getOrderFlow())) {
            this.buildBankInfoForEng(refundDetailBOList, fscPayShouldRefundPO.getRefundMethod());
        }
        rspBO.setFscRefundShouldPayBOS(refundDetailBOList);
        fscOrderRefundPO.setClaimAmt(((FscPayRefundDetailPO)fscPayRefundDetailList.get(0)).getClaimAmt());
        if (fscPayShouldRefundPO.getPayOrderId() != null) {
            rspBO.setPayOrderInfo(this.queryPayOrderInfo(Collections.singletonList(fscPayShouldRefundPO.getPayOrderId())));
        }
        if (fscPayShouldRefundPO.getRefundId() != null) {
            FscComRefundDetailAbilityReqBO fscComRefundDetailAbilityReqBO = new FscComRefundDetailAbilityReqBO();
            fscComRefundDetailAbilityReqBO.setRefundId(fscPayShouldRefundPO.getRefundId());
            FscComRefundDetailAbilityRspBO fscComRefundDetailAbilityRspBO = this.fscComRefundDetailAbilityService.qryRefundDetail(fscComRefundDetailAbilityReqBO);
            if ("0000".equals(fscComRefundDetailAbilityRspBO.getRespCode())) {
                rspBO.setRefundOrderInfo(fscComRefundDetailAbilityRspBO);
            }
        }
        List fscPayClaimRefundList = this.fscPayClaimRefundMapper.queryByRefundId(reqBO.getRefundId());
        rspBO.setFscClaimDetailBOS(JSON.parseArray((String)JSONObject.toJSONString((Object)fscPayClaimRefundList), FscPayClaimRefundBO.class));
        if (!CollectionUtils.isEmpty((Collection)fscPayClaimRefundList) && fscOrderRefundPO.getUserType() == 1) {
            StringBuilder claimNo = new StringBuilder();
            for (FscPayClaimRefundPO fscPayClaimRefundPO : fscPayClaimRefundList) {
                String[] claimNos;
                if (StringUtils.isEmpty((Object)fscPayClaimRefundPO.getClaimNo())) continue;
                for (String s : claimNos = fscPayClaimRefundPO.getClaimNo().split(",")) {
                    if (claimNo.toString().contains(s)) continue;
                    claimNo.append(s).append(",");
                }
            }
            if (!StringUtils.isEmpty((Object)claimNo.toString()) && claimNo.toString().endsWith(",")) {
                fscOrderRefundPO.setClaimNo(claimNo.substring(0, claimNo.length() - 1));
            }
            FscPayClaimRefundDetailPO fscPayClaimRefundDetailPO = new FscPayClaimRefundDetailPO();
            fscPayClaimRefundDetailPO.setRefundId(reqBO.getRefundId());
            List claimRefundDetailPOList = this.fscPayClaimRefundDetailMapper.getClaimInfoByRefundId(fscPayClaimRefundDetailPO);
            List<Long> payOrderIdList = claimRefundDetailPOList.stream().filter(e -> e.getPayOrderId() != null).map(FscPayClaimRefundDetailPO::getPayOrderId).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(payOrderIdList)) {
                rspBO.setPayOrderInfo(this.queryPayOrderInfo(payOrderIdList));
            }
        }
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(fscOrderRefundPO.getRefundId());
        attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY);
        List list = this.fscAttachmentMapper.getList(attachmentPO);
        List fileList = new ArrayList(list.size());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            fileList = JSON.parseArray((String)JSONObject.toJSONString((Object)list), AttachmentBO.class);
        }
        rspBO.setAttachmentList(fileList);
        fileList = new ArrayList();
        attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY_CREDENTIALS);
        list = this.fscAttachmentMapper.getList(attachmentPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            fileList = JSON.parseArray((String)JSONObject.toJSONString((Object)list), AttachmentBO.class);
        }
        rspBO.setVoucherList(fileList);
        Map refundTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_TYPE");
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        fscOrderRefundPO.setRefundReasonTypeStr((String)refundTypeMap.get(fscOrderRefundPO.getRefundReasonType() + ""));
        fscOrderRefundPO.setOrderTypeStr((String)orderTypeMap.get(fscOrderRefundPO.getOrderType() + ""));
        FscOrderRefundBO fscOrderRefundBO = (FscOrderRefundBO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderRefundPO), FscOrderRefundBO.class);
        fscOrderRefundBO.setRefundMethod(fscPayShouldRefundPO.getRefundMethod());
        if (!StringUtils.isEmpty((Object)fscPayShouldRefundPO.getContractType())) {
            Map engContractTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FINANCE_ENGINEERING_CONTRACT_TYPE");
            fscOrderRefundBO.setContractType(fscPayShouldRefundPO.getContractType());
            fscOrderRefundBO.setContractTypeStr((String)engContractTypeMap.get(fscPayShouldRefundPO.getContractType()));
        }
        if (!StringUtils.isEmpty((Object)fscPayShouldRefundPO.getBusinessType())) {
            Map businessTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FINANCE_ENGINEERING_BUSINESS_TYPE");
            fscOrderRefundBO.setBusinessType(fscPayShouldRefundPO.getBusinessType());
            fscOrderRefundBO.setBusinessTypeStr((String)businessTypeMap.get(fscPayShouldRefundPO.getBusinessType().toString()));
        }
        this.buildFinanceOrder(reqBO.getRefundId(), fscOrderRefundBO, fscPayShouldRefundPO);
        List<FscContractInfoBO> contractList = this.queryContractInfo(fscPayShouldRefundPO, reqBO);
        rspBO.setContractList(contractList);
        List<FscFinanceCapitalPlanQryRefundDetailRspBO> capitalPlanQryRefundDetailRsp = this.queryCapitalPlan(fscPayShouldRefundPO, reqBO);
        rspBO.setCapitalPlanList(capitalPlanQryRefundDetailRsp);
        rspBO.setRefundInfo(fscOrderRefundBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildBankInfoForEng(List<FscPayRefundDetailBO> refundDetailBOList, String type) {
        Map<Long, List<FscFinancePayItemPO>> fscOrderIdMap = null;
        if (FscConstants.PaymentMethod.PRE_PAY.toString().equals(type)) {
            FscFinancePayItemPO itemPO = new FscFinancePayItemPO();
            itemPO.setFscOrderIds(refundDetailBOList.stream().map(FscPayRefundDetailBO::getFscOrderId).collect(Collectors.toList()));
            fscOrderIdMap = this.fscFinancePayItemMapper.getList(itemPO).stream().collect(Collectors.groupingBy(FscFinancePayItemPO::getFscOrderId));
        } else if (FscConstants.PaymentMethod.SHOULD_PAY.toString().equals(type)) {
            Set ids = refundDetailBOList.stream().map(FscPayRefundDetailBO::getRefundShouldPayId).collect(Collectors.toSet());
            fscOrderIdMap = this.fscFinancePayItemMapper.getBankInfoByRefundShouldPayId(ids).stream().collect(Collectors.groupingBy(FscFinancePayItemPO::getRefundShouldPayId));
        }
        if (CollectionUtils.isEmpty(fscOrderIdMap)) {
            return;
        }
        Map financePayMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_METHOD");
        for (FscPayRefundDetailBO detailBO : refundDetailBOList) {
            List<FscFinancePayItemPO> itemPOList = fscOrderIdMap.get(FscConstants.PaymentMethod.SHOULD_PAY.toString().equals(type) ? detailBO.getRefundShouldPayId() : detailBO.getFscOrderId());
            if (CollectionUtils.isEmpty(itemPOList)) continue;
            FscFinancePayItemPO po = itemPOList.get(0);
            detailBO.setBankRemark(po.getBankRemark());
            detailBO.setPayerBankAccountNum(po.getPayerBankAccountNum());
            detailBO.setPayerBankCode(po.getPayerBankCode());
            detailBO.setPayerBankName(po.getPayerBankName());
            detailBO.setRecvBankAccount(po.getRecvBankAccount());
            detailBO.setRecvBankAccountCode(po.getRecvBankAccountCode());
            detailBO.setRecvBankAccountName(po.getRecvBankAccountName());
            detailBO.setPayerLinkBankCode(po.getPayerLinkBankCode());
            detailBO.setRecvBankName(po.getRecvBankName());
            detailBO.setRecvBankCode(po.getRecvBankCode());
            detailBO.setFinancePayMethodStr((String)financePayMethodMap.get(po.getFinancePayMethod()));
        }
    }

    private List<FscFinanceCapitalPlanQryRefundDetailRspBO> queryCapitalPlan(FscPayShouldRefundPO fscPayShouldRefundPO, FscBillPayRefundDetailAbilityReqBO reqBO) {
        ArrayList<FscFinanceCapitalPlanQryRefundDetailRspBO> capitalPlanQryRsp = new ArrayList<FscFinanceCapitalPlanQryRefundDetailRspBO>();
        Long refundId = reqBO.getRefundId();
        String refundMethod = fscPayShouldRefundPO.getRefundMethod();
        if ("0".equals(refundMethod)) {
            FscFinanceCapitalPlanPO fscFinanceCapitalPlanPO = new FscFinanceCapitalPlanPO();
            fscFinanceCapitalPlanPO.setRefundId(refundId);
            List list = this.fscFinanceCapitalPlanMapper.getList(fscFinanceCapitalPlanPO);
            if (CollUtil.isEmpty((Collection)list)) {
                return capitalPlanQryRsp;
            }
            return JSON.parseArray((String)JSON.toJSONString((Object)list), FscFinanceCapitalPlanQryRefundDetailRspBO.class);
        }
        if ("2".equals(refundMethod)) {
            FscFinanceCapitalPlanTempPO capitalPlanTempPO = new FscFinanceCapitalPlanTempPO();
            capitalPlanTempPO.setRefundId(refundId);
            capitalPlanTempPO.setTempId(reqBO.getTempId());
            List list = this.fscFinanceCapitalPlanTempMapper.getList(capitalPlanTempPO);
            return JSON.parseArray((String)JSON.toJSONString((Object)list), FscFinanceCapitalPlanQryRefundDetailRspBO.class);
        }
        return capitalPlanQryRsp;
    }

    private List<FscContractInfoBO> queryContractInfo(FscPayShouldRefundPO fscPayShouldRefundPO, FscBillPayRefundDetailAbilityReqBO reqBO) {
        ArrayList<FscContractInfoBO> contractList = new ArrayList<FscContractInfoBO>();
        if (fscPayShouldRefundPO == null) {
            return contractList;
        }
        if (fscPayShouldRefundPO.getRefundId() == null) {
            FscContractInfoBO fscContractInfoBO = new FscContractInfoBO();
            fscContractInfoBO.setContractId(fscPayShouldRefundPO.getContractId());
            fscContractInfoBO.setContractCode(fscPayShouldRefundPO.getContractNo());
            fscContractInfoBO.setContractName(fscPayShouldRefundPO.getContractName());
            FscOrderFinancePO fscOrderFinanceReq = new FscOrderFinancePO();
            fscOrderFinanceReq.setFscOrderId(fscPayShouldRefundPO.getFscOrderId());
            FscOrderFinancePO fscOrderFinance = this.fscOrderFinanceMapper.getModelBy(fscOrderFinanceReq);
            if (fscOrderFinance != null) {
                fscContractInfoBO.setContractSegmentCode(fscOrderFinance.getContractSegmentCode());
                fscContractInfoBO.setContractSegmentName(fscOrderFinance.getContractSegmentName());
            }
            FscFinanceSelectContractAmountReqBO selectContractAmountReqBO = new FscFinanceSelectContractAmountReqBO();
            selectContractAmountReqBO.setContractIds((List)Lists.newArrayList((Object[])new Long[]{fscPayShouldRefundPO.getContractId()}));
            FscFinanceSelectContractAmountRspBo contractAmountRspBo = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(selectContractAmountReqBO);
            if (!contractAmountRspBo.getRespCode().equals("0000")) {
                throw new FscBusinessException("198888", contractAmountRspBo.getRespDesc());
            }
            List rows = contractAmountRspBo.getRows();
            Optional<FscFinanceSelectContractAmountRspBoList> first = rows.stream().filter(e -> ObjectUtil.equal((Object)e.getContractId(), (Object)fscPayShouldRefundPO.getContractId())).findFirst();
            first.ifPresent(e -> fscContractInfoBO.setContractAmount(e.getContractAmount()));
            fscContractInfoBO.setOrderNum(Integer.valueOf(1));
            contractList.add(fscContractInfoBO);
        } else {
            FscFinanceRefundItemPO fscFinanceRefundItemPO = new FscFinanceRefundItemPO();
            fscFinanceRefundItemPO.setRefundId(reqBO.getRefundId());
            List list = this.fscFinanceRefundItemMapper.getList(fscFinanceRefundItemPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List contractInfoList = list.stream().filter(e -> ObjectUtil.isNotNull((Object)e.getContractId())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FscFinanceRefundItemPO>(Comparator.comparing(FscFinanceRefundItemPO::getContractId))), ArrayList::new));
                List refundDetailIds = contractInfoList.stream().map(FscFinanceRefundItemPO::getRefundDetailId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List contractIds = contractInfoList.stream().map(FscFinanceRefundItemPO::getContractId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (CollUtil.isEmpty(contractIds)) {
                    return contractList;
                }
                Map<Object, Object> orderRelationMap = new HashMap();
                if (CollUtil.isNotEmpty(refundDetailIds)) {
                    FscPayRefundDetailPO fscPayRefundDetailPO = new FscPayRefundDetailPO();
                    fscPayRefundDetailPO.setRefundDetailIds(refundDetailIds);
                    List detailMapperList = this.fscPayRefundDetailMapper.getList(fscPayRefundDetailPO);
                    List fscOrderIds = detailMapperList.stream().map(FscPayRefundDetailPO::getFscOrderId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (CollUtil.isNotEmpty(fscOrderIds)) {
                        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
                        fscOrderRelationPO.setFscOrderIds(fscOrderIds);
                        fscOrderRelationPO.setContractIds(contractIds);
                        List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
                        orderRelationMap = fscOrderRelationPOS.stream().collect(Collectors.toMap(FscOrderRelationPO::getContractId, Function.identity(), (existing, replacement) -> replacement));
                    }
                }
                List contractAmountList = new ArrayList();
                if (!CollectionUtils.isEmpty(contractIds)) {
                    FscFinanceSelectContractAmountReqBO selectContractAmountReqBO = new FscFinanceSelectContractAmountReqBO();
                    selectContractAmountReqBO.setContractIds(contractIds);
                    FscFinanceSelectContractAmountRspBo contractAmountRspBo = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(selectContractAmountReqBO);
                    if (!contractAmountRspBo.getRespCode().equals("0000")) {
                        throw new FscBusinessException("198888", contractAmountRspBo.getRespDesc());
                    }
                    contractAmountList = contractAmountRspBo.getRows();
                }
                Map contractAmountMap = contractAmountList.stream().collect(Collectors.toMap(FscFinanceSelectContractAmountRspBoList::getContractId, Function.identity()));
                List countOrderIdByRefundIdList = this.fscOrderRelationMapper.findCountOrderIdByRefundId(fscPayShouldRefundPO.getRefundId(), contractIds);
                for (FscFinanceRefundItemPO financeRefundItemPO : contractInfoList) {
                    FscFinanceSelectContractAmountRspBoList contractAmountRspBoList;
                    FscContractInfoBO fscContractInfoBO = new FscContractInfoBO();
                    fscContractInfoBO.setContractId(financeRefundItemPO.getContractId());
                    fscContractInfoBO.setContractCode(financeRefundItemPO.getContractNo());
                    fscContractInfoBO.setContractName(financeRefundItemPO.getContractName());
                    FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)orderRelationMap.get(financeRefundItemPO.getContractId());
                    if (fscOrderRelationPO != null) {
                        fscContractInfoBO.setContractSegmentCode(fscOrderRelationPO.getContractSegmentCode());
                        fscContractInfoBO.setContractSegmentName(fscOrderRelationPO.getContractSegmentName());
                        fscContractInfoBO.setEstimateBillCode(fscOrderRelationPO.getEstimateBillCode());
                        fscContractInfoBO.setEstimateBillGuid(fscOrderRelationPO.getEstimateBillGuid());
                    }
                    if ((contractAmountRspBoList = (FscFinanceSelectContractAmountRspBoList)contractAmountMap.get(financeRefundItemPO.getContractId())) != null) {
                        fscContractInfoBO.setContractAmount(contractAmountRspBoList.getContractAmount());
                    }
                    FscOrderRelationPO orderNumObj = countOrderIdByRefundIdList.stream().filter(e -> ObjectUtil.equal((Object)e.getContractId(), (Object)financeRefundItemPO.getContractId())).findFirst().orElse(new FscOrderRelationPO());
                    fscContractInfoBO.setOrderNum(orderNumObj.getOrderNum());
                    contractList.add(fscContractInfoBO);
                }
            }
        }
        return contractList;
    }

    private void buildFinanceOrder(Long refundId, FscOrderRefundBO fscOrderRefundBO, FscPayShouldRefundPO fscPayShouldRefundPO) {
        FscRefundFinancePO fscRefundFinanceReq = new FscRefundFinancePO();
        fscRefundFinanceReq.setRefundId(refundId);
        FscRefundFinancePO fscRefundFinancePO = this.fscRefundFinanceMapper.getModelBy(fscRefundFinanceReq);
        if (fscRefundFinancePO != null) {
            fscOrderRefundBO.setAccountEntityCode(fscRefundFinancePO.getAccountEntityCode());
            fscOrderRefundBO.setAccountEntityName(fscRefundFinancePO.getAccountEntityName());
            fscOrderRefundBO.setAgentCompanyCode(fscRefundFinancePO.getAgentCompanyCode());
            fscOrderRefundBO.setAgentCompanyName(fscRefundFinancePO.getAgentCompanyName());
            fscOrderRefundBO.setCashDetailCode(fscRefundFinancePO.getCashDetailCode());
            fscOrderRefundBO.setCashDetailName(fscRefundFinancePO.getCashDetailName());
            fscOrderRefundBO.setCashItemCode(fscRefundFinancePO.getCashItemCode());
            fscOrderRefundBO.setCashItemName(fscRefundFinancePO.getCashItemName());
            fscOrderRefundBO.setCashUnitCode(fscRefundFinancePO.getCashUnitCode());
            fscOrderRefundBO.setCashUnitName(fscRefundFinancePO.getCashUnitName());
            fscOrderRefundBO.setCompanyCode(fscRefundFinancePO.getCompanyCode());
            fscOrderRefundBO.setCompanySegmentCode(fscRefundFinancePO.getCompanySegmentCode());
            fscOrderRefundBO.setCompanySegmentName(fscRefundFinancePO.getCompanySegmentName());
            fscOrderRefundBO.setCurrency(fscRefundFinancePO.getCurrency());
            fscOrderRefundBO.setCurrencyName(fscRefundFinancePO.getCurrencyName());
            fscOrderRefundBO.setExchangeRate(fscRefundFinancePO.getExchangeRate());
            fscOrderRefundBO.setExtBillId(fscRefundFinancePO.getExtBillId());
            fscOrderRefundBO.setExtBillNo(fscRefundFinancePO.getExtBillNo());
            fscOrderRefundBO.setFinanceAuditAccount(fscRefundFinancePO.getFinanceAuditAccount());
            fscOrderRefundBO.setFinanceAuditName(fscRefundFinancePO.getFinanceAuditName());
            fscOrderRefundBO.setFinanceDeptId(fscRefundFinancePO.getFinanceDeptId());
            fscOrderRefundBO.setFinanceDeptName(fscRefundFinancePO.getFinanceDeptName());
            fscOrderRefundBO.setFinanceOrgId(fscRefundFinancePO.getFinanceOrgId());
            fscOrderRefundBO.setFinanceOrgName(fscRefundFinancePO.getFinanceOrgName());
            fscOrderRefundBO.setIndependenceCostCode(fscRefundFinancePO.getIndependenceCostCode());
            fscOrderRefundBO.setIndependenceCostName(fscRefundFinancePO.getIndependenceCostName());
            fscOrderRefundBO.setIsAgent(fscRefundFinancePO.getIsAgent());
            fscOrderRefundBO.setNote(fscRefundFinancePO.getNote());
            fscOrderRefundBO.setPostingDate(fscRefundFinancePO.getPostingDate());
            fscOrderRefundBO.setPostingStatus(fscRefundFinancePO.getPostingStatus());
            fscOrderRefundBO.setPushFinanceRemark(fscRefundFinancePO.getPushFinanceRemark());
            fscOrderRefundBO.setPushFinanceStatus(fscRefundFinancePO.getPushFinanceStatus());
            fscOrderRefundBO.setRefundPayMethod(fscRefundFinancePO.getAccountEntityName());
            fscOrderRefundBO.setSegmentCode(fscRefundFinancePO.getSegmentCode());
            fscOrderRefundBO.setSegmentName(fscRefundFinancePO.getSegmentName());
            BeanUtils.copyProperties((Object)fscRefundFinancePO, (Object)fscOrderRefundBO);
            Map isAgentMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_IS_AGENT");
            Map refundPayMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_PAY_METHOD");
            if (!StringUtils.isEmpty((Object)fscOrderRefundBO.getPostingStatus())) {
                fscOrderRefundBO.setPostingStatusStr(FscPostingStatusEnum.getCodeDesc((String)String.valueOf(fscOrderRefundBO.getPostingStatus())));
            }
            if (fscOrderRefundBO.getIsAgent() != null) {
                fscOrderRefundBO.setIsAgentStr((String)isAgentMap.get(fscOrderRefundBO.getIsAgent().toString()));
            }
            if (!StringUtils.isEmpty((Object)fscOrderRefundBO.getRefundPayMethod())) {
                fscOrderRefundBO.setRefundPayMethodStr((String)refundPayMethodMap.get(fscOrderRefundBO.getRefundPayMethod()));
            }
        }
        if (fscPayShouldRefundPO != null && fscPayShouldRefundPO.getFscOrderId() != null) {
            FscOrderFinancePO fscOrderFinanceReq = new FscOrderFinancePO();
            fscOrderFinanceReq.setFscOrderId(fscPayShouldRefundPO.getFscOrderId());
            FscOrderFinancePO fscOrderFinance = this.fscOrderFinanceMapper.getModelBy(fscOrderFinanceReq);
            if (fscOrderFinance != null) {
                fscOrderRefundBO.setPayDate(fscOrderFinance.getPayDate());
                fscOrderRefundBO.setBusinessItemCode(fscOrderFinance.getBusinessItemCode());
                fscOrderRefundBO.setBusinessItemName(fscOrderFinance.getBusinessItemName());
                fscOrderRefundBO.setProjectSegmentCode(fscOrderFinance.getProjectSegmentCode());
                fscOrderRefundBO.setProjectSegmentName(fscOrderFinance.getProjectSegmentName());
                fscOrderRefundBO.setVendorSiteId(fscOrderFinance.getVendorSiteId());
                fscOrderRefundBO.setVendorSiteName(fscOrderFinance.getVendorSiteName());
            }
        }
    }

    private List<FscBillPayOrderBO> queryPayOrderInfo(List<Long> payOrderIdList) {
        ArrayList<FscBillPayOrderBO> payOrderList = new ArrayList<FscBillPayOrderBO>();
        for (Long payOrderId : payOrderIdList) {
            FscOrderPO fscOrderPO = this.fscOrderMapper.qryByFscOrderId(payOrderId);
            FscBillPayOrderBO fscBillPayOrderBO = (FscBillPayOrderBO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscOrderPO), FscBillPayOrderBO.class);
            fscBillPayOrderBO.setPayAmount(fscOrderPO.getPaidAmount());
            if (null != fscBillPayOrderBO.getOrderType()) {
                Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
                fscBillPayOrderBO.setOrderTypeStr((String)orderTypeMap.get(fscBillPayOrderBO.getOrderType().toString()));
            }
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setFscOrderId(fscBillPayOrderBO.getFscOrderId());
            List payItems = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)payItems)) {
                Integer shouldPayMethod = ((FscOrderPayItemPO)payItems.get(0)).getShouldPayMethod();
                fscBillPayOrderBO.setShouldPayMethodStr(Objects.nonNull(FscPayTypeEnum.getEnum((Integer)shouldPayMethod)) ? FscPayTypeEnum.getEnum((Integer)shouldPayMethod).getDesc() : null);
            }
            if (null != fscBillPayOrderBO.getOrderState()) {
                Map orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE");
                fscBillPayOrderBO.setOrderStateStr((String)orderStateMap.get(fscBillPayOrderBO.getOrderState() + ""));
            }
            payOrderList.add(fscBillPayOrderBO);
        }
        return payOrderList;
    }
}

