/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundSubmitAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundSubmitAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundSubmitAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundSubmitBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundSubmitBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundSubmitBusiRspBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscBusinessPendingTodoAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncEntrustNotificationAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSendNotificationService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushTodoAbilityServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscPushTodoAbilityServiceRspBO;
import com.tydic.fsc.common.ability.bo.FscSyncEntrustNotificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSendNotificationReqBO;
import com.tydic.fsc.common.ability.bo.FscTodoBusinessWaitDoneAddReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPayRefundSubmitAbilityService"})
public class FscBillPayRefundSubmitAbilityServiceImpl
implements FscBillPayRefundSubmitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundSubmitAbilityServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscBillPayRefundSubmitBusiService fscBillPayRefundSubmitBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscBusinessPendingTodoAbilityService fscBusinessPendingTodoAbilityService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscSyncSendNotificationService fscSyncSendNotificationService;
    @Autowired
    private FscSyncEntrustNotificationAbilityService fscSyncEntrustNotificationAbilityService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;

    @PostMapping(value={"dealPayRefundSubmit"})
    public FscBillPayRefundSubmitAbilityRspBO dealPayRefundSubmit(@RequestBody FscBillPayRefundSubmitAbilityReqBO reqBO) {
        FscBillPayRefundSubmitAbilityRspBO rspBO = new FscBillPayRefundSubmitAbilityRspBO();
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscBillPayRefundSubmitBusiReqBO busiReqBO = (FscBillPayRefundSubmitBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscBillPayRefundSubmitBusiReqBO.class));
        FscOrderRefundPO refundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        if (!FscConstants.RefundPayOrderState.TO_COMFIR.equals(refundPO.getRefundStatus())) {
            throw new FscBusinessException("198888", "\u9000\u6b3e\u5355[" + refundPO.getRefundNo() + "]\u72b6\u6001\u5f02\u5e38\uff01");
        }
        FscBillPayRefundSubmitBusiRspBO busiRspBO = this.fscBillPayRefundSubmitBusiService.dealPayRefundSubmit(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            return (FscBillPayRefundSubmitAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscBillPayRefundSubmitAbilityRspBO.class);
        }
        rspBO.setRespCode("0000");
        this.sendMq(reqBO.getRefundId());
        try {
            this.sendTodoNotice(reqBO, busiRspBO);
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u7533\u8bf7\u5355\u5f85\u529e\u63a8\u9001\u5931\u8d25", (Throwable)e);
        }
        return rspBO;
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
    }

    private void valid(FscBillPayRefundSubmitAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAgentUserId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[agentUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAgentUserName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[agentUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAgentDeptId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAgentDeptName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void sendTodoNotice(FscBillPayRefundSubmitAbilityReqBO reqBO, FscBillPayRefundSubmitBusiRspBO busiRspBO) {
        try {
            FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
            fscOrderRefundPO.setRefundId(reqBO.getRefundId());
            fscOrderRefundPO = this.fscOrderRefundMapper.getModelBy(fscOrderRefundPO);
            this.inboxNotify(fscOrderRefundPO);
            this.todoNotify(fscOrderRefundPO);
            this.sendDelegationNotify(reqBO, busiRspBO);
            this.addWaitDone(reqBO);
        }
        catch (Exception e) {
            log.error("dealPayBillCreate -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Object)e.getMessage());
        }
    }

    private void sendDelegationNotify(FscBillPayRefundSubmitAbilityReqBO reqBO, FscBillPayRefundSubmitBusiRspBO busiRspBO) {
        for (Long fscOrderId : busiRspBO.getFscOrderIds()) {
            FscSyncSendNotificationReqBO notificationReqBO = new FscSyncSendNotificationReqBO();
            notificationReqBO.setUserId(reqBO.getUserId());
            notificationReqBO.setObjId(fscOrderId);
            notificationReqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.FINANCE_REFUND);
            this.fscSyncSendNotificationService.syncSendNotification(notificationReqBO);
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList())) {
            FscSyncEntrustNotificationAbilityReqBO abilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
            abilityReqBO.setApproveEntrustType(Integer.valueOf(17));
            abilityReqBO.setAuditNoticeList(busiRspBO.getAuditNoticeList());
            this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(abilityReqBO);
        }
    }

    private void todoNotify(FscOrderRefundPO fscOrderRefundPO) {
        log.info("\u91c7\u8d2d\u9000\u6b3e\u7533\u8bf7\u5355\u5f85\u529e\u63a8\u9001===========>obj_id:{}", (Object)fscOrderRefundPO.getFscOrderId());
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderRefundPO.getSettlePlatform())) {
            return;
        }
        try {
            FscPushTodoAbilityServiceReqBO fscPushTodoAbilityServiceReqBO = new FscPushTodoAbilityServiceReqBO();
            fscPushTodoAbilityServiceReqBO.setBusiCode("1310");
            fscPushTodoAbilityServiceReqBO.setBusiName("\u91c7\u8d2d\u9000\u6b3e\u5ba1\u6279\u5355");
            fscPushTodoAbilityServiceReqBO.setObjId(fscOrderRefundPO.getRefundId());
            fscPushTodoAbilityServiceReqBO.setOperatorType(TaskWaitDoneEnum.PUSH_TODO_OPERATOR_SUBMIT);
            FscPushTodoAbilityServiceRspBO fscPushTodoAbilityServiceRspBO = this.taskTodoWaitService.dealPushTodoHandler(fscPushTodoAbilityServiceReqBO);
            if (!"0000".equals(fscPushTodoAbilityServiceRspBO.getRespCode())) {
                throw new FscBusinessException(fscPushTodoAbilityServiceRspBO.getRespCode(), fscPushTodoAbilityServiceRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u9000\u6b3e\u7533\u8bf7\u63d0\u4ea4|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u9000\u6b3e\u7533\u8bf7\u63d0\u4ea4\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void inboxNotify(FscOrderRefundPO fscOrderRefundPO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderRefundPO.getSettlePlatform())) {
            return;
        }
        Map busiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_TYPE");
        String busiTypeStr = (String)busiTypeMap.get(String.valueOf(fscOrderRefundPO.getOrderType()));
        FscTaskCandidatePO taskCandidatePO = new FscTaskCandidatePO();
        taskCandidatePO.setFscOrderId(fscOrderRefundPO.getFscOrderId());
        List fscApprovalTaskQueryBOList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskCandidatePO);
        if (CollectionUtils.isEmpty((Collection)fscApprovalTaskQueryBOList)) {
            return;
        }
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)fscApprovalTaskQueryBOList.get(0)).getTaskOperId()));
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(fscOrderRefundPO.getCreateUserId());
            fscSendNotificationExtAtomReqBO.setTitel(fscOrderRefundPO.getRefundNo() + "\u9000\u6b3e\u7533\u8bf7\u5355_" + "_" + busiTypeStr + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9000\u6b3e\u7533\u8bf7\u5355" + fscOrderRefundPO.getRefundNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u9000\u6b3e\u7533\u8bf7|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u9000\u6b3e\u7533\u8bf7\u901a\u77e5\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void addWaitDone(FscBillPayRefundSubmitAbilityReqBO reqBO) {
        FscTodoBusinessWaitDoneAddReqBo fscTodoBusinessWaitDoneAddReqBo = new FscTodoBusinessWaitDoneAddReqBo();
        fscTodoBusinessWaitDoneAddReqBo.setBusiCode("2003");
        fscTodoBusinessWaitDoneAddReqBo.setHandleOrgName(reqBO.getOrgName());
        fscTodoBusinessWaitDoneAddReqBo.setHandleOrgNo(reqBO.getOrgCodeIn());
        fscTodoBusinessWaitDoneAddReqBo.setHandleUserNo(String.valueOf(reqBO.getUserName()));
        fscTodoBusinessWaitDoneAddReqBo.setHandleUserName(reqBO.getName());
        fscTodoBusinessWaitDoneAddReqBo.setSubmitUserNo(String.valueOf(reqBO.getUserId()));
        fscTodoBusinessWaitDoneAddReqBo.setSubmitUserName(reqBO.getName());
        fscTodoBusinessWaitDoneAddReqBo.setObjId(String.valueOf(reqBO.getRefundId()));
        this.fscBusinessPendingTodoAbilityService.addWaitDone(fscTodoBusinessWaitDoneAddReqBo);
    }
}

