/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.api.FscComOrderRefundConfirmAbilityService;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundConfirmAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundConfirmAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscComOrderRefundConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundConfirmBusiRspBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscBusinessPendingTodoAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncEntrustNotificationAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSendNotificationService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushEngTodoAbilityServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscPushUnifyRefundInvoiceAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncEntrustNotificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSendNotificationReqBO;
import com.tydic.fsc.common.ability.bo.FscTodoBusinessWaitDoneDealReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.bo.TodoFscWaitAbilityReqBO;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscComOrderRefundConfirmAbilityService"})
public class FscComOrderRefundConfirmAbilityServiceImpl
implements FscComOrderRefundConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderRefundConfirmAbilityServiceImpl.class);
    @Autowired
    private FscComOrderRefundConfirmBusiService fscComOrderRefundConfirmBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Value(value="${es.FSC_PUSH_UNIFY_REFUND__INVOICE_TOPIC:FSC_PUSH_UNIFY_REFUND__INVOICE_TOPIC}")
    private String fscPushUnifyRefundTopic;
    @Value(value="${es.FSC_PUSH_UNIFY_REFUND__INVOICE_TAG:FSC_PUSH_UNIFY_REFUND__INVOICE_TAG}")
    private String fscPushUnifyRefundTag;
    @Resource(name="fscPushUnifyRefundInvoiceMqServiceProvider")
    private ProxyMessageProducer fscPushUnifyRefundInvoiceMqServiceProvider;
    @Autowired
    private FscSyncEntrustNotificationAbilityService fscSyncEntrustNotificationAbilityService;
    @Autowired
    private FscSyncSendNotificationService fscSyncSendNotificationService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscBusinessPendingTodoAbilityService fscBusinessPendingTodoAbilityService;

    @PostMapping(value={"dealOrderRefundConfirm"})
    public FscComOrderRefundConfirmAbilityRspBO dealOrderRefundConfirm(@RequestBody FscComOrderRefundConfirmAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscComOrderRefundConfirmBusiReqBO busiReqBO = (FscComOrderRefundConfirmBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscComOrderRefundConfirmBusiReqBO.class));
        StringBuffer sb = new StringBuffer();
        for (Long refundId : reqBO.getRefundIds()) {
            busiReqBO.setRefundId(refundId);
            FscComOrderRefundConfirmBusiRspBO busiRspBO = this.fscComOrderRefundConfirmBusiService.dealOrderRefundConfirm(busiReqBO);
            if (!busiRspBO.getRespCode().equals("0000")) {
                sb.append("\u9000\u7968\u5355[").append(refundId).append("]\u786e\u8ba4\u5931\u8d25\uff1a").append(busiRspBO.getRespDesc());
                continue;
            }
            if (busiRspBO.getUnifyFlag().booleanValue()) {
                this.dealPushRefund(refundId, busiRspBO.getFscOrderId());
            }
            this.sendMq(refundId);
            this.sendTodoNotice(reqBO, refundId);
            FscTodoBusinessWaitDoneDealReqBo dealReqBo = new FscTodoBusinessWaitDoneDealReqBo();
            dealReqBo.setBusiCode("2001");
            dealReqBo.setDealUserNo(String.valueOf(reqBO.getUserName()));
            dealReqBo.setDealUserName(reqBO.getName());
            dealReqBo.setHandleUserNo(String.valueOf(reqBO.getUserName()));
            dealReqBo.setObjId(refundId + "");
            this.fscBusinessPendingTodoAbilityService.dealWaitDone(dealReqBo);
            this.sendFinanceOrderRefundConfirmEntrustNotice(reqBO, busiRspBO);
            this.sendOrderRefundConfirmEntrustNotice(reqBO, busiRspBO);
        }
        FscComOrderRefundConfirmAbilityRspBO rspBO = new FscComOrderRefundConfirmAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void sendTodoNotice(FscComOrderRefundConfirmAbilityReqBO reqBO, Long refundId) {
        try {
            FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
            fscOrderRefundPO.setRefundId(refundId);
            fscOrderRefundPO = this.fscOrderRefundMapper.getModelBy(fscOrderRefundPO);
            this.inboxNotify(reqBO, fscOrderRefundPO);
            this.todoNotify(fscOrderRefundPO);
        }
        catch (Exception e) {
            log.error("dealPayBillCreate -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Object)e.getMessage());
        }
    }

    private void todoNotify(FscOrderRefundPO fscOrderRefundPO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderRefundPO.getSettlePlatform()) || FscConstants.OrderFlow.REFUND_INVOICE.equals(fscOrderRefundPO.getOrderFlow())) {
            return;
        }
        try {
            TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
            todoFscWaitAbilityReqBO.setCenterCode("settle");
            todoFscWaitAbilityReqBO.setBusiCode("1301");
            todoFscWaitAbilityReqBO.setBusiName("\u91c7\u8d2d\u9000\u7968\u5ba1\u6279(\u8d22\u52a1\u5171\u4eab)");
            todoFscWaitAbilityReqBO.setObjId(fscOrderRefundPO.getRefundId());
            todoFscWaitAbilityReqBO.setOperatorType("0");
            this.taskTodoWaitService.saleRefundHandler(todoFscWaitAbilityReqBO);
        }
        catch (Exception e) {
            log.error("\u9000\u7968\u786e\u8ba4|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u9000\u7968\u786e\u8ba4\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void inboxNotify(FscComOrderRefundConfirmAbilityReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderRefundPO.getSettlePlatform())) {
            return;
        }
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        String orderTypeStr = (String)orderTypeMap.get(String.valueOf(fscOrderRefundPO.getOrderType()));
        FscTaskCandidatePO taskCandidatePO = new FscTaskCandidatePO();
        taskCandidatePO.setFscOrderId(fscOrderRefundPO.getRefundId());
        List fscApprovalTaskQueryBOList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskCandidatePO);
        if (CollectionUtils.isEmpty((Collection)fscApprovalTaskQueryBOList)) {
            return;
        }
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)fscApprovalTaskQueryBOList.get(0)).getTaskOperId()));
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO.setTitel(fscOrderRefundPO.getRefundNo() + "\u9000\u7968\u7533\u8bf7\u5355_" + "_" + orderTypeStr + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9000\u7968\u7533\u8bf7\u5355" + fscOrderRefundPO.getRefundNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u9000\u7968\u786e\u8ba4|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u9000\u7968\u786e\u8ba4\u901a\u77e5\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void sendFinanceOrderRefundConfirmEntrustNotice(FscComOrderRefundConfirmAbilityReqBO reqBO, FscComOrderRefundConfirmBusiRspBO busiRspBO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(busiRspBO.getSettlePlatform())) {
            return;
        }
        if (!FscConstants.OrderFlow.REFUND_INVOICE.equals(busiRspBO.getOrderFlow())) {
            return;
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList()) && !CollectionUtils.isEmpty(busiRspBO.getNoticeOrderIds())) {
            for (Long noticeOrderId : busiRspBO.getNoticeOrderIds()) {
                FscSyncSendNotificationReqBO fscSyncSendNotificationReqBO = new FscSyncSendNotificationReqBO();
                fscSyncSendNotificationReqBO.setUserId(reqBO.getUserId());
                fscSyncSendNotificationReqBO.setObjId(noticeOrderId);
                fscSyncSendNotificationReqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.FINANCE_REFUND_INVOICE);
                this.fscSyncSendNotificationService.syncSendNotification(fscSyncSendNotificationReqBO);
            }
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList())) {
            FscSyncEntrustNotificationAbilityReqBO fscSyncEntrustNotificationAbilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
            fscSyncEntrustNotificationAbilityReqBO.setApproveEntrustType(Integer.valueOf(14));
            fscSyncEntrustNotificationAbilityReqBO.setAuditNoticeList(busiRspBO.getAuditNoticeList());
            this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(fscSyncEntrustNotificationAbilityReqBO);
        }
    }

    private void sendOrderRefundConfirmEntrustNotice(FscComOrderRefundConfirmAbilityReqBO reqBO, FscComOrderRefundConfirmBusiRspBO busiRspBO) {
        if (FscConstants.SettlePlatform.FINANCE.equals(busiRspBO.getSettlePlatform())) {
            return;
        }
        if (!FscConstants.FscOrderReceiveType.OPERATION.equals(busiRspBO.getReceiveType())) {
            return;
        }
        if (!FscConstants.OrderFlow.REFUND_INVOICE.equals(busiRspBO.getOrderFlow())) {
            return;
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList()) && !CollectionUtils.isEmpty(busiRspBO.getNoticeOrderIds())) {
            for (Long noticeOrderId : busiRspBO.getNoticeOrderIds()) {
                FscSyncSendNotificationReqBO fscSyncSendNotificationReqBO = new FscSyncSendNotificationReqBO();
                fscSyncSendNotificationReqBO.setUserId(reqBO.getUserId());
                fscSyncSendNotificationReqBO.setObjId(noticeOrderId);
                fscSyncSendNotificationReqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.REFUND_PUR_INVOICE);
                this.fscSyncSendNotificationService.syncSendNotification(fscSyncSendNotificationReqBO);
            }
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList())) {
            FscSyncEntrustNotificationAbilityReqBO fscSyncEntrustNotificationAbilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
            fscSyncEntrustNotificationAbilityReqBO.setApproveEntrustType(Integer.valueOf(9));
            fscSyncEntrustNotificationAbilityReqBO.setAuditNoticeList(busiRspBO.getAuditNoticeList());
            this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(fscSyncEntrustNotificationAbilityReqBO);
        }
    }

    @PostMapping(value={"dealProjectOrderRefundConfirm"})
    public FscComOrderRefundConfirmAbilityRspBO dealProjectOrderRefundConfirm(@RequestBody FscComOrderRefundConfirmAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscComOrderRefundConfirmBusiReqBO busiReqBO = (FscComOrderRefundConfirmBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscComOrderRefundConfirmBusiReqBO.class));
        StringBuffer sb = new StringBuffer();
        for (Long refundId : reqBO.getRefundIds()) {
            busiReqBO.setRefundId(refundId);
            FscComOrderRefundConfirmBusiRspBO busiRspBO = this.fscComOrderRefundConfirmBusiService.dealProjectOrderRefundConfirm(busiReqBO);
            if (!busiRspBO.getRespCode().equals("0000")) {
                sb.append("\u9000\u7968\u5355[").append(refundId).append("]\u786e\u8ba4\u5931\u8d25\uff1a").append(busiRspBO.getRespDesc());
                continue;
            }
            FscSyncSendNotificationReqBO notificationReqBO = new FscSyncSendNotificationReqBO();
            notificationReqBO.setUserId(reqBO.getUserId());
            notificationReqBO.setObjId(refundId);
            notificationReqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.FINANCE_ENGINEERING_REFUND_INVOICE);
            this.fscSyncSendNotificationService.syncSendNotification(notificationReqBO);
            if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList())) {
                FscSyncEntrustNotificationAbilityReqBO abilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
                abilityReqBO.setApproveEntrustType(Integer.valueOf(12));
                abilityReqBO.setAuditNoticeList(busiRspBO.getAuditNoticeList());
                this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(abilityReqBO);
            }
            try {
                FscPushEngTodoAbilityServiceReqBO todoAbilityServiceReqBO = new FscPushEngTodoAbilityServiceReqBO();
                todoAbilityServiceReqBO.setBusiCode("1205");
                todoAbilityServiceReqBO.setBusiName("\u5de5\u7a0b\u670d\u52a1\u9000\u7968\u5ba1\u6279");
                todoAbilityServiceReqBO.setObjId(refundId);
                todoAbilityServiceReqBO.setOperatorType(TaskWaitDoneEnum.PUSH_TODO_OPERATOR_SUBMIT);
                todoAbilityServiceReqBO.setAuthPermission(reqBO.getAuthPermission());
                this.taskTodoWaitService.dealEngPushTodoHandler(todoAbilityServiceReqBO);
            }
            catch (Exception e) {
                log.error("dealProjectOrderRefundConfirm|\u53d1\u9001\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
            }
            this.sendMq(refundId);
        }
        FscComOrderRefundConfirmAbilityRspBO rspBO = new FscComOrderRefundConfirmAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void dealPushRefund(Long refundId, Long fscOrderId) {
        FscOrderExtPO extPO = new FscOrderExtPO();
        extPO.setFscOrderId(fscOrderId);
        extPO = this.fscOrderExtMapper.getModelBy(extPO);
        if (extPO != null && extPO.getUnifyPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            FscPushUnifyRefundInvoiceAbilityReqBO abilityReqBO = new FscPushUnifyRefundInvoiceAbilityReqBO();
            abilityReqBO.setRefundId(refundId);
            this.fscPushUnifyRefundInvoiceMqServiceProvider.send(new ProxyMessage(this.fscPushUnifyRefundTopic, this.fscPushUnifyRefundTag, JSON.toJSONString((Object)abilityReqBO)));
        }
    }

    private void valid(FscComOrderRefundConfirmAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getConfirmType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[confirmType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO abilityReqBO = new FscComRefundSyncAbilityReqBO();
        abilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(abilityReqBO);
    }
}

