/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscEngineeringBillPayRefundCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscEngineeringBillPayRefundCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscEngineeringBillPayRefundCreateAbilityRspBO;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceRefundPayTempQryAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceRefundPayTempQryAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceRefundPayTempQryAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscEngineeringBillPayRefundCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscEngineeringBillPayRefundCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscEngineeringBillPayRefundCreateBusiRspBO;
import com.tydic.fsc.bo.FscFinanceRefundItemBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscEngineeringBillPayRefundCreateAbilityService"})
public class FscEngineeringBillPayRefundCreateAbilityServiceImpl
implements FscEngineeringBillPayRefundCreateAbilityService {
    @Autowired
    private FscEngineeringBillPayRefundCreateBusiService fscEngineeringBillPayRefundCreateBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscFinanceRefundPayTempQryAtomService fscFinanceRefundPayTempQryAtomService;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long operationSupId;
    @Autowired
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealEngineeringPayRefundCreate"})
    public FscEngineeringBillPayRefundCreateAbilityRspBO dealEngineeringPayRefundCreate(@RequestBody FscEngineeringBillPayRefundCreateAbilityReqBO reqBO) {
        if (reqBO.getTempId() != null) {
            this.qryTempInfo(reqBO);
        }
        this.valid(reqBO);
        this.checkPayOrderId(reqBO);
        FscEngineeringBillPayRefundCreateBusiReqBO fscBillPayRefundCreateBusiReqBO = (FscEngineeringBillPayRefundCreateBusiReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscEngineeringBillPayRefundCreateBusiReqBO.class));
        FscEngineeringBillPayRefundCreateBusiRspBO fscBillPayRefundCreateBusiRspBO = this.fscEngineeringBillPayRefundCreateBusiService.dealEngineeringPayRefundCreate(fscBillPayRefundCreateBusiReqBO);
        if (!"0000".equals(fscBillPayRefundCreateBusiRspBO.getRespCode())) {
            return (FscEngineeringBillPayRefundCreateAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)fscBillPayRefundCreateBusiRspBO)), FscEngineeringBillPayRefundCreateAbilityRspBO.class);
        }
        if (fscBillPayRefundCreateBusiRspBO.getRefundId() != null) {
            this.syncEs(fscBillPayRefundCreateBusiRspBO);
        }
        FscEngineeringBillPayRefundCreateAbilityRspBO rspBO = new FscEngineeringBillPayRefundCreateAbilityRspBO();
        rspBO.setRefundId(fscBillPayRefundCreateBusiRspBO.getRefundId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void qryTempInfo(FscEngineeringBillPayRefundCreateAbilityReqBO reqBO) {
        FscFinanceRefundPayTempQryAtomReqBO atomReqBO = new FscFinanceRefundPayTempQryAtomReqBO();
        atomReqBO.setTempId(reqBO.getTempId());
        atomReqBO.setEngineeringFlag(1);
        FscFinanceRefundPayTempQryAtomRspBO atomRspBO = this.fscFinanceRefundPayTempQryAtomService.qryTempInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u4e34\u65f6\u8868\u4fe1\u606f\u5931\u8d25:" + atomRspBO.getRespDesc());
        }
        reqBO.setFinanceItemList(atomRspBO.getFinanceItemList());
        reqBO.setFileList(atomRspBO.getFileList());
        reqBO.setRefundAmount(atomRspBO.getFinanceItemList().stream().map(FscFinanceRefundItemBO::getRefundAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    private void syncEs(FscEngineeringBillPayRefundCreateBusiRspBO busiRspBO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(busiRspBO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private void valid(FscEngineeringBillPayRefundCreateAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getCwOrgId())) {
            throw new FscBusinessException("191000", "erp\u7f16\u7801[cwOrgid]\u4e0d\u80fd\u7a7a");
        }
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRefundNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundDate() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundAmount() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundAmount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (FscConstants.RefundUserType.PURCHASE.equals(reqBO.getUserType()) && ("0".equals(reqBO.getIsprofess()) || this.operationSupId.equals(reqBO.getOrgId()))) {
            if (reqBO.getAgentUserId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getAgentUserName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getAgentDeptId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBO.getAgentDeptName())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[agentDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFinanceItemList())) {
            BigDecimal refundAmt = BigDecimal.ZERO;
            for (FscFinanceRefundItemBO itemBO : reqBO.getFinanceItemList()) {
                refundAmt = refundAmt.add(itemBO.getRefundAmt());
                if (itemBO.getRefundAmt() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[fscFinanceRefundItemBO.refundAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (itemBO.getRefundAmtLocal() != null) continue;
                throw new FscBusinessException("198888", "\u5165\u53c2[fscFinanceRefundItemBO.refundAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (refundAmt.compareTo(reqBO.getRefundAmount()) != 0) {
                throw new FscBusinessException("198888", "\u9000\u6b3e\u660e\u7ec6\u884c\u5408\u8ba1\u9000\u6b3e\u91d1\u989d\u548c\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getFinanceOrgId()) && CollectionUtils.isEmpty((Collection)reqBO.getFinanceItemList())) {
            throw new FscBusinessException("198888", "\u5bf9\u63a5\u8d22\u52a1\u5171\u4eab\u9000\u6b3e\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkPayOrderId(FscEngineeringBillPayRefundCreateAbilityReqBO reqBO) {
        List payOrderIds = reqBO.getFinanceItemList().stream().map(FscFinanceRefundItemBO::getFscOrderId).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(payOrderIds)) {
            int onwayOrderCount = this.fscFinanceWriteOffMapper.checkIfOnwayOrder(payOrderIds);
            if (onwayOrderCount > 0) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u6b3e\u660e\u7ec6\u6240\u9009\u4ed8\u6b3e\u5355\u5b58\u5728\u5728\u9014\u6838\u9500\u5355\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4\uff01");
            }
            int adjustOrderCount = this.fscFinanceWriteOffAdjustMapper.checkIfOnwayAdjustOrder(payOrderIds);
            if (adjustOrderCount > 0) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u6b3e\u660e\u7ec6\u6240\u9009\u4ed8\u6b3e\u5355\u5b58\u5728\u5728\u9014\u8865\u6838\u9500\u5355\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4\uff01");
            }
        }
    }
}

