/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.ability.api.FscFinanceWriteOffApprovalService;
import com.tydic.fsc.bill.ability.bo.FscFinanceWriteOffApprovalServiceReqBo;
import com.tydic.fsc.bill.ability.bo.FscFinanceWriteOffApprovalServiceRspBo;
import com.tydic.fsc.bill.busi.api.FscFinanceWriteOffApprovalBusiService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.bo.FscFinanceWriteOffApprovalServiceBusiReqBo;
import com.tydic.fsc.busibase.busi.bo.FscFinanceWriteOffApprovalServiceBusiRspBo;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncEntrustNotificationAbilityService;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.common.ability.bo.FscPushEngTodoAbilityServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncEntrustNotificationAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscFinanceWriteOffApprovalService"})
public class FscFinanceWriteOffApprovalServiceImpl
implements FscFinanceWriteOffApprovalService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceWriteOffApprovalServiceImpl.class);
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscFinanceWriteOffApprovalBusiService fscFinanceWriteOffApprovalBusiService;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    public static final Integer PASS = 0;
    @Autowired
    private FscSyncEntrustNotificationAbilityService fscSyncEntrustNotificationAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealFinanceWriteOffApproval"})
    public FscFinanceWriteOffApprovalServiceRspBo dealFinanceWriteOffApproval(@RequestBody FscFinanceWriteOffApprovalServiceReqBo reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getStationsList())) {
            throw new FscBusinessException("190000", "\u5f53\u524d\u8d26\u53f7\u65e0\u4e0b\u4e00\u6b65\u5ba1\u6279\u6743\u9650");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAdjustIdList())) {
            throw new FscBusinessException("190000", "\u5fc5\u4f20\u53c2\u6570adjustIdList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Long adjustId : reqBo.getAdjustIdList()) {
            reqBo.setAdjustId(adjustId);
            this.dealApproval(reqBo);
        }
        FscFinanceWriteOffApprovalServiceRspBo rspBo = new FscFinanceWriteOffApprovalServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealApproval(FscFinanceWriteOffApprovalServiceReqBo reqBo) {
        FscFinanceWriteOffAdjustPO adjustPO = new FscFinanceWriteOffAdjustPO();
        adjustPO.setAdjustId(reqBo.getAdjustId());
        adjustPO = this.fscFinanceWriteOffAdjustMapper.getModelBy(adjustPO);
        if (null == adjustPO) {
            throw new FscBusinessException("190000", "\u8865\u5f55\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        Integer count = this.fscOrderMapper.getWriteOffAuditCount(adjustPO.getAdjustId(), reqBo.getStationsList(), reqBo.getUserId());
        if (count == 0 || CollectionUtils.isEmpty((Collection)reqBo.getStationsList())) {
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        if (!FscConstants.WriteOffBillStatus.TO_AUDIT.equals(adjustPO.getBillStatus())) {
            throw new FscBusinessException("190000", "\u5f53\u524d\u72b6\u6001[" + adjustPO.getBillStatus() + "]\u4e0d\u5141\u8bb8\u5ba1\u6279");
        }
        FscFinanceWriteOffApprovalServiceBusiReqBo busiReqBo = (FscFinanceWriteOffApprovalServiceBusiReqBo)JUtil.js((Object)reqBo, FscFinanceWriteOffApprovalServiceBusiReqBo.class);
        busiReqBo.setBillType(adjustPO.getBillType());
        busiReqBo.setFscOrderId(adjustPO.getFscOrderId());
        busiReqBo.setWriteOffAmt(adjustPO.getWriteOffAmt());
        FscFinanceWriteOffApprovalServiceBusiRspBo rspBo = this.fscFinanceWriteOffApprovalBusiService.dealFinanceWriteOffApproval(busiReqBo);
        this.toSendText(reqBo, adjustPO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getAuditNoticeList())) {
            FscSyncEntrustNotificationAbilityReqBO abilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
            abilityReqBO.setApproveEntrustType(Integer.valueOf(FscConstants.FinanceWriteOffType.ADD.equals(adjustPO.getBillType()) ? 5 : 6));
            abilityReqBO.setAuditNoticeList(rspBo.getAuditNoticeList());
            this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(abilityReqBO);
        }
        try {
            FscPushEngTodoAbilityServiceReqBO todoAbilityServiceReqBO = new FscPushEngTodoAbilityServiceReqBO();
            todoAbilityServiceReqBO.setBusiCode(FscConstants.FinanceWriteOffType.ADD.equals(adjustPO.getBillType()) ? "1206" : "1207");
            todoAbilityServiceReqBO.setBusiName(FscConstants.FinanceWriteOffType.ADD.equals(adjustPO.getBillType()) ? "\u8865\u6838\u9500\u5ba1\u6279" : "\u64a4\u9500\u6838\u9500\u5ba1\u6279");
            todoAbilityServiceReqBO.setObjId(adjustPO.getAdjustId());
            todoAbilityServiceReqBO.setOperatorType(TaskWaitDoneEnum.PUSH_TODO_OPERATOR_AUDIT);
            this.taskTodoWaitService.dealEngPushTodoHandler(todoAbilityServiceReqBO);
        }
        catch (Exception e) {
            log.error("dealFinanceWriteOffApproval|\u53d1\u9001\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
        }
        FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
        syncReqBO.setFscOrderId(adjustPO.getFscOrderId());
        this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
    }

    private void toSendText(FscFinanceWriteOffApprovalServiceReqBo reqBo, FscFinanceWriteOffAdjustPO adjustPO) {
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(adjustPO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        String orderTypeStr = (String)orderTypeMap.get(String.valueOf(orderPO.getOrderType()));
        if (FscConstants.OrderFlow.ENGINEERING_INVOICE.equals(orderPO.getOrderFlow())) {
            FscOrderRelationPO orderRelationPO = new FscOrderRelationPO();
            orderRelationPO.setFscOrderId(orderPO.getFscOrderId());
            List poList = this.fscOrderRelationMapper.getList(orderRelationPO);
            if (CollectionUtils.isEmpty((Collection)poList) || null == ((FscOrderRelationPO)poList.get(0)).getBusinessType()) {
                log.info("\u83b7\u53d6\u4e1a\u52a1\u7c7b\u578b\u5931\u8d25");
                return;
            }
            Integer businessType = ((FscOrderRelationPO)poList.get(0)).getBusinessType();
            Map engTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FINANCE_ENGINEERING_BUSINESS_TYPE");
            orderTypeStr = (String)engTypeMap.get(businessType.toString());
        }
        FscTaskCandidatePO taskCandidatePO = new FscTaskCandidatePO();
        taskCandidatePO.setFscOrderId(orderPO.getFscOrderId());
        List fscApprovalTaskQueryBOList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskCandidatePO);
        if (CollectionUtils.isEmpty((Collection)fscApprovalTaskQueryBOList)) {
            return;
        }
        String billType = FscConstants.FinanceWriteOffType.ADD.equals(adjustPO.getBillType()) ? "\u8865\u6838\u9500\u7533\u8bf7\u5355" : "\u64a4\u9500\u6838\u9500\u7533\u8bf7\u5355";
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(reqBo.getUserId());
            fscSendNotificationExtAtomReqBO.setTitel(orderPO.getOrderNo() + billType + "_" + orderTypeStr + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
            if (PASS.equals(reqBo.getAuditResult())) {
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u63d0\u4ea4\u7684" + billType + adjustPO.getFscOrderNo() + "\u5df2\u901a\u8fc7\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            } else {
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u63d0\u4ea4\u7684" + billType + adjustPO.getFscOrderNo() + "\u88ab\u5ba1\u6279\u9a73\u56de\u3002");
            }
            fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(adjustPO.getCreateUserId()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("dealFinanceWriteOffApproval|\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }
}

