/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.authority.busi.api.DycStationSelectService;
import com.tydic.authority.busi.bo.DycStationSelectReqBO;
import com.tydic.authority.busi.bo.DycStationSelectRspBO;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.fsc.bill.ability.api.FscMatchmakWxyBillPrintService;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintRspBO;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.bo.OrderInvoiceBO;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscExpenseTypeMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscPurWriteOffMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscExpenseTypePO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPurWriteOffPO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.CheckUtils;
import com.tydic.fsc.util.FscStringUtils;
import com.tydic.fsc.util.PdfUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscMatchmakWxyBillPrintService"})
public class FscMatchmakWxyBillPrintServiceImpl
implements FscMatchmakWxyBillPrintService {
    private static final Logger log = LoggerFactory.getLogger(FscMatchmakWxyBillPrintServiceImpl.class);
    @Autowired
    private FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService;
    @Autowired
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    @Autowired
    private DycStationSelectService dycStationSelectService;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscPurWriteOffMapper fscPurWriteOffMapper;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscExpenseTypeMapper fscExpenseTypeMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @PostMapping(value={"fscMatchmakWxyBillPrint"})
    public FscBillListPrintRspBO fscMatchmakWxyBillPrint(@RequestBody FscBillListPrintReqBO reqBO) {
        if (CheckUtils.isBlank((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        String pdfUrl = this.createWxyBillPdfPrint(reqBO);
        return new FscBillListPrintRspBO(pdfUrl, fscOrderPo.getOrderNo(), reqBO.getOrderId());
    }

    private String createWxyBillPdfPrint(FscBillListPrintReqBO reqBO) {
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        List<PdfPTable> tableList = this.addPdfTable(reqBO);
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        return this.uploadFile("\u64ae\u5408\u65e0\u534f\u8bae\u7ed3\u7b97\u5355", byteArrayOutputStream);
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private List<PdfPTable> addPdfTable(FscBillListPrintReqBO reqBO) {
        PdfPTable contextRow8;
        FscComOrderDetailQueryAbilityReqBO orderDetailReqBO = new FscComOrderDetailQueryAbilityReqBO();
        orderDetailReqBO.setOrderId(reqBO.getOrderId());
        FscComOrderDetailQueryAbilityRspBO orderDetail = this.fscComOrderDetailQueryAbilityService.qryOrderDetail(orderDetailReqBO);
        List attachmentBOS = orderDetail.getAttachmentList();
        FscPurWriteOffPO fscPurWriteOffPO = new FscPurWriteOffPO();
        fscPurWriteOffPO.setFscOrderId(reqBO.getOrderId());
        List writeOffList = this.fscPurWriteOffMapper.getWriteOffList(fscPurWriteOffPO);
        if (!CollectionUtils.isEmpty((Collection)writeOffList)) {
            BigDecimal writeOffAmount = writeOffList.stream().filter(y -> y.getWriteOffAmount() != null).map(x -> x.getWriteOffAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderDetail.setWriteOffAmount(writeOffAmount.stripTrailingZeros().setScale(2, 4));
        } else {
            orderDetail.setWriteOffAmount(new BigDecimal("0.00"));
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(orderDetail.getFscOrderId());
        List relationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        ContractDetailQueryAbilityReqBO contractDetailBO = new ContractDetailQueryAbilityReqBO();
        contractDetailBO.setContractId(((FscOrderRelationPO)relationPOS.get(0)).getContractId());
        ContractDetailQueryAbilityRspBO contractRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailBO);
        log.info("\u5408\u540c\u8be6\u60c5\u67e5\u8be2\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)contractRspBO));
        FscInvoicePO invoicePO = new FscInvoicePO();
        invoicePO.setFscOrderId(reqBO.getOrderId());
        List invoicePOS = this.fscInvoiceMapper.getList(invoicePO);
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = (FscComApprovalprocessListQryAbilityReqBO)BeanUtil.copyProperties((Object)reqBO, FscComApprovalprocessListQryAbilityReqBO.class);
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(6));
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        log.info("\u5ba1\u6279\u67e5\u8be2\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)fscApprovalList));
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
            this.dealStationInfo(approvalList);
        }
        FscOrderExtPO extPO = new FscOrderExtPO();
        extPO.setFscOrderId(reqBO.getOrderId());
        FscOrderExtPO modelBy = this.fscOrderExtMapper.getModelBy(extPO);
        String orgName = StringUtils.isBlank((CharSequence)modelBy.getUnifyOrgName()) ? "\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u516c\u53f8\u672c\u90e8" : modelBy.getUnifyOrgName();
        String deptName = StringUtils.isBlank((CharSequence)modelBy.getUnifyOrgName()) ? orderDetail.getOperationName() : modelBy.getUnifyDeptName();
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setFscOrderId(reqBO.getOrderId());
        List fscAttachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
        ArrayList<PdfPTable> tableList = new ArrayList<PdfPTable>();
        PdfPTable titleRow = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleRow, (Object)(orgName + "\n        \u804c\u80fd\u91c7\u8d2d\u7ed3\u7b97\u5355"), (Font)PdfUtils.DEFAULT_TITLE_FONT_NORMAL, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)22, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleRow, (Object)("\u9644\u4ef6" + (CollectionUtils.isEmpty((Collection)fscAttachmentPOList) ? 0 : fscAttachmentPOList.size()) + "\u5f20"), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)4, (Float)Float.valueOf(10.0f), (Integer)2, (Integer)0);
        tableList.add(titleRow);
        PdfPTable contextRow1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)contextRow1, (Object)"\u90e8\u95e8\u540d\u79f0\uff1a", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)0, (Integer)5, null, (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)contextRow1, (Object)deptName, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)5, (Integer)5, null, (Integer)6, (Integer)0);
        String approveDate = "";
        if (!Integer.valueOf(1001).equals(orderDetail.getSendState()) && orderDetail.getSendOperTime() != null) {
            approveDate = new SimpleDateFormat("yyyy\u5e74M\u6708d\u53f7").format(orderDetail.getSendOperTime());
        }
        PdfUtils.addCellToTable((PdfPTable)contextRow1, (Object)approveDate, (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, null, (Integer)8, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)contextRow1, (Object)"\u5355\u636e\u7f16\u53f7\uff1a", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)0, (Integer)5, null, (Integer)2, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)contextRow1, (Object)orderDetail.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)5, (Integer)5, null, (Integer)6, (Integer)0);
        tableList.add(contextRow1);
        PdfPTable contextRow2 = PdfUtils.newPdfTable();
        contextRow2.addCell(this.createCell("\u7ed3\u7b97\u540d\u79f0", 2, 3, 30.0f));
        contextRow2.addCell(this.createCell(contractRspBO.getContractName(), 2, 10, Float.NaN));
        contextRow2.addCell(this.createCell("\u5b9e\u9645\u6536\u6b3e\u5355\u4f4d", 0, 3, 15.0f));
        contextRow2.addCell(this.createCell(orderDetail.getSupplierName(), 0, 8, Float.NaN));
        contextRow2.addCell(this.createCell("\u7ecf\u529e\u4eba", 0, 3, 15.0f));
        contextRow2.addCell(this.createCell(orderDetail.getCreateOperName(), 0, 8, Float.NaN));
        tableList.add(contextRow2);
        PdfPTable contextRow3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)contextRow3, (Object)"\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow3, (Object)((FscOrderRelationPO)relationPOS.get(0)).getContractNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)10, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow3, (Object)"\u4f9b\u5e94\u5546\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow3, (Object)orderDetail.getSupplierName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)8, null);
        tableList.add(contextRow3);
        PdfPTable contextRow4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)contextRow4, (Object)"\u5e01\u79cd", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow4, (Object)"\u4eba\u6c11\u5e01", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow4, (Object)"\u6c47\u7387", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow4, (Object)"1", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow4, (Object)"\u7ed3\u7b97\u91d1\u989d\uff08\u672c\u5e01\uff09", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow4, (Object)orderDetail.getTotalCharge(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow4, (Object)"\u7ed3\u7b97\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow4, (Object)orderDetail.getTotalCharge(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)5, null);
        tableList.add(contextRow4);
        PdfPTable contextRow5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)contextRow5, (Object)"\u5907\u6ce8", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow5, (Object)orderDetail.getRemark(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)21, null);
        tableList.add(contextRow5);
        PdfPTable contextRow6 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)contextRow6, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow6, (Object)"\u8d39\u7528\u9879", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow6, (Object)"\u53d1\u7968\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow6, (Object)"\u5f00\u7968\u65e5\u671f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow6, (Object)"\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow6, (Object)"\u7a0e\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow6, (Object)"\u4ef7\u7a0e\u5408\u8ba1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
        tableList.add(contextRow6);
        String expType = "";
        if (StringUtils.isNotBlank((CharSequence)((FscOrderRelationPO)relationPOS.get(0)).getExpType())) {
            expType = relationPOS.stream().map(x -> x.getExpType()).distinct().collect(Collectors.joining(","));
        } else {
            FscExpenseTypePO typePO = new FscExpenseTypePO();
            typePO.setFscOrderId(reqBO.getOrderId());
            List expenseTypePOS = this.fscExpenseTypeMapper.getList(typePO);
            if (!CollectionUtils.isEmpty((Collection)expenseTypePOS) && StringUtils.isNotBlank((CharSequence)((FscExpenseTypePO)expenseTypePOS.get(0)).getExpLineType())) {
                expType = expenseTypePOS.stream().map(x -> x.getExpLineType()).distinct().collect(Collectors.joining(","));
            }
        }
        BigDecimal untaxAmtSum = BigDecimal.ZERO;
        BigDecimal taxAmtSum = BigDecimal.ZERO;
        BigDecimal amtSum = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty((Collection)invoicePOS)) {
            PdfPTable contextRow7 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)1, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)expType, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
            tableList.add(contextRow7);
            contextRow8 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)contextRow8, (Object)"\u5408\u8ba1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)16, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow8, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow8, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow8, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
            tableList.add(contextRow8);
        } else {
            Boolean invoiceTypeFlag = false;
            for (int i = 0; i < invoicePOS.size(); ++i) {
                FscInvoicePO fscInvoicePO = (FscInvoicePO)invoicePOS.get(i);
                PdfPTable contextRow7 = PdfUtils.newPdfTable();
                BigDecimal unTaxAmtItem = fscInvoicePO.getUntaxAmt().stripTrailingZeros().setScale(2, 4);
                BigDecimal taxAmtItem = fscInvoicePO.getTaxAmt().stripTrailingZeros().setScale(2, 4);
                BigDecimal amtItem = fscInvoicePO.getAmt().stripTrailingZeros().setScale(2, 4);
                invoiceTypeFlag = "01".equals(fscInvoicePO.getInvoiceType());
                PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
                PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)expType, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)5, null);
                PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)fscInvoicePO.getInvoiceNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)5, null);
                PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)fscInvoicePO.getBillDate(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
                PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)(invoiceTypeFlag != false ? amtItem : unTaxAmtItem), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
                PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)(invoiceTypeFlag != false ? BigDecimal.ZERO : taxAmtItem), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)2, null);
                PdfUtils.addCellToTable((PdfPTable)contextRow7, (Object)amtItem, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
                tableList.add(contextRow7);
                untaxAmtSum = untaxAmtSum.add(unTaxAmtItem);
                taxAmtSum = taxAmtSum.add(taxAmtItem);
                amtSum = amtSum.add(amtItem);
            }
            contextRow8 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)contextRow8, (Object)"\u5408\u8ba1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)16, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow8, (Object)(invoiceTypeFlag != false ? amtSum : untaxAmtSum), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow8, (Object)(invoiceTypeFlag != false ? BigDecimal.ZERO : taxAmtSum), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)contextRow8, (Object)amtSum, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)3, null);
            tableList.add(contextRow8);
        }
        BigDecimal amount = orderDetail.getTotalCharge().subtract(orderDetail.getWriteOffAmount());
        PdfPTable contextRow9 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)contextRow9, (Object)"\u672c\u6b21\u6838\u9500\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow9, (Object)orderDetail.getWriteOffAmount(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow9, (Object)"\u5408\u540c\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow9, (Object)contractRspBO.getContractAmount(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow9, (Object)"\u672c\u6b21\u7ed3\u7b97\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow9, (Object)amount, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)5, null);
        tableList.add(contextRow9);
        tableList.add(this.dealCellBorder("\u7ed3\u7b97\u91d1\u989d", AmountUtils.upper((BigDecimal)amount), amount.toString()));
        PdfPTable contextRow12 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)contextRow12, (Object)"\u6536\u6b3e\u65b9", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow12, (Object)"\u5f00\u6237\u94f6\u884c", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow12, (Object)"\u94f6\u884c\u8d26\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)8, null);
        tableList.add(contextRow12);
        OrderInvoiceBO orderInvoiceBO = (OrderInvoiceBO)orderDetail.getOrderInvoiceInfo().get(0);
        String bank = orderInvoiceBO.getBank();
        String account = orderInvoiceBO.getAccount();
        FscMerchantPayeePO merchantPayeePO = new FscMerchantPayeePO();
        merchantPayeePO.setSupplierId(orderDetail.getSupplierId());
        List list = this.fscMerchantPayeeMapper.getList(merchantPayeePO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            bank = ((FscMerchantPayeePO)list.get(0)).getPayeeBankName();
            account = ((FscMerchantPayeePO)list.get(0)).getPayeeBankAccount();
        }
        PdfPTable contextRow13 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)contextRow13, (Object)orderDetail.getSupplierName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow13, (Object)bank, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)contextRow13, (Object)account, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, null, (Integer)8, null);
        tableList.add(contextRow13);
        PdfPTable wrapRow = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)wrapRow, (Object)"", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)24, (Integer)0);
        tableList.add(wrapRow);
        PdfPTable pageTableAuditTitle = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAuditTitle, (Object)"\u5ba1\u6279\u8bb0\u5f55", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(35.0f), (Integer)24, null);
        PdfPTable pageTableAudit = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u8282\u70b9", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(20.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u65e5\u671f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, null, (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u7ec4", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, null, (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, null, (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u610f\u89c1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, null, (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u72b6\u6001", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, null, (Integer)4, null);
        tableList.add(pageTableAudit);
        if (!CollectionUtils.isEmpty(approvalList)) {
            for (int i = 0; i < approvalList.size(); ++i) {
                PdfPTable auditTable = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)String.valueOf(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)((FscApprovalprocessListBO)approvalList.get(i)).getTime()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)((FscApprovalprocessListBO)approvalList.get(i)).getStationName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)((FscApprovalprocessListBO)approvalList.get(i)).getOperName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)((FscApprovalprocessListBO)approvalList.get(i)).getAdvice()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)((FscApprovalprocessListBO)approvalList.get(i)).getAudit()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                tableList.add(auditTable);
            }
        }
        return tableList;
    }

    public void dealStationInfo(List<FscApprovalprocessListBO> approvalList) {
        approvalList.get(0).setStationName("\u63d0\u4ea4\u4eba");
        for (int i = 0; i < approvalList.size() - 1; ++i) {
            if (approvalList.get(i).getNextStationId() == null) continue;
            approvalList.get(i + 1).setStationId(approvalList.get(i).getNextStationId());
            DycStationSelectReqBO dycStationSelectReqBO = new DycStationSelectReqBO();
            dycStationSelectReqBO.setStationId(Long.valueOf(approvalList.get(i).getNextStationId()));
            DycStationSelectRspBO dycStationSelectRspBO = this.dycStationSelectService.stationSelectById(dycStationSelectReqBO);
            if (!ObjectUtils.isEmpty((Object)dycStationSelectRspBO.getData())) {
                approvalList.get(i + 1).setStationName(dycStationSelectRspBO.getData().getStationName());
                continue;
            }
            approvalList.get(i + 1).setStationName(approvalList.get(i).getNextStationId());
        }
        log.info("\u4e8c\u6b21\u5904\u7406\u4fe1\u606f\u4eba\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014:" + approvalList.toString());
    }

    private PdfPCell createCell(String content, int rowspan, int colspan, float fixedHeight) {
        Font font = PdfUtils.DEFAULT_SECOND_TITLE_FONT;
        if (fixedHeight == Float.NaN) {
            font = PdfUtils.DEFAULT_CONTENT_FONT;
        }
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(content, font));
        if (fixedHeight != Float.NaN) {
            cell.setFixedHeight(fixedHeight);
        }
        cell.setFixedHeight(fixedHeight);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        if (rowspan != 0) {
            cell.setRowspan(rowspan);
        }
        cell.setColspan(colspan);
        return cell;
    }

    private PdfPTable dealCellBorder(String a, String b, String c) {
        PdfPTable contextRow10 = PdfUtils.newPdfTable();
        contextRow10.getDefaultCell().setBorder(0);
        PdfPCell cell1 = this.createCell(a, 0, 3, 20.0f);
        cell1.setBorderWidthRight(0.0f);
        contextRow10.addCell(cell1);
        PdfPCell cell2 = this.createCell("\uff08\u5927\u5199\uff09" + b, 0, 11, Float.NaN);
        cell2.setBorderWidthLeft(0.0f);
        cell2.setBorderWidthRight(0.0f);
        contextRow10.addCell(cell2);
        PdfPCell cell3 = this.createCell("\uff08\u5c0f\u5199\uff09" + c, 0, 10, Float.NaN);
        cell3.setBorderWidthLeft(0.0f);
        contextRow10.addCell(cell3);
        return contextRow10;
    }
}

