/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.authority.busi.api.DycStationSelectService;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.fsc.bill.ability.api.FscRefundBillListPrintService;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintRspBO;
import com.tydic.fsc.bill.ability.bo.FscRefundBillListPrintReqBO;
import com.tydic.fsc.bill.ability.bo.FscRefundBillListPrintRspBO;
import com.tydic.fsc.bill.busi.api.FscBillValidOverdraftBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillValidOverdraftBusiReqBO;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.bo.FscOrderItemDetailBO;
import com.tydic.fsc.bo.OrderInvoiceBO;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundDetailAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComRefundDetailAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundDetailAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.enums.FscPostingStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.CheckUtils;
import com.tydic.fsc.util.FscStringUtils;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.uoc.common.ability.api.PebExtMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocMainOrderDetailQueryRspBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscRefundBillListPrintService"})
public class FscRefundBillListPrintServiceImpl
implements FscRefundBillListPrintService {
    private static final Logger log = LoggerFactory.getLogger(FscRefundBillListPrintServiceImpl.class);
    private FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService;
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    private FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService;
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    private DycStationSelectService dycStationSelectService;
    private PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final int RECEIVE_TYPE = 2;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscComRefundDetailAbilityService fscComRefundDetailAbilityService;
    @Autowired
    private UocMainOrderDetailQueryAbilityService uocMainOrderDetailQueryAbilityService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscBillValidOverdraftBusiService fscBillValidOverdraftBusiService;

    @PostMapping(value={"fscRefundBillListPrint"})
    public FscRefundBillListPrintRspBO fscRefundBillListPrint(@RequestBody FscRefundBillListPrintReqBO reqBO) {
        if (CheckUtils.isBlank((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u9000\u7968\u5355ID\u4e3a\u7a7a");
        }
        FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
        fscOrderRefundPO.setRefundId(reqBO.getOrderId());
        fscOrderRefundPO = this.fscOrderRefundMapper.getModelBy(fscOrderRefundPO);
        String pdfUrl = this.createBillPdfPrint(fscOrderRefundPO);
        if (FscPostingStatusEnum.EFFECTIVE.getCode().equals(String.valueOf(fscOrderRefundPO.getPostStatus()))) {
            FscBillValidOverdraftBusiReqBO busiReqBO = new FscBillValidOverdraftBusiReqBO();
            ArrayList<FscBillListPrintRspBO> bos = new ArrayList<FscBillListPrintRspBO>();
            FscBillListPrintRspBO printRspBO = new FscBillListPrintRspBO();
            printRspBO.setFscOrderId(reqBO.getOrderId());
            printRspBO.setPrintUrl(pdfUrl);
            bos.add(printRspBO);
            busiReqBO.setBos(bos);
            this.fscBillValidOverdraftBusiService.dealDownRefundAttachment(busiReqBO);
        }
        return new FscRefundBillListPrintRspBO(pdfUrl, fscOrderRefundPO.getRefundNo());
    }

    private String createBillPdfPrint(FscOrderRefundPO fscOrderRefundPO) {
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        List<PdfPTable> list = this.addPdfTable(fscOrderRefundPO);
        PdfUtils.addTableListToDoc((Document)document, list);
        document.close();
        return this.uploadFile("\u9500\u552e\u9000\u7968\u5355", byteArrayOutputStream);
    }

    private List<PdfPTable> addPdfTable(FscOrderRefundPO fscOrderRefundPO) {
        FscComRefundDetailAbilityReqBO reqBO = new FscComRefundDetailAbilityReqBO();
        reqBO.setRefundId(fscOrderRefundPO.getRefundId());
        FscComRefundDetailAbilityRspBO fscComRefundDetailAbilityRspBO = this.fscComRefundDetailAbilityService.qryRefundDetail(reqBO);
        FscComOrderDetailQueryAbilityReqBO orderDetailReqBO = new FscComOrderDetailQueryAbilityReqBO();
        orderDetailReqBO.setOrderId(fscOrderRefundPO.getFscOrderId());
        FscComOrderDetailQueryAbilityRspBO orderDetail = this.fscComOrderDetailQueryAbilityService.qryOrderDetail(orderDetailReqBO);
        ContractDetailQueryAbilityReqBO contractDetailBO = new ContractDetailQueryAbilityReqBO();
        contractDetailBO.setContractId(orderDetail.getContractId());
        ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailBO);
        FscOrderItemDetailQueryAbilityReqBO orderItemDetailBO = new FscOrderItemDetailQueryAbilityReqBO();
        orderItemDetailBO.setFscOrderIdList(Stream.of(fscOrderRefundPO.getFscOrderId()).collect(Collectors.toList()));
        FscOrderItemDetailQueryAbilityRspBO fscOrderItemDetailQueryAbilityRspBO = this.fscOrderItemDetailQueryAbilityService.queryOrderItemDetail(orderItemDetailBO);
        List fscOrderItemDetail = fscOrderItemDetailQueryAbilityRspBO.getFscOrderItemDetailBOS();
        List orderList = fscOrderItemDetail.stream().map(FscOrderItemDetailBO::getOrderId).distinct().collect(Collectors.toList());
        FscOrderItemDetailQueryAbilityReqBO itemDetailQueryAbilityReqBO = new FscOrderItemDetailQueryAbilityReqBO();
        itemDetailQueryAbilityReqBO.setOrderIds(orderList);
        List acceptOrderIdList = fscOrderItemDetail.stream().map(FscOrderItemDetailBO::getAcceptOrderId).distinct().collect(Collectors.toList());
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setAcceptOrderIds(acceptOrderIdList);
        fscShouldPayPo.setPayeeIdNot(this.operationOrgId);
        fscShouldPayPo.setShouldPayTypeNot(FscConstants.ShouldPayType.PAYMENT_ADVANCE_PAY);
        FscOrderWriteRelationPO fscOrderWriteRelationPO = new FscOrderWriteRelationPO();
        fscOrderWriteRelationPO.setRefundId(fscOrderRefundPO.getRefundId());
        List writeRelationList = this.fscOrderWriteRelationMapper.getList(fscOrderWriteRelationPO);
        BigDecimal totalWrite = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)writeRelationList)) {
            totalWrite = writeRelationList.stream().map(FscOrderWriteRelationPO::getWriteOffAmount).reduce(BigDecimal::add).get();
        }
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = (FscComApprovalprocessListQryAbilityReqBO)BeanUtil.copyProperties((Object)reqBO, FscComApprovalprocessListQryAbilityReqBO.class);
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(fscOrderRefundPO.getRefundId());
        fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(8));
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
            this.dealStationInfo(approvalList);
        }
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, fscOrderRefundPO, fscComRefundDetailAbilityRspBO);
        this.addMiddleTable(tableList, fscComRefundDetailAbilityRspBO, orderDetail, contractDetailQueryAbilityRspBO, fscOrderItemDetailQueryAbilityRspBO, totalWrite);
        this.addFootTable(tableList, orderDetail, writeRelationList, fscComRefundDetailAbilityRspBO.getRefundNote());
        this.addAuditTable(tableList, approvalList);
        return tableList;
    }

    private void addHeadTable(List<PdfPTable> tableList, FscOrderRefundPO fscOrderRefundPO, FscComRefundDetailAbilityRspBO fscComRefundDetailAbilityRspBO) {
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)23, null);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)("\u9644\u4ef6" + (fscComRefundDetailAbilityRspBO.getAttachmentList() == null ? 0 : fscComRefundDetailAbilityRspBO.getAttachmentList().size()) + "\u5f20"), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)1, null);
        tableList.add(titleTable1);
        String name = "\u9500\u552e\u7ed3\u7b97\u9000\u7968\u5355";
        tableList.add(this.dealColor(fscOrderRefundPO, name));
        PdfPTable pageTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u90e8\u95e8", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)FscStringUtils.convertValueCopy((Object)fscOrderRefundPO.getAgentDeptName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)FscStringUtils.convertValueCopy((Object)fscOrderRefundPO.getAgentUserName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        tableList.add(pageTable3);
    }

    private void addMiddleTable(List<PdfPTable> tableList, FscComRefundDetailAbilityRspBO fscComRefundDetailAbilityRspBO, FscComOrderDetailQueryAbilityRspBO orderDetail, ContractDetailQueryAbilityRspBO contractDetail, FscOrderItemDetailQueryAbilityRspBO orderItemDetail, BigDecimal totalWrite) {
        List orderItemDetailBOList = orderItemDetail.getFscOrderItemDetailBOS();
        FscOrderItemPO fscOrderItemPO = this.fscOrderItemMapper.getSumAmt(orderDetail.getFscOrderId());
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setRefundId(fscComRefundDetailAbilityRspBO.getRefundId());
        List fscInvoicePOList = this.fscInvoiceMapper.getSumAmtByRefundId(fscInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
            fscInvoicePO = (FscInvoicePO)fscInvoicePOList.get(0);
        }
        FscOrderItemPO po = new FscOrderItemPO();
        po.setRefundId(fscComRefundDetailAbilityRspBO.getRefundId());
        List refundList = this.fscOrderItemMapper.getRefundList(po);
        List orderItemIdList = refundList.stream().map(FscOrderItemPO::getOrderItemId).collect(Collectors.toList());
        Map<Long, BigDecimal> orderItemIdAndNumMap = refundList.stream().collect(Collectors.groupingBy(FscOrderItemPO::getOrderItemId, Collectors.reducing(BigDecimal.ZERO, FscOrderItemPO::getNum, BigDecimal::add)));
        po = new FscOrderItemPO();
        po.setOrderItemIds(orderItemIdList);
        po.setFscOrderId(orderDetail.getFscOrderId());
        List listNoPage = this.fscOrderItemMapper.getListByFscOrderIdAndOrderItemId(po);
        BigDecimal reduce = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)listNoPage)) {
            for (FscOrderItemPO itemPO : listNoPage) {
                if (itemPO.getOrderItemId() == null) continue;
                BigDecimal num = orderItemIdAndNumMap.get(itemPO.getOrderItemId());
                BigDecimal purchaseAmt = itemPO.getPurchasePrice().multiply(num);
                BigDecimal purchaseTaxAmt = TaxUtils.calTaxAmt((BigDecimal)purchaseAmt, (BigDecimal)itemPO.getTaxRate());
                reduce = reduce.add(purchaseAmt.subtract(purchaseTaxAmt));
            }
        }
        PdfPTable pageTable4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u9000\u7968\u7533\u8bf7\u7f16\u7801", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)FscStringUtils.convertValueCopy((Object)fscComRefundDetailAbilityRspBO.getRefundNo()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u539f\u9500\u552e\u7ed3\u7b97\u5355\u7801", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)FscStringUtils.convertValueCopy((Object)fscComRefundDetailAbilityRspBO.getFscOrderNo()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u4e1a\u52a1\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        String fscTypeStr = "-";
        if (orderDetail.getOrderType() != null) {
            Map<String, Map<String, String>> dicMap = this.getDicMap();
            fscTypeStr = dicMap.get("FSC_TYPE").get(orderDetail.getOrderType().toString());
        }
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)fscTypeStr, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable4);
        PdfPTable pageTable = PdfUtils.newPdfTable();
        Set<Object> setOrderNO = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)orderItemDetailBOList)) {
            setOrderNO = orderItemDetailBOList.stream().map(FscOrderItemDetailBO::getOrderCode).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        ArrayList<String> agreeNoList = new ArrayList<String>();
        ArrayList<String> agreeNameList = new ArrayList<String>();
        PebExtMainOrderDetailQueryReqBO pebExtMainOrderDetailQueryReqBO = new PebExtMainOrderDetailQueryReqBO();
        pebExtMainOrderDetailQueryReqBO.setOrderId(((FscOrderItemDetailBO)orderItemDetailBOList.get(0)).getOrderId());
        PebExtMainOrderDetailQueryRspBO pebExtMainOrderDetailQuery = this.pebExtMainOrderDetailQueryAbilityService.getPebExtMainOrderDetailQuery(pebExtMainOrderDetailQueryReqBO);
        if ("0000".equals(pebExtMainOrderDetailQuery.getRespCode()) && CheckUtils.isNotBlank((Object)pebExtMainOrderDetailQuery) && CheckUtils.isNotBlank((Object)pebExtMainOrderDetailQuery.getOrdAgreementRspBO()) && !org.springframework.util.StringUtils.isEmpty((Object)pebExtMainOrderDetailQuery.getOrdAgreementRspBO().getPlaAgreementCode())) {
            agreeNoList.add(pebExtMainOrderDetailQuery.getOrdAgreementRspBO().getPlaAgreementCode());
            agreeNameList.add(pebExtMainOrderDetailQuery.getOrdAgreementRspBO().getAgreementName());
        }
        UocMainOrderDetailQueryReqBO uocMainOrderDetailQueryReqBO = new UocMainOrderDetailQueryReqBO();
        uocMainOrderDetailQueryReqBO.setOrderId(((FscOrderItemDetailBO)orderItemDetailBOList.get(0)).getOrderId());
        uocMainOrderDetailQueryReqBO.setQueryLevelList(Collections.singletonList(3));
        log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)uocMainOrderDetailQueryReqBO));
        UocMainOrderDetailQueryRspBO uocMainOrderDetailQuery = this.uocMainOrderDetailQueryAbilityService.getUocMainOrderDetailQuery(uocMainOrderDetailQueryReqBO);
        if (!"0000".equals(uocMainOrderDetailQuery.getRespCode())) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + uocMainOrderDetailQuery.getRespDesc());
        }
        String catt = "-";
        if (uocMainOrderDetailQuery.getOrdAgreementRspBO() != null && StringUtils.isNotBlank((CharSequence)uocMainOrderDetailQuery.getOrdAgreementRspBO().getAgreementId())) {
            AgrAgreementBO agrAgreementBO;
            AgrQryAgreementSubjectDetailsAbilityReqBO agrQryAgreementSubjectDetailsAbilityReqBO = new AgrQryAgreementSubjectDetailsAbilityReqBO();
            agrQryAgreementSubjectDetailsAbilityReqBO.setAgreementId(Long.valueOf(uocMainOrderDetailQuery.getOrdAgreementRspBO().getAgreementId()));
            agrQryAgreementSubjectDetailsAbilityReqBO.setTranslateFlag(Boolean.valueOf(false));
            agrQryAgreementSubjectDetailsAbilityReqBO.setQueryAttachmentFlag(Boolean.valueOf(false));
            agrQryAgreementSubjectDetailsAbilityReqBO.setQueryScopeFlag(Boolean.valueOf(false));
            AgrQryAgreementSubjectDetailsAbilityRspBO agrQryAgreementSubjectDetailsAbilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(agrQryAgreementSubjectDetailsAbilityReqBO);
            if (agrQryAgreementSubjectDetailsAbilityRspBO != null && agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO() != null && StringUtils.isNotBlank((CharSequence)(agrAgreementBO = agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO()).getCategory())) {
                catt = agrAgreementBO.getCategory();
            }
        }
        PdfUtils.addCellToTable((PdfPTable)pageTable, (Object)"\u8ba2\u5355\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable, (Object)String.join((CharSequence)",", setOrderNO), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable, (Object)"\u54c1\u7c7b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable, (Object)catt, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable, (Object)"\u9000\u7968\u539f\u56e0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable, (Object)FscStringUtils.convertValueCopy((Object)fscComRefundDetailAbilityRspBO.getRefundReason()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable);
        PdfPTable pageTable5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u9500\u552e\u534f\u8bae\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)(!CollectionUtils.isEmpty(agreeNoList) ? agreeNoList.stream().distinct().collect(Collectors.joining(",")) : "-"), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u9500\u552e\u534f\u8bae\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)(!CollectionUtils.isEmpty(agreeNameList) ? agreeNameList.stream().distinct().collect(Collectors.joining(",")) : "-"), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u672c\u6b21\u6210\u672c\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)listNoPage.stream().map(FscOrderItemPO::getPurchaseUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).negate().setScale(2, RoundingMode.HALF_UP)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable5);
        PdfPTable pageTable6 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u5e01\u79cd", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u4eba\u6c11\u5e01", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u6c47\u7387", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"1", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u7a0e\u7387", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)(CollectionUtils.isEmpty((Collection)orderItemDetailBOList) || org.springframework.util.StringUtils.isEmpty((Object)((FscOrderItemDetailBO)orderItemDetailBOList.get(0)).getTaxRate()) ? "-" : ((FscOrderItemDetailBO)orderItemDetailBOList.get(0)).getTaxRate().multiply(new BigDecimal("100")) + "%"), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable6);
        PdfPTable pageTable11 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)"\u672c\u6b21\u9000\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)(fscInvoicePO.getUntaxAmt() == null ? "-" : AmountUtils.formatWithThousandSeparator((BigDecimal)fscInvoicePO.getUntaxAmt().setScale(2, RoundingMode.HALF_UP))), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)"\u672c\u6b21\u9000\u7968\u7a0e\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)(fscInvoicePO.getAmt() == null || fscInvoicePO.getUntaxAmt() == null ? "-" : AmountUtils.formatWithThousandSeparator((BigDecimal)fscInvoicePO.getAmt().subtract(fscInvoicePO.getUntaxAmt()).setScale(2, RoundingMode.HALF_UP))), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)"\u672c\u6b21\u9000\u7968\u91d1\u989d(\u542b\u7a0e)", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)(fscInvoicePO.getAmt() == null ? "-" : AmountUtils.formatWithThousandSeparator((BigDecimal)fscInvoicePO.getAmt().setScale(2, RoundingMode.HALF_UP))), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable11);
    }

    private void addFootTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO orderDetail, List<FscOrderWriteRelationPO> writeRelationList, String refundNote) {
        PdfPTable pageTable16 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable16, (Object)"\u9000\u7968\u8bf4\u660e", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable16, (Object)refundNote, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(pageTable16);
        if (!CollectionUtils.isEmpty((Collection)orderDetail.getOrderInvoiceInfo())) {
            OrderInvoiceBO orderInvoiceInfo = (OrderInvoiceBO)orderDetail.getOrderInvoiceInfo().get(0);
            PdfPTable pageTableAuditTitle = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTableAuditTitle, (Object)"\u5f00\u7968\u4fe1\u606f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(35.0f), (Integer)24, null);
            tableList.add(pageTableAuditTitle);
            PdfPTable pageTable161 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u5e8f\u53f7 ", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u53d1\u7968\u62ac\u5934", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u53d1\u7968\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u5730\u5740/\u7535\u8bdd", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable161, (Object)"\u5f00\u6237\u94f6\u884c/\u94f6\u884c\u8d26\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(pageTable161);
            PdfPTable pageTable162 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)"1", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)(StringUtils.isBlank((CharSequence)orderInvoiceInfo.getBuyName()) ? "-" : orderInvoiceInfo.getBuyName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)FscStringUtils.convertValueCopy((Object)orderInvoiceInfo.getInvoiceTypeStr()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)FscStringUtils.convertValueCopy((Object)orderInvoiceInfo.getTaxNo()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)(orderInvoiceInfo.getAddress() + "/" + orderInvoiceInfo.getPhone()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable162, (Object)(orderInvoiceInfo.getBank() + "/" + orderInvoiceInfo.getAccount()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(pageTable162);
        }
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    public void dealStationInfo(List<FscApprovalprocessListBO> approvalList) {
        approvalList.get(0).setStationName("\u53d1\u8d77\u5ba1\u6279");
        for (int i = 1; i < approvalList.size(); ++i) {
            if (StringUtils.isNotBlank((CharSequence)approvalList.get(i).getStepName())) {
                approvalList.get(i).setStationName(approvalList.get(i).getStepName());
                continue;
            }
            approvalList.get(i).setStationName("\u53d1\u8d77\u5ba1\u6279");
        }
        log.info("\u4e8c\u6b21\u5904\u7406\u4fe1\u606f\u4eba\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014:" + approvalList.toString());
    }

    private BigDecimal dealDecimal(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        if (bigDecimal1 == null) {
            bigDecimal1 = BigDecimal.ZERO;
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = BigDecimal.ZERO;
        }
        return bigDecimal1.subtract(bigDecimal2).setScale(2, RoundingMode.HALF_UP);
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> dicPCodes = new ArrayList<String>();
        dicPCodes.add("FSC_TYPE");
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        for (String pCode : dicPCodes) {
            queryPo.setPCode(pCode);
            List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, FscDicDictionaryPO::getTitle));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }

    private PdfPTable dealColor(FscOrderRefundPO fscOrderRefundPO, String name) {
        PdfPTable pageTable2 = PdfUtils.newPdfTable();
        Integer pushResult = 0;
        FscPushLogPO pushLogPO = new FscPushLogPO();
        pushLogPO.setObjectId(fscOrderRefundPO.getRefundId());
        pushLogPO.setType(Integer.valueOf(19));
        pushLogPO.setStatus(Integer.valueOf(1));
        FscPushLogPO lastPushLog = this.fscPushLogMapper.getLastPushLog(pushLogPO);
        if (lastPushLog != null && lastPushLog.getStatus() != null) {
            pushResult = lastPushLog.getStatus();
        }
        if (pushResult == 1) {
            PdfUtils.addCellToTable((PdfPTable)pageTable2, (Object)name, (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)24, null);
        } else {
            PdfPCell cell1 = new PdfPCell();
            Paragraph paragraph = new Paragraph();
            paragraph.add((Element)new Chunk(name, PdfUtils.DEFAULT_TITLE_FONT));
            paragraph.add((Element)new Chunk("(\u6d41\u7a0b\u672a\u7ed3\u675f\uff0c\u4ec5\u4f9b\u9884\u89c8\u4f7f\u7528)", PdfUtils.DEFAULT_TITLE_FONT_RED));
            paragraph.setAlignment(1);
            cell1.addElement((Element)paragraph);
            cell1.setColspan(24);
            cell1.setFixedHeight(40.0f);
            cell1.setVerticalAlignment(5);
            pageTable2.addCell(cell1);
        }
        return pageTable2;
    }

    public void addAuditTable(List<PdfPTable> tableList, List<FscApprovalprocessListBO> auditList) {
        PdfPTable pageTableAuditTitle = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAuditTitle, (Object)"\u7b7e\u5b57\u5ba1\u6279", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(35.0f), (Integer)24, null);
        tableList.add(pageTableAuditTitle);
        PdfPTable pageTableAudit = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u65f6\u95f4", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u8282\u70b9", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u72b6\u6001", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u610f\u89c1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTableAudit);
        if (!CollectionUtils.isEmpty(auditList)) {
            for (int i = 0; i < auditList.size(); ++i) {
                PdfPTable auditTable = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)String.valueOf(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getTime()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getStationName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getOperName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getAudit()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getAdvice()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                tableList.add(auditTable);
            }
        }
    }

    @Autowired
    public void setFscComOrderDetailQueryAbilityService(FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService) {
        this.fscComOrderDetailQueryAbilityService = fscComOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setContractDetailQueryAbilityService(ContractDetailQueryAbilityService contractDetailQueryAbilityService) {
        this.contractDetailQueryAbilityService = contractDetailQueryAbilityService;
    }

    @Autowired
    public void setFscOrderItemDetailQueryAbilityService(FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService) {
        this.fscOrderItemDetailQueryAbilityService = fscOrderItemDetailQueryAbilityService;
    }

    @Autowired
    public void setFscComApprovalprocessListQryAbilityService(FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService) {
        this.fscComApprovalprocessListQryAbilityService = fscComApprovalprocessListQryAbilityService;
    }

    @Autowired
    public void setDycStationSelectService(DycStationSelectService dycStationSelectService) {
        this.dycStationSelectService = dycStationSelectService;
    }

    @Autowired
    public void setPebExtMainOrderDetailQueryAbilityService(PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService) {
        this.pebExtMainOrderDetailQueryAbilityService = pebExtMainOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setFscOrderRelationMapper(FscOrderRelationMapper fscOrderRelationMapper) {
        this.fscOrderRelationMapper = fscOrderRelationMapper;
    }

    @Autowired
    public void setFileClient(FileClient fileClient) {
        this.fileClient = fileClient;
    }
}

