/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.finance.FscEngineeringRefundInvoiceCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscEngineeringRefundInvoiceCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscEngineeringRefundInvoiceCreateAbilityRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscEngineeringRefundInvoiceCreateBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringRefundInvoiceCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringRefundInvoiceCreateBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscEngineeringRefundInvoiceCreateAbilityService"})
public class FscEngineeringRefundInvoiceCreateAbilityServiceImpl
implements FscEngineeringRefundInvoiceCreateAbilityService {
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscEngineeringRefundInvoiceCreateBusiService fscEngineeringRefundInvoiceCreateBusiService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealEngineeringRefundInvoiceCreate"})
    public FscEngineeringRefundInvoiceCreateAbilityRspBO dealEngineeringRefundInvoiceCreate(@RequestBody FscEngineeringRefundInvoiceCreateAbilityReqBO reqBO) {
        this.checkInput(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.ENGINEERING_INVOICE);
        FscOrderPO orderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (Objects.isNull(orderPO)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        if (!(FscConstants.FscInvoiceOrderState.BILLED.equals(orderPO.getOrderState()) || FscConstants.FscInvoiceOrderState.SIGNED.equals(orderPO.getOrderState()) || FscConstants.FscInvoiceOrderState.BILL_REFUSE.equals(orderPO.getOrderState()) || FscConstants.FscInvoiceOrderState.FINANCE_BACK.equals(orderPO.getOrderState()))) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u9000\u7968\uff01");
        }
        FscEngineeringRefundInvoiceCreateBusiRspBO busiRspBO = this.fscEngineeringRefundInvoiceCreateBusiService.dealEngineeringRefundInvoiceCreate((FscEngineeringRefundInvoiceCreateBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscEngineeringRefundInvoiceCreateBusiReqBO.class)));
        if (Objects.nonNull((Object)busiRspBO) && "0000".equals(busiRspBO.getRespCode())) {
            this.syncEs(reqBO);
        }
        return (FscEngineeringRefundInvoiceCreateAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscEngineeringRefundInvoiceCreateAbilityRspBO.class);
    }

    private void syncEs(FscEngineeringRefundInvoiceCreateAbilityReqBO reqBO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(reqBO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void checkInput(FscEngineeringRefundInvoiceCreateAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new FscBusinessException("198888", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getOperationType())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getRefundId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getFscOrderId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getRefundNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getCertification())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[certification]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getRefundReasonType())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundReasonType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getRefundNote())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundNote]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCwOrgId())) {
            throw new FscBusinessException("191000", "erp\u7f16\u7801[cwOrgid]\u4e0d\u80fd\u7a7a");
        }
    }
}

