/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderListQryAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderListQryReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderListQryRspBoInvocieList;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyRspBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.SSLClient;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderListQryAbilityService"})
public class FscFinanceInvoiceFolderListQryAbilityServiceImpl
implements FscFinanceInvoiceFolderListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceFolderListQryAbilityServiceImpl.class);
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscDictionaryBusiService dictionaryBusiService;
    @Value(value="${finance.invoice.item.url:}")
    private String invoiceItemUrl;

    @PostMapping(value={"qryFinanceInvoiceFolderList"})
    public FscRspPageBaseBO<FscFinanceInvoiceFolderListQryRspBoInvocieList> qryFinanceInvoiceFolderList(@RequestBody FscFinanceInvoiceFolderListQryReqBo reqBo) {
        if (Objects.isNull(reqBo.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[fscOrderId]\u4e3a\u7a7a");
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", this.getToken());
        JSONObject reqParam = new JSONObject();
        JSONObject bizTiItem = new JSONObject();
        bizTiItem.put("currentPage", (Object)reqBo.getPageNo());
        bizTiItem.put("pageSize", (Object)reqBo.getPageSize());
        bizTiItem.put("createUser", (Object)reqBo.getCreateOperNo());
        if ("2".equals(reqBo.getIsprofess())) {
            bizTiItem.put("relationUser", (Object)reqBo.getUserName());
        }
        if (Objects.equals(reqBo.getIsRefund(), 1)) {
            FscRefundFinancePO refundFinancePO = new FscRefundFinancePO();
            refundFinancePO.setRefundId(reqBo.getFscOrderId());
            refundFinancePO = this.fscRefundFinanceMapper.getModelBy(refundFinancePO);
            if (Objects.isNull(refundFinancePO) || StringUtils.isEmpty((CharSequence)refundFinancePO.getCompanySegmentCode())) {
                throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5bf9\u5e94\u7684\u516c\u53f8\u4fe1\u606f[companySegmentCode]\uff01");
            }
            bizTiItem.put("companyCode", (Object)refundFinancePO.getFinanceOrgId());
        } else {
            FscOrderFinancePO fscOrderFinancePo = new FscOrderFinancePO();
            fscOrderFinancePo.setFscOrderId(reqBo.getFscOrderId());
            fscOrderFinancePo = this.fscOrderFinanceMapper.getModelBy(fscOrderFinancePo);
            if (Objects.isNull(fscOrderFinancePo) || StringUtils.isEmpty((CharSequence)fscOrderFinancePo.getCompanySegmentCode())) {
                throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5bf9\u5e94\u7684\u516c\u53f8\u4fe1\u606f[companySegmentCode]\uff01");
            }
            bizTiItem.put("companyCode", (Object)fscOrderFinancePo.getFinanceOrgId());
        }
        bizTiItem.put("useStatus", (Object)"0");
        if (StringUtils.isNotEmpty((CharSequence)reqBo.getHeadName())) {
            bizTiItem.put("headName", (Object)reqBo.getHeadName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBo.getInvoiceType())) {
            reqParam.put("filter", (Object)(" invoice_type='" + reqBo.getInvoiceType() + "'"));
        }
        if (null != reqBo.getInvoiceDateBegin()) {
            reqParam.put("startDate", (Object)DateUtil.dateToStrYYYYMMdd((Date)reqBo.getInvoiceDateBegin()));
        }
        if (null != reqBo.getInvoiceDateEnd()) {
            reqParam.put("endDate", (Object)DateUtil.dateToStrYYYYMMdd((Date)reqBo.getInvoiceDateEnd()));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqBo.getSelectedGuid())) {
            reqParam.put("filterGuids", (Object)reqBo.getSelectedGuid());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBo.getRmbAmountTaxBegin())) {
            reqParam.put("minAmtTax", (Object)reqBo.getRmbAmountTaxBegin());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBo.getRmbAmountTaxEnd())) {
            reqParam.put("maxAmtTax", (Object)reqBo.getRmbAmountTaxEnd());
        }
        if (Integer.valueOf(1).equals(reqBo.getFilterType()) && StringUtils.isEmpty((CharSequence)reqBo.getRmbAmountTaxBegin())) {
            reqParam.put("minAmtTax", (Object)"0");
        }
        if (Integer.valueOf(2).equals(reqBo.getFilterType()) && StringUtils.isEmpty((CharSequence)reqBo.getRmbAmountTaxEnd())) {
            reqParam.put("maxAmtTax", (Object)"0");
        }
        reqParam.put("bizTiItem", (Object)bizTiItem);
        log.info("\u8d22\u52a1\u5171\u4eab\u67e5\u8be2\u53ef\u9009\u62e9\u53d1\u7968\u5217\u8868\u63a5\u53e3\u8bf7\u6c42param:{},\u8bf7\u6c42url:{}", (Object)reqParam.toJSONString(), (Object)this.invoiceItemUrl);
        String res = SSLClient.doPostWithHeadMap((String)this.invoiceItemUrl, (String)reqParam.toJSONString(), header);
        log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u67e5\u8be2\u53ef\u9009\u62e9\u53d1\u7968\u5217\u8868\u63a5\u53e3-\u8fd4\u56de\u62a5\u6587:{}", (Object)res);
        if (StringUtils.isEmpty((CharSequence)res)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u67e5\u8be2\u53ef\u9009\u62e9\u53d1\u7968\u5217\u8868\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        return this.parseData(res);
    }

    private FscRspPageBaseBO<FscFinanceInvoiceFolderListQryRspBoInvocieList> parseData(String respStr) {
        FscRspPageBaseBO rspBo = new FscRspPageBaseBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        FscFinanceOccupyRspBO res = (FscFinanceOccupyRspBO)JSONObject.parseObject((String)respStr, FscFinanceOccupyRspBO.class);
        if (!"0".equals(res.getCode())) {
            rspBo.setRespCode("190000");
            rspBo.setRespDesc("\u5931\u8d25");
            return rspBo;
        }
        Map data = res.getData();
        if (Objects.nonNull(data) && null != data.get("records")) {
            Map bypCodeBackMap = this.dictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_INVOICE_TYPE");
            List list = JSONObject.parseArray((String)((String)data.get("records")), FscFinanceInvoiceFolderListQryRspBoInvocieList.class);
            list.forEach(e -> {
                if ("1".equals(e.getTruthStatus())) {
                    e.setTruthStatusStr("\u67e5\u9a8c\u901a\u8fc7");
                } else if ("0".equals(e.getTruthStatus())) {
                    e.setTruthStatusStr("\u67e5\u9a8c\u5931\u8d25");
                }
                e.setInvoiceTypeStr((String)bypCodeBackMap.get(e.getInvoiceType()));
                if (StringUtils.isNotEmpty((CharSequence)e.getInvoiceDate())) {
                    e.setInvoiceDate(DateUtil.strTostr((String)e.getInvoiceDate(), (String)"yyyy-MM-dd", (String)"yyyyMMdd"));
                }
                if (null != e.getRmbAmountTax()) {
                    e.setRmbAmountTax(e.getRmbAmountTax().setScale(2, RoundingMode.HALF_UP));
                }
                if (null != e.getRmbAmount()) {
                    e.setRmbAmount(e.getRmbAmount().setScale(2, RoundingMode.HALF_UP));
                }
                if (null != e.getRmbTax()) {
                    e.setRmbTax(e.getRmbTax().setScale(2, RoundingMode.HALF_UP));
                }
            });
            rspBo.setPageNo(Integer.valueOf(Integer.parseInt((String)data.get("currentPage"))));
            int total = Integer.parseInt((String)data.get("total"));
            int pageSize = Integer.parseInt((String)data.get("pageSize"));
            rspBo.setRecordsTotal(Integer.valueOf(total));
            rspBo.setTotal(Integer.valueOf((total + pageSize - 1) / pageSize));
            rspBo.setRows(list);
        }
        return rspBo;
    }

    private String getToken() {
        FscFinanceShareTokenRspBO tokenRspBO = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        if (StringUtils.isEmpty((CharSequence)tokenRspBO.getToken())) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u8d22\u52a1\u5171\u4eabtoken\u5931\u8d25:" + tokenRspBO.getRespDesc());
        }
        return tokenRspBO.getToken();
    }
}

