/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderUploadAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadRspBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadRspBoData;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderUploadAbilityService"})
public class FscFinanceInvoiceFolderUploadAbilityServiceImpl
implements FscFinanceInvoiceFolderUploadAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceFolderUploadAbilityServiceImpl.class);
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Resource
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Value(value="${finance.invoice.upload.url:}")
    private String uploadUrl;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"uploadInvoiceFolder"})
    public FscFinanceInvoiceFolderUploadRspBo uploadInvoiceFolder(@RequestBody FscFinanceInvoiceFolderUploadReqBo reqBo) {
        List fileUrls = reqBo.getFileUrl();
        if (CollectionUtil.isEmpty((Collection)fileUrls)) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[fileUrl]\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBo.getGuid())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[guid]\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBo.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[fscOrderId]\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBo.getContractId())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[contractId]\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBo.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (Objects.isNull(fscOrderPO)) {
            throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        FscOrderFinancePO fscOrderFinancePo = new FscOrderFinancePO();
        fscOrderFinancePo.setFscOrderId(reqBo.getFscOrderId());
        fscOrderFinancePo = this.fscOrderFinanceMapper.getModelBy(fscOrderFinancePo);
        if (Objects.isNull(fscOrderFinancePo)) throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5bf9\u5e94\u7684\u5171\u4eab\u673a\u6784ID[financeOrgId]\uff01");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fscOrderFinancePo.getFinanceOrgId())) {
            throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5bf9\u5e94\u7684\u5171\u4eab\u673a\u6784ID[financeOrgId]\uff01");
        }
        FscFinanceInvoiceFolderUploadRspBo rspBo = new FscFinanceInvoiceFolderUploadRspBo();
        String result = null;
        File file = null;
        ArrayList<File> files = new ArrayList<File>();
        for (String fileUrl : fileUrls) {
            try {
                String fileName = Sequence.getInstance().nextId() + fileUrl.substring(fileUrl.lastIndexOf("."));
                HttpUtils.httpDownload((String)fileUrl, (String)fileName);
                byte[] bytes = FscFinanceInvoiceFolderUploadAbilityServiceImpl.getBytes(fileName);
                try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
                    file = new File(fileName);
                    files.add(file);
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        int temp;
                        byte[] bt = new byte[10240];
                        while ((temp = input.read(bt)) != -1) {
                            fos.write(bt, 0, temp);
                        }
                    }
                    catch (Exception e) {
                        rspBo.setRespCode("8888");
                        rspBo.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                        FscFinanceInvoiceFolderUploadRspBo fscFinanceInvoiceFolderUploadRspBo = rspBo;
                        input.close();
                        return fscFinanceInvoiceFolderUploadRspBo;
                    }
                }
                catch (Exception e) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                    return rspBo;
                }
            }
            catch (Exception e) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01" + e.getMessage());
                return rspBo;
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("createUser", (Object)fscOrderPO.getCreateOperNo());
        jsonObject.put("createUserName", (Object)fscOrderPO.getCreateOperName());
        jsonObject.put("companyCode", (Object)fscOrderFinancePo.getFinanceOrgId());
        if ("2".equals(reqBo.getIsprofess())) {
            jsonObject.put("relationUser", (Object)reqBo.getUserName());
            jsonObject.put("relationUserName", (Object)reqBo.getName());
        }
        jsonObject.put("headGuid", (Object)reqBo.getGuid());
        log.info("\u5171\u4eab\u53d1\u7968\u4e0a\u4f20ocr\u8bf7\u6c42\u53c2\u6570\uff1a" + jsonObject.toJSONString());
        log.info("\u5171\u4eab\u53d1\u7968\u4e0a\u4f20ocr\u8bf7\u6c42\u5730\u5740\uff1a" + this.uploadUrl);
        try {
            result = this.httpUpload(this.uploadUrl, files, jsonObject.toJSONString());
        }
        catch (IOException e) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5171\u4eab\u53d1\u7968\u4e0a\u4f20ocr\u5931\u8d25");
            return rspBo;
        }
        log.info("\u5171\u4eab\u53d1\u7968\u4e0a\u4f20ocr\u8fd4\u56de\u6570\u636e\uff1a" + result);
        return this.parse(result);
    }

    private FscFinanceInvoiceFolderUploadRspBo parse(String result) {
        FscFinanceInvoiceFolderUploadRspBo rspBO = new FscFinanceInvoiceFolderUploadRspBo();
        if (StringUtils.isEmpty((String)result)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        JSONObject object = JSONObject.parseObject((String)result);
        String code = object.getString("code");
        if (StringUtils.isEmpty((String)code)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u72b6\u6001\u7801code\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (!"0".equals(code)) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u63a5\u53e3\u5931\u8d25\uff1a" + object.getString("msg"));
            return rspBO;
        }
        JSONArray jsonArray = object.getJSONArray("data");
        if (jsonArray.isEmpty()) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u6587\u4ef6\u4e0a\u4f20ocr\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587data\u4e3a\u7a7a\uff1a");
            return rspBO;
        }
        String respArray = jsonArray.toJSONString();
        List list = JSONObject.parseArray((String)respArray, FscFinanceInvoiceFolderUploadRspBoData.class);
        rspBO.setData(list);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static byte[] getBytes(String filePath) throws IOException {
        File file = new File(filePath);
        byte[] buffer = new byte[(int)file.length()];
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead = fis.read(buffer);
            if (bytesRead != buffer.length) {
                throw new IOException("\u53ea\u8bfb\u53d6\u4e86\u90e8\u5206\u6587\u4ef6\u5185\u5bb9\uff0c\u9884\u671f=" + buffer.length + ", \u5b9e\u9645=" + bytesRead);
            }
        }
        catch (Exception e) {
            throw new IOException("\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25", e.getCause());
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpUpload(String actionUrl, List<File> files, String reqJson) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(actionUrl);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Authorization", this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken().getToken());
        String result = null;
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        multipartEntityBuilder.addTextBody("reqJson", reqJson, ContentType.APPLICATION_JSON);
        for (File file : files) {
            multipartEntityBuilder.addBinaryBody("file", (InputStream)new FileInputStream(file), ContentType.MULTIPART_FORM_DATA, file.getName());
        }
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httpPost.setEntity(reqEntity);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                System.out.println("--------------------------------------");
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                System.out.println("Response content: " + result);
                System.out.println("--------------------------------------");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

