/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceTempAbilityService;
import com.tydic.fsc.bill.ability.bo.FscOrderInvoiceListAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscOrderInvoiceListAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscOrderInvoiceListBo;
import com.tydic.fsc.bill.ability.enums.FscSettleStateEnum;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderItemTempMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderItemTempPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceTempAbilityService"})
public class FscFinanceInvoiceTempAbilityServiceImpl
implements FscFinanceInvoiceTempAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceTempAbilityServiceImpl.class);
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscOrderItemTempMapper fscOrderItemTempMapper;
    @Resource
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    private static final String INVOICED = "\u5df2\u5f00\u7968";
    private static final String PART_INVOICED = "\u90e8\u5206\u5f00\u7968";
    private static final String TO_BE_INVOICE = "\u5f85\u5f00\u7968";
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"queryTempInvoiceList"})
    public FscOrderInvoiceListAbilityRspBO queryTempInvoiceList(@RequestBody FscOrderInvoiceListAbilityReqBO reqBO) {
        FscOrderInfoBO orderInfoBO;
        this.checkInput(reqBO);
        FscOrderInvoiceListAbilityRspBO rspBO = new FscOrderInvoiceListAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Integer settleType = reqBO.getSettleType();
        List objIds = reqBO.getObjIdList();
        ArrayList<FscOrderInvoiceListBo> rows = new ArrayList<FscOrderInvoiceListBo>();
        BigDecimal purchaseFee = BigDecimal.ZERO;
        BigDecimal invoiceFee = BigDecimal.ZERO;
        BigDecimal leaveInvoiceFee = BigDecimal.ZERO;
        Map fscOrderInfoBoMap = new HashMap();
        FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
        fscOrderRelationTempPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderRelationTempPO.setContractId(reqBO.getContractId());
        List fscOrderRelationTempPOList = this.fscOrderRelationTempMapper.getList(fscOrderRelationTempPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationTempPOList)) {
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRows(rows);
            return rspBO;
        }
        objIds = FscConstants.SettleType.ORDER.equals(settleType) ? fscOrderRelationTempPOList.stream().map(FscOrderRelationTempPO::getOrderId).collect(Collectors.toList()) : fscOrderRelationTempPOList.stream().map(FscOrderRelationTempPO::getAcceptOrderId).collect(Collectors.toList());
        ArrayList<Long> totalAccetpOrderIdList = new ArrayList<Long>();
        if (FscConstants.SettleType.ORDER.equals(settleType)) {
            FscSaleOrderListQueryAtomReqBO fscSaleOrderListQueryAtomReqBO = new FscSaleOrderListQueryAtomReqBO();
            fscSaleOrderListQueryAtomReqBO.setOrderIds(objIds);
            fscSaleOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                fscSaleOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
            }
            fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
                fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
            }
            if (FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
                fscSaleOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.INDIVIDUAL_TYPE);
            }
            fscSaleOrderListQueryAtomReqBO.setTabId(this.SALE_ORDER_TAB_ID);
            fscSaleOrderListQueryAtomReqBO.setIsAfterSales(Boolean.valueOf(false));
            fscSaleOrderListQueryAtomReqBO.setPageNo(reqBO.getPageNo());
            fscSaleOrderListQueryAtomReqBO.setPageSize(reqBO.getPageSize());
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(fscSaleOrderListQueryAtomReqBO);
            log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)fscSaleOrderListQueryAtomRspBO));
            if (null == fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap()) {
                throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Map)fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)fscSaleOrderListQueryAtomRspBO));
            fscSaleOrderListQueryAtomReqBO.setPageSize(Integer.valueOf(10000));
            fscSaleOrderListQueryAtomReqBO.setPageNo(Integer.valueOf(1));
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListAllRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(fscSaleOrderListQueryAtomReqBO);
            if (CollectionUtils.isEmpty((Map)fscSaleOrderListAllRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            for (Long key : fscSaleOrderListAllRspBO.getFscOrderInfoBoMap().keySet()) {
                orderInfoBO = (FscOrderInfoBO)fscSaleOrderListAllRspBO.getFscOrderInfoBoMap().get(key);
                if (orderInfoBO.getInspInvoiceMoney() != null && orderInfoBO.getInspInvoiceMoney().compareTo(BigDecimal.ZERO) < 0) {
                    orderInfoBO.setInspInvoiceMoney(BigDecimal.ZERO);
                }
                leaveInvoiceFee = leaveInvoiceFee.add(orderInfoBO.getInspInvoiceMoney());
                totalAccetpOrderIdList.add(key);
            }
            fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            rspBO.setRecordsTotal(fscSaleOrderListQueryAtomRspBO.getRecordsTotal());
            rspBO.setTotal(fscSaleOrderListQueryAtomRspBO.getTotal());
            rspBO.setPageNo(fscSaleOrderListQueryAtomRspBO.getPageNo());
        } else {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(objIds);
            fscAcceptOrderListQueryAtomReqBO.setPageNo(reqBO.getPageNo());
            fscAcceptOrderListQueryAtomReqBO.setPageSize(reqBO.getPageSize());
            fscAcceptOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                fscAcceptOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
            }
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
                ArrayList<Integer> relTypeList = new ArrayList<Integer>();
                relTypeList.add(1);
                relTypeList.add(3);
                fscAcceptOrderListQueryAtomReqBO.setRelTypeList(relTypeList);
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
                fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
            }
            fscAcceptOrderListQueryAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
            if (reqBO.getFscOrderId() != null) {
                fscAcceptOrderListQueryAtomReqBO.setIsExclIsFscQuery(Integer.valueOf(1));
            }
            fscAcceptOrderListQueryAtomReqBO.setIgnore(Boolean.valueOf(true));
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (null == fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap()) {
                throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            fscAcceptOrderListQueryAtomReqBO.setPageSize(Integer.valueOf(10000));
            fscAcceptOrderListQueryAtomReqBO.setPageNo(Integer.valueOf(1));
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListAllRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            for (Long key : fscAcceptOrderListAllRspBO.getFscOrderInfoBoMap().keySet()) {
                orderInfoBO = (FscOrderInfoBO)fscAcceptOrderListAllRspBO.getFscOrderInfoBoMap().get(key);
                purchaseFee = purchaseFee.add(orderInfoBO.getInspTotalMoney());
                if (orderInfoBO.getInspInvoiceMoney() != null && orderInfoBO.getInspInvoiceMoney().compareTo(BigDecimal.ZERO) < 0) {
                    orderInfoBO.setInspInvoiceMoney(BigDecimal.ZERO);
                }
                leaveInvoiceFee = leaveInvoiceFee.add(orderInfoBO.getInspInvoiceMoney());
                totalAccetpOrderIdList.add(key);
            }
            rspBO.setRecordsTotal(fscAcceptOrderListQueryAtomRspBO.getRecordsTotal());
            rspBO.setTotal(fscAcceptOrderListQueryAtomRspBO.getTotal());
            rspBO.setPageNo(fscAcceptOrderListQueryAtomRspBO.getPageNo());
        }
        Map<Object, Object> selfInvoiceTempMap = new HashMap();
        FscOrderItemTempPO fscOrderItemTempPO = new FscOrderItemTempPO();
        fscOrderItemTempPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderItemTempPO.setContractId(reqBO.getContractId());
        List fscOrderItemTempPOList = this.fscOrderItemTempMapper.getList(fscOrderItemTempPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderItemTempPOList)) {
            selfInvoiceTempMap = fscOrderItemTempPOList.stream().collect(Collectors.groupingBy(FscOrderItemTempPO::getAcceptOrderId, Collectors.mapping(FscOrderItemTempPO::getAmt, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        }
        Map<Object, Object> billedInvoiceMap = new HashMap();
        FscOrderItemPO billedOrderItemQryPO = new FscOrderItemPO();
        billedOrderItemQryPO.setAcceptOrderIds(totalAccetpOrderIdList);
        billedOrderItemQryPO.setMakeType(reqBO.getMakeType());
        billedOrderItemQryPO.setReceiveType(reqBO.getReceiveType());
        billedOrderItemQryPO.setFscOrderStatus(Arrays.asList(1002, 1020, 1012, 1013, 1022, 1023, 1003));
        billedOrderItemQryPO.setRefundFlag(FscConstants.FscRefundFlag.NO);
        billedOrderItemQryPO.setExclRefundFlag(Integer.valueOf(1));
        List billedOrderPo = this.fscOrderItemMapper.getList(billedOrderItemQryPO);
        if (!CollectionUtils.isEmpty((Collection)billedOrderPo)) {
            billedInvoiceMap = billedOrderPo.stream().collect(Collectors.groupingBy(FscOrderItemPO::getAcceptOrderId, Collectors.mapping(FscOrderItemPO::getAmt, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            invoiceFee = billedOrderPo.stream().map(FscOrderItemPO::getAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        for (Long key : fscOrderInfoBoMap.keySet()) {
            FscOrderInvoiceListBo invoiceListBo = new FscOrderInvoiceListBo();
            FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)fscOrderInfoBoMap.get(key);
            invoiceListBo.setPurchaseFee(fscOrderInfoBO.getInspTotalMoney());
            invoiceListBo.setLeaveInvoiceFee(fscOrderInfoBO.getInspInvoiceMoney());
            if (fscOrderInfoBO.getInspInvoiceMoney() != null && fscOrderInfoBO.getInspInvoiceMoney().compareTo(BigDecimal.ZERO) < 0) {
                invoiceListBo.setLeaveInvoiceFee(BigDecimal.ZERO);
            }
            invoiceListBo.setOrderId(fscOrderInfoBO.getOrderId());
            invoiceListBo.setOrderNo(fscOrderInfoBO.getOrderNo());
            invoiceListBo.setObjId(fscOrderInfoBO.getAcceptOrderId());
            if (FscConstants.SettleType.ORDER.equals(settleType)) {
                invoiceListBo.setObjCode(fscOrderInfoBO.getOrderNo());
            } else {
                invoiceListBo.setObjCode(fscOrderInfoBO.getAcceptOrderNo());
            }
            if (!CollectionUtils.isEmpty(billedInvoiceMap) && billedInvoiceMap.containsKey(key)) {
                invoiceListBo.setInvoiceFee((BigDecimal)billedInvoiceMap.get(key));
            } else {
                invoiceListBo.setInvoiceFee(BigDecimal.ZERO);
            }
            if (invoiceListBo.getInvoiceFee().compareTo(BigDecimal.ZERO) == 0) {
                invoiceListBo.setInvoiceState(Integer.valueOf(1));
                invoiceListBo.setInvoiceStateStr(TO_BE_INVOICE);
            } else if (invoiceListBo.getInvoiceFee().compareTo(invoiceListBo.getPurchaseFee()) < 0) {
                invoiceListBo.setInvoiceState(Integer.valueOf(2));
                invoiceListBo.setInvoiceStateStr(PART_INVOICED);
            } else if (invoiceListBo.getInvoiceFee().compareTo(invoiceListBo.getPurchaseFee()) >= 0) {
                invoiceListBo.setInvoiceState(Integer.valueOf(3));
                invoiceListBo.setInvoiceStateStr(INVOICED);
            }
            if (Objects.nonNull(reqBO.getContractId()) && selfInvoiceTempMap.containsKey(key)) {
                if (Objects.isNull(reqBO.getSettleState()) || Objects.nonNull(((FscOrderRelationTempPO)fscOrderRelationTempPOList.get(0)).getSettleState()) && ((FscOrderRelationTempPO)fscOrderRelationTempPOList.get(0)).getSettleState().equals(reqBO.getSettleState())) {
                    invoiceListBo.setSelfInvoiceFeeTemp((BigDecimal)selfInvoiceTempMap.get(key));
                } else if (FscSettleStateEnum.QUALITY.getCode().equals(reqBO.getSettleState())) {
                    invoiceListBo.setSelfInvoiceFeeTemp(Objects.nonNull(fscOrderInfoBO.getDownTotalLeaveInvoiceQualityAmt()) ? fscOrderInfoBO.getDownTotalLeaveInvoiceQualityAmt() : BigDecimal.ZERO);
                } else if (FscSettleStateEnum.INSPECTION.getCode().equals(reqBO.getSettleState())) {
                    if (FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode().equals(fscOrderInfoBO.getOrderType())) {
                        invoiceListBo.setSelfInvoiceFeeTemp(fscOrderInfoBO.getIntegralFee());
                    } else {
                        invoiceListBo.setSelfInvoiceFeeTemp(Objects.nonNull(fscOrderInfoBO.getDownTotalLeaveInvoiceQualityAmt()) ? fscOrderInfoBO.getInspInvoiceMoney().subtract(fscOrderInfoBO.getDownTotalLeaveInvoiceQualityAmt()) : fscOrderInfoBO.getInspInvoiceMoney());
                    }
                } else if (FscSettleStateEnum.INSPECTION_QUALITY.getCode().equals(reqBO.getSettleState())) {
                    invoiceListBo.setSelfInvoiceFeeTemp(fscOrderInfoBO.getInspInvoiceMoney());
                }
            }
            rows.add(invoiceListBo);
        }
        BigDecimal totalInvoiceFeeTemp = rows.stream().map(FscOrderInvoiceListBo::getSelfInvoiceFeeTemp).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        rspBO.setTotalInvoiceFeeTemp(totalInvoiceFeeTemp);
        rspBO.setRows(rows);
        rspBO.setInvoiceFee(invoiceFee == null ? BigDecimal.ZERO : invoiceFee);
        rspBO.setLeaveInvoiceFee(leaveInvoiceFee == null ? BigDecimal.ZERO : leaveInvoiceFee);
        rspBO.setPurchaseFee(purchaseFee == null ? BigDecimal.ZERO : purchaseFee);
        return rspBO;
    }

    private void checkInput(FscOrderInvoiceListAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getContractId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getObjIdList()) && reqBO.getSettleType() == null) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

