/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.api.finance.FscFinancePurInvoiceSignApplyAbilityService;
import com.tydic.fsc.bill.ability.bo.FscFinanceWriteOffBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePurInvoiceSignApplyAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePurInvoiceSignApplyAbilityRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscFinancePurInvoiceSignApplyBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscFinancePurInvoiceSignApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscFinancePurInvoiceSignApplyBusiRspBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.bo.InvoiceCmpResultBO;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncEntrustNotificationAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSendNotificationService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushTodoAbilityServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscPushTodoAbilityServiceRspBO;
import com.tydic.fsc.common.ability.bo.FscSyncEntrustNotificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSendNotificationReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscInvoiceSignErrorMsgEnum;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinancePurInvoiceSignApplyAbilityService"})
public class FscFinancePurInvoiceSignApplyAbilityServiceImpl
implements FscFinancePurInvoiceSignApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePurInvoiceSignApplyAbilityServiceImpl.class);
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    private static BigDecimal TAX_AMOUNT_OTHER_CHECK = BigDecimal.ZERO;
    private static BigDecimal TOTAL_AMOUNT_EX_OTHER_CHECK = BigDecimal.ZERO;
    private static final String REPLACE_KEY = "#replace#";
    private static final String REPLACE_LIMIT_AMT = "##";
    private static final String ERROR_MSG_TITLE_BEGIN = "\u7ed3\u7b97\u5355";
    private static final String ERROR_MSG_TITLE_END = "\u4e0d\u7b26\u5408\u7b7e\u6536\u89c4\u5219\uff0c\u539f\u56e0\u5982\u4e0b\uff1a<br>";
    @Resource
    private FscShouldPayMapper fscShouldPayMapper;
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscFinancePurInvoiceSignApplyBusiService fscFinancePurInvoiceSignApplyBusiService;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSyncSendNotificationService fscSyncSendNotificationService;
    @Autowired
    private FscSyncEntrustNotificationAbilityService fscSyncEntrustNotificationAbilityService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPurInvoiceSignApply"})
    public FscFinancePurInvoiceSignApplyAbilityRspBO dealPurInvoiceSignApply(@RequestBody FscFinancePurInvoiceSignApplyAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (!(FscConstants.FscInvoiceOrderState.BILLED.equals(fscOrderPO.getOrderState()) || FscConstants.FscInvoiceOrderState.BILL_REFUSE.equals(fscOrderPO.getOrderState()) || FscConstants.FscInvoiceOrderState.FINANCE_BACK.equals(fscOrderPO.getOrderState()))) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + fscOrderPO.getOrderState() + "]\u4e0d\u5141\u8bb8\u7b7e\u6536\u7533\u8bf7");
        }
        if (!"0".equals(reqBO.getAutoSignFlag()) && FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            this.valCmpResult(reqBO);
            this.checkCmpResult(reqBO.getInvoiceCmpResult(), fscOrderPO);
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
        List itemPOList = this.fscOrderItemMapper.getFinanceList(fscOrderItemPO);
        List checkItemList = itemPOList.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getSettleItemCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkItemList)) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u660e\u7ec6\u4e2d\u7ed3\u7b97\u4e8b\u9879\u5fc5\u586b\uff01");
        }
        FscFinancePurInvoiceSignApplyBusiReqBO fscFinancePurInvoiceSignApplyBusiReqBO = (FscFinancePurInvoiceSignApplyBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscFinancePurInvoiceSignApplyBusiReqBO.class));
        fscFinancePurInvoiceSignApplyBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow()) && ("up_a".equals(reqBO.getSignSource()) || "up_b".equals(reqBO.getSignSource()))) {
            this.valUp(reqBO);
        }
        fscFinancePurInvoiceSignApplyBusiReqBO.setSettlePlatform(Objects.isNull(fscOrderPO.getSettlePlatform()) ? 0 : fscOrderPO.getSettlePlatform());
        fscFinancePurInvoiceSignApplyBusiReqBO.setTradeMode(fscOrderPO.getTradeMode());
        fscFinancePurInvoiceSignApplyBusiReqBO.setOrderSource(fscOrderPO.getOrderSource());
        fscFinancePurInvoiceSignApplyBusiReqBO.setBuynerNo(fscOrderPO.getBuynerNo());
        fscFinancePurInvoiceSignApplyBusiReqBO.setPayType(fscOrderPO.getPayType());
        FscFinancePurInvoiceSignApplyBusiRspBO fscFinancePurInvoiceSignApplyBusiRspBO = this.fscFinancePurInvoiceSignApplyBusiService.dealPurInvoiceSignApply(fscFinancePurInvoiceSignApplyBusiReqBO);
        if (!"0000".equals(fscFinancePurInvoiceSignApplyBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscFinancePurInvoiceSignApplyBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        this.sendFinanceSignApplyNoticeAndTodo(reqBO, fscOrderPO);
        this.sendFinanceSignApplyEntrustNotice(reqBO, fscFinancePurInvoiceSignApplyBusiRspBO, fscOrderPO);
        return (FscFinancePurInvoiceSignApplyAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)fscFinancePurInvoiceSignApplyBusiRspBO)), FscFinancePurInvoiceSignApplyAbilityRspBO.class);
    }

    private void checkCmpResult(InvoiceCmpResultBO invoiceCmpResultBO, FscOrderPO fscOrderPO) {
        this.checkCfcParam(invoiceCmpResultBO, fscOrderPO.getOrderSource());
        log.debug("\u6821\u9a8c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)invoiceCmpResultBO));
        if (invoiceCmpResultBO.getCmpResultStr().contains(FscConstants.FscInvoiceVerifyResult.NO.toString()) || Objects.nonNull(invoiceCmpResultBO.getPoolCmpResultNum()) && invoiceCmpResultBO.getPoolCmpResultNum() > 0) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(ERROR_MSG_TITLE_BEGIN);
            errorMsg.append(fscOrderPO.getOrderNo());
            errorMsg.append(ERROR_MSG_TITLE_END);
            int strLen = invoiceCmpResultBO.getCmpResultStr().length();
            int seq = 1;
            for (int i = 0; i < strLen; ++i) {
                if (invoiceCmpResultBO.getCmpResultStr().charAt(i) == FscConstants.FscInvoiceVerifyResult.NO.toString().charAt(0)) {
                    errorMsg.append(seq);
                    errorMsg.append(FscInvoiceSignErrorMsgEnum.getInstance((Integer)seq).getDescr());
                    ++seq;
                }
                if (i == 5) break;
            }
            if (seq > 1) {
                throw new FscBusinessException("191035", errorMsg.toString());
            }
        }
    }

    private void val(FscFinancePurInvoiceSignApplyAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
        if (Integer.valueOf(1).equals(reqBO.getPaySource())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderPayItemBOS())) {
                throw new FscBusinessException("191000", "\u5373\u6302\u5373\u4ed8\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (FscOrderPayItemBO fscOrderPayItemBO : reqBO.getFscOrderPayItemBOS()) {
            }
        }
    }

    private void valCmpResult(FscFinancePurInvoiceSignApplyAbilityReqBO reqBO) {
        if (null == reqBO.getInvoiceCmpResult()) {
            throw new FscBusinessException("191000", "\u5165\u53c2invoiceCmpResult\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInvoiceCmpResult().getCmpResultStr())) {
            throw new FscBusinessException("191000", "\u5165\u53c2cmpResultStr\u4e3a\u7a7a");
        }
    }

    private void valUp(FscFinancePurInvoiceSignApplyAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getDeptId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[deptId]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getDeptName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[deptName]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPersonId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[personId]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPersonName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[personName]\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPurWriteOffAmountList())) {
            for (FscFinanceWriteOffBO purBO : reqBO.getPurWriteOffAmountList()) {
                if (null == purBO.getPayOrderId()) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[purWriteOffAmount]\u7684[payOrderId]\u4e3a\u7a7a");
                }
                if (purBO.getWriteOffAmt().compareTo(new BigDecimal(0)) > 0) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2[purWriteOffAmount]\u7684[writeOffAmount]\u4e3a\u7a7a");
            }
        }
    }

    private void checkCfcParam(InvoiceCmpResultBO invoiceCmpResultBO, Integer orderSource) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_check_" + orderSource);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        StringBuffer cmpResult = new StringBuffer(invoiceCmpResultBO.getCmpResultStr());
        char resultYesChar = FscConstants.FscInvoiceVerifyResult.YES.toString().charAt(0);
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceTitleCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BUY_NAME.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxpayerIdCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.TAX_NO.getCode() - 1, resultYesChar);
        }
        Boolean categoryFlag = FscConstants.FscInvoiceCategory.FULL.equals(invoiceCmpResultBO.getInvoiceCategory());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAddressCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ADDRESS.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getPhoneCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.PHONE.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getBankCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BANK.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAccountCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ACCOUNT.getCode() - 1, resultYesChar);
        }
        invoiceCmpResultBO.setCmpResultStr(cmpResult.toString());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountCheck())) {
            invoiceCmpResultBO.setAmountMargin(BigDecimal.ZERO);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExCheck())) {
            invoiceCmpResultBO.setUntaxAmtMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck())) {
            BigDecimal diffUntaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck());
            TOTAL_AMOUNT_EX_OTHER_CHECK = diffUntaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountCheck())) {
            invoiceCmpResultBO.setTaxMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck())) {
            BigDecimal diffTaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck());
            TAX_AMOUNT_OTHER_CHECK = diffTaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceDetailCheck())) {
            invoiceCmpResultBO.setItemNumMargin(BigDecimal.ZERO);
        }
    }

    private void checkPrePay(FscOrderPO fscOrderPo) {
        FscOrderRelationPO relationPo = new FscOrderRelationPO();
        relationPo.setFscOrderId(fscOrderPo.getFscOrderId());
        List relationList = this.fscOrderRelationMapper.getList(relationPo);
        List orderIds = relationList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
        FscShouldPayPO queryVo = new FscShouldPayPO();
        queryVo.setOrderIds(orderIds);
        queryVo.setPayeeId(this.operationOrgId);
        ArrayList<Integer> shouldPayTypes = new ArrayList<Integer>(2);
        shouldPayTypes.add(FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY);
        shouldPayTypes.add(FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY);
        shouldPayTypes.add(FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY);
        shouldPayTypes.add(FscConstants.ShouldPayType.ADVANCE_PAY);
        queryVo.setShouldPayTypes(shouldPayTypes);
        ArrayList<Integer> shouldPayStatus = new ArrayList<Integer>();
        shouldPayStatus.add(FscConstants.ShouldPayStatus.TO_PAY);
        shouldPayStatus.add(FscConstants.ShouldPayStatus.PART_PAY);
        queryVo.setShouldPayStatusList(shouldPayStatus);
        List list = this.fscShouldPayMapper.getList(queryVo);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("198888", "\u9884\u4ed8\u6b3e\u672a\u5b8c\u6210\u65f6\u4e0d\u80fd\u63d0\u4ea4\u91c7\u8d2d\u7ed3\u7b97\u5355\u5ba1\u6279!");
        }
    }

    private void sendMq(FscFinancePurInvoiceSignApplyAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private FscOrderPO getFscOrderById(Long fscOrderId) {
        FscOrderPO qryFscOrder = new FscOrderPO();
        qryFscOrder.setFscOrderId(fscOrderId);
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(qryFscOrder);
        if (ObjectUtil.isEmpty((Object)fscOrderPO)) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
        }
        return fscOrderPO;
    }

    private void sendFinanceSignApplyNoticeAndTodo(FscFinancePurInvoiceSignApplyAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        this.sendFinanceSignApplyNotice(reqBO, fscOrderPO);
        this.sendFinanceSignApplyTodo(reqBO, fscOrderPO);
    }

    private void sendFinanceSignApplyNotice(FscFinancePurInvoiceSignApplyAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderPO.getSettlePlatform())) {
            return;
        }
        Map busiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        String busiTypeStr = fscOrderPO.getOrderType() == 2 && fscOrderPO.getTradeMode() != null && fscOrderPO.getTradeMode() == 2 && fscOrderPO.getOrderSource() == 3 && fscOrderPO.getSettlePlatform() != null && fscOrderPO.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)busiTypeMap.get(String.valueOf(fscOrderPO.getOrderType()));
        FscTaskCandidatePO taskCandidatePO = new FscTaskCandidatePO();
        taskCandidatePO.setFscOrderId(fscOrderPO.getFscOrderId());
        List fscApprovalTaskQueryBOList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskCandidatePO);
        if (CollectionUtils.isEmpty((Collection)fscApprovalTaskQueryBOList)) {
            return;
        }
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)fscApprovalTaskQueryBOList.get(0)).getTaskOperId()));
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO.setTitel(fscOrderPO.getOrderNo() + "\u91c7\u8d2d\u7ed3\u7b97_" + "_" + busiTypeStr + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u91c7\u8d2d\u7ed3\u7b97\u5355" + fscOrderPO.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5355\u4f4d\u53d1\u7968\u7b7e\u6536\u63d0\u4ea4|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5355\u4f4d\u53d1\u7968\u7b7e\u6536\u63d0\u4ea4\u901a\u77e5\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void sendFinanceSignApplyTodo(FscFinancePurInvoiceSignApplyAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderPO.getSettlePlatform())) {
            return;
        }
        try {
            FscPushTodoAbilityServiceReqBO fscPushTodoAbilityServiceReqBO = new FscPushTodoAbilityServiceReqBO();
            fscPushTodoAbilityServiceReqBO.setBusiCode("1302");
            fscPushTodoAbilityServiceReqBO.setBusiName("\u91c7\u8d2d\u7ed3\u7b97\u5ba1\u6279(\u8d22\u52a1\u5171\u4eab)");
            fscPushTodoAbilityServiceReqBO.setObjId(reqBO.getOrderId());
            fscPushTodoAbilityServiceReqBO.setOperatorType(TaskWaitDoneEnum.PUSH_TODO_OPERATOR_SUBMIT);
            FscPushTodoAbilityServiceRspBO fscPushTodoAbilityServiceRspBO = this.taskTodoWaitService.dealPushTodoHandler(fscPushTodoAbilityServiceReqBO);
            if (!"0000".equals(fscPushTodoAbilityServiceRspBO.getRespCode())) {
                throw new FscBusinessException(fscPushTodoAbilityServiceRspBO.getRespCode(), fscPushTodoAbilityServiceRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5355\u4f4d\u53d1\u7968\u7b7e\u6536\u63d0\u4ea4|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5355\u4f4d\u53d1\u7968\u7b7e\u6536\u63d0\u4ea4\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void sendFinanceSignApplyEntrustNotice(FscFinancePurInvoiceSignApplyAbilityReqBO reqBO, FscFinancePurInvoiceSignApplyBusiRspBO busiRspBO, FscOrderPO fscOrderPO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderPO.getSettlePlatform())) {
            return;
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList()) && !CollectionUtils.isEmpty(busiRspBO.getNoticeOrderIds())) {
            for (Long noticeOrderId : busiRspBO.getNoticeOrderIds()) {
                FscSyncSendNotificationReqBO fscSyncSendNotificationReqBO = new FscSyncSendNotificationReqBO();
                fscSyncSendNotificationReqBO.setUserId(reqBO.getUserId());
                fscSyncSendNotificationReqBO.setObjId(noticeOrderId);
                fscSyncSendNotificationReqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.FINANCE_PURCHASE_INVOICE);
                this.fscSyncSendNotificationService.syncSendNotification(fscSyncSendNotificationReqBO);
            }
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList())) {
            FscSyncEntrustNotificationAbilityReqBO fscSyncEntrustNotificationAbilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
            fscSyncEntrustNotificationAbilityReqBO.setApproveEntrustType(Integer.valueOf(4));
            fscSyncEntrustNotificationAbilityReqBO.setAuditNoticeList(busiRspBO.getAuditNoticeList());
            this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(fscSyncEntrustNotificationAbilityReqBO);
        }
    }
}

