/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.finance.FscFinancePurInvoiceSignApprovalAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePurInvoiceSignApprovalAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePurInvoiceSignApprovalAbilityRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscFinancePurInvoiceSignApprovalBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscFinancePurInvoiceSignApprovalBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscFinancePurInvoiceSignApprovalBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscPhasePayListBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.InvoiceCmpResultBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.api.FscPushContractApproveAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncEntrustNotificationAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcSignAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSendNotificationService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.common.ability.bo.FscPushContractAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushContractAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushTodoAbilityServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscPushTodoAbilityServiceRspBO;
import com.tydic.fsc.common.ability.bo.FscSyncEntrustNotificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSendNotificationReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscInvoiceSignErrorMsgEnum;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinancePurInvoiceSignApprovalAbilityService"})
public class FscFinancePurInvoiceSignApprovalAbilityServiceImpl
implements FscFinancePurInvoiceSignApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePurInvoiceSignApprovalAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscFinancePurInvoiceSignApprovalBusiService fscFinancePurInvoiceSignApprovalBusiService;
    @Autowired
    private FscSyncPushYcSignAbilityService fscSyncPushYcSignAbilityService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Value(value="${es.FSC_SIGN_BACK_FILL_INVOICE_TOPIC:FSC_SIGN_BACK_FILL_INVOICE_TOPIC}")
    private String fscSignBackFillInvoiceTopic;
    @Value(value="${es.FSC_SIGN_BACK_FILL_INVOICE_TAG:FSC_SIGN_BACK_FILL_INVOICE_TAG}")
    private String fscSignBackFillInvoiceTag;
    @Resource(name="fscPushFinanceSettleMqServiceProvider")
    private ProxyMessageProducer fscPushFinanceSettleMqServiceProvider;
    @Value(value="${FSC_PUSH_FINANCE_SETTLE_TOPIC:FSC_PUSH_FINANCE_SETTLE_TOPIC}")
    private String fscPushFinanceSettleTopic;
    @Value(value="${FSC_PUSH_FINANCE_SETTLE_TAG:FSC_PUSH_FINANCE_SETTLE_TAG}")
    private String fscPushFinanceSettleTag;
    @Value(value="${FINANCE_STATION_ID:1060246138443051008}")
    private String financeStationId;
    @Resource(name="fscSignBackFillInvoiceMqServiceProvider")
    private ProxyMessageProducer fscSignBackFillInvoiceMqServiceProvider;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    private static final Integer IN = 1;
    private static final Integer OUT = 2;
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    private static BigDecimal TAX_AMOUNT_OTHER_CHECK = BigDecimal.ZERO;
    private static BigDecimal TOTAL_AMOUNT_EX_OTHER_CHECK = BigDecimal.ZERO;
    private static final String REPLACE_KEY = "#replace#";
    private static final String REPLACE_LIMIT_AMT = "##";
    private static final String ERROR_MSG_TITLE_BEGIN = "\u7ed3\u7b97\u5355";
    private static final String ERROR_MSG_TITLE_END = "\u4e0d\u7b26\u5408\u7b7e\u6536\u89c4\u5219\uff0c\u539f\u56e0\u5982\u4e0b\uff1a<br>";
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscSyncSendNotificationService fscSyncSendNotificationService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscPushContractApproveAbilityService fscPushContractApproveAbilityService;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscSyncEntrustNotificationAbilityService fscSyncEntrustNotificationAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPurInvoiceSignApproval"})
    public FscFinancePurInvoiceSignApprovalAbilityRspBO dealPurInvoiceSignApproval(@RequestBody FscFinancePurInvoiceSignApprovalAbilityReqBO reqBO) {
        FscFinancePurInvoiceSignApprovalAbilityRspBO abilityRspBO = new FscFinancePurInvoiceSignApprovalAbilityRspBO();
        this.val(reqBO);
        if (CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u8d26\u53f7\u65e0\u4e0b\u4e00\u6b65\u5ba1\u6279\u6743\u9650");
        }
        if (reqBO.getStationsList().contains(Long.valueOf(this.financeStationId)) && reqBO.getAuditResult() == 0) {
            this.checkInput(reqBO);
        }
        StringBuffer errorInfo = new StringBuffer();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            for (Long orderId : reqBO.getOrderIds()) {
                reqBO.setOrderId(orderId);
                FscFinancePurInvoiceSignApprovalBusiRspBO rspBO = this.signBusi(reqBO);
                errorInfo.append(rspBO.getResult());
                this.sendMq(orderId);
            }
        } else if (reqBO.getOrderId() != null) {
            FscFinancePurInvoiceSignApprovalBusiRspBO rspBO = this.signBusi(reqBO);
            errorInfo.append(rspBO.getResult());
            this.sendMq(reqBO.getOrderId());
        }
        if (StringUtils.isNotEmpty((CharSequence)errorInfo)) {
            abilityRspBO.setRespCode("190000");
            abilityRspBO.setRespDesc(errorInfo.toString());
        } else {
            abilityRspBO.setRespCode("0000");
            abilityRspBO.setRespDesc("\u6210\u529f");
        }
        return abilityRspBO;
    }

    private void checkInput(FscFinancePurInvoiceSignApprovalAbilityReqBO reqBO) {
        log.info("\u4e1a\u8d22\u5ba1\u6279\u5c97\u4f4d");
        if (StringUtils.isBlank((CharSequence)reqBO.getCashItemCode()) || StringUtils.isBlank((CharSequence)reqBO.getCashItemName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u73b0\u91d1\u6d41\u91cf\u8868\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
        List itemPOList = this.fscOrderItemMapper.getFinanceList(fscOrderItemPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getOrderId());
        List invoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        if (CollectionUtils.isEmpty((Collection)itemPOList) || CollectionUtils.isEmpty((Collection)invoicePOList)) {
            throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u5165\u53c2\uff01");
        }
        List checkItemList = itemPOList.stream().filter(e -> Objects.isNull(e.getIsSimpleTax()) || Objects.isNull(e.getIsInputOut()) || e.getIsInputOut() == 1 && e.getIsInputOutAmt().compareTo(BigDecimal.ZERO) == 0 || StringUtils.isBlank((CharSequence)e.getSettleItemCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkItemList)) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u660e\u7ec6\u4e2d\u662f\u5426\u7b80\u6613\u8ba1\u7a0e/\u5dee\u989d\u5f81\u7a0e\u3001\u662f\u5426\u6d89\u53ca\u8fdb\u9879\u7a0e\u8f6c\u51fa\u3001\u7ed3\u7b97\u4e8b\u9879\u5fc5\u586b\uff0c\u6d89\u53ca\u8fdb\u9879\u7a0e\u8f6c\u51fa\u65f6\u8fdb\u9879\u8f6c\u51fa\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List checkInvoiceList = invoicePOList.stream().filter(e -> Objects.isNull(e.getIsSimpleTax()) || Objects.isNull(e.getIsInputOut()) || e.getIsInputOut() == 1 && (e.getIsInputOutAmt().compareTo(BigDecimal.ZERO) == 0 || Objects.isNull(e.getInputOutTypeCode()))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkInvoiceList)) {
            throw new FscBusinessException("191019", "\u53d1\u7968\u660e\u7ec6\u4e2d\u662f\u5426\u7b80\u6613\u8ba1\u7a0e/\u5dee\u989d\u5f81\u7a0e\u3001\u662f\u5426\u6d89\u53ca\u8fdb\u9879\u7a0e\u8f6c\u51fa\u5fc5\u586b\uff0c\u6d89\u53ca\u8fdb\u9879\u7a0e\u8f6c\u51fa\u65f6\u8fdb\u9879\u8f6c\u51fa\u7a0e\u91d1\u989d\u3001\u8fdb\u9879\u7a0e\u8f6c\u51fa\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List checkInvoiceTaxList = invoicePOList.stream().filter(e -> Objects.nonNull(e.getTaxAmt()) && e.getTaxAmt().compareTo(e.getIsInputOutAmt()) < 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkInvoiceTaxList)) {
            throw new FscBusinessException("191019", "\u53d1\u7968\u660e\u7ec6\u4e2d\u8fdb\u9879\u7a0e\u8f6c\u51fa\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7a0e\u989d\uff01");
        }
        BigDecimal itemAmount = itemPOList.stream().map(FscOrderItemPO::getIsInputOutAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal invoiceAmount = invoicePOList.stream().map(FscInvoicePO::getIsInputOutAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (Objects.nonNull(itemAmount) && Objects.nonNull(invoiceAmount) && itemAmount.compareTo(invoiceAmount) != 0) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u660e\u7ec6\u4e2d\u7684\u8f6c\u51fa\u8fdb\u9879\u7a0e\u91d1\u989d\u4e0e\u53d1\u7968\u660e\u7ec6\u7684\u8fdb\u9879\u7a0e\u8f6c\u51fa\u91d1\u989d\u5fc5\u987b\u76f8\u7b49\uff01");
        }
        if (Integer.valueOf(1).equals(reqBO.getPaySource())) {
            reqBO.getFscOrderPayItemBOS().forEach(o -> {
                List financePayItemBOS = o.getFinanceItemList().stream().filter(e -> "FKFS0001".equals(e.getFinancePayMethod()) && (Objects.isNull(e.getPayerAccountName()) || Objects.isNull(e.getPayerBankName()) || Objects.isNull(e.getPayerLinkBankCode()) || Objects.isNull(e.getPayerBankAccountNum()))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(financePayItemBOS)) {
                    throw new FscBusinessException("191019", "\u5373\u6302\u5373\u4ed8\u4ed8\u6b3e\u660e\u7ec6\u4e2d\u7684\u4ed8\u6b3e\u65b9\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            });
        }
    }

    private FscFinancePurInvoiceSignApprovalBusiRspBO signBusi(FscFinancePurInvoiceSignApprovalAbilityReqBO reqBO) {
        String result = "";
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (fscOrderPO.getSignStation() == null) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u5ba1\u6279\u6743\u9650\u5f02\u5e38");
        }
        Integer count = this.fscOrderMapper.getOrderAuditCount(reqBO.getOrderId(), reqBO.getStationsList(), reqBO.getUserId());
        if (count == 0 || CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        if (!FscConstants.FscInvoiceOrderState.BILL_APPLY.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + fscOrderPO.getOrderState() + "]\u4e0d\u5141\u8bb8\u5ba1\u6279");
        }
        FscFinancePurInvoiceSignApprovalBusiReqBO fscFinancePurInvoiceSignApprovalBusiReqBO = (FscFinancePurInvoiceSignApprovalBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscFinancePurInvoiceSignApprovalBusiReqBO.class));
        fscFinancePurInvoiceSignApprovalBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        boolean notFd = true;
        FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
        fscOrderExtPO.setFscOrderId(reqBO.getOrderId());
        fscOrderExtPO = this.fscOrderExtMapper.getModelBy(fscOrderExtPO);
        if (fscOrderExtPO != null && "3".equals(fscOrderExtPO.getFscType())) {
            notFd = false;
        }
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow()) && notFd) {
            this.dealStockFlag(fscFinancePurInvoiceSignApprovalBusiReqBO, fscOrderPO);
        }
        fscFinancePurInvoiceSignApprovalBusiReqBO.setPayAmount(fscOrderPO.getTotalCharge());
        FscFinancePurInvoiceSignApprovalBusiRspBO fscFinancePurInvoiceSignApprovalBusiRspBO = this.fscFinancePurInvoiceSignApprovalBusiService.dealPurInvoiceSignApproval(fscFinancePurInvoiceSignApprovalBusiReqBO);
        if (!"0000".equals(fscFinancePurInvoiceSignApprovalBusiRspBO.getRespCode())) {
            result = result + ERROR_MSG_TITLE_BEGIN + fscOrderPO.getOrderNo() + "\u5ba1\u6279\u5931\u8d25\uff0c" + fscFinancePurInvoiceSignApprovalBusiRspBO.getRespDesc() + ";";
        }
        if ("0000".equals(fscFinancePurInvoiceSignApprovalBusiRspBO.getRespCode()) && !fscFinancePurInvoiceSignApprovalBusiRspBO.getFinish().booleanValue() && !FscConstants.SettlePlatform.FINANCE.equals(fscOrderPO.getSettlePlatform())) {
            this.syncSendNotice(reqBO.getOrderId(), reqBO.getUserId());
        }
        if ("0000".equals(fscFinancePurInvoiceSignApprovalBusiRspBO.getRespCode()) && fscFinancePurInvoiceSignApprovalBusiRspBO.getFinish().booleanValue() && reqBO.getAuditResult() == 0) {
            log.info("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3-------");
            CompletableFuture.runAsync(() -> {
                try {
                    FscPushContractAbilityReqBO fscPushContractAbilityReqBO = new FscPushContractAbilityReqBO();
                    fscPushContractAbilityReqBO.setFscOrderId(reqBO.getOrderId());
                    FscPushContractAbilityRspBO abilityRspBO = this.fscPushContractApproveAbilityService.pushContract(fscPushContractAbilityReqBO);
                    if (Objects.nonNull(abilityRspBO) && "0000".equals(abilityRspBO.getRespCode())) {
                        log.error("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + abilityRspBO.getRespDesc());
                    }
                }
                catch (Exception exception) {
                    log.error("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + exception);
                }
            });
            log.info("\u7ed3\u7b97\u5355\uff1a{}\u5ba1\u6279\u5b8c\u6210\u63a8\u9001\u8d22\u52a1\u5171\u4eab", (Object)reqBO.getOrderId());
            JSONObject object = new JSONObject();
            object.put("fscOrderId", (Object)reqBO.getOrderId());
            this.fscPushFinanceSettleMqServiceProvider.send(new ProxyMessage(this.fscPushFinanceSettleTopic, this.fscPushFinanceSettleTag, JSONObject.toJSONString((Object)object)));
        }
        fscFinancePurInvoiceSignApprovalBusiRspBO.setResult(result);
        fscFinancePurInvoiceSignApprovalBusiRspBO.setTradeMode(fscOrderPO.getTradeMode());
        this.sendFinanceSignApprovalNoticeAndTodo(reqBO, fscFinancePurInvoiceSignApprovalBusiRspBO, fscOrderPO);
        this.sendFinanceSignApprovalEntrustNotice(reqBO, fscFinancePurInvoiceSignApprovalBusiRspBO, fscOrderPO);
        return fscFinancePurInvoiceSignApprovalBusiRspBO;
    }

    private void checkCmpResult(InvoiceCmpResultBO invoiceCmpResultBO, FscOrderPO fscOrderPO) {
        this.checkCfcParam(invoiceCmpResultBO, fscOrderPO.getOrderSource());
        if (invoiceCmpResultBO.getCmpResultStr().contains(FscConstants.FscInvoiceVerifyResult.NO.toString())) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(ERROR_MSG_TITLE_BEGIN);
            errorMsg.append(fscOrderPO.getOrderNo());
            errorMsg.append(ERROR_MSG_TITLE_END);
            int strLen = invoiceCmpResultBO.getCmpResultStr().length();
            int seq = 1;
            for (int i = 0; i < strLen; ++i) {
                if (invoiceCmpResultBO.getCmpResultStr().charAt(i) == FscConstants.FscInvoiceVerifyResult.NO.toString().charAt(0)) {
                    errorMsg.append(seq);
                    errorMsg.append(FscInvoiceSignErrorMsgEnum.getInstance((Integer)seq).getDescr());
                    ++seq;
                }
                if (i == 5) break;
            }
            if (invoiceCmpResultBO.getAmountMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getAmountMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getUntaxAmtMargin().compareTo(TOTAL_AMOUNT_EX_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.UNTAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getUntaxAmtMargin().toString()).replace(REPLACE_LIMIT_AMT, TOTAL_AMOUNT_EX_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getTaxMargin().compareTo(TAX_AMOUNT_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.TAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getTaxMargin().toString()).replace(REPLACE_LIMIT_AMT, TAX_AMOUNT_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getItemNumMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.ITEM.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getItemNumMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getPoolCmpResultNum() > 0) {
                errorMsg.append(seq);
                errorMsg.append("\u3001\u8fdb\u9879\u53d1\u7968\u660e\u7ec6\u603b\u8ba1\u6709" + invoiceCmpResultBO.getPoolCmpResultNum() + "\u9879\u65e0\u6cd5\u5339\u914d\uff1b<br>");
                ++seq;
            }
            if (seq > 1) {
                throw new FscBusinessException("191035", errorMsg.toString());
            }
        }
    }

    private void val(FscFinancePurInvoiceSignApprovalAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId() && CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getAuditResult())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void sendMq(Long orderId) {
        FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
        syncReqBO.setFscOrderId(orderId);
        this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(orderId);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        JSONObject object = new JSONObject();
        object.put("fscOrderId", (Object)orderId);
        ProxySendResult proxySendResult = this.fscSignBackFillInvoiceMqServiceProvider.send(new ProxyMessage(this.fscSignBackFillInvoiceTopic, this.fscSignBackFillInvoiceTag, JSONObject.toJSONString((Object)object)));
    }

    private void dealAccountRule(FscFinancePurInvoiceSignApprovalBusiReqBO fscFinancePurInvoiceSignApprovalBusiReqBO, FscOrderPO fscOrderPO, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, Set<String> orderCodeList, Set<String> orderOperList) {
        if (FscConstants.SettleType.ORDER.equals(fscOrderPO.getSettleType())) {
            return;
        }
        if (this.qryHistoryRefund(fscOrderPO)) {
            return;
        }
        String billDateMax = this.fscInvoiceMapper.setInvoiceBillDate(fscOrderPO.getFscOrderId());
        List fscOrderRelationPOList = this.fscOrderRelationMapper.getListByOrderIdGroupByContractId(fscOrderPO.getFscOrderId());
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOList)) {
            throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f");
        }
        FscOrderFinancePO fscOrderFinancePOReq = new FscOrderFinancePO();
        fscOrderFinancePOReq.setFscOrderId(fscOrderPO.getFscOrderId());
        FscOrderFinancePO fscOrderFinancePO = this.fscOrderFinanceMapper.getModelBy(fscOrderFinancePOReq);
        if (Objects.isNull(fscOrderFinancePO)) {
            throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5171\u4eab\u76f8\u5173\u4fe1\u606f");
        }
        ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
        fscOrderRelationPOList.forEach(relationPO -> {
            if (Objects.isNull(relationPO.getContractId())) {
                throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5173\u8054\u7684\u5408\u540c\u4fe1\u606f");
            }
            Optional<FscOrderInfoBO> max = fscOrderInfoBoMap.values().stream().filter(e -> relationPO.getContractId().equals(e.getFinanceContractId())).max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime));
            if (!max.isPresent()) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            FscOrderInfoBO fscOrderInfoBO = max.get();
            log.debug("++++++++++fscOrderInfoBO:{}", (Object)JSON.toJSONString((Object)fscOrderInfoBO));
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
                if (FscConstants.MerchantPayAccountDayRule.SIGN.equals(fscOrderInfoBO.getPayAccountDayRule()) || FscConstants.MerchantPayNodeRule.SIGN.equals(fscOrderInfoBO.getPayNodeRule())) {
                    FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                    fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                    fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                    fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                    fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                    fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                    fscShouldPayBO.setShouldPayAmount(relationPO.getSettleAmt());
                    fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                    fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                    fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                    fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                    fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                    fscShouldPayBO.setContractId(relationPO.getContractId());
                    fscShouldPayBO.setContractNo(relationPO.getContractNo());
                    fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
                    fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
                    fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO, fscOrderPO.getOrderSource(), billDateMax, fscOrderPO.getReceiveType()));
                    fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                    fscShouldPayBO.setInvoiceNo(fscOrderPO.getInvoiceNo());
                    fscShouldPayBO.setBillDate(billDateMax);
                    fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                    fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                    fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                    fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
                    fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
                    fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                    fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                    fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                    fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                    fscShouldPayBO.setOperatorDeptId(Convert.toStr((Object)fscOrderPO.getOperatorDeptId()));
                    fscShouldPayBO.setOperatorDeptName(fscOrderPO.getOperatorDeptName());
                    fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                    fscShouldPayBO.setShouldPayMethod(Integer.valueOf(2));
                    fscShouldPayBO.setContractName(fscOrderInfoBO.getContractName());
                    fscShouldPayBO.setContractType(StringUtils.isNotBlank((CharSequence)fscOrderInfoBO.getUnifyContractType()) ? Integer.valueOf(fscOrderInfoBO.getUnifyContractType()) : null);
                    fscShouldPayBO.setVendorSiteId(fscOrderFinancePO.getVendorSiteId());
                    fscShouldPayBO.setVendorSiteName(fscOrderFinancePO.getVendorSiteName());
                    fscShouldPayBO.setSupplierNo(fscOrderInfoBO.getSupplierNo());
                    fscShouldPayBO.setSupplierErpNo(fscOrderInfoBO.getSupplierErpNo());
                    fscShouldPayBOS.add(fscShouldPayBO);
                }
            } else if (FscConstants.FscPayType.FSC_PAY_TYPE_STAGE.equals(fscOrderPO.getPayType())) {
                boolean flag = false;
                ArrayList<FscPhasePayListBO> payListBOS = new ArrayList<FscPhasePayListBO>();
                if (CollectionUtils.isEmpty((Collection)fscOrderInfoBO.getPayList())) {
                    return;
                }
                for (FscPhasePayListBO payListBO : fscOrderInfoBO.getPayList()) {
                    if (payListBO.getPayNode() != 4 || payListBO.getNodePayRatio().compareTo(BigDecimal.ZERO) <= 0) continue;
                    payListBOS.add(payListBO);
                    flag = true;
                }
                if (flag) {
                    BigDecimal shouldPayAmount = relationPO.getSettleAmt();
                    if (fscOrderPO.getIsQuality() != null && FscConstants.IsQuality.YES.equals(fscOrderPO.getIsQuality())) {
                        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                        fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY);
                        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                        fscShouldPayBO.setPayType(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE);
                        fscShouldPayBO.setShouldPayAmount(relationPO.getQualityAmt());
                        fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                        fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                        fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                        fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                        fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                        fscShouldPayBO.setContractId(relationPO.getContractId());
                        fscShouldPayBO.setContractNo(relationPO.getContractNo());
                        fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
                        fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
                        fscShouldPayBO.setShouldPayDate(relationPO.getQualityDate());
                        fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                        fscShouldPayBO.setInvoiceNo(fscOrderPO.getInvoiceNo());
                        fscShouldPayBO.setBillDate(billDateMax);
                        fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                        fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                        fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                        fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
                        fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
                        fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                        fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                        fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                        fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                        fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                        fscShouldPayBO.setShouldPayMethod(FscConstants.PaymentMethod.DEPOSIT);
                        fscShouldPayBO.setContractName(fscOrderInfoBO.getContractName());
                        fscShouldPayBO.setContractType(StringUtils.isNotBlank((CharSequence)fscOrderInfoBO.getUnifyContractType()) ? Integer.valueOf(fscOrderInfoBO.getUnifyContractType()) : null);
                        fscShouldPayBO.setVendorSiteId(fscOrderFinancePO.getVendorSiteId());
                        fscShouldPayBO.setVendorSiteName(fscOrderFinancePO.getVendorSiteName());
                        fscShouldPayBO.setSupplierNo(fscOrderInfoBO.getSupplierNo());
                        fscShouldPayBO.setSupplierErpNo(fscOrderInfoBO.getSupplierErpNo());
                        fscShouldPayBOS.add(fscShouldPayBO);
                        shouldPayAmount = shouldPayAmount.subtract(relationPO.getQualityAmt());
                    }
                    if (shouldPayAmount.compareTo(BigDecimal.ZERO) > 0) {
                        for (FscPhasePayListBO fscPhasePayListBO : payListBOS) {
                            FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                            fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                            fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                            fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                            fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                            fscShouldPayBO.setPayType(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE);
                            fscShouldPayBO.setShouldPayAmount(shouldPayAmount.multiply(fscPhasePayListBO.getNodePayRatio()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                            fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                            fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                            fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                            fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                            fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                            fscShouldPayBO.setContractId(relationPO.getContractId());
                            fscShouldPayBO.setContractNo(relationPO.getContractNo());
                            fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
                            fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
                            fscShouldPayBO.setShouldPayDate(this.calShouldPayDateNew(fscPhasePayListBO.getNodePayCycle(), billDateMax));
                            fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                            fscShouldPayBO.setInvoiceNo(fscOrderPO.getInvoiceNo());
                            fscShouldPayBO.setBillDate(billDateMax);
                            fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                            fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                            fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                            fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
                            fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
                            fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                            fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                            fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                            fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                            fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                            fscShouldPayBO.setShouldPayMethod(fscPhasePayListBO.getPayType());
                            fscShouldPayBO.setContractName(fscOrderInfoBO.getContractName());
                            fscShouldPayBO.setContractType(StringUtils.isNotBlank((CharSequence)fscOrderInfoBO.getUnifyContractType()) ? Integer.valueOf(fscOrderInfoBO.getUnifyContractType()) : null);
                            fscShouldPayBO.setVendorSiteId(fscOrderFinancePO.getVendorSiteId());
                            fscShouldPayBO.setVendorSiteName(fscOrderFinancePO.getVendorSiteName());
                            fscShouldPayBO.setSupplierNo(fscOrderInfoBO.getSupplierNo());
                            fscShouldPayBO.setSupplierErpNo(fscOrderInfoBO.getSupplierErpNo());
                            fscShouldPayBOS.add(fscShouldPayBO);
                        }
                    }
                }
            }
        });
        fscFinancePurInvoiceSignApprovalBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        fscFinancePurInvoiceSignApprovalBusiReqBO.setCreateShouldPayFlag(true);
    }

    private boolean qryHistoryRefund(FscOrderPO fscOrderPO) {
        if (fscOrderPO.getRefundId() == null) {
            return false;
        }
        FscOrderPO orderPO = this.fscOrderMapper.qryHistoryRefund(fscOrderPO.getRefundId());
        if (orderPO == null) {
            return false;
        }
        if (orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.SIGNED)) {
            return true;
        }
        if (orderPO.getRefundId() != null) {
            return this.qryHistoryRefund(orderPO);
        }
        return false;
    }

    private FscShouldPayBO buildShouldPayInfo(FscOrderPO fscOrderPO, FscOrderInfoBO fscOrderInfoBO, String billDateMax) {
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
        fscShouldPayBO.setPayType(fscOrderPO.getPayType());
        fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
        fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
        fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
        fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
        fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
        fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
        fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
        fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
        fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
        fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
        fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
        fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
        fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
        fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
        fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
        fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
        fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
        fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
        fscShouldPayBO.setSettlePlatform(fscOrderPO.getSettlePlatform());
        FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setInvoiceNo(signTemp.getInvoiceNo());
        fscShouldPayBO.setBillDate(billDateMax);
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List relationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        if (!CollectionUtils.isEmpty((Collection)relationPOList)) {
            fscShouldPayBO.setProContractSource(((FscOrderRelationPO)relationPOList.get(0)).getProContractSource());
            fscShouldPayBO.setProContractId(((FscOrderRelationPO)relationPOList.get(0)).getProContractId());
            fscShouldPayBO.setProContractNo(((FscOrderRelationPO)relationPOList.get(0)).getProContractNo());
            fscShouldPayBO.setProContractName(((FscOrderRelationPO)relationPOList.get(0)).getProContractName());
            fscShouldPayBO.setProContractType(((FscOrderRelationPO)relationPOList.get(0)).getProContractType());
        }
        return fscShouldPayBO;
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO, Integer orderSource, String billDateMax, Integer receiveType) {
        Calendar now = Calendar.getInstance();
        Boolean flag = FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderSource) && FscConstants.FscOrderReceiveType.OPERATION.equals(receiveType);
        if (StringUtils.isNotBlank((CharSequence)billDateMax) && !flag.booleanValue()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                now.setTime(sdf.parse(billDateMax));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }

    private Date calShouldPayDateNew(String nodePayCycle, String billDateMax) {
        Integer payDays = 0;
        payDays = StringUtils.isEmpty((CharSequence)nodePayCycle) || nodePayCycle.equals("null") ? Integer.valueOf(0) : Integer.valueOf(nodePayCycle);
        Calendar now = Calendar.getInstance();
        if (StringUtils.isNotBlank((CharSequence)billDateMax)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                now.setTime(sdf.parse(billDateMax));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        now.add(5, payDays);
        return now.getTime();
    }

    private void checkCfcParam(InvoiceCmpResultBO invoiceCmpResultBO, Integer orderSource) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_check_" + orderSource);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        StringBuffer cmpResult = new StringBuffer(invoiceCmpResultBO.getCmpResultStr());
        char resultYesChar = FscConstants.FscInvoiceVerifyResult.YES.toString().charAt(0);
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceTitleCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BUY_NAME.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxpayerIdCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.TAX_NO.getCode() - 1, resultYesChar);
        }
        Boolean categoryFlag = FscConstants.FscInvoiceCategory.FULL.equals(invoiceCmpResultBO.getInvoiceCategory());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAddressCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ADDRESS.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getPhoneCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.PHONE.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getBankCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BANK.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAccountCheck()) || categoryFlag.booleanValue()) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ACCOUNT.getCode() - 1, resultYesChar);
        }
        invoiceCmpResultBO.setCmpResultStr(cmpResult.toString());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountCheck())) {
            invoiceCmpResultBO.setAmountMargin(BigDecimal.ZERO);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExCheck())) {
            invoiceCmpResultBO.setUntaxAmtMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck())) {
            BigDecimal diffUntaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck());
            TOTAL_AMOUNT_EX_OTHER_CHECK = diffUntaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountCheck())) {
            invoiceCmpResultBO.setTaxMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck())) {
            BigDecimal diffTaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck());
            TAX_AMOUNT_OTHER_CHECK = diffTaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
    }

    private void dealStockFlag(FscFinancePurInvoiceSignApprovalBusiReqBO fscFinancePurInvoiceSignApprovalBusiReqBO, FscOrderPO fscOrderPO) {
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType())) {
            fscFinancePurInvoiceSignApprovalBusiReqBO.setNeedOperStockEnable(true);
            fscFinancePurInvoiceSignApprovalBusiReqBO.setStockFlag(IN);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
            fscFinancePurInvoiceSignApprovalBusiReqBO.setNeedOperStockEnable(true);
            fscFinancePurInvoiceSignApprovalBusiReqBO.setStockFlag(OUT);
        }
    }

    private void dealOrderCheck(FscFinancePurInvoiceSignApprovalBusiReqBO fscFinancePurInvoiceSignApprovalBusiReqBO, FscOrderPO fscOrderPO) {
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap();
        if (fscOrderPO.getSettleType() == null || fscOrderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            this.dealAccountRule(fscFinancePurInvoiceSignApprovalBusiReqBO, fscOrderPO, fscOrderInfoBoMap, fscAcceptOrderListQueryAtomRspBO.getOrderCodeList(), fscAcceptOrderListQueryAtomRspBO.getOrderOperList());
        } else {
            FscSaleOrderListQueryAtomReqBO atomReqBO = new FscSaleOrderListQueryAtomReqBO();
            atomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(atomReqBO);
            if (!"0000".equals(fscSaleOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscSaleOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            this.dealAccountRule(fscFinancePurInvoiceSignApprovalBusiReqBO, fscOrderPO, fscOrderInfoBoMap, fscSaleOrderListQueryAtomRspBO.getOrderCodeList(), fscSaleOrderListQueryAtomRspBO.getOrderOperList());
        }
    }

    private void checkProSign(Map<Long, FscOrderInfoBO> fscOrderInfoBoMap) {
        fscOrderInfoBoMap.forEach((acceptOrderId, fscOrderInfoBO) -> fscOrderInfoBO.getFscRelInfoBos().forEach(fscProFscRelInfoBo -> {
            if (FscConstants.FscRelType.PRO_INVOICE.equals(fscProFscRelInfoBo.getRelType()) && !FscConstants.FscRelStatus.SIGN.equals(fscProFscRelInfoBo.getRelState())) {
                throw new FscBusinessException("191019", "\u4e0a\u6e38\u7ed3\u7b97\u5355\u53d1\u7968\u672a\u7b7e\u6536\uff0c\u4e0b\u6e38\u4e0d\u5141\u8bb8\u7b7e\u6536");
            }
        }));
    }

    private void syncSendNotice(Long fscOrderId, Long userId) {
        FscSyncSendNotificationReqBO reqBO = new FscSyncSendNotificationReqBO();
        reqBO.setUserId(userId);
        reqBO.setObjId(fscOrderId);
        reqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.PUR_WAIT_AUDIT);
        this.fscSyncSendNotificationService.syncSendNotification(reqBO);
    }

    private FscOrderPO getFscOrderById(Long fscOrderId) {
        FscOrderPO qryFscOrder = new FscOrderPO();
        qryFscOrder.setFscOrderId(fscOrderId);
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(qryFscOrder);
        if (ObjectUtil.isEmpty((Object)fscOrderPO)) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
        }
        return fscOrderPO;
    }

    private void sendFinanceSignApprovalNoticeAndTodo(FscFinancePurInvoiceSignApprovalAbilityReqBO reqBO, FscFinancePurInvoiceSignApprovalBusiRspBO busiRspBO, FscOrderPO fscOrderPO) {
        this.sendFinanceSignApprovalNotice(reqBO, fscOrderPO, busiRspBO);
        this.sendFinanceSignApprovalTodo(reqBO, fscOrderPO);
    }

    private void sendFinanceSignApprovalNotice(FscFinancePurInvoiceSignApprovalAbilityReqBO reqBO, FscOrderPO fscOrderPO, FscFinancePurInvoiceSignApprovalBusiRspBO busiRspBO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderPO.getSettlePlatform())) {
            return;
        }
        if (!busiRspBO.getFinish().booleanValue()) {
            return;
        }
        FscOrderPO fscSignTemp = this.fscOrderMapper.getOrderSignTemp(reqBO.getOrderId());
        Map busiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        String busiTypeStr = fscOrderPO.getOrderType() == 2 && fscOrderPO.getTradeMode() != null && fscOrderPO.getTradeMode() == 2 && fscOrderPO.getOrderSource() == 3 && fscOrderPO.getSettlePlatform() != null && fscOrderPO.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)busiTypeMap.get(String.valueOf(fscOrderPO.getOrderType()));
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO.setTitel(fscOrderPO.getOrderNo() + "\u91c7\u8d2d\u7ed3\u7b97_" + "_" + busiTypeStr + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO.setReceiveIds((List)CollectionUtil.newArrayList((Object[])new Long[]{fscSignTemp.getUserId()}));
            if (FscConstants.AuditResultStatus.PASS.equals(reqBO.getAuditResult())) {
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u786e\u8ba4\u7684\u91c7\u8d2d\u7ed3\u7b97\u5355" + fscOrderPO.getOrderNo() + "\u5df2\u901a\u8fc7\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            }
            if (FscConstants.AuditResultStatus.REFUSE.equals(reqBO.getAuditResult())) {
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u786e\u8ba4\u7684\u91c7\u8d2d\u7ed3\u7b97\u5355" + fscOrderPO.getOrderNo() + "\u88ab\u5ba1\u6279\u9a73\u56de\u3002");
            }
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5355\u4f4d\u53d1\u7968\u7b7e\u6536\u5ba1\u6279|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5355\u4f4d\u53d1\u7968\u7b7e\u6536\u5ba1\u6279\u901a\u77e5\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void sendFinanceSignApprovalTodo(FscFinancePurInvoiceSignApprovalAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderPO.getSettlePlatform())) {
            return;
        }
        try {
            FscPushTodoAbilityServiceReqBO fscPushTodoAbilityServiceReqBO = new FscPushTodoAbilityServiceReqBO();
            fscPushTodoAbilityServiceReqBO.setBusiCode("1302");
            fscPushTodoAbilityServiceReqBO.setBusiName("\u91c7\u8d2d\u7ed3\u7b97\u5ba1\u6279(\u8d22\u52a1\u5171\u4eab)");
            fscPushTodoAbilityServiceReqBO.setObjId(reqBO.getOrderId());
            fscPushTodoAbilityServiceReqBO.setOperatorType(TaskWaitDoneEnum.PUSH_TODO_OPERATOR_AUDIT);
            FscPushTodoAbilityServiceRspBO fscPushTodoAbilityServiceRspBO = this.taskTodoWaitService.dealPushTodoHandler(fscPushTodoAbilityServiceReqBO);
            if (!"0000".equals(fscPushTodoAbilityServiceRspBO.getRespCode())) {
                throw new FscBusinessException(fscPushTodoAbilityServiceRspBO.getRespCode(), fscPushTodoAbilityServiceRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5355\u4f4d\u53d1\u7968\u7b7e\u6536\u5ba1\u6279|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5355\u4f4d\u53d1\u7968\u7b7e\u6536\u5ba1\u6279\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void sendFinanceSignApprovalEntrustNotice(FscFinancePurInvoiceSignApprovalAbilityReqBO reqBO, FscFinancePurInvoiceSignApprovalBusiRspBO busiRspBO, FscOrderPO fscOrderPO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderPO.getSettlePlatform())) {
            return;
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList()) && !CollectionUtils.isEmpty(busiRspBO.getNoticeOrderIds())) {
            for (Long noticeOrderId : busiRspBO.getNoticeOrderIds()) {
                FscSyncSendNotificationReqBO fscSyncSendNotificationReqBO = new FscSyncSendNotificationReqBO();
                fscSyncSendNotificationReqBO.setUserId(reqBO.getUserId());
                fscSyncSendNotificationReqBO.setObjId(noticeOrderId);
                fscSyncSendNotificationReqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.FINANCE_PURCHASE_INVOICE);
                this.fscSyncSendNotificationService.syncSendNotification(fscSyncSendNotificationReqBO);
            }
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAuditNoticeList())) {
            FscSyncEntrustNotificationAbilityReqBO fscSyncEntrustNotificationAbilityReqBO = new FscSyncEntrustNotificationAbilityReqBO();
            fscSyncEntrustNotificationAbilityReqBO.setApproveEntrustType(Integer.valueOf(4));
            fscSyncEntrustNotificationAbilityReqBO.setAuditNoticeList(busiRspBO.getAuditNoticeList());
            this.fscSyncEntrustNotificationAbilityService.syncEntrustNotification(fscSyncEntrustNotificationAbilityReqBO);
        }
    }

    private void approvalAuthVerify(FscFinancePurInvoiceSignApprovalAbilityReqBO reqBO) {
        Integer count = this.fscOrderMapper.getOrderAuditCount(reqBO.getOrderId(), reqBO.getStationsList(), reqBO.getUserId());
        if (count == 0) {
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650, \u8bf7\u5237\u65b0\u9875\u9762");
        }
    }
}

