/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceSettleRefundInvoiceTempQryAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceRefundInvoiceDetailBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceSettleRefundInvoiceTempBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceSettleRefundInvoiceTempDetailBO;
import com.tydic.fsc.bill.ability.bo.finance.FscSettleRefundInvoiceTempListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscSettleRefundInvoiceTempListQueryAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscInvoiceTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscInvoiceTempPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceSettleRefundInvoiceTempQryAbilityService"})
public class FscFinanceSettleRefundInvoiceTempQryAbilityServiceImpl
implements FscFinanceSettleRefundInvoiceTempQryAbilityService {
    @Autowired
    private FscInvoiceTempMapper fscInvoiceTempMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"getSettleRefundInvoiceTempListPageQuery"})
    public FscSettleRefundInvoiceTempListQueryAbilityRspBO getSettleRefundInvoiceTempListPageQuery(@RequestBody FscSettleRefundInvoiceTempListQueryAbilityReqBO reqBO) {
        FscSettleRefundInvoiceTempListQueryAbilityRspBO rspBO = new FscSettleRefundInvoiceTempListQueryAbilityRspBO();
        ArrayList<FscFinanceSettleRefundInvoiceTempBO> listResult = new ArrayList<FscFinanceSettleRefundInvoiceTempBO>();
        this.valid(reqBO);
        FscInvoiceRefundRelationPO fscInvoiceRefundRelationPOReq = new FscInvoiceRefundRelationPO();
        fscInvoiceRefundRelationPOReq.setContractId(reqBO.getContractId());
        fscInvoiceRefundRelationPOReq.setRefundType(reqBO.getRefundType());
        fscInvoiceRefundRelationPOReq.setRefundId(reqBO.getRefundId());
        fscInvoiceRefundRelationPOReq.setFscOrderId(reqBO.getFscOrderId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List listPage = this.fscInvoiceRefundRelationMapper.getListPage(fscInvoiceRefundRelationPOReq, page);
        List list = JSON.parseArray((String)JSON.toJSONString((Object)listPage), FscFinanceRefundInvoiceDetailBO.class);
        BigDecimal qryRefundAllAmt = BigDecimal.ZERO;
        BigDecimal refundQualityAllAmt = BigDecimal.ZERO;
        if (!list.isEmpty()) {
            FscInvoicePO fscInvoicePOReq = new FscInvoicePO();
            fscInvoicePOReq.setInvoiceIds(reqBO.getInvoiceIds());
            List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePOReq);
            Map fscInvoiceMap = fscInvoicePOList.stream().collect(Collectors.toMap(FscInvoicePO::getInvoiceId, Function.identity()));
            FscInvoiceTempPO fscInvoiceTempPOReq = new FscInvoiceTempPO();
            fscInvoiceTempPOReq.setPreInvoiceIds(reqBO.getInvoiceIds());
            fscInvoiceTempPOReq.setTempId(reqBO.getTempId());
            fscInvoiceTempPOReq.setContractId(reqBO.getContractId());
            List fscInvoiceTempPOList = this.fscInvoiceTempMapper.getList(fscInvoiceTempPOReq);
            Map fscInvoiceTempMap = fscInvoiceTempPOList.stream().filter(fscInvoicePO -> Objects.nonNull(fscInvoicePO.getPreInvoiceId())).collect(Collectors.toMap(FscInvoiceTempPO::getPreInvoiceId, Function.identity()));
            Map fscRefundTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_TYPE");
            Map fscFinanceInvoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_INVOICE_TYPE");
            Map fscInvoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
            Map fscInvoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
            Map refundTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_RELATION_REFUND_TYPE");
            rspBO.setRefundType(((FscFinanceRefundInvoiceDetailBO)list.get(0)).getRefundType());
            rspBO.setRefundTypeStr((String)refundTypeMap.get(String.valueOf(rspBO.getRefundType())));
            Map<Object, Object> fscInvoiceRefundRelationPOMap = new HashMap();
            if (Objects.nonNull(reqBO.getRefundId())) {
                FscInvoiceRefundRelationPO fscInvoiceRefundRelationPO = new FscInvoiceRefundRelationPO();
                fscInvoiceRefundRelationPO.setRefundId(reqBO.getRefundId());
                List invoiceRefundRelationPOList = this.fscInvoiceRefundRelationMapper.getRefundType(fscInvoiceRefundRelationPO);
                if (!CollectionUtils.isEmpty((Collection)invoiceRefundRelationPOList)) {
                    fscInvoiceRefundRelationPOMap = invoiceRefundRelationPOList.stream().collect(Collectors.toMap(FscInvoiceRefundRelationPO::getInvoiceId, Function.identity(), (k1, k2) -> k1));
                }
            }
            for (FscFinanceRefundInvoiceDetailBO bo : list) {
                FscFinanceSettleRefundInvoiceTempBO settleInvoiceBO = new FscFinanceSettleRefundInvoiceTempBO();
                FscInvoicePO fscInvoice = (FscInvoicePO)fscInvoiceMap.get(bo.getInvoiceId());
                if (fscInvoice != null) {
                    this.buildInvoice(fscInvoice, bo);
                }
                if (bo.getRefundType() != null) {
                    bo.setRefundTypeStr((String)fscRefundTypeMap.get(bo.getRefundType().toString()));
                }
                if (StringUtils.isNotBlank((CharSequence)bo.getInvoiceType())) {
                    bo.setInvoiceTypeStr((String)fscInvoiceTypeMap.get(bo.getInvoiceType()));
                }
                if (bo.getInvoiceCategory() != null) {
                    bo.setInvoiceCategoryStr((String)fscInvoiceCategoryMap.get(bo.getInvoiceCategory().toString()));
                }
                if (!CollectionUtils.isEmpty(fscInvoiceRefundRelationPOMap) && fscInvoiceRefundRelationPOMap.containsKey(bo.getInvoiceId())) {
                    bo.setRefundType(((FscInvoiceRefundRelationPO)fscInvoiceRefundRelationPOMap.get(bo.getInvoiceId())).getRefundType());
                    bo.setRefundTypeStr(((FscInvoiceRefundRelationPO)fscInvoiceRefundRelationPOMap.get(bo.getInvoiceId())).getRefundTypeStr());
                }
                qryRefundAllAmt = qryRefundAllAmt.add(bo.getRefundAmt() == null ? BigDecimal.ZERO : bo.getRefundAmt());
                refundQualityAllAmt = refundQualityAllAmt.add(bo.getRefundQualityAmt() == null ? BigDecimal.ZERO : bo.getRefundQualityAmt());
                FscFinanceSettleRefundInvoiceTempDetailBO refundInvoiceBO = new FscFinanceSettleRefundInvoiceTempDetailBO();
                FscInvoiceTempPO fscInvoiceTemp = (FscInvoiceTempPO)fscInvoiceTempMap.get(bo.getInvoiceId());
                if (Objects.nonNull(fscInvoiceTemp)) {
                    BeanUtils.copyProperties((Object)fscInvoiceTemp, (Object)refundInvoiceBO);
                    if (refundInvoiceBO.getAmt() != null && refundInvoiceBO.getAmt().compareTo(BigDecimal.ZERO) > 0) {
                        refundInvoiceBO.setAmt(refundInvoiceBO.getAmt().negate());
                    }
                    if (refundInvoiceBO.getUntaxAmt() != null && refundInvoiceBO.getUntaxAmt().compareTo(BigDecimal.ZERO) > 0) {
                        refundInvoiceBO.setUntaxAmt(refundInvoiceBO.getUntaxAmt().negate());
                    }
                    if (refundInvoiceBO.getTaxAmt() != null && refundInvoiceBO.getTaxAmt().compareTo(BigDecimal.ZERO) > 0) {
                        refundInvoiceBO.setTaxAmt(refundInvoiceBO.getTaxAmt().negate());
                    }
                    if (StringUtils.isNotBlank((CharSequence)refundInvoiceBO.getInvoiceType())) {
                        refundInvoiceBO.setInvoiceTypeStr((String)fscInvoiceTypeMap.get(refundInvoiceBO.getInvoiceType()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)refundInvoiceBO.getInvoiceCategory())) {
                        refundInvoiceBO.setInvoiceCategoryStr((String)fscInvoiceCategoryMap.get(String.valueOf(refundInvoiceBO.getInvoiceCategory())));
                    }
                    if (!CollectionUtils.isEmpty(fscInvoiceRefundRelationPOMap) && fscInvoiceRefundRelationPOMap.containsKey(bo.getInvoiceId())) {
                        refundInvoiceBO.setRefundType(((FscInvoiceRefundRelationPO)fscInvoiceRefundRelationPOMap.get(bo.getInvoiceId())).getRefundType());
                        refundInvoiceBO.setRefundTypeStr(((FscInvoiceRefundRelationPO)fscInvoiceRefundRelationPOMap.get(bo.getInvoiceId())).getRefundTypeStr());
                    }
                }
                settleInvoiceBO.setSettleInvoiceBO(bo);
                settleInvoiceBO.setRefundInvoiceBO(refundInvoiceBO);
                listResult.add(settleInvoiceBO);
            }
        }
        rspBO.setQryRefundAllAmt(qryRefundAllAmt);
        rspBO.setRefundQualityAllAmt(refundQualityAllAmt);
        rspBO.setRows(listResult);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscSettleRefundInvoiceTempListQueryAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTempId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e34\u65f6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u7ed3\u7b97\u5355id[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u7968\u5355id[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInvoiceIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u539f\u53d1\u7968\u96c6\u5408[InvoiceIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void buildInvoice(FscInvoicePO fscInvoice, FscFinanceRefundInvoiceDetailBO bo) {
        bo.setAmt(fscInvoice.getAmt());
        bo.setInvoiceNo(fscInvoice.getInvoiceNo());
        bo.setInvoiceCode(fscInvoice.getInvoiceCode());
        bo.setBuyName(fscInvoice.getBuyName());
        bo.setInvoiceType(fscInvoice.getInvoiceType());
        bo.setInvoiceCategory(fscInvoice.getInvoiceCategory());
        bo.setBillDate(fscInvoice.getBillDate());
        BigDecimal leaveRefundAmt = Optional.ofNullable(fscInvoice.getAmt()).orElse(BigDecimal.ZERO);
        bo.setLeaveRefundAmt(leaveRefundAmt);
    }
}

