/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl.finance;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceDistributePreAmtAtomService;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscPhasePayListBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderAdvanceUseInfoMapper;
import com.tydic.fsc.dao.FscOrderAdvanceUseItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderAdvanceUseInfoPO;
import com.tydic.fsc.po.FscOrderAdvanceUseItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceDistributePreAmtAtomServiceImpl
implements FscFinanceDistributePreAmtAtomService {
    @Resource
    private FscOrderAdvanceUseInfoMapper fscOrderAdvanceUseInfoMapper;
    @Resource
    private FscOrderAdvanceUseItemMapper fscOrderAdvanceUseItemMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;

    @Override
    public BigDecimal handleDistributePreAmt(List<FscPhasePayListBO> payList, FscOrderRelationPO relationPO, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, Long userId) {
        if (CollectionUtils.isEmpty(payList) || !payList.stream().map(FscPhasePayListBO::getPayType).collect(Collectors.toList()).contains(FscConstants.PaymentMethod.PRE_PAY)) {
            return BigDecimal.ZERO;
        }
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(relationPO.getFscOrderId());
        fscOrderRelationPO.setContractId(relationPO.getContractId());
        List orderRelationPOList = this.fscOrderRelationMapper.getListByContractId(fscOrderRelationPO);
        if (CollectionUtils.isEmpty((Collection)orderRelationPOList)) {
            throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5173\u8054\u4fe1\u606f\uff01");
        }
        List orderIds = orderRelationPOList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
        FscOrderAdvanceUseItemPO orderAdvanceUseItemPO = new FscOrderAdvanceUseItemPO();
        orderAdvanceUseItemPO.setFscOrderId(relationPO.getFscOrderId());
        orderAdvanceUseItemPO.setOrderIds(orderIds);
        List advanceUseItemPOList = this.fscOrderAdvanceUseItemMapper.getList(orderAdvanceUseItemPO);
        if (!CollectionUtils.isEmpty((Collection)advanceUseItemPOList)) {
            return advanceUseItemPOList.stream().map(FscOrderAdvanceUseItemPO::getUseAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal[] preAmt = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal prePayRatio = payList.stream().filter(e -> Objects.nonNull(e.getPayType()) && FscConstants.PaymentMethod.PRE_PAY.equals(e.getPayType())).map(FscPhasePayListBO::getNodePayRatio).reduce(BigDecimal.ZERO, BigDecimal::add).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP);
        BigDecimal shouldPayRatio = payList.stream().filter(e -> Objects.nonNull(e.getPayType()) && FscConstants.PaymentMethod.SHOULD_PAY.equals(e.getPayType())).map(FscPhasePayListBO::getNodePayRatio).reduce(BigDecimal.ZERO, BigDecimal::add).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP);
        if (prePayRatio.compareTo(BigDecimal.ZERO) == 0 || shouldPayRatio.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        FscOrderAdvanceUseInfoPO useInfoPOReq = new FscOrderAdvanceUseInfoPO();
        useInfoPOReq.setOrderIdList(orderIds);
        List fscOrderAdvanceUseInfoPOS = this.fscOrderAdvanceUseInfoMapper.getList(useInfoPOReq);
        Map<Object, Object> useInfoPOMap = !CollectionUtils.isEmpty((Collection)fscOrderAdvanceUseInfoPOS) ? fscOrderAdvanceUseInfoPOS.stream().collect(Collectors.toMap(FscOrderAdvanceUseInfoPO::getOrderId, Function.identity(), (k1, k2) -> k1)) : new HashMap();
        Map<Long, List<FscOrderRelationPO>> settleMap = orderRelationPOList.stream().collect(Collectors.groupingBy(FscOrderRelationPO::getOrderId));
        ArrayList addInfoList = new ArrayList();
        ArrayList updateInfoList = new ArrayList();
        ArrayList fscOrderAdvanceUseItemPOList = new ArrayList();
        settleMap.forEach((key, val) -> {
            BigDecimal settleAmt = val.stream().map(FscOrderRelationPO::getSettleAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal qualityAmt = val.stream().map(FscOrderRelationPO::getQualityAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)fscOrderInfoBoMap.get(((FscOrderRelationPO)val.get(0)).getAcceptOrderId());
            if (Objects.isNull(fscOrderInfoBO)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01");
            }
            BigDecimal settleUseAmt = settleAmt.subtract(qualityAmt).multiply(prePayRatio.divide(prePayRatio.add(shouldPayRatio), 8, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            FscOrderAdvanceUseInfoPO fscOrderAdvanceUseInfoPO = new FscOrderAdvanceUseInfoPO();
            if (!CollectionUtils.isEmpty((Map)useInfoPOMap) && useInfoPOMap.containsKey(key)) {
                fscOrderAdvanceUseInfoPO.setId(((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getId());
                BigDecimal leaveAmt = ((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getAdvanceAmt().subtract(((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getTotalUseAmt());
                if (settleUseAmt.compareTo(leaveAmt) >= 0 || settleUseAmt.add(new BigDecimal("0.1")).compareTo(leaveAmt) > 0) {
                    settleUseAmt = leaveAmt;
                    fscOrderAdvanceUseInfoPO.setTotalUseAmt(((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getAdvanceAmt());
                } else {
                    fscOrderAdvanceUseInfoPO.setTotalUseAmt(((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getTotalUseAmt().add(settleUseAmt));
                }
                fscOrderAdvanceUseInfoPO.setAdvanceAmt(((FscOrderAdvanceUseInfoPO)useInfoPOMap.get(key)).getAdvanceAmt());
                fscOrderAdvanceUseInfoPO.setUpdateId(userId);
                fscOrderAdvanceUseInfoPO.setUpdateTime(new Date());
                updateInfoList.add(fscOrderAdvanceUseInfoPO);
            } else {
                fscOrderAdvanceUseInfoPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderAdvanceUseInfoPO.setOrderId(key);
                BigDecimal totalPrePayAmt = fscOrderInfoBO.getSaleMoneyIntegral().multiply(prePayRatio).setScale(2, RoundingMode.HALF_UP);
                fscOrderAdvanceUseInfoPO.setAdvanceAmt(totalPrePayAmt);
                if (settleUseAmt.compareTo(totalPrePayAmt) >= 0 || settleUseAmt.add(new BigDecimal("0.01")).compareTo(totalPrePayAmt) > 0) {
                    fscOrderAdvanceUseInfoPO.setTotalUseAmt(totalPrePayAmt);
                    settleUseAmt = totalPrePayAmt;
                } else {
                    fscOrderAdvanceUseInfoPO.setTotalUseAmt(settleUseAmt);
                }
                fscOrderAdvanceUseInfoPO.setCreateId(userId);
                fscOrderAdvanceUseInfoPO.setCreateTime(new Date());
                fscOrderAdvanceUseInfoPO.setUpdateId(userId);
                fscOrderAdvanceUseInfoPO.setUpdateTime(new Date());
                addInfoList.add(fscOrderAdvanceUseInfoPO);
            }
            FscOrderAdvanceUseItemPO fscOrderAdvanceUseItemPO = new FscOrderAdvanceUseItemPO();
            fscOrderAdvanceUseItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderAdvanceUseItemPO.setFscOrderId(relationPO.getFscOrderId());
            fscOrderAdvanceUseItemPO.setOrderId(key);
            fscOrderAdvanceUseItemPO.setUseAmt(settleUseAmt);
            fscOrderAdvanceUseItemPO.setLeaveAdvanceAmt(fscOrderAdvanceUseInfoPO.getAdvanceAmt().subtract(fscOrderAdvanceUseInfoPO.getTotalUseAmt()));
            fscOrderAdvanceUseItemPO.setCreateId(userId);
            fscOrderAdvanceUseItemPO.setCreateTime(new Date());
            fscOrderAdvanceUseItemPO.setUpdateId(userId);
            fscOrderAdvanceUseItemPO.setUpdateTime(new Date());
            fscOrderAdvanceUseItemPOList.add(fscOrderAdvanceUseItemPO);
            preAmt[0] = preAmt[0].add(settleUseAmt);
        });
        if (!CollectionUtils.isEmpty(addInfoList)) {
            this.fscOrderAdvanceUseInfoMapper.insertBatch(addInfoList);
        }
        if (!CollectionUtils.isEmpty(updateInfoList)) {
            this.fscOrderAdvanceUseInfoMapper.updateAmtBatch(updateInfoList);
        }
        if (!CollectionUtils.isEmpty(fscOrderAdvanceUseItemPOList)) {
            this.fscOrderAdvanceUseItemMapper.insertBatch(fscOrderAdvanceUseItemPOList);
        }
        return preAmt[0];
    }
}

