/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateInvoiceBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundQualityBO;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundChangeAtomService;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundPayAtomService;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceOrderRefundPayAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomRspBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundPayAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundPayAtomRspBO;
import com.tydic.fsc.bill.atom.bo.FscFinanceOrderRefundPayAtomRspBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceOrderRefundPayAtomReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderRefundCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundCreateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscNoTaskAuditOrderAuditNoticeBO;
import com.tydic.fsc.bo.FscUacApproveEntrustBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscBillRefundInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundFlowProcKeyEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.dao.FscRefundInvoiceHeadMapper;
import com.tydic.fsc.dao.FscShouldPayDetailMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.fsc.po.FscRefundInvoiceHeadPO;
import com.tydic.fsc.po.FscShouldPayDetailPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import com.tydic.uoc.common.ability.api.PebExtUpdateAbnormalRefundFlagAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUpdateOrderRefundFlagAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUpdateAbnormalRefundFlagReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUpdateAbnormalRefundFlagRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUpdateAbnormalRefundItemBO;
import com.tydic.uoc.common.ability.bo.PebExtUpdateOrderRefundFlagReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUpdateOrderRefundFlagRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUpdateOrderRefundItemBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderRefundCreateBusiServiceImpl
implements FscBillOrderRefundCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderRefundCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private PebExtUpdateAbnormalRefundFlagAbilityService pebExtUpdateAbnormalRefundFlagAbilityService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscFinanceOrderRefundPayAtomService fscFinanceOrderRefundPayAtomService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Value(value="${REFUND_PERMIT_ERROR_AMT:0.05}")
    private BigDecimal permitError;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    private static final String BUSI_NAME = "\u9000\u7968\u4e3b\u5355\u521b\u5efa";
    private static final String SEPARATOR = ",";
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private String operationSupId;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscRefundInvoiceHeadMapper fscRefundInvoiceHeadMapper;
    @Autowired
    private FscBillOrderRefundChangeAtomService fscBillOrderRefundChangeAtomService;
    @Autowired
    private FscBillOrderRefundPayAtomService fscBillOrderRefundPayAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscShouldPayDetailMapper fscShouldPayDetailMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Autowired
    private PebExtUpdateOrderRefundFlagAbilityService pebExtUpdateOrderRefundFlagAbilityService;

    @Override
    public FscBillOrderRefundCreateBusiRspBO dealRefundCreate(FscBillOrderRefundCreateBusiReqBO reqBO) {
        int refundCount;
        if (CollectionUtils.isEmpty(reqBO.getOrderList())) {
            throw new FscBusinessException("198888", "\u9000\u7968\u5f02\u5e38\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(reqBO.getInvoiceList())) {
            throw new FscBusinessException("198888", "\u9000\u7968\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = this.buildRefundOrderInfo(reqBO);
        ArrayList<FscInvoiceRefundRelationPO> invoiceRefundList = new ArrayList<FscInvoiceRefundRelationPO>();
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        Map<Long, FscBillOrderRefundCreateInvoiceBO> invoiceIdRefundAmtMap = reqBO.getInvoiceBOS().stream().collect(Collectors.toMap(FscBillOrderRefundCreateInvoiceBO::getInvoiceId, o -> o, (o1, o2) -> o1));
        for (FscInvoicePO invoicePO : reqBO.getInvoiceList()) {
            FscInvoiceRefundRelationPO refundRelationPO = new FscInvoiceRefundRelationPO();
            refundRelationPO.setFscOrderId(invoicePO.getFscOrderId());
            refundRelationPO.setCreateTime(new Date());
            refundRelationPO.setInvoiceId(invoicePO.getInvoiceId());
            refundRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundRelationPO.setRefundId(refundPO.getRefundId());
            refundRelationPO.setContractId(invoicePO.getContractId());
            if (invoiceIdRefundAmtMap.containsKey(invoicePO.getInvoiceId())) {
                FscBillOrderRefundCreateInvoiceBO fscBillOrderRefundCreateInvoiceBO = invoiceIdRefundAmtMap.get(invoicePO.getInvoiceId());
                if (null == fscBillOrderRefundCreateInvoiceBO.getRefundQualityAmt()) {
                    fscBillOrderRefundCreateInvoiceBO.setRefundQualityAmt(BigDecimal.ZERO);
                }
                refundRelationPO.setRefundAmt(fscBillOrderRefundCreateInvoiceBO.getRefundAmt());
                refundRelationPO.setRefundQualityAmt(fscBillOrderRefundCreateInvoiceBO.getRefundQualityAmt());
                if (reqBO.getTempId() != null) {
                    refundRelationPO.setRefundType(fscBillOrderRefundCreateInvoiceBO.getRefundType());
                } else {
                    refundRelationPO.setRefundType(reqBO.getRefundType());
                }
            }
            if (reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT)) {
                refundRelationPO.setInvoiceStatus(FscConstants.FscInvoiceStatus.TO_CONFIRM);
            } else {
                refundRelationPO.setInvoiceStatus(invoicePO.getStatus());
            }
            BigDecimal rate = BigDecimal.ZERO;
            if (invoicePO.getTaxAmt() != null && invoicePO.getUntaxAmt() != null) {
                rate = invoicePO.getTaxAmt().divide(invoicePO.getUntaxAmt(), 2, 4);
            }
            BigDecimal noTaxAmt = TaxUtils.calNoTaxAmt((BigDecimal)refundRelationPO.getRefundAmt(), (BigDecimal)rate);
            BigDecimal taxAmt = refundRelationPO.getRefundAmt().subtract(noTaxAmt);
            refundRelationPO.setUntaxAmt(noTaxAmt);
            refundRelationPO.setTaxAmt(taxAmt);
            refundRelationPO.setRefundAmt(refundRelationPO.getRefundAmt().subtract(refundRelationPO.getRefundQualityAmt()));
            invoiceRefundList.add(refundRelationPO);
            invoiceIds.add(invoicePO.getInvoiceId());
        }
        for (FscOrderRelationPO relationPO : reqBO.getOrderList()) {
            relationPO.setFscOrderId(null);
            relationPO.setRefundId(refundPO.getRefundId());
            relationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        }
        String refundNo = this.qryRefundNo(refundPO);
        refundPO.setRefundNo(refundNo);
        refundPO.setRefundAmount(reqBO.getRefundAmt());
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(refundPO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        Long supplierId = fscOrderPO.getSupplierId();
        Integer tradeMode = fscOrderPO.getTradeMode();
        FscShouldPayPO shouldPayPO = new FscShouldPayPO();
        shouldPayPO.setObjectId(reqBO.getFscOrderId());
        BigDecimal paidAmt = BigDecimal.ZERO;
        paidAmt = FscConstants.FscTradeMode.TRADE_MODEL.equals(tradeMode) ? (FscConstants.FscOrderReceiveType.PURCHASE.equals(refundPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(refundPO.getMakeType()) ? (FscConstants.SettlePlatform.FINANCE.equals(refundPO.getSettlePlatform()) ? this.getFinancePaidAmt(refundPO, shouldPayPO) : this.fscClaimDetailMapper.sumPayPaidAmt(reqBO.getFscOrderId())) : (fscOrderPO.getSettleType().equals(FscConstants.SettleType.ORDER) ? this.fscShouldPayMapper.sumOrderPayPaidAmt(shouldPayPO) : this.getPaidAmtByPay(refundPO))) : (this.operationSupId.equals(String.valueOf(supplierId)) ? this.fscClaimDetailMapper.sumPayPaidAmt(reqBO.getFscOrderId()) : (FscConstants.SettlePlatform.FINANCE.equals(refundPO.getSettlePlatform()) ? this.getFinancePaidAmt(refundPO, shouldPayPO) : (fscOrderPO.getSettleType().equals(FscConstants.SettleType.ORDER) ? this.fscShouldPayMapper.sumOrderPayPaidAmt(shouldPayPO) : this.fscShouldPayMapper.sumPayPaidAmt(shouldPayPO))));
        refundPO.setActualPaidAmount(paidAmt);
        if (!CollectionUtils.isEmpty(reqBO.getFileList())) {
            ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>();
            Date now = new Date();
            for (AttachmentBO attachmentBO : reqBO.getFileList()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)attachmentPO);
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setFscOrderId(refundPO.getRefundId());
                attachmentPO.setObjId(attachmentBO.getObjId());
                attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
                attachmentPO.setCreateTime(now);
                attachmentPO.setCreateUser(reqBO.getName());
                attachmentPO.setCreateUserId(reqBO.getUserId());
                attachmentPO.setContractRemark(attachmentBO.getContractRemark());
                attachmentList.add(attachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION) || reqBO.getOperationDown().equals(FscConstants.OperationDown.YES)) {
            this.dealOperatorInfo(refundPO, reqBO);
        }
        if ((refundCount = this.fscOrderRefundMapper.insert(refundPO)) == 0) {
            throw new FscBusinessException("198888", "refundCount\u9000\u7968\u5355\u65b0\u589e\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        int relationCount = this.fscOrderRelationMapper.insertBatch(reqBO.getOrderList());
        if (relationCount == 0) {
            throw new FscBusinessException("198888", "relationCount\u9000\u7968\u5355\u5173\u8054\u5173\u7cfb\u65b0\u589e\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        int invoiceRcount = this.fscInvoiceRefundRelationMapper.insertBatch(invoiceRefundList);
        if (invoiceRcount == 0) {
            throw new FscBusinessException("198888", "invoiceRcount\u9000\u7968\u5355\u5173\u8054\u65b0\u589e\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        if (!CollectionUtils.isEmpty(reqBO.getInsertFscOrderItemPOS())) {
            this.fscOrderItemMapper.insertBatch(reqBO.getInsertFscOrderItemPOS());
        }
        if (!CollectionUtils.isEmpty(reqBO.getUpdateInvoiceItemPOS())) {
            int count = this.fscInvoiceItemMapper.updateBatchRefundAmt(reqBO.getUpdateInvoiceItemPOS());
            if (reqBO.getUpdateInvoiceItemPOS().size() != count) {
                throw new FscBusinessException("198888", "\u53d1\u7968\u91d1\u989d\u4e0d\u6ee1\u8db3\u9000\u7968\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getUpdateFscOrderItemPOS())) {
            int count = this.fscOrderItemMapper.updateBatchRefundAmt(reqBO.getUpdateFscOrderItemPOS());
            if (reqBO.getUpdateFscOrderItemPOS().size() != count) {
                throw new FscBusinessException("198888", "\u53d1\u7968\u91d1\u989d\u4e0d\u6ee1\u8db3\u9000\u7968\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            }
        }
        if (reqBO.getInvoiceHead() != null) {
            FscRefundInvoiceHeadPO invoiceHeadPO = (FscRefundInvoiceHeadPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO.getInvoiceHead()), FscRefundInvoiceHeadPO.class);
            invoiceHeadPO.setChangeId(Long.valueOf(Sequence.getInstance().nextId()));
            invoiceHeadPO.setCreateTiem(new Date());
            invoiceHeadPO.setRefundId(refundPO.getRefundId());
            int count = this.fscRefundInvoiceHeadMapper.insert(invoiceHeadPO);
            if (count == 0) {
                throw new FscBusinessException("198888", "\u53d1\u7968\u6362\u5f00\u53d1\u7968\u62ac\u5934\u65b0\u589e\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
            }
        }
        if (null != reqBO.getFinanceOrgId()) {
            FscRefundFinancePO fscRefundFinancePO = (FscRefundFinancePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscRefundFinancePO.class);
            if (fscRefundFinancePO.getIsAgent() == null) {
                fscRefundFinancePO.setIsAgent(Integer.valueOf(0));
            }
            fscRefundFinancePO.setCreateTime(new Date());
            fscRefundFinancePO.setCreateUserId(reqBO.getUserId());
            fscRefundFinancePO.setCreateUserName(reqBO.getName());
            fscRefundFinancePO.setCreateUserAccount(reqBO.getUserName());
            fscRefundFinancePO.setExt1(reqBO.getFinanceExt1());
            fscRefundFinancePO.setExt2(reqBO.getFinanceExt2());
            if (StringUtils.isEmpty((Object)reqBO.getCwOrgId())) {
                fscRefundFinancePO.setExt3(reqBO.getFinanceExt3());
            } else {
                fscRefundFinancePO.setExt3(reqBO.getCwOrgId());
            }
            fscRefundFinancePO.setExt4(reqBO.getFinanceExt4());
            this.fscRefundFinanceMapper.insert(fscRefundFinancePO);
        }
        if (reqBO.getOperationDown().equals(FscConstants.OperationDown.YES) && reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT) && (refundPO.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION) || this.operationSupId.equals(String.valueOf(supplierId)))) {
            FscBillOrderRefundChangeAtomReqBO atomReqBO = new FscBillOrderRefundChangeAtomReqBO();
            atomReqBO.setRefundId(refundPO.getRefundId());
            atomReqBO.setCreateUserId(reqBO.getUserId());
            atomReqBO.setOperationType(FscConstants.RefundChangeOperationType.SAVE);
            FscBillOrderRefundChangeAtomRspBO atomRspBO = this.fscBillOrderRefundChangeAtomService.recordRefundChange(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8bb0\u5f55\u6838\u9500\u865a\u62df\u53d8\u66f4\u8868\u5931\u8d25" + atomRspBO.getRespDesc());
            }
        }
        FscBillOrderRefundCreateBusiRspBO rspBO = new FscBillOrderRefundCreateBusiRspBO();
        if (reqBO.getOperationDown() != null && reqBO.getOperationDown().equals(FscConstants.OperationDown.YES) && reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT)) {
            UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.dealStartApproval(reqBO, refundPO);
            if (!CollectionUtils.isEmpty((Collection)uacNoTaskAuditCreateRspBO.getApprovalInNotice())) {
                List approvalInNotice = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uacNoTaskAuditCreateRspBO.getApprovalInNotice()), FscUacApproveEntrustBO.class);
                FscNoTaskAuditOrderAuditNoticeBO noticeBO = new FscNoTaskAuditOrderAuditNoticeBO();
                noticeBO.setOrderId(refundPO.getRefundId());
                noticeBO.setApprovalInNotice(approvalInNotice);
                if (CollectionUtils.isEmpty(rspBO.getAuditNoticeList())) {
                    rspBO.setAuditNoticeList(new ArrayList<FscNoTaskAuditOrderAuditNoticeBO>());
                }
                rspBO.getAuditNoticeList().add(noticeBO);
            }
            rspBO.setNoticeOrderIds(Collections.singletonList(refundPO.getRefundId()));
        }
        if (reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT)) {
            this.dealWorkFlow(refundPO, reqBO.getOperationDown());
            if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                FscBillOrderRefundPayAtomReqBO refundPayAtomReqBO = new FscBillOrderRefundPayAtomReqBO();
                refundPayAtomReqBO.setRefundId(refundPO.getRefundId());
                refundPayAtomReqBO.setOperationType(FscConstants.RefundChangeOperationType.SAVE);
                FscBillOrderRefundPayAtomRspBO atomRspBO = this.fscBillOrderRefundPayAtomService.recordRefundPay(refundPayAtomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    throw new ZTBusinessException("\u8bb0\u5f55\u4ed8\u6b3e\u53d8\u66f4\u8868\u5931\u8d25" + atomRspBO.getRespDesc());
                }
            } else if (FscConstants.FscOrderReceiveType.PURCHASE.equals(refundPO.getReceiveType()) && FscConstants.FscTradeMode.MATCHMAKING_MODE.equals(refundPO.getTradeMode()) && FscConstants.SettlePlatform.FINANCE.equals(refundPO.getSettlePlatform())) {
                FscFinanceOrderRefundPayAtomReqBO refundPayAtomReqBO = new FscFinanceOrderRefundPayAtomReqBO();
                refundPayAtomReqBO.setRefundId(refundPO.getRefundId());
                refundPayAtomReqBO.setOperationType(FscConstants.RefundChangeOperationType.SAVE);
                FscFinanceOrderRefundPayAtomRspBO refundPayAtomRspBO = this.fscFinanceOrderRefundPayAtomService.dealFinanceRefundPay(refundPayAtomReqBO);
                if (!"0000".equals(refundPayAtomRspBO.getRespCode())) {
                    throw new ZTBusinessException("\u8bb0\u5f55\u4ed8\u6b3e\u53d8\u66f4\u8868\u5931\u8d25" + refundPayAtomRspBO.getRespDesc());
                }
            }
        }
        if (reqBO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND)) {
            if (FscConstants.SettleType.INSPECTION.equals(refundPO.getSettleType())) {
                this.syncAbnormal(reqBO.getInsertFscOrderItemPOS(), refundPO);
            } else {
                this.syncOrderAbnormal(reqBO.getInsertFscOrderItemPOS(), refundPO);
            }
        }
        rspBO.setRefundId(refundPO.getRefundId());
        rspBO.setFscOrderId(reqBO.getFscOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private BigDecimal getFinancePaidAmt(FscOrderRefundPO refundPO, FscShouldPayPO shouldPayPO) {
        BigDecimal paidAmt = BigDecimal.ZERO;
        BigDecimal writeOffAmt = BigDecimal.ZERO;
        FscFinanceWriteOffPO fscFinanceWriteOffPO = this.fscFinanceWriteOffMapper.sumAmtByFscOrderId(refundPO.getFscOrderId());
        if (null != fscFinanceWriteOffPO && null != fscFinanceWriteOffPO.getWriteOffAmt()) {
            writeOffAmt = fscFinanceWriteOffPO.getWriteOffAmt();
        }
        paidAmt = refundPO.getSettleType().equals(FscConstants.SettleType.INSPECTION) ? this.fscShouldPayMapper.sumShouldPayAmtByObjectId(refundPO.getFscOrderId()) : this.fscShouldPayMapper.sumOrderPayPaidAmt(shouldPayPO);
        paidAmt = writeOffAmt.add(paidAmt);
        return paidAmt;
    }

    private void syncOrderAbnormal(List<FscOrderItemPO> insertFscOrderItemPOS, FscOrderRefundPO refundPO) {
        PebExtUpdateOrderRefundFlagReqBO refundFlagReqBO = new PebExtUpdateOrderRefundFlagReqBO();
        refundFlagReqBO.setRefundId(refundPO.getRefundId());
        refundFlagReqBO.setRefundFlag(FscConstants.FscRefundFlag.YES);
        refundFlagReqBO.setReceiveType(refundPO.getReceiveType());
        ArrayList<PebExtUpdateOrderRefundItemBO> refundItemList = new ArrayList<PebExtUpdateOrderRefundItemBO>(insertFscOrderItemPOS.size());
        for (FscOrderItemPO orderItemPO : insertFscOrderItemPOS) {
            PebExtUpdateOrderRefundItemBO refundItemBO = new PebExtUpdateOrderRefundItemBO();
            refundItemBO.setOrderId(orderItemPO.getOrderId());
            refundItemBO.setRefundAmt(orderItemPO.getRefundAmt());
            refundItemBO.setRefundNum(orderItemPO.getNum());
            refundItemBO.setOrdItemId(orderItemPO.getOrderItemId());
            refundItemList.add(refundItemBO);
        }
        refundFlagReqBO.setRefundItems(refundItemList);
        PebExtUpdateOrderRefundFlagRspBO refundFlagRspBO = this.pebExtUpdateOrderRefundFlagAbilityService.updateOrderFlag(refundFlagReqBO);
        if (!refundFlagRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(refundFlagRspBO.getRespCode(), "\u540c\u6b65\u8ba2\u5355\u9000\u7968\u72b6\u6001\u5931\u8d25:" + refundFlagRspBO.getRespDesc());
        }
    }

    private void dealOperatorInfo(FscOrderRefundPO refundPO, FscBillOrderRefundCreateBusiReqBO reqBO) {
        String[] split;
        refundPO.setOperatorId(reqBO.getUserId());
        refundPO.setOperatorName(reqBO.getName());
        for (String orgId : split = this.proOrg.split(SEPARATOR)) {
            if (!reqBO.getOrgPath().contains("-" + orgId + "-")) continue;
            refundPO.setOperationId(Long.valueOf(orgId));
            UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            abilityReqBO.setOrgIdList(Collections.singletonList(Long.valueOf(orgId)));
            UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
            if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
                Map orgMap = rspBO.getOrgMap();
                refundPO.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(refundPO.getOperationId())).getOrgName());
                break;
            }
            throw new FscBusinessException("198888", "\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5f02\u5e38:" + rspBO.getRespDesc());
        }
    }

    private void checkRefundInvoice(List<Long> invoiceIds) {
        int count = this.fscInvoiceRefundRelationMapper.checkRefund(invoiceIds);
        if (count > 0) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u53d1\u7968\u5df2\u8fdb\u884c\u9000\u7968\u6216\u5728\u9000\u7968\u4e2d,\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77\u9000\u7968\u7533\u8bf7\uff01");
        }
    }

    private BigDecimal getPaidAmtByPay(FscOrderRefundPO refundPO) {
        BigDecimal paidAmt = BigDecimal.ZERO;
        List payDetailPOList = new ArrayList();
        payDetailPOList = refundPO.getSettleType().equals(FscConstants.SettleType.INSPECTION) ? this.fscShouldPayDetailMapper.qryRefundList(refundPO.getFscOrderId(), null) : this.fscShouldPayDetailMapper.qryOrderRefundList(refundPO.getFscOrderId(), null);
        if (!CollectionUtils.isEmpty(payDetailPOList)) {
            for (FscShouldPayDetailPO shouldPayDetailPO : payDetailPOList) {
                paidAmt = paidAmt.add(shouldPayDetailPO.getPayAmount().subtract(shouldPayDetailPO.getRefundAmount()));
            }
        }
        return paidAmt;
    }

    private UacNoTaskAuditCreateRspBO dealStartApproval(FscBillOrderRefundCreateBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setOrgTreeId(reqBO.getOrgPath());
        if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            auditCreateReqBO.setMenuId("M001009");
        } else {
            auditCreateReqBO.setMenuId("M001010");
        }
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.REFUND_INVOICE);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(refundPO.getRefundId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(refundPO.getRefundId().toString());
        approvalObjBO.setObjName("\u9000\u7968\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.REFUND_INVOICE);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setAuditStatus(FscConstants.AuditStatus.AUDITING);
        this.fscOrderRefundMapper.updateById(updatePo);
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(refundPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(refundPO.getMakeType())) {
            try {
                this.taskTodoWaitService.syncNotifySaleRefundWaitDone(reqBO.getRefundId());
            }
            catch (Exception e) {
                log.error("dealPayBillCreateBySale -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
            }
        }
        return uacNoTaskAuditCreateRspBO;
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO, Integer paramValue) {
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO;
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusStartAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusStartAtomReqBO.setOrderFlowKey(refundPO.getOrderFlowKey());
        fscOrderStatusStartAtomReqBO.setOrderFlow(refundPO.getOrderFlow());
        if (paramValue != null) {
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("startFlag", paramValue);
            fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        }
        if (!(fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealRefundStatusStart(fscOrderStatusStartAtomReqBO)).getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusStartAtomRspBO.getRespCode(), fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private String qryRefundNo(FscOrderRefundPO refundPO) {
        StringBuffer keySb = new StringBuffer();
        keySb.append(refundPO.getReceiveType());
        if (FscConstants.FscOrderMakeType.OPERTION.equals(refundPO.getMakeType()) || FscConstants.FscOrderReceiveType.OPERATION.equals(refundPO.getReceiveType())) {
            keySb.append(FscConstants.FscBusiModel.TRADE);
        } else {
            keySb.append(FscConstants.FscBusiModel.MATCHING);
        }
        keySb.append(refundPO.getOrderSource());
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillRefundInvoiceSerial.getInstance((String)keySb.toString()).getDesc());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (!encodedSerialGetServiceRspBO.getRespCode().equals("0000") || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u6b3e\u5355\u53f7\u7f16\u7801\u89c4\u5219\u5931\u8d25\uff01" + encodedSerialGetServiceRspBO.getRespDesc());
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }

    private FscOrderRefundPO buildRefundOrderInfo(FscBillOrderRefundCreateBusiReqBO reqBO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        BeanUtils.copyProperties((Object)orderPO, (Object)refundPO);
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO.setAgentDeptId(reqBO.getAgentDeptId());
        refundPO.setAgentDeptName(reqBO.getAgentDeptName());
        refundPO.setAgentUserId(reqBO.getAgentUserId());
        refundPO.setAgentUserName(reqBO.getAgentUserName());
        refundPO.setAuditStatus(FscConstants.AuditStatus.SAVE);
        refundPO.setRefundNote(reqBO.getRefundNote());
        refundPO.setRefundReason(reqBO.getRefundReason());
        refundPO.setRefundReasonType(reqBO.getRefundReasonType());
        refundPO.setTotalCharge(orderPO.getTotalCharge());
        refundPO.setCertification(reqBO.getCertification());
        refundPO.setCreateTime(new Date());
        refundPO.setCreateUserId(reqBO.getUserId());
        refundPO.setCreateUserName(reqBO.getName());
        refundPO.setRefundStatus(FscConstants.RefundInvoiceStatus.SAVE);
        refundPO.setPushStatus(FscConstants.RefundPushStatus.UN_PUSH);
        refundPO.setFscOrderNo(orderPO.getOrderNo());
        refundPO.setOrderFlow(FscConstants.OrderFlow.REFUND_INVOICE);
        refundPO.setIsPushUnify(orderPO.getSettlePlatform());
        if (refundPO.getIsPushUnify() == null) {
            refundPO.setIsPushUnify(Integer.valueOf(0));
        }
        refundPO.setPushUnifyStatus(FscConstants.FscPushStatus.NO_PUSH);
        if (orderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            refundPO.setOrderFlowKey(FscRefundFlowProcKeyEnum.REFUND_INVOICE.getDescr());
        } else {
            refundPO.setOrderFlowKey(FscRefundFlowProcKeyEnum.REFUND_DOWN_INVOICE.getDescr());
        }
        refundPO.setYcUserId(reqBO.getYcUserId());
        refundPO.setYcPersonId(reqBO.getYcPersonId());
        refundPO.setYcPersonName(reqBO.getYcPersonName());
        refundPO.setYcDeptId(reqBO.getYcDeptId());
        refundPO.setYcDeptName(reqBO.getYcDeptName());
        refundPO.setExt1(reqBO.getExt1());
        refundPO.setIsQuality(reqBO.getIsQuality());
        BigDecimal qualityAmt = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(reqBO.getQualityBOS())) {
            for (FscBillOrderRefundQualityBO qualityBO : reqBO.getQualityBOS()) {
                qualityAmt = qualityAmt.add(qualityBO.getQualityAmt());
            }
        }
        refundPO.setQualityAmt(qualityAmt);
        refundPO.setIsInvoiceChange(reqBO.getIsInvoiceChange());
        refundPO.setIsOperateCreate(reqBO.getIsOperateCreate());
        return refundPO;
    }

    private void syncAbnormal(List<FscOrderItemPO> orderItemPOS, FscOrderRefundPO refundPO) {
        PebExtUpdateAbnormalRefundFlagReqBO refundFlagReqBO = new PebExtUpdateAbnormalRefundFlagReqBO();
        refundFlagReqBO.setReceiveType(refundPO.getReceiveType());
        refundFlagReqBO.setRefundFlag(FscConstants.FscRefundFlag.YES);
        refundFlagReqBO.setRefundId(refundPO.getRefundId());
        ArrayList<Object> refundItems = new ArrayList<Object>();
        for (FscOrderItemPO orderItemPO : orderItemPOS) {
            PebExtUpdateAbnormalRefundItemBO itemBO = new PebExtUpdateAbnormalRefundItemBO();
            itemBO.setAbnormalVoucherId(orderItemPO.getAbnormalVoucherId());
            itemBO.setOrderId(orderItemPO.getOrderId());
            if (FscConstants.SettleType.ORDER.equals(refundPO.getSettleType())) {
                itemBO.setInspectionItemId(orderItemPO.getRefundOrderItemId());
            } else {
                itemBO.setInspectionItemId(orderItemPO.getOrderItemId());
            }
            itemBO.setRefundAmt(orderItemPO.getRefundAmt());
            itemBO.setRefundNum(orderItemPO.getNum());
            refundItems.add(itemBO);
        }
        if (!CollectionUtils.isEmpty(refundItems)) {
            ArrayList<PebExtUpdateAbnormalRefundItemBO> distRefundItems = new ArrayList<PebExtUpdateAbnormalRefundItemBO>();
            Map<Long, List<PebExtUpdateAbnormalRefundItemBO>> abnormalVoucherIdMap = refundItems.stream().collect(Collectors.groupingBy(PebExtUpdateAbnormalRefundItemBO::getAbnormalVoucherId));
            for (Long abnormalVoucherId : abnormalVoucherIdMap.keySet()) {
                Map<Long, List<PebExtUpdateAbnormalRefundItemBO>> itemIdMap = abnormalVoucherIdMap.get(abnormalVoucherId).stream().collect(Collectors.groupingBy(PebExtUpdateAbnormalRefundItemBO::getInspectionItemId));
                for (Long itemId : itemIdMap.keySet()) {
                    BigDecimal refundAmt = BigDecimal.ZERO;
                    BigDecimal refundNum = BigDecimal.ZERO;
                    for (PebExtUpdateAbnormalRefundItemBO pebExtUpdateAbnormalRefundItemBO : itemIdMap.get(itemId)) {
                        refundAmt = refundAmt.add(pebExtUpdateAbnormalRefundItemBO.getRefundAmt());
                        refundNum = refundNum.add(pebExtUpdateAbnormalRefundItemBO.getRefundNum());
                    }
                    PebExtUpdateAbnormalRefundItemBO pebExtUpdateAbnormalRefundItemBO = itemIdMap.get(itemId).get(0);
                    PebExtUpdateAbnormalRefundItemBO itemBO = new PebExtUpdateAbnormalRefundItemBO();
                    itemBO.setAbnormalVoucherId(pebExtUpdateAbnormalRefundItemBO.getAbnormalVoucherId());
                    itemBO.setOrderId(pebExtUpdateAbnormalRefundItemBO.getOrderId());
                    itemBO.setInspectionItemId(pebExtUpdateAbnormalRefundItemBO.getInspectionItemId());
                    itemBO.setRefundAmt(refundAmt);
                    itemBO.setRefundNum(refundNum);
                    distRefundItems.add(itemBO);
                }
            }
            refundFlagReqBO.setRefundItems(distRefundItems);
            log.info("\u540c\u6b65\u5f02\u5e38\u8ba2\u5355\u9000\u7968\u5165\u53c2" + JSONObject.toJSONString((Object)refundFlagReqBO));
            PebExtUpdateAbnormalRefundFlagRspBO rspBO = this.pebExtUpdateAbnormalRefundFlagAbilityService.updateAbnormalFlag(refundFlagReqBO);
            if (!rspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(rspBO.getRespCode(), "\u540c\u6b65\u5f02\u5e38\u8ba2\u5355\u9000\u7968\u72b6\u6001\u5931\u8d25:" + rspBO.getRespDesc());
            }
        }
    }
}

