/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundSubmitBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundSubmitBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundSubmitBusiRspBO;
import com.tydic.fsc.bo.FscContractPlanItemBO;
import com.tydic.fsc.bo.FscNoTaskAuditOrderAuditNoticeBO;
import com.tydic.fsc.bo.FscUacApproveEntrustBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscUnifySettleTokenAbilityService;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityReqBO;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayClaimRefundDetailMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPlanPayItemMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOperateCapitalPlanPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayClaimRefundDetailPO;
import com.tydic.fsc.po.FscPayClaimRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPlanPayItemPo;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocQueryContractInfoAbilityService;
import com.tydic.uoc.common.ability.bo.UocQueryContractInfoAbilityBO;
import com.tydic.uoc.common.ability.bo.UocQueryContractInfoAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocQueryContractInfoAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillPayRefundSubmitBusiServiceImpl
implements FscBillPayRefundSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundSubmitBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u9000\u6b3e\u4e3b\u5355\u63d0\u4ea4";
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscPayClaimRefundDetailMapper fscPayClaimRefundDetailMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Value(value="${fsc.main.pro.org:1000000087,1000000089}")
    private String proOrg;
    @Value(value="${OPER_ORG_ID:436}")
    private String operOrgId;
    @Autowired
    private FscUnifySettleTokenAbilityService fscUnifySettleTokenAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscPlanPayItemMapper fscPlanPayItemMapper;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private UocQueryContractInfoAbilityService uocQueryContractInfoAbilityService;

    @Override
    public FscBillPayRefundSubmitBusiRspBO dealPayRefundSubmit(FscBillPayRefundSubmitBusiReqBO reqBO) {
        FscBillPayRefundSubmitBusiRspBO rspBO = new FscBillPayRefundSubmitBusiRspBO();
        FscOrderRefundPO refundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        this.fscPayRefundDetailMapper.updateClaimAmtBatch(JSON.parseArray((String)JSONObject.toJSONString(reqBO.getFscRefundShouldPayBOS()), FscPayRefundDetailPO.class));
        List fscPayClaimRefundList = JSON.parseArray((String)JSONObject.toJSONString(reqBO.getFscPayClaimRefundBOS()), FscPayClaimRefundPO.class);
        if (CollectionUtils.isEmpty((Collection)fscPayClaimRefundList)) {
            throw new FscBusinessException("190000", "\u5173\u8054\u6536\u6b3e\u8ba4\u9886\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<FscPayClaimRefundDetailPO> fscPayClaimRefundDetailPOS = new ArrayList<FscPayClaimRefundDetailPO>();
        for (FscPayClaimRefundPO fscPayClaimRefundPO : fscPayClaimRefundList) {
            fscPayClaimRefundPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayClaimRefundPO.setRefundId(refundPO.getRefundId());
            BigDecimal refundAmt = fscPayClaimRefundPO.getRefundAmt();
            for (FscClaimDetailPO fscClaimDetailPO : fscPayClaimRefundPO.getClaimDetailList()) {
                FscPayClaimRefundDetailPO fscPayClaimRefundDetailPO = new FscPayClaimRefundDetailPO();
                fscPayClaimRefundDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscPayClaimRefundDetailPO.setClaimRefundId(fscPayClaimRefundPO.getId());
                fscPayClaimRefundDetailPO.setClaimDetailId(fscClaimDetailPO.getClaimDetailId());
                fscPayClaimRefundDetailPO.setRefundId(refundPO.getRefundId());
                fscPayClaimRefundDetailPO.setClaimAmt(fscClaimDetailPO.getClaimAmt());
                if (refundAmt.compareTo(new BigDecimal(0)) > 0) {
                    BigDecimal claimRefundAmt = fscClaimDetailPO.getRefundAmt();
                    if (refundAmt.compareTo(claimRefundAmt) > 0) {
                        fscPayClaimRefundDetailPO.setRefundAmt(claimRefundAmt);
                        refundAmt = refundAmt.subtract(claimRefundAmt);
                    } else {
                        fscPayClaimRefundDetailPO.setRefundAmt(refundAmt);
                        refundAmt = BigDecimal.ZERO;
                    }
                } else {
                    fscPayClaimRefundDetailPO.setRefundAmt(BigDecimal.ZERO);
                }
                fscPayClaimRefundDetailPOS.add(fscPayClaimRefundDetailPO);
            }
        }
        this.dealContract(fscPayClaimRefundList);
        int count = this.fscPayClaimRefundMapper.insertBatch(fscPayClaimRefundList);
        if (count != fscPayClaimRefundList.size()) {
            throw new FscBusinessException("190000", "\u5173\u8054\u8ba4\u9886\u4fe1\u606f\u5931\u8d25");
        }
        count = this.fscPayClaimRefundDetailMapper.insertBatch(fscPayClaimRefundDetailPOS);
        if (count != fscPayClaimRefundDetailPOS.size()) {
            throw new FscBusinessException("190000", "\u5173\u8054\u8ba4\u9886\u4fe1\u606f\u5931\u8d25");
        }
        if (FscConstants.RefundType.REFUND_INVOICE.equals(refundPO.getRefundReasonType())) {
            Long againstId = this.fscOrderRefundMapper.queryRefundIdByRefundId(refundPO.getRefundId());
            FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
            fscClaimDetailPO.setRefundId(refundPO.getRefundId());
            fscClaimDetailPO.setAgainstId(againstId);
            count = this.fscClaimDetailMapper.updateRefundAmtByRefundIdChange(fscClaimDetailPO);
        } else {
            count = this.fscClaimDetailMapper.updateRefundAmtByRefundId(refundPO.getRefundId());
        }
        if (count != 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u6536\u6b3e\u8ba4\u9886\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)fscPayClaimRefundList) && (count = this.fscPayClaimRefundMapper.updateRefundAmountBatch(fscPayClaimRefundList)) != fscPayClaimRefundList.size()) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u5e94\u9000\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        this.dealStartApproval(reqBO, rspBO);
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(reqBO.getRefundId());
        updatePo.setAuditStatus(FscConstants.AuditStatus.AUDITING);
        updatePo.setAgentDeptId(reqBO.getAgentDeptId());
        updatePo.setAgentDeptName(reqBO.getAgentDeptName());
        updatePo.setAgentUserId(reqBO.getAgentUserId());
        updatePo.setAgentUserName(reqBO.getAgentUserName());
        updatePo.setAccountBranch(reqBO.getAccountBranch());
        updatePo.setExt1(reqBO.getAgentAccount());
        updatePo.setBankAccount(reqBO.getBankAccount());
        updatePo.setCustomerName(reqBO.getCustomerName());
        updatePo.setOperatorId(reqBO.getUserId());
        updatePo.setOperatorName(reqBO.getName());
        this.buildOperation(reqBO, updatePo);
        refundPO.setOperatorId(reqBO.getUserId());
        refundPO.setOperatorName(reqBO.getName());
        updatePo.setRefundDate(reqBO.getRefundDate());
        this.fscOrderRefundMapper.updateById(updatePo);
        this.occupyFundsPlan(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealStartApproval(FscBillPayRefundSubmitBusiReqBO reqBO, FscBillPayRefundSubmitBusiRspBO rspBO) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setOrgTreeId(reqBO.getOrgPath());
        auditCreateReqBO.setMenuId("M001011");
        auditCreateReqBO.setOrgId(this.operationOrgId.toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.REFUND_PAY);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(reqBO.getRefundId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(reqBO.getRefundId().toString());
        approvalObjBO.setObjName("\u9000\u6b3e\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.REFUND_PAY);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u9000\u6b3e\u5355\u5ba1\u6279\u6d41\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)uacNoTaskAuditCreateRspBO.getApprovalInNotice())) {
            List approvalInNotice = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uacNoTaskAuditCreateRspBO.getApprovalInNotice()), FscUacApproveEntrustBO.class);
            FscNoTaskAuditOrderAuditNoticeBO noticeBO = new FscNoTaskAuditOrderAuditNoticeBO();
            noticeBO.setOrderId(reqBO.getRefundId());
            noticeBO.setApprovalInNotice(approvalInNotice);
            if (CollectionUtils.isEmpty(rspBO.getAuditNoticeList())) {
                rspBO.setAuditNoticeList(new ArrayList<FscNoTaskAuditOrderAuditNoticeBO>());
            }
            rspBO.getAuditNoticeList().add(noticeBO);
        }
    }

    private void buildOperation(FscBillPayRefundSubmitBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        Long operationId = null;
        String[] proOrgList = this.proOrg.split(",");
        if (proOrgList.length > 0) {
            for (String orgId : proOrgList) {
                if (!reqBO.getOrgPath().contains(orgId)) continue;
                operationId = Long.valueOf(orgId);
                break;
            }
        }
        fscOrderRefundPO.setOperationId(operationId);
        if (operationId != null) {
            Map orgMap;
            UmcDycEnterpriseOrgBO umcDycEnterpriseOrgBO;
            UmcEnterpriseOrgNameListQryAbilityReqBO quryOrgNameReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            List<Object> orgIds = Collections.singletonList(operationId);
            quryOrgNameReqBO.setOrgIdList(orgIds);
            UmcEnterpriseOrgNameListQryAbilityRspBO quryOrgNameRspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(quryOrgNameReqBO);
            if (quryOrgNameRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)quryOrgNameRspBO.getOrgMap()) && (umcDycEnterpriseOrgBO = (UmcDycEnterpriseOrgBO)(orgMap = quryOrgNameRspBO.getOrgMap()).get(operationId)) != null) {
                fscOrderRefundPO.setOperationName(umcDycEnterpriseOrgBO.getOrgName());
            }
        }
    }

    private void occupyFundsPlan(FscBillPayRefundSubmitBusiReqBO reqBO) {
        FscPlanPayItemPo planPayItemPo = new FscPlanPayItemPo();
        planPayItemPo.setFscOrderId(reqBO.getRefundId());
        this.fscPlanPayItemMapper.deleteByFscOrderId(planPayItemPo);
        ArrayList<FscPlanPayItemPo> insertList = new ArrayList<FscPlanPayItemPo>();
        for (FscContractPlanItemBO planItemBO : reqBO.getPlanItemBOs()) {
            FscPlanPayItemPo fscPlanPayItemPo = new FscPlanPayItemPo();
            fscPlanPayItemPo.setFscOrderId(reqBO.getRefundId());
            fscPlanPayItemPo.setShouldPayId(reqBO.getFscRefundShouldPayBOS().get(0).getRefundShouldPayId());
            fscPlanPayItemPo.setContractCapitalPlanId(planItemBO.getContractCapitalPlanId());
            fscPlanPayItemPo.setContractNum(planItemBO.getContractNum());
            fscPlanPayItemPo.setOccAmount(planItemBO.getOccAmount());
            fscPlanPayItemPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPlanPayItemPo.setType(Integer.valueOf(2));
            insertList.add(fscPlanPayItemPo);
        }
        int i = this.fscPlanPayItemMapper.insertBatch(insertList);
        if (i < 1) {
            throw new BusinessException("8888", "\u63d2\u5165\u8d44\u91d1\u8ba1\u5212\u5173\u8054\u8868\u5931\u8d25");
        }
        FscOrderRefundPO refundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        List list = this.fscOperateCapitalPlanMapper.getListByFscOrderId(reqBO.getRefundId());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        FscBillDealPushLogAbilityReqBO logReqBO = new FscBillDealPushLogAbilityReqBO();
        logReqBO.setPushStatus(Integer.valueOf(0));
        logReqBO.setObjectId(refundPO.getRefundId());
        logReqBO.setCreateTime(new Date());
        logReqBO.setType(FscConstants.FscPushType.FSC_NEW_OCCUPY_PLAN);
        try {
            QryUnifySettleTokenAbilityReqBO qryUnifySettleTokenReqBO = new QryUnifySettleTokenAbilityReqBO();
            qryUnifySettleTokenReqBO.setUserId(reqBO.getAgentAccount());
            QryUnifySettleTokenAbilityRspBO qryUnifySettleTokenAbilityRspBO = this.fscUnifySettleTokenAbilityService.qryToken(qryUnifySettleTokenReqBO);
            if (!qryUnifySettleTokenAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(qryUnifySettleTokenAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + qryUnifySettleTokenAbilityRspBO.getMsg());
            }
            logReqBO.setObjectNo(refundPO.getRefundNo());
            FscUnifySettleFundingPlanReqBO planReqBO = new FscUnifySettleFundingPlanReqBO();
            JSONObject jsonObject = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (FscOperateCapitalPlanPO x : list) {
                JSONObject bo = new JSONObject();
                bo.put("period", (Object)x.getPeriod());
                bo.put("itemId", (Object)x.getItemId());
                bo.put("itemName", (Object)x.getItemName());
                bo.put("controlMode", (Object)x.getControlMode());
                bo.put("exeType", (Object)"ZY");
                bo.put("planAmount", (Object)x.getPlanAmount());
                bo.put("amount", (Object)x.getUseAmount());
                bo.put("fromSource", (Object)"EBAY");
                bo.put("contractNum", (Object)x.getContractNum());
                if ("BILL".equals(x.getControlMode())) {
                    bo.put("billId", (Object)refundPO.getRefundId());
                    bo.put("billNum", (Object)refundPO.getRefundNo());
                }
                bo.put("recOrgName", (Object)refundPO.getPayeeName());
                bo.put("fromBillId", (Object)(refundPO.getRefundId() + ""));
                bo.put("fromBillLineId", (Object)x.getId());
                bo.put("deptId", (Object)x.getDeptId());
                bo.put("deptName", (Object)x.getDeptName());
                bo.put("orgId", (Object)(x.getOrgId() != null ? x.getOrgId() : this.operOrgId));
                bo.put("billType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "HTJS"));
                bo.put("fromBillType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "FK"));
                jsonArray.add((Object)bo);
            }
            jsonObject.put("head", (Object)jsonArray);
            JSONArray jsonArray1 = new JSONArray();
            jsonArray1.add((Object)jsonObject);
            logReqBO.setPushData(jsonArray1.toJSONString());
            logReqBO.setObjData(jsonArray1.toJSONString());
            planReqBO.setJsonObject(jsonArray1);
            planReqBO.setToken(qryUnifySettleTokenAbilityRspBO.getData());
            FscUnifySettleFundingPlanRspBO fundingPlanRspBO = this.fscUnifySettleRelatedInterfacesAtomService.occupyFundsEabyUpdateState(planReqBO);
            logReqBO.setPushParseData(fundingPlanRspBO.getPushParseData());
            logReqBO.setRespData(fundingPlanRspBO.getRespData());
            logReqBO.setRespParseData(fundingPlanRspBO.getRespParseData());
            if (!"0000".equals(fundingPlanRspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u5360\u7528/\u91ca\u653e\u8d44\u91d1\u8ba1\u5212\u5931\u8d25\uff1a" + fundingPlanRspBO.getRespData());
            }
            logReqBO.setPushStatus(Integer.valueOf(1));
        }
        catch (Exception e) {
            this.fscBillAddPushLogAbilityService.savePushLog(logReqBO);
            throw new FscBusinessException("190000", e.getMessage());
        }
        this.fscBillAddPushLogAbilityService.savePushLog(logReqBO);
    }

    private void dealContract(List<FscPayClaimRefundPO> fscPayClaimRefundList) {
        if (!CollectionUtils.isEmpty(fscPayClaimRefundList)) {
            try {
                Set orderIdSet = fscPayClaimRefundList.stream().filter(e -> e.getOrderId() != null).map(FscPayClaimRefundPO::getOrderId).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(orderIdSet)) {
                    UocQueryContractInfoAbilityReqBO abilityReqBO = new UocQueryContractInfoAbilityReqBO();
                    abilityReqBO.setOrderIds(new ArrayList(orderIdSet));
                    UocQueryContractInfoAbilityRspBO abilityRspBO = this.uocQueryContractInfoAbilityService.queryContractInfo(abilityReqBO);
                    if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                        Map<Long, UocQueryContractInfoAbilityBO> orderIdMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UocQueryContractInfoAbilityBO::getOrderId, o -> o));
                        for (FscPayClaimRefundPO po : fscPayClaimRefundList) {
                            if (po.getOrderId() == null || !orderIdMap.containsKey(po.getOrderId())) continue;
                            po.setContractId(orderIdMap.get(po.getOrderId()).getContractId());
                            po.setProContractId(orderIdMap.get(po.getOrderId()).getProContractId());
                        }
                    }
                }
            }
            catch (Exception e2) {
                log.error("\u6839\u636e\u8ba2\u5355Id\u67e5\u8be2\u5408\u540c\u7684\u4e0a\u4e0b\u6e38\u5408\u540cid\u4fe1\u606f\u5f02\u5e38" + e2.getMessage());
            }
        }
    }
}

