/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.finance.FscFinancePushSettleAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePushSettleAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscFinanceWriteOffApprovalBusiService;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscNoTaskAuditOrderAuditNoticeBO;
import com.tydic.fsc.bo.FscUacApproveEntrustBO;
import com.tydic.fsc.busibase.busi.bo.FscFinanceWriteOffApprovalServiceBusiReqBo;
import com.tydic.fsc.busibase.busi.bo.FscFinanceWriteOffApprovalServiceBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinanceWriteOffApprovalServiceBusiImpl
implements FscFinanceWriteOffApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceWriteOffApprovalServiceBusiImpl.class);
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscFinancePushSettleAbilityService fscFinancePushSettleAbilityService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;

    @Override
    public FscFinanceWriteOffApprovalServiceBusiRspBo dealFinanceWriteOffApproval(FscFinanceWriteOffApprovalServiceBusiReqBo reqBo) {
        UocApprovalLogPO uocApprovalLogPO = null;
        try {
            uocApprovalLogPO = this.taskTodoWaitService.listApproval(reqBo.getAdjustId());
        }
        catch (Exception e) {
            log.error("dealFinanceWriteOffApproval get stationId error:" + e);
        }
        UacNoTaskAuditOrderAuditRspBO approvalResult = this.getApprovalResult(reqBo, uocApprovalLogPO);
        UacNoneInstanceBO noneInstanceBO = approvalResult.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        Long adjustId = reqBo.getAdjustId();
        FscFinanceWriteOffApprovalServiceBusiRspBo rspBo = new FscFinanceWriteOffApprovalServiceBusiRspBo();
        FscFinanceWriteOffAdjustPO set = new FscFinanceWriteOffAdjustPO();
        set.setAuditOperId(reqBo.getUserId().toString());
        set.setAuditOperName(reqBo.getName());
        set.setAuditOperTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)approvalResult.getAuditNoticeList())) {
            List auditNoticeList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)approvalResult.getAuditNoticeList()), FscNoTaskAuditOrderAuditNoticeBO.class);
            StringBuilder entrustUserIds = new StringBuilder(",");
            StringBuilder commissionedUserIds = new StringBuilder(",");
            for (FscNoTaskAuditOrderAuditNoticeBO auditNoticeBO : auditNoticeList) {
                if (CollectionUtils.isEmpty((Collection)auditNoticeBO.getApprovalInNotice())) continue;
                for (FscUacApproveEntrustBO entrustBO : auditNoticeBO.getApprovalInNotice()) {
                    entrustUserIds.append(entrustBO.getEntrustUserId()).append(",");
                    commissionedUserIds.append(entrustBO.getCommissionedUserId()).append(",");
                }
            }
            set.setEntrustUserId(entrustUserIds.toString());
            set.setCommissionedUserId(commissionedUserIds.toString());
            rspBo.setAuditNoticeList(auditNoticeList);
        }
        FscTaskCandidatePO fscTaskCandidateQueryVo = new FscTaskCandidatePO();
        fscTaskCandidateQueryVo.setFscOrderId(adjustId);
        List auditedList = this.fscTaskCandidateMapper.getAuditedPostIdAndOperIdList(fscTaskCandidateQueryVo);
        List auditedIdList = auditedList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
        String auditedIds = String.join((CharSequence)",", auditedIdList);
        set.setAuditedOperId("," + auditedIds + ",");
        if ("0".equals(auditResult)) {
            if (finish.booleanValue()) {
                FscFinancePushSettleAbilityReqBO reqBO = new FscFinancePushSettleAbilityReqBO();
                reqBO.setAdjustIds(Collections.singletonList(reqBo.getAdjustId()));
                if (reqBo.getBillType() != null && reqBo.getBillType() == 1) {
                    this.fscFinancePushSettleAbilityService.dealPushFinanceWriteOffAdjustSettleBatch(reqBO);
                } else {
                    this.fscFinancePushSettleAbilityService.dealPushCancelFinanceWriteOffAdjustSettleBatch(reqBO);
                }
            } else {
                FscTaskCandidatePO fscTaskCandidatePO = new FscTaskCandidatePO();
                fscTaskCandidatePO.setFscOrderId(adjustId);
                List auditedPostIdAndOperIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(fscTaskCandidatePO);
                if (!CollectionUtils.isEmpty((Collection)auditedPostIdAndOperIdList)) {
                    StringBuilder auditedPostIds = new StringBuilder();
                    auditedPostIds.append(",");
                    for (FscApprovalTaskQueryBO fscApprovalTaskQueryBO : auditedPostIdAndOperIdList) {
                        auditedPostIds.append(fscApprovalTaskQueryBO.getTaskOperId()).append(",");
                    }
                    set.setTaskOperId(auditedPostIds.toString());
                }
            }
        } else {
            set.setBillStatus(FscConstants.WriteOffBillStatus.AUDIT_FAIL);
        }
        FscFinanceWriteOffAdjustPO where = new FscFinanceWriteOffAdjustPO();
        where.setAdjustId(adjustId);
        this.fscFinanceWriteOffAdjustMapper.updateBy(set, where);
        return rspBo;
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscFinanceWriteOffApprovalServiceBusiReqBo reqBO, UocApprovalLogPO uocApprovalLogPO) {
        FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
        if (Objects.nonNull(reqBO.getFscOrderId())) {
            fscOrderFinancePO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderFinancePO = this.fscOrderFinanceMapper.getModelBy(fscOrderFinancePO);
        }
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getAdjustId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.FinanceWriteOffType.ADD.equals(reqBO.getBillType()) ? FscConstants.AuditObjType.FINANCE_WRITEOFF : FscConstants.AuditObjType.FINANCE_WRITEOFF_CANCEL;
        String stepId = this.fscFinanceWriteOffAdjustMapper.selectStepId(reqBO.getAdjustId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        auditReqBO.setStepId(stepId);
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        auditReqBO.setVariables(paramMap);
        if (StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("payAmount", reqBO.getWriteOffAmt());
        variables.put("orgCode", fscOrderFinancePO.getFinanceDeptName());
        variables.put("note", fscOrderFinancePO.getNote());
        variables.put("businessItemName", fscOrderFinancePO.getBusinessItemName());
        variables.put("createName", fscOrderFinancePO.getCreateUserName());
        auditReqBO.setVariables(variables);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }
}

