/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscRecvClaimListQueryBusiService;
import com.tydic.fsc.bill.busi.bo.FscFinancialPreClaimBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscFinancialPreClaimBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscRecvClaimListQueryBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscRecvClaimListQueryBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscUpdateClaimDetailRspBO;
import com.tydic.fsc.bo.FscClaimDetailBO;
import com.tydic.fsc.bo.FscRecvClaimBO;
import com.tydic.fsc.common.ability.api.FscPushYcRecvClaimBillAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountSerialMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimPushStatusEnum;
import com.tydic.fsc.enums.FscClaimRecvStatusEnum;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.enums.FscRecvTypeEnum;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.uoc.common.ability.api.UocQueryContractInfoAbilityService;
import com.tydic.uoc.common.ability.bo.UocQueryContractInfoAbilityBO;
import com.tydic.uoc.common.ability.bo.UocQueryContractInfoAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocQueryContractInfoAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscRecvClaimListQueryBusiServiceImpl
implements FscRecvClaimListQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimListQueryBusiServiceImpl.class);
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscAccountSerialMapper fscAccountSerialMapper;
    @Autowired
    private FscPushYcRecvClaimBillAbilityService fscPushYcRecvClaimBillAbilityService;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private UocQueryContractInfoAbilityService uocQueryContractInfoAbilityService;

    @Override
    public FscRecvClaimListQueryBusiRspBO qryRecvClaimList(FscRecvClaimListQueryBusiReqBO reqBO) {
        List claimIdList;
        List claimDetailList;
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscRecvClaimPO fscRecvClaimPO = new FscRecvClaimPO();
        fscRecvClaimPO = (FscRecvClaimPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscRecvClaimPO.class);
        if (reqBO.getWebSource() != null && reqBO.getWebSource() == 1) {
            ArrayList<String> claimStatusList = new ArrayList<String>();
            claimStatusList.add(FscClaimStatusEnum.NOT_CLAIM.getCode());
            claimStatusList.add(FscClaimStatusEnum.PART_CLAIM.getCode());
            fscRecvClaimPO.setRecvStatus(FscClaimRecvStatusEnum.EFFECTIVE.getCode());
            fscRecvClaimPO.setClaimStatusList(claimStatusList);
        }
        fscRecvClaimPO.setExcludeRecvStatus(FscClaimRecvStatusEnum.DELETE.getCode());
        fscRecvClaimPO.setHandleUserId(reqBO.getClaimUserId());
        fscRecvClaimPO.setHandleDeptId(reqBO.getClaimDeptId());
        if (reqBO.getOnlyMemType() != null && reqBO.getOnlyMemType() == 1) {
            fscRecvClaimPO.setClaimType(FscClaimTypeEnum.MEM_FEE_CLAIM.getCode());
        } else {
            fscRecvClaimPO.setExClaimType(FscClaimTypeEnum.MEM_FEE_CLAIM.getCode());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getPushStatus())) {
            fscRecvClaimPO.setPushStatus(null);
            fscRecvClaimPO.setStatus(Integer.valueOf(reqBO.getPushStatus()));
        }
        List listPage = this.fscRecvClaimMapper.getListPage(fscRecvClaimPO, page);
        HashMap<Long, List<FscClaimDetailPO>> detailPOMap = new HashMap();
        List<Object> claimDetailIdList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)listPage) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(claimDetailList = this.fscClaimDetailMapper.queryByClaimIdList(claimIdList = listPage.stream().map(FscRecvClaimPO::getClaimId).collect(Collectors.toList()))))) {
            detailPOMap = claimDetailList.stream().collect(Collectors.groupingBy(FscClaimDetailPO::getClaimId));
            claimDetailIdList = claimDetailList.stream().filter(e -> e.getClaimType() != null && FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode().equals(e.getClaimType())).map(FscClaimDetailPO::getClaimDetailId).collect(Collectors.toList());
        }
        HashMap<Long, String> buynerNoMap = new HashMap<Long, String>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(claimDetailIdList)) {
            List fscAccountChargePOList = this.fscAccountChargeMapper.getByClaimDetailId(claimDetailIdList);
            List fscAccountChargeDetailPOList = this.fscAccountChargeDetailMapper.getByClaimDetailId(claimDetailIdList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)fscAccountChargePOList)) {
                for (FscAccountChargePO fscAccountChargePO : fscAccountChargePOList) {
                    buynerNoMap.put(fscAccountChargePO.getClaimDetailId(), fscAccountChargePO.getUseDeptCode());
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)fscAccountChargeDetailPOList)) {
                Iterator iterator = fscAccountChargeDetailPOList.iterator();
                while (iterator.hasNext()) {
                    FscAccountChargeDetailPO fscAccountChargeDetailPO = (FscAccountChargeDetailPO)iterator.next();
                    buynerNoMap.put(fscAccountChargeDetailPO.getClaimDetailId(), fscAccountChargeDetailPO.getUseDeptCode());
                }
            }
        }
        LinkedList<FscRecvClaimBO> rows = new LinkedList<FscRecvClaimBO>();
        for (FscRecvClaimPO recvClaimPo : listPage) {
            FscRecvClaimBO fscRecvClaimBo = new FscRecvClaimBO();
            BeanUtils.copyProperties((Object)recvClaimPo, (Object)fscRecvClaimBo);
            fscRecvClaimBo.setFailFeason(recvClaimPo.getFailReason());
            this.transform(fscRecvClaimBo);
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            fscAttachmentPo.setObjId(recvClaimPo.getClaimId());
            if (reqBO.getNoPic() == null || reqBO.getNoPic() != 1) {
                fscRecvClaimBo.setAttachmentList(this.fscAttachmentMapper.getExtensionList(fscAttachmentPo));
            }
            fscRecvClaimBo.setClaimAmount(fscRecvClaimBo.getRecvAmt().subtract(fscRecvClaimBo.getNoClaimAmt()));
            this.transDetailInfo(fscRecvClaimBo, detailPOMap, buynerNoMap);
            rows.add(fscRecvClaimBo);
        }
        FscRecvClaimListQueryBusiRspBO rspBO = new FscRecvClaimListQueryBusiRspBO();
        rspBO.setRows(rows);
        if (reqBO.getOnlyMemType() != null && reqBO.getOnlyMemType() == 1) {
            rspBO.setRecvAmt(this.fscRecvClaimMapper.selectMemRecvAmt(fscRecvClaimPO));
            rspBO.setNoClaimAmt(this.fscRecvClaimMapper.selectMemNoClaimAmt(fscRecvClaimPO));
        } else {
            rspBO.setRecvAmt(this.fscRecvClaimMapper.selectRecvAmt(fscRecvClaimPO));
            rspBO.setNoClaimAmt(this.fscRecvClaimMapper.selectNoClaimAmt(fscRecvClaimPO));
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void transform(FscRecvClaimBO fscRecvClaimBo) {
        if (!StringUtils.isEmpty((Object)fscRecvClaimBo.getRecvType())) {
            fscRecvClaimBo.setRecvTypeStr(FscRecvTypeEnum.getCodeDesc((String)fscRecvClaimBo.getRecvType()));
        }
        if (!StringUtils.isEmpty((Object)fscRecvClaimBo.getClaimStatus())) {
            fscRecvClaimBo.setClaimStatusStr(FscClaimStatusEnum.getCodeDsc((String)fscRecvClaimBo.getClaimStatus()));
        }
        if (!StringUtils.isEmpty((Object)fscRecvClaimBo.getRecvStatus())) {
            fscRecvClaimBo.setRecvStatusStr(FscClaimRecvStatusEnum.getCodeDesc((String)fscRecvClaimBo.getRecvStatus()));
        }
        if (!StringUtils.isEmpty((Object)fscRecvClaimBo.getPostingStatus()) && "1".equals(fscRecvClaimBo.getPostingStatus())) {
            fscRecvClaimBo.setPostingStatusStr("\u5df2\u8fc7\u8d26");
            fscRecvClaimBo.setCheckFlag(Integer.valueOf(0));
        } else {
            fscRecvClaimBo.setPostingStatusStr("\u672a\u8fc7\u8d26");
            fscRecvClaimBo.setCheckFlag(Integer.valueOf(1));
        }
        if (fscRecvClaimBo.getChangeId() != null) {
            fscRecvClaimBo.setCheckFlag(Integer.valueOf(2));
        }
        if (StringUtils.isEmpty((Object)fscRecvClaimBo.getStatus()) || 0 == fscRecvClaimBo.getStatus()) {
            fscRecvClaimBo.setStatusStr("\u672a\u63a8\u9001");
        } else if (1 == fscRecvClaimBo.getStatus()) {
            fscRecvClaimBo.setStatusStr("\u63a8\u9001\u6210\u529f");
        } else if (2 == fscRecvClaimBo.getStatus()) {
            fscRecvClaimBo.setStatusStr("\u63a8\u9001\u5931\u8d25");
        }
    }

    private void transDetailInfo(FscRecvClaimBO fscRecvClaimBo, Map<Long, List<FscClaimDetailPO>> detailPOMap, Map<Long, String> buynerNoMap) {
        List<FscClaimDetailPO> detailPOList = detailPOMap.get(fscRecvClaimBo.getClaimId());
        ArrayList<FscClaimDetailBO> detailBOList = new ArrayList<FscClaimDetailBO>();
        BigDecimal refundAmt = BigDecimal.ZERO;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(detailPOList)) {
            for (FscClaimDetailPO e : detailPOList) {
                if (e.getClaimAmt() == null || e.getClaimAmt().compareTo(BigDecimal.ZERO) == 0) continue;
                FscClaimDetailBO fscClaimDetailBO = new FscClaimDetailBO();
                BeanUtils.copyProperties((Object)e, (Object)fscClaimDetailBO);
                if (FscConstants.IsSup.REFUND.equals(fscRecvClaimBo.getIsSup())) {
                    fscClaimDetailBO.setPushStatusStr(FscClaimPushStatusEnum.getCodeDesc((Integer)e.getPushStatus()));
                } else {
                    fscClaimDetailBO.setPushStatusStr(fscRecvClaimBo.getStatusStr());
                }
                fscClaimDetailBO.setSysSourceStr(FscSystemSourceEnum.getCodeDesc((Integer)e.getSysSource()));
                FscClaimTypeEnum instance = FscClaimTypeEnum.getInstance((String)fscClaimDetailBO.getClaimType());
                if (instance != null) {
                    fscClaimDetailBO.setClaimTypeStr(instance.getCodeDesc());
                }
                if (FscSystemSourceEnum.YC.getCode().equals(fscClaimDetailBO.getSysSource())) {
                    fscClaimDetailBO.setClaimAmtForYC(fscClaimDetailBO.getClaimAmt());
                } else {
                    fscClaimDetailBO.setClaimAmtForYG(fscClaimDetailBO.getClaimAmt());
                }
                fscClaimDetailBO.setBuyerNo(buynerNoMap.get(fscClaimDetailBO.getClaimDetailId()));
                if (e.getRefundType() != null) {
                    refundAmt = refundAmt.add(e.getClaimAmt());
                }
                detailBOList.add(fscClaimDetailBO);
            }
        }
        fscRecvClaimBo.setClaimDetailList(detailBOList);
        if (Objects.nonNull(fscRecvClaimBo.getRefundAmt())) {
            fscRecvClaimBo.setActualRecvAmt(fscRecvClaimBo.getRecvAmt().subtract(fscRecvClaimBo.getRefundAmt()));
        } else {
            fscRecvClaimBo.setActualRecvAmt(fscRecvClaimBo.getRecvAmt().subtract(refundAmt));
        }
    }

    @Override
    public FscUpdateClaimDetailRspBO updateRecvClaimAndDetail(FscFinancialPreClaimBusiReqBO reqBO) {
        FscUpdateClaimDetailRspBO rspBO = new FscUpdateClaimDetailRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO == null) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u8d22\u52a1\u9884\u8ba4\u9886\u64cd\u4f5c\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(reqBO.getClaimIds())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u8d22\u52a1\u9884\u8ba4\u9886\u64cd\u4f5c\u5165\u53c2 \u8ba4\u9886id\u96c6\u5408 \u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getClaimIds().size() > 20) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u8d22\u52a1\u9884\u8ba4\u9886\u6700\u591a\u64cd\u4f5c 20 \u6761\u6570\u636e\uff01");
            return rspBO;
        }
        List fscRecvClaimPOS = this.fscRecvClaimMapper.queryByIds(reqBO.getClaimIds());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)fscRecvClaimPOS)) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u8d22\u52a1\u9884\u8ba4\u9886\u64cd\u4f5c\u8ba4\u9886\u6570\u636e\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        ArrayList claimNos = new ArrayList();
        fscRecvClaimPOS.forEach(e -> {
            if ("3".equals(e.getClaimStatus())) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u8ba4\u9886\u5355\u53f7\uff1a" + e.getClaimNo() + "\u5df2\u88ab\u9884\u8ba4\u9886");
            }
            if ("2".equals(e.getClaimStatus())) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u8ba4\u9886\u5355\u53f7\uff1a" + e.getClaimNo() + "\u5df2\u8ba4\u9886");
            }
            claimNos.add(e.getClaimNo());
        });
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        ArrayList<FscClaimDetailPO> list = new ArrayList<FscClaimDetailPO>();
        for (FscRecvClaimPO fscRecvClaimPO : fscRecvClaimPOS) {
            FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
            fscClaimDetailPo.setOrderCode(fscRecvClaimPO.getClaimNo() + "-CWYRL");
            fscClaimDetailPo.setClaimDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            fscClaimDetailPo.setClaimAmt(fscRecvClaimPO.getNoClaimAmt());
            fscClaimDetailPo.setClaimDate(new Date());
            fscClaimDetailPo.setClaimId(fscRecvClaimPO.getClaimId());
            fscClaimDetailPo.setClaimType(FscClaimTypeEnum.PER_FEE_CLAIM.getCode());
            fscClaimDetailPo.setHandleDeptId(reqBO.getDeptId());
            fscClaimDetailPo.setHandleDeptName(reqBO.getDeptName());
            fscClaimDetailPo.setHandleUserId(reqBO.getHandleUserId());
            fscClaimDetailPo.setHandleUserName(reqBO.getHandleUserName());
            fscClaimDetailPo.setStatus("1");
            fscClaimDetailPo.setSysSource(Integer.valueOf(1));
            fscClaimDetailPo.setPushStatus(Integer.valueOf(0));
            fscClaimDetailPo.setProBalance(fscRecvClaimPO.getNoClaimAmt());
            fscClaimDetailPo.setBalanceType("2");
            list.add(fscClaimDetailPo);
            map.put(fscRecvClaimPO.getClaimId(), fscClaimDetailPo.getClaimDetailId());
        }
        this.fscRecvClaimMapper.updateClaimStatusByClaimId(reqBO.getClaimIds());
        this.dealContract(list);
        this.fscClaimDetailMapper.insertBatch(list);
        rspBO.setMap(map);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public FscFinancialPreClaimBusiRspBO qryClaimDetailList(FscFinancialPreClaimBusiReqBO reqBO) {
        FscFinancialPreClaimBusiRspBO rspBO = new FscFinancialPreClaimBusiRspBO();
        if (reqBO == null) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u67e5\u8be2\u8d22\u52a1\u9884\u8ba4\u9886\u540e\u7684\u64cd\u4f5c\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getClaimId() == null) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u67e5\u8be2\u8d22\u52a1\u9884\u8ba4\u9886\u540e\u7684\u64cd\u4f5c\u5165\u53c2 \u8ba4\u9886id \u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        FscClaimDetailPO po = new FscClaimDetailPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)po);
        if (reqBO.getClaimDateStar() != null && !"".equals(reqBO.getClaimDateStar())) {
            po.setClaimDateStar(DateUtil.strToDateLong((String)(reqBO.getClaimDateStar() + " 00:0:00")));
        }
        if (reqBO.getClaimDateEnd() != null && !"".equals(reqBO.getClaimDateEnd())) {
            po.setClaimDateEnd(DateUtil.strToDateLong((String)(reqBO.getClaimDateEnd() + " 23:59:59")));
        }
        po.setBalanceType("1");
        List fscClaimDetailPOS = this.fscClaimDetailMapper.queryAll(po);
        List fscClaimDetailBOS = JSON.parseArray((String)JSON.toJSONString((Object)fscClaimDetailPOS), FscClaimDetailBO.class);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)fscClaimDetailBOS)) {
            fscClaimDetailBOS.forEach(e -> {
                if (e.getClaimType() != null && !"".equals(e.getClaimType())) {
                    e.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)e.getClaimType()));
                }
            });
        }
        rspBO.setList(fscClaimDetailBOS);
        return rspBO;
    }

    @Override
    public FscRecvClaimListQueryBusiRspBO getListLine(FscRecvClaimListQueryBusiReqBO reqBO) {
        FscRecvClaimListQueryBusiRspBO rspBo = new FscRecvClaimListQueryBusiRspBO();
        FscRecvClaimPO fscRecvClaimPO = new FscRecvClaimPO();
        fscRecvClaimPO = (FscRecvClaimPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscRecvClaimPO.class);
        List listPage = this.fscRecvClaimMapper.getListLinePage(fscRecvClaimPO);
        List rows = JSON.parseArray((String)JSON.toJSONString((Object)listPage), FscRecvClaimBO.class);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setRows(rows);
        return rspBo;
    }

    private void dealContract(List<FscClaimDetailPO> addClaimDetailList) {
        if (!CollectionUtils.isEmpty(addClaimDetailList)) {
            try {
                Set orderIdSet = addClaimDetailList.stream().filter(e -> e.getOrderId() != null).map(FscClaimDetailPO::getOrderId).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(orderIdSet)) {
                    UocQueryContractInfoAbilityReqBO abilityReqBO = new UocQueryContractInfoAbilityReqBO();
                    abilityReqBO.setOrderIds(new ArrayList(orderIdSet));
                    UocQueryContractInfoAbilityRspBO abilityRspBO = this.uocQueryContractInfoAbilityService.queryContractInfo(abilityReqBO);
                    if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                        Map<Long, UocQueryContractInfoAbilityBO> orderIdMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UocQueryContractInfoAbilityBO::getOrderId, o -> o));
                        for (FscClaimDetailPO po : addClaimDetailList) {
                            if (po.getOrderId() == null || !orderIdMap.containsKey(po.getOrderId())) continue;
                            po.setContractId(orderIdMap.get(po.getOrderId()).getContractId());
                            po.setProContractId(orderIdMap.get(po.getOrderId()).getProContractId());
                        }
                    }
                }
            }
            catch (Exception e2) {
                log.error("\u6839\u636e\u8ba2\u5355Id\u67e5\u8be2\u5408\u540c\u7684\u4e0a\u4e0b\u6e38\u5408\u540cid\u4fe1\u606f\u5f02\u5e38" + e2.getMessage());
            }
        }
    }
}

