/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl.finance;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderToYCAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityReqBO;
import com.tydic.fsc.bill.ability.enums.FscOperatorTypeEnum;
import com.tydic.fsc.bill.atom.api.finance.FscSyncContractSettlementDetailAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscSyncContractSettlementDetailAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscSyncContractSettlementDetailAtomRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscCreateEngineeringFinanceBillOrderAndPayBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscCreateEngineeringFinanceBillOrderAndPayBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscCreateEngineeringFinanceBillOrderAndPayBusiRspBO;
import com.tydic.fsc.bill.busi.bo.finance.FscCreateEngineeringFinanceBillOrderBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscCreateFinanceBillOrderBusiReqBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.FscShouldPayRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.bo.FscOrderItemTempAddBO;
import com.tydic.fsc.common.ability.enums.FscInvoiceValueTypeEnum;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscCheckTempMapper;
import com.tydic.fsc.dao.FscContractSettlementDetailMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayItemSerialMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscFinanceEngineeringPayBillCreateReqBO;
import com.tydic.fsc.pay.atom.api.FscPayBillDetailAssemblyAtomService;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscCheckTempPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscCreateEngineeringFinanceBillOrderAndPayBusiServiceImpl
implements FscCreateEngineeringFinanceBillOrderAndPayBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCreateEngineeringFinanceBillOrderAndPayBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Value(value="${fsc.main.electricity.pro.org:100100}")
    private String electricityOrg;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    private static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscBillSendSaleFscOrderToYCAbilityService fscBillSendSaleFscOrderToYCAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscCheckTempMapper fscCheckTempMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    @Autowired
    private FscPayBillDetailAssemblyAtomService fscPayBillDetailAssemblyAtomService;
    @Value(value="${fsc.oil.taxCode:1070101070100000000,1070101070200000000}")
    private String oilTaxCode;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long operationSupId;
    @Autowired
    private PebExtOrderSettleTypeUpdateAbilityService pebExtOrderSettleTypeUpdateAbilityService;
    @Autowired
    private FscFinanceCapitalInfoAtomService fscFinanceCapitalInfoAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscPayItemSerialMapper fscPayItemSerialMapper;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscContractSettlementDetailMapper fscContractSettlementDetailMapper;
    @Autowired
    private FscSyncContractSettlementDetailAtomService fscSyncContractSettlementDetailAtomService;

    @Override
    public FscCreateEngineeringFinanceBillOrderAndPayBusiRspBO dealCreate(FscCreateEngineeringFinanceBillOrderAndPayBusiReqBO busiReqBO) {
        FscCreateEngineeringFinanceBillOrderAndPayBusiRspBO rspBO = this.createOrder(busiReqBO);
        this.createPay(busiReqBO, rspBO);
        List<Long> fscOrderIds = rspBO.getFscOrderIds();
        FscCreateEngineeringFinanceBillOrderBusiReqBO reqBO = busiReqBO.getOrderReqBO();
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
        for (Long fscOrderId : fscOrderIds) {
            fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusStartAtomReqBO.setOrderFlow(FscOrderFlowEnum.ENGINEERING_INVOICE.getCode());
            FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
            if ("0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) continue;
            throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) {
            FscBillSendSaleFscOrderApplyAbilityReqBO abilityReqBO = new FscBillSendSaleFscOrderApplyAbilityReqBO();
            abilityReqBO.setUserId(reqBO.getUserId());
            abilityReqBO.setUserName(reqBO.getUserName());
            abilityReqBO.setFscOrderIds(fscOrderIds);
            abilityReqBO.setDeptId(reqBO.getDeptId());
            abilityReqBO.setDeptName(reqBO.getDeptName());
            abilityReqBO.setPersonId(reqBO.getPersonId());
            abilityReqBO.setPersonName(reqBO.getPersonName());
            abilityReqBO.setYcUserId(reqBO.getYcUserId());
            abilityReqBO.setName(reqBO.getName());
            abilityReqBO.setOrgId(reqBO.getOrgId());
            abilityReqBO.setOrgPath(reqBO.getOrgPath());
            this.dealApproval(abilityReqBO, rspBO);
        }
        FscSyncContractSettlementDetailAtomReqBO atomReqBO = new FscSyncContractSettlementDetailAtomReqBO();
        atomReqBO.setFscOrderId(rspBO.getFscOrderIds().get(0));
        atomReqBO.setOperatorType(FscOperatorTypeEnum.ADD.getCode());
        atomReqBO.setUserId(reqBO.getUserId());
        FscSyncContractSettlementDetailAtomRspBO atomRspBO = this.fscSyncContractSettlementDetailAtomService.syncContractSettlementDetail(atomReqBO);
        if (Objects.nonNull((Object)atomRspBO) && !"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("8888", atomRspBO.getRespDesc());
        }
        return rspBO;
    }

    private FscCreateEngineeringFinanceBillOrderAndPayBusiRspBO createOrder(FscCreateEngineeringFinanceBillOrderAndPayBusiReqBO busiReqBO) {
        FscCreateEngineeringFinanceBillOrderBusiReqBO reqBO = busiReqBO.getOrderReqBO();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        reqBO.setTotalCharge(reqBO.getTotalCharge());
        FscOrderPO orderPo = this.buildFscOrderInfo(reqBO);
        fscOrderIds.add(orderPo.getFscOrderId());
        FscOrderInvoicePO fscOrderInvoicePO = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
        fscOrderInvoicePO.setFscOrderId(orderPo.getFscOrderId());
        fscOrderInvoicePO.setBillOperId(String.valueOf(reqBO.getUserId()));
        fscOrderInvoicePO.setBillOperName(reqBO.getName());
        fscOrderInvoicePO.setBillTime(new Date());
        fscOrderInvoicePO.setBillTimeStart(new Date());
        FscOrderFinancePO fscOrderFinancePO = (FscOrderFinancePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderFinancePO.class);
        fscOrderFinancePO.setFscOrderId(orderPo.getFscOrderId());
        fscOrderFinancePO.setCreateUserId(reqBO.getUserName());
        fscOrderFinancePO.setCreateUserName(reqBO.getName());
        fscOrderFinancePO.setCreateTime(new Date());
        fscOrderFinancePO.setUpdateUserId(reqBO.getUserName());
        fscOrderFinancePO.setUpdateUserName(reqBO.getName());
        fscOrderFinancePO.setUpdateTime(new Date());
        fscOrderFinancePO.setPushFinanceStatus(FscConstants.FscPushStatus.NO_PUSH);
        fscOrderFinancePO.setFinanceUserId(StringUtils.isNotBlank((CharSequence)reqBO.getFinanceUserId()) ? reqBO.getFinanceUserId() : reqBO.getUserName());
        fscOrderFinancePO.setFinanceUserName(StringUtils.isNotBlank((CharSequence)reqBO.getFinanceUserId()) ? reqBO.getFinanceUserName() : reqBO.getName());
        fscOrderFinancePO.setPaySource(Integer.valueOf(1));
        fscOrderFinancePO.setPaymentPhase(busiReqBO.getPayReqBO().getPaymentPhase());
        fscOrderFinancePO.setIsAgent(busiReqBO.getPayReqBO().getIsAgent());
        fscOrderFinancePO.setPaymentType(busiReqBO.getPayReqBO().getPaymentType());
        fscOrderFinancePO.setPayDate(busiReqBO.getPayReqBO().getPayDate());
        fscOrderFinancePO.setCashUnitCode(busiReqBO.getPayReqBO().getCashUnitCode());
        fscOrderFinancePO.setCashUnitName(busiReqBO.getPayReqBO().getCashUnitName());
        fscOrderFinancePO.setAgentCompanyCode(busiReqBO.getPayReqBO().getAgentCompanyCode());
        fscOrderFinancePO.setAgentCompanyName(busiReqBO.getPayReqBO().getAgentCompanyName());
        fscOrderFinancePO.setExt1(reqBO.getSupplierErpNo());
        fscOrderFinancePO.setExt3(reqBO.getBuynerErpNo());
        fscOrderFinancePO.setExt4(String.valueOf(fscOrderFinancePO.getExchangeRate().stripTrailingZeros()));
        this.fscOrderFinanceMapper.insert(fscOrderFinancePO);
        this.fscOrderMapper.insert(orderPo);
        this.fscOrderInvoiceMapper.insert(fscOrderInvoicePO);
        ArrayList<FscOrderItemPO> fscOrderItemPOS = new ArrayList<FscOrderItemPO>();
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        for (FscOrderItemTempAddBO each : reqBO.getRows()) {
            FscOrderItemPO orderItemPO = new FscOrderItemPO();
            BeanUtils.copyProperties((Object)each, (Object)orderItemPO);
            orderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            orderItemPO.setFscOrderId(orderPo.getFscOrderId());
            orderItemPO.setOrderId(each.getOrderPayItemId());
            orderItemPO.setOrderItemId(each.getOrderPayItemId());
            orderItemPO.setAcceptOrderId(each.getOrderPayItemId());
            orderItemPO.setPrice(each.getPayAmount());
            orderItemPO.setTotalAmt(each.getPayAmount());
            orderItemPO.setAmt(each.getSettleAmt());
            orderItemPO.setTotalNum(new BigDecimal(1));
            if (each.getTaxRate() == null) {
                orderItemPO.setTaxRate(BigDecimal.ZERO);
            } else {
                orderItemPO.setTaxRate(each.getTaxRate());
            }
            orderItemPO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)orderItemPO.getAmt(), (BigDecimal)orderItemPO.getTaxRate()));
            orderItemPO.setUntaxAmt(orderItemPO.getAmt().subtract(orderItemPO.getTaxAmt()));
            orderItemPO.setCostCenterCode(reqBO.getIndependenceCostCode());
            orderItemPO.setCostCenterName(reqBO.getIndependenceCostName());
            orderItemPO.setContractId(reqBO.getContractId());
            orderItemPO.setContractNo(reqBO.getContractNo());
            fscOrderItemPOS.add(orderItemPO);
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderRelationPO.setFscOrderId(orderPo.getFscOrderId());
            fscOrderRelationPO.setOrderId(each.getOrderPayItemId());
            fscOrderRelationPO.setAcceptOrderId(each.getOrderPayItemId());
            fscOrderRelationPO.setContractId(reqBO.getContractId());
            fscOrderRelationPO.setContractNo(reqBO.getContractNo());
            fscOrderRelationPO.setContractName(reqBO.getContractName());
            fscOrderRelationPO.setContractType("2");
            fscOrderRelationPO.setSettleAmt(each.getSettleAmt());
            fscOrderRelationPO.setAmount(each.getSettleAmt());
            fscOrderRelationPO.setContractRemark(reqBO.getContractRemark());
            fscOrderRelationPO.setBusinessType(busiReqBO.getPayReqBO().getBusinessType());
            if (busiReqBO.getPayReqBO().getContractType() != null) {
                fscOrderRelationPO.setContractCategory(busiReqBO.getPayReqBO().getContractType().toString());
            }
            fscOrderRelationPOS.add(fscOrderRelationPO);
        }
        if (!CollectionUtils.isEmpty(fscOrderItemPOS)) {
            this.fscOrderItemMapper.insertBatch(fscOrderItemPOS);
        }
        if (!CollectionUtils.isEmpty(fscOrderRelationPOS)) {
            this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        }
        if (!CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
            ArrayList<FscAttachmentPO> fscAttachmentPOList = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
                FscAttachmentPO fscAttachmentPO = (FscAttachmentPO)JSONObject.parseObject((String)JSON.toJSONString((Object)attachmentBO), FscAttachmentPO.class);
                fscAttachmentPO.setFscOrderId(orderPo.getFscOrderId());
                fscAttachmentPO.setObjId(reqBO.getContractId());
                fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER);
                fscAttachmentPO.setObjType(FscConstants.AttachmentObjType.FSC_ORDER);
                fscAttachmentPOList.add(fscAttachmentPO);
            }
            if (!CollectionUtils.isEmpty(fscAttachmentPOList)) {
                this.fscAttachmentMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString(fscAttachmentPOList), FscAttachmentPO.class));
            }
        }
        FscCreateEngineeringFinanceBillOrderAndPayBusiRspBO rspBO = new FscCreateEngineeringFinanceBillOrderAndPayBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFscOrderIds(fscOrderIds);
        return rspBO;
    }

    private FscOrderPO buildFscOrderInfo(FscCreateEngineeringFinanceBillOrderBusiReqBO reqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderPO.setMakeType(FscConstants.FscOrderMakeType.SUPPLIER);
        fscOrderPO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        fscOrderPO.setOrderFlow(FscOrderFlowEnum.ENGINEERING_INVOICE.getCode());
        fscOrderPO.setOrderFlowKey(FscOrderFlowProcKeyEnum.getInstance((String)fscOrderPO.getOrderFlow().toString()).getDescr());
        fscOrderPO.setPayerId(reqBO.getBuynerId());
        fscOrderPO.setPayerName(reqBO.getBuynerName());
        fscOrderPO.setPurchaserId(reqBO.getPurchaserId());
        fscOrderPO.setPurchaserName(reqBO.getPurchaserName());
        fscOrderPO.setPayeeId(reqBO.getSupplierId());
        fscOrderPO.setPayeeName(reqBO.getSupplierName());
        fscOrderPO.setSupplierId(reqBO.getSupplierId());
        fscOrderPO.setSupplierName(reqBO.getSupplierName());
        fscOrderPO.setTotalCharge(reqBO.getTotalCharge());
        fscOrderPO.setCreateCompanyId(reqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(reqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(reqBO.getOrgId());
        fscOrderPO.setCreateOrgName(reqBO.getOrgName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateOperId(reqBO.getUserId());
        fscOrderPO.setCreateOperName(reqBO.getName());
        fscOrderPO.setCreateOperNo(reqBO.getUserName());
        List<String> serial = this.getSerial(FscBillInvoiceSerial.ENGINEERING_CONTRACT_NO.getCode(), 1);
        fscOrderPO.setOrderNo(serial.get(0));
        fscOrderPO.setUpdateTime(new Date());
        fscOrderPO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        fscOrderPO.setUpdateOperName(reqBO.getUserName());
        fscOrderPO.setOrderType(FscOrderTypeEnum.ENGINEERING_INVOICE.getCode());
        fscOrderPO.setTradeMode(FscConstants.FscBusiModel.MATCHING);
        fscOrderPO.setUserType(reqBO.getUserType());
        fscOrderPO.setBuynerNo(reqBO.getBuynerNo());
        fscOrderPO.setBuynerName(reqBO.getBuynerName());
        fscOrderPO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
        fscOrderPO.setBuyName(reqBO.getBuyName());
        fscOrderPO.setToPayAmount(reqBO.getTotalCharge());
        fscOrderPO.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
        fscOrderPO.setContractId(reqBO.getContractId());
        fscOrderPO.setContractNo(reqBO.getContractNo());
        fscOrderPO.setContractName(reqBO.getContractName());
        return fscOrderPO;
    }

    private List<String> getSerial(String key, Integer num) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(num);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u751f\u6210\u7ed3\u7b97\u5355\u7f16\u53f7\u5f02\u5e38");
        }
        return encodedSerialGetServiceRspBO.getSerialNoList();
    }

    private void dealDescAndModel(FscOrderItemPO fscOrderItemPO, FscCreateFinanceBillOrderBusiReqBO reqBO) {
        if ("2".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.AGREE_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSkuMaterialName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId(), reqBO.getOrderSource()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null, reqBO.getOrderSource()));
            }
        } else if ("1".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.PLAN_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getPlanItemName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode(), reqBO.getOrderSource()));
            } else if (FscInvoiceValueTypeEnum.ELECTRONIC.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSkuName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null, reqBO.getOrderSource()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId(), reqBO.getOrderSource()));
            }
        }
    }

    public String dealSpecificationsModel(String spec, String model, String materialBJ, String materialId, String orderSource) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)materialId) && materialId.startsWith("61")) {
            return "";
        }
        String specificationsModel = "";
        specificationsModel = !org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) ? spec + "|" + model : (!org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) ? spec : (!org.springframework.util.StringUtils.isEmpty((Object)model) ? model : materialBJ)))));
        if (!"2".equals(orderSource) && !org.springframework.util.StringUtils.isEmpty((Object)specificationsModel) && specificationsModel.length() > 40) {
            return specificationsModel.substring(0, 40);
        }
        return specificationsModel;
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private void dealApproval(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, FscCreateEngineeringFinanceBillOrderAndPayBusiRspBO rspBO) {
        for (Long l : reqBO.getFscOrderIds()) {
            FscOrderPO order = new FscOrderPO();
            order.setFscOrderId(l);
            order = this.fscOrderMapper.getModelBy(order);
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(l);
            List fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemList)) {
                throw new FscBusinessException("193008", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u67e5\u8be2\u7ed3\u7b97\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a\uff01");
            }
            int index = 1;
            for (FscOrderItemPO po : fscOrderItemList) {
                if (StringUtils.isNotBlank((CharSequence)po.getSpecificationsModel()) && po.getSpecificationsModel().length() > 120) {
                    throw new FscBusinessException("193004", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u7b2c" + index + "\u884c\u89c4\u683c\u578b\u53f7\u4e0d\u53ef\u8d85\u8fc7120\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u4e4b\u540e\u8fdb\u884c\u63d0\u4ea4\uff01");
                }
                ++index;
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(l);
            fscOrderPO.setOperatorId(reqBO.getUserId());
            fscOrderPO.setOperatorName(reqBO.getName());
            String operationNo = String.valueOf(reqBO.getOrgId());
            String[] org = this.proOrg.split(",");
            String[] pur = reqBO.getOrgPath().split("-");
            block2: for (String pro : org) {
                for (String t : pur) {
                    if (!pro.equals(t)) continue;
                    operationNo = pro;
                    continue block2;
                }
            }
            fscOrderPO.setOperationNo(operationNo);
            this.fscOrderMapper.updateById(fscOrderPO);
            if (reqBO.getWebSource() == null || !reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) continue;
            this.dealWorkFlow(order);
        }
    }

    private void checkOrderBillNum(Map<Long, FscOrderItemPO> itemMap, Integer receiveType) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setOrderItemIdSets(itemMap.keySet());
        fscOrderItemPO.setReceiveType(receiveType);
        List orderItemPOS = this.fscOrderItemMapper.getCheckList(fscOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)orderItemPOS)) {
            for (FscOrderItemPO orderItemPO : orderItemPOS) {
                FscOrderItemPO invoiceItem = itemMap.get(orderItemPO.getOrderItemId());
                orderItemPO.setNum(orderItemPO.getNum().subtract(orderItemPO.getAlreadyRefundNum()));
                orderItemPO.setAmt(orderItemPO.getAmt().subtract(orderItemPO.getAlreadyRefundAmt()));
                if (invoiceItem.getTotalNum().subtract(orderItemPO.getNum()).compareTo(invoiceItem.getNum()) < 0) {
                    throw new FscBusinessException("198888", "\u8ba2\u5355\u660e\u7ec6\u884c[" + invoiceItem.getOrderItemId() + "]\u672c\u6b21\u63d0\u7968\u6570\u91cf\u8d85\u8fc7\u53ef\u63d0\u7968\u6570\u91cf\uff01");
                }
                if (invoiceItem.getTotalAmt().subtract(orderItemPO.getAmt()).compareTo(invoiceItem.getAmt()) >= 0) continue;
                throw new FscBusinessException("198888", "\u8ba2\u5355\u660e\u7ec6\u884c[" + invoiceItem.getOrderItemId() + "]\u672c\u6b21\u63d0\u7968\u6570\u91cf\u8d85\u8fc7\u53ef\u63d0\u7968\u6570\u91cf\uff01");
            }
        }
    }

    private void checkTemp(FscCreateFinanceBillOrderBusiReqBO reqBO, FscOrderItemPO fscOrderItemPO, RelOrderBO relOrderBO, FscOrderInfoBO fscOrderInfoBO, List<FscCheckTempPO> list) {
        if ("1".equals(reqBO.getIsprofess()) && !FscConstants.FscOrderOperType.save.equals(reqBO.getOperType())) {
            FscCheckTempPO po;
            if (StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getProductDescription()) && FscCommonUtils.getLength((String)fscOrderItemPO.getProductDescription()) > 90) {
                po = new FscCheckTempPO();
                if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                    po.setObjNo(reqBO.getFscOrderNo());
                }
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(relOrderBO.getOrderId() + "");
                po.setOrderNo(fscOrderInfoBO.getOrderNo());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("0");
                po.setReason("\u5f00\u7968\u540d\u79f0\u5b57\u6bb5\u9650\u523690\u5b57\u7b26");
                list.add(po);
            }
            if (StringUtils.isBlank((CharSequence)fscOrderItemPO.getSpecificationsModel())) {
                po = new FscCheckTempPO();
                if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                    po.setObjNo(reqBO.getFscOrderNo());
                }
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(relOrderBO.getOrderId() + "");
                po.setOrderNo(fscOrderInfoBO.getOrderNo());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("1");
                po.setReason("\u89c4\u683c\u578b\u53f7\u4e3a\u7a7a");
                list.add(po);
            }
            if (StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSpecificationsModel()) && FscCommonUtils.getLength((String)fscOrderItemPO.getSpecificationsModel()) > 40) {
                po = new FscCheckTempPO();
                if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                    po.setObjNo(reqBO.getFscOrderNo());
                }
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(relOrderBO.getOrderId() + "");
                po.setOrderNo(fscOrderInfoBO.getOrderNo());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("0");
                po.setReason("\u89c4\u683c\u578b\u53f7\u5b57\u6bb5\u957f\u5ea6\u9650\u523640\u5b57\u7b26");
                list.add(po);
            }
            this.fscCheckTempMapper.deleteByObjId(fscOrderItemPO.getFscOrderId());
        }
    }

    private void checkOliTaxCode(List<FscOrderItemPO> pos) {
        List<FscOrderItemPO> bos = pos.stream().filter(x -> !org.springframework.util.StringUtils.isEmpty((Object)x.getTaxCode()) && this.oilTaxCode.contains(x.getTaxCode()) && Objects.nonNull(x.getNum()) && x.getNum().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(bos)) {
            log.info("\u6210\u6cb9\u54c1\u660e\u7ec6\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString(bos));
            BigDecimal submitCount = this.calOliCount(bos);
            BigDecimal downCount = this.calOliCount(this.fscOrderItemMapper.queryDownOilTaxCode(Arrays.stream(this.oilTaxCode.split(",")).collect(Collectors.toList())));
            BigDecimal upCount = this.calOliCount(this.fscOrderItemMapper.queryUpOilTaxCode(Arrays.stream(this.oilTaxCode.split(",")).collect(Collectors.toList())));
            BigDecimal maxCount = upCount.subtract(downCount);
            if (submitCount.compareTo(maxCount) > 0) {
                throw new FscBusinessException("198888", "\u6210\u54c1\u6cb9\u5df2\u6536\u53d1\u7968" + upCount + "\u5347,\u5df2\u5f00\u53d1\u7968" + downCount + "\u5347,\u6700\u5927\u53ef\u5f00\u53d1\u7968" + maxCount + "\u5347\uff0c\u5f53\u524d\u5355\u636e" + submitCount + "\u5347\uff0c\u65e0\u6cd5\u6ee1\u8db3\u5f00\u7968\u8981\u6c42\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u5458\u5b8c\u6210\u6536\u7968\u5904\u7406\u540e\u518d\u7ee7\u7eed\u5f00\u7968\u3002");
            }
        }
    }

    private BigDecimal calOliCount(List<FscOrderItemPO> pos) {
        BigDecimal sgNum = pos.stream().filter(x -> "\u5347".equals(x.getUnit())).map(FscOrderItemPO::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal dunNum = pos.stream().filter(x -> "\u5428".equals(x.getUnit())).map(y -> y.getNum().multiply(BigDecimal.valueOf(1126L))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal tgNum = pos.stream().filter(x -> "\u6876".equals(x.getUnit())).map(y -> (Objects.nonNull(y.getSettleNum()) ? y.getSettleNum() : y.getNum()).multiply(BigDecimal.valueOf(1126L))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal gjNum = pos.stream().filter(x -> "\u516c\u65a4".equals(x.getUnit())).map(y -> y.getNum().multiply(BigDecimal.valueOf(1.126))).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sgNum.add(dunNum).add(tgNum).add(gjNum);
    }

    private FscShouldPayPO createShouldPay(FscOrderPO fscOrderPO, List<String> orderCodes, FscOrderInfoBO shouldPayOrderInfo, List<String> acceptOrderCodes, FscCreateFinanceBillOrderBusiReqBO reqBO) {
        ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
        fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
        fscShouldPayBO.setShouldPayAmount(reqBO.getTotalAmount());
        fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
        fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
        fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
        fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
        fscShouldPayBO.setPenaltyRatio(shouldPayOrderInfo.getPayBreakScale());
        fscShouldPayBO.setContractId(shouldPayOrderInfo.getFinanceContractId());
        fscShouldPayBO.setContractNo(shouldPayOrderInfo.getFinanceContractNo());
        fscShouldPayBO.setAgreementId(shouldPayOrderInfo.getProtocolId());
        fscShouldPayBO.setAgreementNo(shouldPayOrderInfo.getPlaAgreementCode());
        fscShouldPayBO.setOrderId(shouldPayOrderInfo.getOrderId());
        fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
        fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
        fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
        fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
        fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
        fscShouldPayBO.setOrderOperStr(String.valueOf(fscOrderPO.getOperatorId()));
        fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodes));
        fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
        fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
        fscShouldPayBO.setOperatorDeptId(Convert.toStr((Object)fscOrderPO.getOperatorDeptId()));
        fscShouldPayBO.setOperatorDeptName(fscOrderPO.getOperatorDeptName());
        fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
        fscShouldPayBO.setShouldPayMethod(Integer.valueOf(2));
        fscShouldPayBO.setAcceptOrderCode(String.join((CharSequence)",", acceptOrderCodes));
        fscShouldPayBO.setNodePayRatio(reqBO.getShouldPayRatio());
        fscShouldPayBOS.add(fscShouldPayBO);
        FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
        fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
        fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
        fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
        fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
        fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
        fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
        fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
        FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
        if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
        }
        return (FscShouldPayPO)fscPayShouldPayCreateAtomRspBO.getFscShouldPayPOS().get(0);
    }

    private FscCreateEngineeringFinanceBillOrderAndPayBusiRspBO createPay(FscCreateEngineeringFinanceBillOrderAndPayBusiReqBO busiReqBO, FscCreateEngineeringFinanceBillOrderAndPayBusiRspBO createRspBO) {
        FscFinanceEngineeringPayBillCreateReqBO reqBO = busiReqBO.getPayReqBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        String operationNo = String.valueOf(busiReqBO.getOrgId());
        if ("0".equals(busiReqBO.getIsprofess())) {
            String[] org;
            for (String pro : org = this.proOrg.split(",")) {
                if (!busiReqBO.getOrgPath().contains(pro)) continue;
                operationNo = pro;
            }
        }
        this.updateShouldPay(reqBO, fscOrderId, createRspBO.getFscOrderIds().get(0));
        this.insertOrder(reqBO, fscOrderId, operationNo, busiReqBO);
        this.insertAttachment(reqBO.getAttachmentList(), fscOrderId);
        reqBO.setBizTypeCode(busiReqBO.getOrderReqBO().getBizTypeCode());
        reqBO.setBizTypeName(busiReqBO.getOrderReqBO().getBizTypeName());
        this.insertFinanceInfo(reqBO, fscOrderId);
        this.insertCapitalInfo(reqBO, fscOrderId);
        createRspBO.setFscOrderId(fscOrderId);
        createRspBO.setRespCode("0000");
        createRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return createRspBO;
    }

    private void insertCapitalInfo(FscFinanceEngineeringPayBillCreateReqBO reqBO, Long fscOrderId) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(fscOrderId);
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscFinanceCapitalInfoAtomReqBO atomReqBO = (FscFinanceCapitalInfoAtomReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscFinanceCapitalInfoAtomReqBO.class);
        atomReqBO.setObjId(fscOrderId);
        atomReqBO.setObjNo(orderPO.getOrderNo());
        atomReqBO.setObjType(Integer.valueOf(1));
        atomReqBO.setFscOrderPayItemBOS(reqBO.getFscOrderPayItemBOS());
        atomReqBO.setOperationType(Integer.valueOf(0));
        FscFinanceCapitalInfoAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealFinanceCapitalInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u5b58\u50a8\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
    }

    private void insertOrder(FscFinanceEngineeringPayBillCreateReqBO createReqBO, Long fscOrderId, String operationNo, FscCreateEngineeringFinanceBillOrderAndPayBusiReqBO busiReqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.ENGINEERING_SERVICE_PAY);
        if (!org.springframework.util.StringUtils.isEmpty((Object)createReqBO.getOrderNo())) {
            fscOrderPO.setOrderNo(createReqBO.getOrderNo());
        } else {
            CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
            encodedSerialGetServiceReqBO.setCenter("FSC");
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
            encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
            encodedSerialGetServiceReqBO.setOrgType("-1");
            CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
            fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
            createReqBO.setOrderNo(fscOrderPO.getOrderNo());
        }
        fscOrderPO.setOrderName(createReqBO.getOrderName());
        fscOrderPO.setPayerId(createReqBO.getPayerId());
        fscOrderPO.setPayerName(createReqBO.getPayerName());
        fscOrderPO.setPayeeId(createReqBO.getPayeeId());
        fscOrderPO.setPayeeName(createReqBO.getPayeeName());
        fscOrderPO.setPayeeAccountName(createReqBO.getPayeeAccountName());
        fscOrderPO.setPayeeBankAccount(createReqBO.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName(createReqBO.getPayeeBankName());
        if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPO.getPayeeAccountName()) || org.springframework.util.StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankAccount()) || org.springframework.util.StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankName())) {
            FscMerchantPayeePO fscMerchantPayeePO = new FscMerchantPayeePO();
            fscMerchantPayeePO.setSupplierId(createReqBO.getPayeeId());
            List fscMerchantPayeePOList = this.fscMerchantPayeeMapper.getList(fscMerchantPayeePO);
            if (!CollectionUtils.isEmpty((Collection)fscMerchantPayeePOList)) {
                fscMerchantPayeePO = (FscMerchantPayeePO)fscMerchantPayeePOList.get(0);
                fscOrderPO.setPayeeAccountName(fscMerchantPayeePO.getPayeeAccountName());
                fscOrderPO.setPayeeBankAccount(fscMerchantPayeePO.getPayeeBankAccount());
                fscOrderPO.setPayeeBankName(fscMerchantPayeePO.getPayeeBankName());
            } else {
                throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u672a\u914d\u7f6e\u6536\u6b3e\u8d26\u6237");
            }
        }
        fscOrderPO.setPayMethod(createReqBO.getPayMethod());
        fscOrderPO.setPayType(createReqBO.getPayType());
        fscOrderPO.setShouldPayType(createReqBO.getShouldPayType());
        fscOrderPO.setPayChannel(createReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateOperNo(busiReqBO.getUserName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(createReqBO.getTotalAmount());
        fscOrderPO.setContractNo(createReqBO.getContractNo());
        fscOrderPO.setContractId(createReqBO.getContractId());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        fscOrderPO.setPaidAmount(BigDecimal.ZERO);
        fscOrderPO.setPayingAmount(fscOrderPO.getTotalCharge());
        fscOrderPO.setToPayAmount(fscOrderPO.getTotalCharge());
        fscOrderPO.setBuynerNo(createReqBO.getBuynerNo());
        fscOrderPO.setBuynerName(createReqBO.getBuynerName());
        fscOrderPO.setOrderType(createReqBO.getOrderType());
        fscOrderPO.setOrderSource(createReqBO.getOrderSource());
        fscOrderPO.setTradeMode(FscConstants.FscTradeMode.MATCHMAKING_MODE);
        fscOrderPO.setRemark(createReqBO.getRemark());
        fscOrderPO.setPaymentMethod(createReqBO.getPaymentMethod());
        fscOrderPO.setSettleType(createReqBO.getSettleType());
        if ("0".equals(createReqBO.getIsprofess())) {
            fscOrderPO.setOperatorId(createReqBO.getUserId());
            fscOrderPO.setOperatorName(createReqBO.getName());
            fscOrderPO.setOperationNo(operationNo);
            fscOrderPO.setOperationName(createReqBO.getCompanyName());
        }
        if ("3".equals(createReqBO.getPayChannel())) {
            if (null != createReqBO.getUserId()) {
                fscOrderPO.setPayOperId(createReqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(createReqBO.getName());
        }
        fscOrderPO.setSettlePlatform(Integer.valueOf(3));
        if ("1".equals(createReqBO.getSaveOrSubmit())) {
            fscOrderPO.setOrderState(FscConstants.FscPayOrderState.CANCEL);
        }
        String procKey = FscOrderFlowProcKeyEnum.ENGINEERING_PAY.getDescr();
        fscOrderPO.setOrderFlowKey(procKey);
        this.fscOrderMapper.insert(fscOrderPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(fscOrderId);
        List invoicePOList = this.fscInvoiceMapper.getInvoiceByShouldPay(fscInvoicePO);
        if (CollectionUtils.isEmpty((Collection)invoicePOList)) {
            invoicePOList = this.fscInvoiceMapper.getInvoiceByAdvance(fscInvoicePO);
        }
        StringBuilder invoiceNo = new StringBuilder();
        StringBuilder invoiceCode = new StringBuilder();
        log.debug("invoicePoList:{}", (Object)JSONObject.toJSONString((Object)invoicePOList));
        if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
            boolean flag = false;
            for (FscInvoicePO po : invoicePOList) {
                if (po == null) continue;
                flag = true;
                invoiceNo.append(po.getInvoiceNo()).append(",");
                invoiceCode.append(po.getInvoiceCode()).append(",");
            }
            if (flag) {
                fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderId);
                fscOrderPO.setInvoiceNo(invoiceNo.toString());
                fscOrderPO.setInvoiceCode(invoiceCode.toString());
                this.fscOrderMapper.updateById(fscOrderPO);
            }
        }
    }

    private void updateShouldPay(FscFinanceEngineeringPayBillCreateReqBO busiReqBO, Long fscOrderId, Long invoiceFscOrderId) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(invoiceFscOrderId);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        ArrayList<FscShouldPayBO> fscShouldPayBOList = new ArrayList<FscShouldPayBO>();
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        ArrayList fscContractSettlementDetailPOS = new ArrayList();
        HashMap<String, Long> shouldItemPayRelationMap = new HashMap<String, Long>();
        BigDecimal totalAmount = new BigDecimal(0);
        for (FscOrderPayItemBO fscOrderPayItemBO : busiReqBO.getFscOrderPayItemBOS()) {
            if (busiReqBO.getPayType() == 1) {
                busiReqBO.setShouldPayType(FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY);
            }
            FscShouldPayBO fscShouldPayBO = this.assemableShouldPayPO(fscOrderPayItemBO, busiReqBO, fscOrderPO);
            fscShouldPayBOList.add(fscShouldPayBO);
        }
        if (!CollectionUtils.isEmpty(fscShouldPayBOList)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOList);
            fscPayShouldPayCreateAtomReqBO.setUserId(busiReqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(busiReqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(busiReqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(busiReqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(busiReqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(busiReqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(busiReqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.saveShouldPayInfo(fscPayShouldPayCreateAtomReqBO);
            if (!CollectionUtils.isEmpty((Collection)fscPayShouldPayCreateAtomRspBO.getFscShouldPayRspBOs())) {
                shouldItemPayRelationMap.putAll(fscPayShouldPayCreateAtomRspBO.getFscShouldPayRspBOs().stream().collect(Collectors.toMap(item -> item.getObjectId() + "-" + item.getOrderId(), FscShouldPayRspBO::getShouldPayId)));
            }
        }
        List shouldPayIds = shouldItemPayRelationMap.values().stream().distinct().collect(Collectors.toList());
        FscShouldPayPO qryShouldPO = new FscShouldPayPO();
        qryShouldPO.setShouldPayIds(shouldPayIds);
        List fscShouldPayPOList = this.fscShouldPayMapper.getList(qryShouldPO);
        Map shouldPayMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, Function.identity()));
        for (FscOrderPayItemBO fscOrderPayItemBO : busiReqBO.getFscOrderPayItemBOS()) {
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setItemNo(fscOrderPayItemBO.getItemNo());
            po.setIsReduce(fscOrderPayItemBO.getIsReduce());
            if (po.getIsReduce() == null) {
                po.setIsReduce(FscConstants.NO);
            }
            po.setPaymentPhase(fscOrderPayItemBO.getPaymentPhase());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId((Long)shouldItemPayRelationMap.get(invoiceFscOrderId + "-" + fscOrderPayItemBO.getObjectId()));
            po.setPayAmount(fscOrderPayItemBO.getPayAmount());
            po.setPayAmountLocal(fscOrderPayItemBO.getPayAmountLocal());
            po.setExt3(fscOrderPayItemBO.getExt3());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            if (po.getReduceAmt() == null) {
                po.setReduceAmt(BigDecimal.ZERO);
            }
            po.setExpType(fscOrderPayItemBO.getExpLineType());
            po.setExpTypeId(fscOrderPayItemBO.getExpTypeCode());
            if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPayItemBO.getShouldPayItemNo())) {
                po.setShouldPayItemNo(((FscShouldPayPO)shouldPayMap.get(po.getShouldPayId())).getShouldPayNo() + "-01");
            } else {
                po.setShouldPayItemNo(fscOrderPayItemBO.getShouldPayItemNo());
            }
            po.setShouldPayMethod(busiReqBO.getShouldPayMethod());
            po.setFscBillOrderId(fscOrderPO.getFscOrderId().toString());
            po.setFscBillOrderNo(fscOrderPO.getOrderNo());
            po.setRemark(fscOrderPayItemBO.getRemark());
            po.setPaymentPhase(fscOrderPayItemBO.getPaymentPhase());
            fscOrderPayItemBO.setOrderPayItemId(po.getOrderPayItemId());
            fscOrderPayItemBO.setShouldPayItemNo(po.getShouldPayItemNo());
            fscOrderPayItemBO.setShouldPayId(po.getShouldPayId());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO.getPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
    }

    private void insertFinanceInfo(FscFinanceEngineeringPayBillCreateReqBO reqBO, Long fscOrderId) {
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)financePO);
        financePO.setFscOrderId(fscOrderId);
        financePO.setCreateTime(new Date());
        financePO.setCreateUserId(reqBO.getUserName());
        financePO.setCreateUserName(reqBO.getName());
        financePO.setFinanceUserId(reqBO.getUserName());
        financePO.setFinanceUserName(reqBO.getName());
        financePO.setExt1(reqBO.getSupplierErpNo());
        financePO.setPaySource(Integer.valueOf(1));
        financePO.setExt4(String.valueOf(financePO.getExchangeRate().stripTrailingZeros()));
        int count = this.fscOrderFinanceMapper.insert(financePO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        int count;
        if (CollectionUtils.isEmpty(attachmentBOList)) {
            return;
        }
        FscAttachmentPO deletePo = new FscAttachmentPO();
        deletePo.setFscOrderId(fscOrderId);
        deletePo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
        ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletePo);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS) && (count = this.fscAttachmentMapper.deleteBy(deletePo)) != fscAttachmentPOS.size()) {
            throw new FscBusinessException("198888", "\u5220\u9664\u4ed8\u6b3e\u5355\u9644\u4ef6\u5931\u8d25\uff01");
        }
        fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
        for (AttachmentBO attachmentBO : attachmentBOList) {
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPo);
            fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAYMENT);
            fscAttachmentPo.setObjId(fscOrderId);
            fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
            fscAttachmentPo.setFscOrderId(fscOrderId);
            fscAttachmentPOS.add(fscAttachmentPo);
        }
        count = this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        if (count != fscAttachmentPOS.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u5355\u9644\u4ef6\u5931\u8d25\uff01");
        }
    }

    private FscShouldPayBO assemableShouldPayPO(FscOrderPayItemBO fscOrderPayItemBO, FscFinanceEngineeringPayBillCreateReqBO reqBO, FscOrderPO fscOrderPO) {
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setShouldPayType(reqBO.getShouldPayType());
        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.CONTRACT);
        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
        fscShouldPayBO.setOrderId(fscOrderPayItemBO.getObjectId());
        fscShouldPayBO.setPayType(reqBO.getPayType());
        fscShouldPayBO.setShouldPayAmount(fscOrderPayItemBO.getShouldPayAmount());
        fscShouldPayBO.setPayingAmount(fscOrderPayItemBO.getPayAmount());
        fscShouldPayBO.setToPayAmount(fscShouldPayBO.getShouldPayAmount().subtract(Optional.ofNullable(fscShouldPayBO.getPayingAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(fscShouldPayBO.getPaidAmount()).orElse(BigDecimal.ZERO)));
        fscShouldPayBO.setPayeeId(reqBO.getPayeeId());
        fscShouldPayBO.setPayeeName(reqBO.getPayeeName());
        fscShouldPayBO.setPayerId(reqBO.getPayerId());
        fscShouldPayBO.setPayerName(reqBO.getPayerName());
        fscShouldPayBO.setContractId(reqBO.getContractId());
        fscShouldPayBO.setContractNo(reqBO.getContractNo());
        fscShouldPayBO.setContractName(reqBO.getContractName());
        fscShouldPayBO.setBuyerNo(reqBO.getBuynerNo());
        fscShouldPayBO.setBuyerName(reqBO.getBuynerName());
        fscShouldPayBO.setShouldPayMethod(reqBO.getShouldPayMethod());
        fscShouldPayBO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
        fscShouldPayBO.setContractType(reqBO.getContractType());
        fscShouldPayBO.setBusinessType(reqBO.getBusinessType());
        return fscShouldPayBO;
    }

    private FscPayShouldPayCreateAtomRspBO saveShouldPayInfo(FscPayShouldPayCreateAtomReqBO atomReqBO) {
        ArrayList<FscShouldPayRspBO> fscShouldPayRspBOs = new ArrayList<FscShouldPayRspBO>();
        List fscShouldPayPOS = JSON.parseArray((String)JSON.toJSONString((Object)atomReqBO.getFscShouldPayBOS()), FscShouldPayPO.class);
        List serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()) == null) {
            throw new FscBusinessException("194311", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()).getDescr());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(fscShouldPayPOS.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        for (int i = 0; i < fscShouldPayPOS.size(); ++i) {
            Long shouldPayId = Sequence.getInstance().nextId();
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayPOS.get(i);
            fscShouldPayPO.setShouldPayId(shouldPayId);
            fscShouldPayPO.setCreateId(atomReqBO.getUserId());
            fscShouldPayPO.setCreateName(atomReqBO.getName());
            fscShouldPayPO.setCreateAccount(atomReqBO.getUserName());
            fscShouldPayPO.setCreateTime(new Date());
            fscShouldPayPO.setCreateCompanyId(atomReqBO.getCompanyId());
            fscShouldPayPO.setCreateCompanyName(atomReqBO.getCompanyName());
            fscShouldPayPO.setCreateOrgId(atomReqBO.getOrgId());
            fscShouldPayPO.setCreateOrgName(atomReqBO.getOrgName());
            fscShouldPayPO.setPenalty(new BigDecimal(0));
            fscShouldPayPO.setOriginalAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
            fscShouldPayPO.setToPayAmount(fscShouldPayPO.getToPayAmount());
            fscShouldPayPO.setPaidAmount(new BigDecimal(0));
            fscShouldPayPO.setPayingAmount(fscShouldPayPO.getPayingAmount());
            fscShouldPayPO.setShouldPayNo((String)serialNoList.get(i));
            fscShouldPayPO.setPayMethod(fscShouldPayPO.getShouldPayMethod());
            FscShouldPayRspBO bo = new FscShouldPayRspBO();
            bo.setShouldPayId(shouldPayId);
            bo.setObjectId(fscShouldPayPO.getObjectId());
            bo.setOrderId(fscShouldPayPO.getOrderId());
            fscShouldPayRspBOs.add(bo);
        }
        this.fscShouldPayMapper.insertBatch(fscShouldPayPOS);
        FscPayShouldPayCreateAtomRspBO atomRspBO = new FscPayShouldPayCreateAtomRspBO();
        atomRspBO.setFscShouldPayRspBOs(fscShouldPayRspBOs);
        return atomRspBO;
    }
}

