/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl.finance;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderToYCAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityReqBO;
import com.tydic.fsc.bill.busi.api.finance.FscCreateFinanceBillOrderAndPayBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscCreateFinanceBillOrderAndPayBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscCreateFinanceBillOrderAndPayBusiRspBO;
import com.tydic.fsc.bill.busi.bo.finance.FscCreateFinanceBillOrderBusiReqBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemReqBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.enums.FscInvoiceValueTypeEnum;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscCheckTempMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayItemSerialMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscFinancePayBillCreateReqBO;
import com.tydic.fsc.pay.atom.api.FscPayBillDetailAssemblyAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillDetailAssemblyAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillDetailAssemblyAtomRspBO;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscCheckTempPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPayItemSerialPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscCreateFinanceBillOrderAndPayBusiServiceImpl
implements FscCreateFinanceBillOrderAndPayBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCreateFinanceBillOrderAndPayBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Value(value="${fsc.main.electricity.pro.org:100100}")
    private String electricityOrg;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    private static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscBillSendSaleFscOrderToYCAbilityService fscBillSendSaleFscOrderToYCAbilityService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscCheckTempMapper fscCheckTempMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    @Autowired
    private FscPayBillDetailAssemblyAtomService fscPayBillDetailAssemblyAtomService;
    @Value(value="${fsc.oil.taxCode:1070101070100000000,1070101070200000000}")
    private String oilTaxCode;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long operationSupId;
    @Autowired
    private PebExtOrderSettleTypeUpdateAbilityService pebExtOrderSettleTypeUpdateAbilityService;
    @Autowired
    private FscFinanceCapitalInfoAtomService fscFinanceCapitalInfoAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscPayItemSerialMapper fscPayItemSerialMapper;
    @Autowired
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;

    @Override
    public FscCreateFinanceBillOrderAndPayBusiRspBO dealCreate(FscCreateFinanceBillOrderAndPayBusiReqBO busiReqBO) {
        FscCreateFinanceBillOrderAndPayBusiRspBO rspBO = this.createOrder(busiReqBO);
        this.createPay(busiReqBO, rspBO);
        List<Long> fscOrderIds = rspBO.getFscOrderIds();
        FscCreateFinanceBillOrderBusiReqBO reqBO = busiReqBO.getOrderReqBO();
        if (FscConstants.FscOrderOperType.save.equals(reqBO.getOperType())) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(fscOrderIds);
            fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.DRAFT);
            this.fscOrderMapper.dealSave(fscOrderPO);
        } else {
            FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
            for (Long fscOrderId : fscOrderIds) {
                fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
                FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
                if ("0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) continue;
                throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
            }
            if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) {
                FscBillSendSaleFscOrderApplyAbilityReqBO abilityReqBO = new FscBillSendSaleFscOrderApplyAbilityReqBO();
                abilityReqBO.setUserId(reqBO.getUserId());
                abilityReqBO.setUserName(reqBO.getUserName());
                abilityReqBO.setFscOrderIds(fscOrderIds);
                abilityReqBO.setDeptId(reqBO.getDeptId());
                abilityReqBO.setDeptName(reqBO.getDeptName());
                abilityReqBO.setPersonId(reqBO.getPersonId());
                abilityReqBO.setPersonName(reqBO.getPersonName());
                abilityReqBO.setYcUserId(reqBO.getYcUserId());
                abilityReqBO.setName(reqBO.getName());
                abilityReqBO.setOrgId(reqBO.getOrgId());
                abilityReqBO.setOrgPath(reqBO.getOrgPath());
                this.dealApproval(abilityReqBO, rspBO);
            }
        }
        return rspBO;
    }

    private FscCreateFinanceBillOrderAndPayBusiRspBO createOrder(FscCreateFinanceBillOrderAndPayBusiReqBO busiReqBO) {
        FscCreateFinanceBillOrderBusiReqBO reqBO = busiReqBO.getOrderReqBO();
        ArrayList<FscOrderPO> fscOrderPOS = new ArrayList<FscOrderPO>();
        ArrayList<FscOrderExtPO> fscOrderExtPOS = new ArrayList<FscOrderExtPO>();
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        List<Object> fscOrderItemPOS = new ArrayList<FscOrderItemPO>();
        ArrayList<FscOrderInvoicePO> fscOrderInvoicePOS = new ArrayList<FscOrderInvoicePO>();
        ArrayList<FscInvoiceRulePO> fscInvoiceRulePOS = new ArrayList<FscInvoiceRulePO>();
        ArrayList<FscPayLogPO> fscPayLogUpdateList = new ArrayList<FscPayLogPO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        ArrayList<FscAttachmentPO> fscAttachmentPOList = new ArrayList<FscAttachmentPO>();
        ArrayList<String> acceptOrderCodes = new ArrayList<String>();
        ArrayList<String> orderCodes = new ArrayList<String>();
        Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
        }
        int num = 0;
        FscOrderInfoBO shouldPayOrderInfo = null;
        AtomicReference<String> supplierErpNo = new AtomicReference<String>();
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            FscOrderPO fscOrderPo = (FscOrderPO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
            fscOrderPo.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderPo.setCreateTime(new Date());
            fscOrderPo.setCreateOperId(reqBO.getUserId());
            fscOrderPo.setCreateOperName(reqBO.getName());
            fscOrderPo.setCreateOperNo(reqBO.getUserName());
            fscOrderPo.setCreateOrgId(reqBO.getOrgId());
            fscOrderPo.setCreateOrgName(reqBO.getOrgName());
            fscOrderPo.setCreateCompanyId(reqBO.getCompanyId());
            fscOrderPo.setCreateCompanyName(reqBO.getCompanyName());
            fscOrderPo.setTotalCharge(splitOrderBO.getAmount().setScale(2, 4));
            fscOrderPo.setToPayAmount(splitOrderBO.getAmount().setScale(2, 4));
            fscOrderPo.setOrderNo(reqBO.getOrderNos().get(num));
            fscOrderPo.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
            fscOrderPo.setShouldPayType(reqBO.getPayNodeRule());
            fscOrderPo.setAutoBill(reqBO.getAutoBill());
            fscOrderPo.setBuyName(reqBO.getBuyName());
            fscOrderPo.setOperationArea(reqBO.getOperationArea());
            fscOrderPo.setSettleType(reqBO.getSettleType());
            fscOrderPo.setIsQuality(reqBO.getIsQuality());
            if (reqBO.getIsQuality() != null && reqBO.getIsQuality() == 1) {
                fscOrderPo.setQualityAmt(fscOrderPo.getTotalCharge());
            }
            if (!CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
                for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
                    FscAttachmentPO fscAttachmentPO = (FscAttachmentPO)JSONObject.parseObject((String)JSON.toJSONString((Object)attachmentBO), FscAttachmentPO.class);
                    fscAttachmentPO.setFscOrderId(fscOrderPo.getFscOrderId());
                    fscAttachmentPO.setObjId(fscOrderPo.getFscOrderId());
                    fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER);
                    fscAttachmentPO.setObjType(FscConstants.AttachmentObjType.FSC_ORDER);
                    fscAttachmentPOList.add(fscAttachmentPO);
                }
            }
            if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) || FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscOrderPo.setTradeMode(FscConstants.FscBusiModel.TRADE);
            } else {
                fscOrderPo.setTradeMode(FscConstants.FscBusiModel.MATCHING);
            }
            if (null != reqBO.getBuildAction()) {
                fscOrderPo.setBuildAction(reqBO.getBuildAction());
            }
            ++num;
            StringBuilder orderNos = new StringBuilder();
            BigDecimal[] totalCharge = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal qualityAmt = BigDecimal.ZERO;
            HashMap<Long, FscOrderItemPO> invoiceItemMap = new HashMap<Long, FscOrderItemPO>(fscOrderItemPOS.size());
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                List itemReqBOList = relOrderBO.getFscOrderItemBOList();
                Map<Object, Object> itemReqBOMap = CollectionUtils.isEmpty((Collection)itemReqBOList) ? new HashMap() : itemReqBOList.stream().collect(Collectors.toMap(FscOrderItemReqBO::getInspectionItemId, e -> e, (k1, k2) -> k1));
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
                if (null == fscOrderInfoBO) {
                    throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getSupplierErpNo())) {
                    supplierErpNo.set(fscOrderInfoBO.getSupplierErpNo());
                }
                if (shouldPayOrderInfo == null) {
                    shouldPayOrderInfo = fscOrderInfoBO;
                }
                Integer settlePlatform = fscOrderInfoBO.getSettlePlatform();
                if (Objects.nonNull(fscOrderInfoBO.getTradeMode()) && fscOrderInfoBO.getTradeMode() == 2) {
                    if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getBuynerId()) && !org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getBuynerName())) {
                        fscOrderPo.setPayerId(Long.valueOf(fscOrderInfoBO.getBuynerId()));
                        fscOrderPo.setPayerName(fscOrderInfoBO.getBuynerName());
                    }
                    if (reqBO.getOrderType() == 4 || reqBO.getOrderType() == 5) {
                        fscOrderPo.setTradeMode(fscOrderInfoBO.getTradeMode());
                    }
                }
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationPO.class);
                fscOrderRelationPO.setContractNo(fscOrderInfoBO.getFinanceContractNo());
                fscOrderRelationPO.setContractId(fscOrderInfoBO.getFinanceContractId());
                fscOrderRelationPO.setProContractId(fscOrderInfoBO.getProModelContractId());
                fscOrderRelationPO.setProContractName(fscOrderInfoBO.getProModelContractName());
                fscOrderRelationPO.setProContractNo(fscOrderInfoBO.getProModelContractNo());
                fscOrderRelationPO.setProContractType(fscOrderInfoBO.getProModelContractType());
                fscOrderRelationPO.setProContractSource(fscOrderInfoBO.getProModelContractSource());
                fscOrderRelationPO.setExpType(relOrderBO.getExpLineType());
                fscOrderRelationPO.setExpTypeId(relOrderBO.getExpTypeCode());
                fscOrderRelationPO.setQualityAmt(relOrderBO.getQualityAmt());
                fscOrderRelationPO.setQualityDate(relOrderBO.getQualityDate());
                qualityAmt = qualityAmt.add(relOrderBO.getQualityAmt());
                if (FscConstants.SettlePlatform.YES.equals(settlePlatform) && reqBO.getReceiveType() == 1) {
                    if (fscOrderInfoBO.getContractId() == null) {
                        log.info("\u5bf9\u63a5\u652f\u4ed8\u7ed3\u7b97\u7cfb\u7edf\uff0c\u5931\u8d25\u9a8c\u6536\u5355ID\uff1a" + relOrderBO.getAcceptOrderId());
                        throw new FscBusinessException("193008", "\u5bf9\u63a5\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\uff0c\u672a\u83b7\u53d6\u5230\u5408\u540c\u76f8\u5173\u4fe1\u606f\uff01");
                    }
                    fscOrderRelationPO.setContractNo(fscOrderInfoBO.getContractNo());
                    fscOrderRelationPO.setContractId(fscOrderInfoBO.getContractId());
                }
                fscOrderRelationPO.setErpInspectionNo(fscOrderInfoBO.getErpInspectionVoucherCode());
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(fscOrderPo.getFscOrderId());
                fscOrderRelationPO.setContractSegmentCode(reqBO.getContractSegmentCode());
                fscOrderRelationPO.setContractSegmentName(reqBO.getContractSegmentName());
                fscOrderRelationPO.setEstimateBillCode(reqBO.getEstimateBillCode());
                fscOrderRelationPO.setEstimateBillGuid(reqBO.getEstimateBillGuid());
                fscOrderRelationPO.setEstimateBizTypeCode(reqBO.getEstimateBizTypeCode());
                fscOrderRelationPO.setPanDueDate(reqBO.getPanDueDate());
                fscOrderRelationPO.setSettleState(reqBO.getSettleState());
                acceptOrderCodes.add(fscOrderRelationPO.getAcceptOrderNo());
                orderCodes.add(fscOrderRelationPO.getOrderNo());
                List<FscOrderItemPO> orderItemPOS = JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class);
                BigDecimal[] settleAmt = new BigDecimal[]{BigDecimal.ZERO};
                ArrayList list = new ArrayList();
                StringBuffer sb = null;
                ArrayList exOrderItemIds = new ArrayList();
                HashSet taxRate = new HashSet();
                orderItemPOS.forEach(fscOrderItemPO -> {
                    if (Objects.nonNull(fscOrderInfoBO.getOrderType()) && PebExtConstant.OrderType.CX_AGR.equals(fscOrderInfoBO.getOrderType())) {
                        fscOrderItemPO.setSkuName(fscOrderItemPO.getSkuMaterialLongDesc());
                    }
                    if (StringUtils.isBlank((CharSequence)fscOrderItemPO.getSettleUnit()) && fscOrderItemPO.getSalesUnitRate() != null && BigDecimal.ONE.compareTo(fscOrderItemPO.getSalesUnitRate()) == 0) {
                        fscOrderItemPO.setSettleUnit(fscOrderItemPO.getUnitName());
                    }
                    fscOrderItemPO.setContractId(fscOrderInfoBO.getFinanceContractId());
                    fscOrderItemPO.setContractNo(fscOrderInfoBO.getFinanceContractNo());
                    fscOrderItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
                    invoiceItemMap.put(fscOrderItemPO.getOrderItemId(), (FscOrderItemPO)fscOrderItemPO);
                    if (Objects.nonNull(itemReqBOMap.get(fscOrderItemPO.getOrderItemId()))) {
                        FscOrderItemReqBO fscOrderItemReqBO = (FscOrderItemReqBO)itemReqBOMap.get(fscOrderItemPO.getOrderItemId());
                        if (Objects.nonNull(fscOrderItemReqBO.getProductDescription()) || Objects.nonNull(fscOrderItemReqBO.getSpecificationsModel())) {
                            fscOrderItemPO.setProductDescription(fscOrderItemReqBO.getProductDescription());
                            fscOrderItemPO.setSpecificationsModel(fscOrderItemReqBO.getSpecificationsModel());
                        } else {
                            this.dealDescAndModel((FscOrderItemPO)fscOrderItemPO, reqBO);
                        }
                        if (fscOrderItemReqBO.getNum() != null && fscOrderItemReqBO.getNum().compareTo(BigDecimal.ZERO) > 0) {
                            fscOrderItemPO.setNum(fscOrderItemReqBO.getNum());
                            fscOrderItemPO.setAmt(fscOrderItemReqBO.getAmt());
                            fscOrderItemPO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemPO.getAmt(), (BigDecimal)fscOrderItemPO.getTaxRate()));
                            fscOrderItemPO.setUntaxAmt(fscOrderItemPO.getAmt().subtract(fscOrderItemPO.getTaxAmt()));
                            fscOrderItemPO.setPurchaseAmt(fscOrderItemReqBO.getNum().multiply(fscOrderItemPO.getPurchasePrice()));
                            BigDecimal purchaseTaxAmt = TaxUtils.calTaxAmt((BigDecimal)fscOrderItemPO.getPurchaseAmt(), (BigDecimal)fscOrderItemPO.getTaxRate());
                            fscOrderItemPO.setPurchaseUntaxAmt(fscOrderItemPO.getPurchaseAmt().subtract(purchaseTaxAmt));
                            if (fscOrderItemPO.getSalesUnitRate() != null && fscOrderItemPO.getSalesUnitRate().compareTo(BigDecimal.ZERO) > 0) {
                                fscOrderItemPO.setSettlePrice(fscOrderItemPO.getPrice().divide(fscOrderItemPO.getSalesUnitRate(), 8, 4));
                                fscOrderItemPO.setSettleNum(fscOrderItemPO.getNum().multiply(fscOrderItemPO.getSalesUnitRate()));
                            }
                            if (fscOrderItemReqBO.getNum().multiply(fscOrderItemPO.getPrice()).setScale(2, 4).compareTo(fscOrderItemReqBO.getAmt()) != 0) {
                                throw new FscBusinessException("198888", "\u524d\u7aef\u63d0\u4ea4\u660e\u7ec6\u884c\u91d1\u989d\u4e0e\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
                            }
                            taxRate.add(fscOrderItemPO.getTaxRate() == null ? 0 : fscOrderItemPO.getTaxRate().multiply(new BigDecimal(100)).intValue());
                        } else if (fscOrderItemReqBO.getNum().compareTo(BigDecimal.ZERO) == 0) {
                            exOrderItemIds.add(fscOrderItemPO.getOrderItemId());
                            fscOrderItemPO.setNum(fscOrderItemReqBO.getNum());
                            fscOrderItemPO.setAmt(BigDecimal.ZERO);
                        }
                    } else {
                        this.dealDescAndModel((FscOrderItemPO)fscOrderItemPO, reqBO);
                        taxRate.add(fscOrderItemPO.getTaxRate() == null ? 0 : fscOrderItemPO.getTaxRate().multiply(new BigDecimal(100)).intValue());
                    }
                    totalCharge[0] = totalCharge[0].add(fscOrderItemPO.getAmt());
                    settleAmt[0] = settleAmt[0].add(fscOrderItemPO.getAmt());
                    this.checkTemp(reqBO, (FscOrderItemPO)fscOrderItemPO, relOrderBO, fscOrderInfoBO, list);
                });
                if (sb != null) {
                    throw new FscBusinessException("193008", sb.toString());
                }
                try {
                    log.info("------------------\u6dfb\u52a0\u65e5\u5fd71\uff1a" + JSON.toJSON(list));
                    if (!CollectionUtils.isEmpty(list)) {
                        this.fscCheckTempMapper.insertBatch(list);
                    }
                }
                catch (Exception e2) {
                    log.error("\u6821\u9a8c\u5f00\u7968\u540d\u79f0\u548c\u89c4\u683c\u578b\u53f7\u63d2\u5165\u6570\u636e\u5e93\u9519\u8bef\uff01");
                    e2.printStackTrace();
                }
                if (!CollectionUtils.isEmpty(exOrderItemIds) && CollectionUtils.isEmpty(orderItemPOS = orderItemPOS.stream().filter(e -> !exOrderItemIds.contains(e.getOrderItemId())).collect(Collectors.toList()))) continue;
                if ((FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) || FscConstants.FscOrderMakeType.SUPPLIER.equals(reqBO.getMakeType()) && reqBO.getSupplierId() != null && reqBO.getSupplierId().equals(this.operationSupId)) && taxRate.size() != 1) {
                    throw new FscBusinessException("193008", "\u5f00\u7968\u660e\u7ec6\u7a0e\u7387\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968\u3002");
                }
                fscOrderItemPOS.addAll(orderItemPOS);
                fscOrderRelationPO.setSettleAmt(settleAmt[0]);
                if (!fscOrderPo.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE)) {
                    fscOrderRelationPO.setAmount(settleAmt[0]);
                } else {
                    fscOrderRelationPO.setAmount(BigDecimal.ZERO);
                }
                if (FscConstants.SettleType.ORDER.equals(reqBO.getSettleType())) {
                    fscOrderRelationPO.setAmount(BigDecimal.ZERO);
                }
                if (fscOrderRelationPO.getQualityAmt().compareTo(fscOrderRelationPO.getSettleAmt()) > 0) {
                    throw new FscBusinessException("191014", fscOrderRelationPO.getOrderNo() + "\u8d28\u4fdd\u91d1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u6b21\u5f00\u7968\u91d1\u989d\uff01");
                }
                if (reqBO.getConfirmType() != null) {
                    fscOrderRelationPO.setAmount(fscOrderRelationPO.getSettleAmt());
                    fscOrderPo.setPayType(Integer.valueOf(1));
                    fscOrderPo.setShouldPayType(Integer.valueOf(1));
                }
                fscOrderRelationPOS.add(fscOrderRelationPO);
                if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getOperatorId())) {
                    fscOrderPo.setOperatorId(Long.valueOf(Long.parseLong(fscOrderInfoBO.getOperatorId())));
                }
                fscOrderPo.setSettlePlatform(settlePlatform);
                fscOrderPo.setOperatorName(fscOrderInfoBO.getOperatorName());
                fscOrderPo.setOperationNo(fscOrderInfoBO.getOperationNo());
                if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getOperatorDeptId())) {
                    fscOrderPo.setOperatorDeptId(Long.valueOf(Long.parseLong(fscOrderInfoBO.getOperatorDeptId())));
                }
                fscOrderPo.setOperatorDeptName(fscOrderInfoBO.getOperatorDeptName());
                if ("0".equals(reqBO.getIsprofess())) {
                    if (fscOrderPo.getOperatorId() == null) {
                        fscOrderPo.setOperatorId(reqBO.getUserId());
                        fscOrderPo.setOperatorName(reqBO.getName());
                    }
                    if (fscOrderPo.getOperatorDeptId() == null) {
                        fscOrderPo.setOperatorDeptId(reqBO.getDeptId());
                        fscOrderPo.setOperatorDeptName(reqBO.getDeptName());
                    }
                    fscOrderPo.setOperationTime(new Date());
                    if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPo.getOperationNo())) {
                        String[] org = this.proOrg.split(",");
                        String[] pur = reqBO.getOrgPath().split("-");
                        String operationNo = String.valueOf(reqBO.getOrgId());
                        block5: for (String pro : org) {
                            for (String t : pur) {
                                if (!pro.equals(t)) continue;
                                operationNo = pro;
                                continue block5;
                            }
                        }
                        fscOrderPo.setOperationNo(operationNo);
                    }
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPo.getOperationNo())) continue;
                UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
                ArrayList<Long> operationNos = new ArrayList<Long>();
                operationNos.add(Long.parseLong(fscOrderPo.getOperationNo()));
                abilityReqBO.setOrgIdList(operationNos);
                UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
                if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
                    Map orgMap = rspBO.getOrgMap();
                    fscOrderPo.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(Long.valueOf(fscOrderPo.getOperationNo()))).getOrgName());
                }
                if (!"1".equals(fscOrderPo.getOrderSource().toString())) continue;
                orderNos.append(fscOrderInfoBO.getOrderNo()).append(",");
            }
            fscOrderPo.setQualityAmt(qualityAmt);
            if (qualityAmt.compareTo(fscOrderPo.getTotalCharge()) > 0) {
                throw new FscBusinessException("198888", qualityAmt + "\u8d28\u4fdd\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u7b97\u91d1\u989d" + fscOrderPo.getTotalCharge());
            }
            if (reqBO.getFscOrderInfoBoMap() != null && reqBO.getFscOrderInfoBoMap().get(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getAcceptOrderId()) != null) {
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(((RelOrderBO)splitOrderBO.getRelOrderList().get(0)).getAcceptOrderId());
                FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
                fscOrderExtPO.setFscOrderId(fscOrderPo.getFscOrderId());
                fscOrderExtPO.setIsEquipPurchase(reqBO.getIsEquipPurchase());
                fscOrderExtPO.setVendorSiteId(fscOrderInfoBO.getVendorSiteId());
                fscOrderExtPO.setVendorSiteName(fscOrderInfoBO.getVendorSiteName());
                fscOrderExtPO.setSupplierErpCode(fscOrderInfoBO.getSupplierErpNo());
                fscOrderExtPO.setAgentAccount(reqBO.getAgentAccount());
                fscOrderExtPO.setUnifyUserName(reqBO.getUnifyUserName());
                fscOrderExtPO.setUnifyUserId(reqBO.getUnifyUserId());
                fscOrderExtPO.setUnifyDeptName(reqBO.getUnifyDeptName());
                fscOrderExtPO.setUnifyDeptId(reqBO.getUnifyDeptId());
                fscOrderExtPO.setUnifyOrgName(reqBO.getUnifyOrgName());
                fscOrderExtPO.setUnifyOrgId(reqBO.getUnifyOrgId());
                fscOrderExtPO.setUnifyComCode(reqBO.getUnifyComCode());
                fscOrderExtPO.setExt1(reqBO.getHandlerUserId());
                fscOrderExtPO.setExt3(reqBO.getColmunCode());
                fscOrderExtPO.setExt4(reqBO.getColmunName());
                fscOrderExtPO.setOrgCodeIn(reqBO.getOrgCodeIn());
                fscOrderExtPOS.add(fscOrderExtPO);
            }
            FscPayLogPO fscPayLogPO = new FscPayLogPO();
            Set orderIdSet = fscOrderItemPOS.stream().map(FscOrderItemPO::getOrderId).collect(Collectors.toSet());
            fscPayLogPO.setBusiOrderIdList(orderIdSet);
            ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
            busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_PAY);
            busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_REFUND);
            busiCategoryList.add(FscConstants.FscBusiCategory.PERIOD_PAY);
            busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
            busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_CHANGE);
            fscPayLogPO.setBusiCategoryList(busiCategoryList);
            fscPayLogPO.setPayeeId(this.operationOrgId);
            List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
            if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                for (FscPayLogPO po : fscPayLogPOList) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)po.getFscOrderNo())) {
                        po.setFscOrderNo(fscOrderPo.getOrderNo());
                        fscPayLogUpdateList.add(po);
                        continue;
                    }
                    if (po.getFscOrderNo().contains(fscOrderPo.getOrderNo())) continue;
                    po.setFscOrderNo(po.getFscOrderNo() + "," + fscOrderPo.getOrderNo());
                    fscPayLogUpdateList.add(po);
                }
            }
            this.checkOrderBillNum(invoiceItemMap, reqBO.getReceiveType());
            if (splitOrderBO.getAmount().compareTo(totalCharge[0].setScale(2, 4)) != 0) {
                throw new FscBusinessException("198888", "\u524d\u7aef\u63d0\u4ea4\u91d1\u989d\u4e0e\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
            }
            fscOrderPOS.add(fscOrderPo);
            fscOrderIds.add(fscOrderPo.getFscOrderId());
            FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
            fscOrderInvoicePo.setFscOrderId(fscOrderPo.getFscOrderId());
            fscOrderInvoicePo.setBillOperId(reqBO.getUserId().toString());
            fscOrderInvoicePo.setBillOperName(reqBO.getName());
            fscOrderInvoicePo.setBillTime(new Date());
            fscOrderInvoicePo.setBillTimeStart(new Date());
            if (this.operationOrgId.equals(fscOrderPo.getPayeeId())) {
                fscOrderInvoicePo.setInvoiceCategory(FscConstants.FscInvoiceCategory.FULL);
            }
            fscOrderInvoicePOS.add(fscOrderInvoicePo);
            FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
            fscInvoiceRulePO.setFscOrderId(fscOrderPo.getFscOrderId());
            fscInvoiceRulePO.setDataFlag(FscConstants.FscInvoiceRuleDataFlag.YES);
            fscInvoiceRulePO.setDataStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePO.setElecFlag(elecFlag);
            fscInvoiceRulePO.setElecStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePOS.add(fscInvoiceRulePO);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(((FscOrderPO)fscOrderPOS.get(0)).getReceiveType()) && "1".equals(((FscOrderPO)fscOrderPOS.get(0)).getOrderSource() + "")) {
            this.checkOliTaxCode(fscOrderItemPOS);
        }
        if (!CollectionUtils.isEmpty(fscOrderExtPOS)) {
            this.fscOrderExtMapper.insertBatch(fscOrderExtPOS);
        }
        if (CollectionUtils.isEmpty(fscOrderPOS) || CollectionUtils.isEmpty(fscOrderRelationPOS) || CollectionUtils.isEmpty(fscOrderItemPOS) || CollectionUtils.isEmpty(fscOrderInvoicePOS) || CollectionUtils.isEmpty(fscInvoiceRulePOS)) {
            throw new FscBusinessException("193008", "\u5f00\u7968\u4e3b\u5355\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a");
        }
        fscOrderItemPOS = fscOrderItemPOS.stream().filter(e -> Objects.nonNull(e.getNum()) && e.getNum().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        fscOrderItemPOS.forEach(fscOrderItemPO -> {
            fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderItemPO.setCostCenterCode(reqBO.getIndependenceCostCode());
            fscOrderItemPO.setCostCenterName(reqBO.getIndependenceCostName());
        });
        FscOrderFinancePO fscOrderFinancePO = (FscOrderFinancePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderFinancePO.class);
        fscOrderFinancePO.setFscOrderId(((FscOrderPO)fscOrderPOS.get(0)).getFscOrderId());
        fscOrderFinancePO.setCreateUserId(reqBO.getUserName());
        fscOrderFinancePO.setCreateUserName(reqBO.getName());
        fscOrderFinancePO.setCreateTime(new Date());
        fscOrderFinancePO.setUpdateUserId(reqBO.getUserName());
        fscOrderFinancePO.setUpdateUserName(reqBO.getName());
        fscOrderFinancePO.setUpdateTime(new Date());
        fscOrderFinancePO.setPushFinanceStatus(FscConstants.FscPushStatus.NO_PUSH);
        fscOrderFinancePO.setFinanceUserId(StringUtils.isNotBlank((CharSequence)reqBO.getFinanceUserId()) ? reqBO.getFinanceUserId() : reqBO.getUserName());
        fscOrderFinancePO.setFinanceUserName(StringUtils.isNotBlank((CharSequence)reqBO.getFinanceUserId()) ? reqBO.getFinanceUserName() : reqBO.getName());
        fscOrderFinancePO.setPaySource(Integer.valueOf(1));
        fscOrderFinancePO.setPaymentPhase(busiReqBO.getPayReqBO().getPaymentPhase());
        fscOrderFinancePO.setIsAgent(busiReqBO.getPayReqBO().getIsAgent());
        fscOrderFinancePO.setPaymentType(busiReqBO.getPayReqBO().getPaymentType());
        fscOrderFinancePO.setPayDate(busiReqBO.getPayReqBO().getPayDate());
        fscOrderFinancePO.setCashUnitCode(busiReqBO.getPayReqBO().getCashUnitCode());
        fscOrderFinancePO.setCashUnitName(busiReqBO.getPayReqBO().getCashUnitName());
        fscOrderFinancePO.setAgentCompanyCode(busiReqBO.getPayReqBO().getAgentCompanyCode());
        fscOrderFinancePO.setAgentCompanyName(busiReqBO.getPayReqBO().getAgentCompanyName());
        fscOrderFinancePO.setExt1((String)supplierErpNo.get());
        if (org.springframework.util.StringUtils.isEmpty((Object)reqBO.getCwOrgId())) {
            fscOrderFinancePO.setExt3(reqBO.getBuynerErpNo());
        } else {
            fscOrderFinancePO.setExt3(reqBO.getCwOrgId());
        }
        fscOrderFinancePO.setExt4(String.valueOf(fscOrderFinancePO.getExchangeRate().stripTrailingZeros()));
        this.fscOrderFinanceMapper.insert(fscOrderFinancePO);
        this.fscOrderMapper.insertBatch(fscOrderPOS);
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        this.fscOrderItemMapper.insertBatch(fscOrderItemPOS);
        this.fscOrderInvoiceMapper.insertBatch(fscOrderInvoicePOS);
        this.fscInvoiceRuleMapper.insertBatch(fscInvoiceRulePOS);
        if (!CollectionUtils.isEmpty(fscAttachmentPOList)) {
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
        }
        if (!CollectionUtils.isEmpty(fscPayLogUpdateList)) {
            this.fscPayLogMapper.updateFscOrderNo(fscPayLogUpdateList);
        }
        FscShouldPayPO fscShouldPayPO = this.createShouldPay((FscOrderPO)fscOrderPOS.get(0), orderCodes, shouldPayOrderInfo, acceptOrderCodes, reqBO);
        busiReqBO.setFscShouldPayPO(fscShouldPayPO);
        FscCreateFinanceBillOrderAndPayBusiRspBO rspBO = new FscCreateFinanceBillOrderAndPayBusiRspBO();
        rspBO.setFscOrderIds(fscOrderIds);
        return rspBO;
    }

    private void dealDescAndModel(FscOrderItemPO fscOrderItemPO, FscCreateFinanceBillOrderBusiReqBO reqBO) {
        if ("2".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.AGREE_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSkuMaterialName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId(), reqBO.getOrderSource()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null, reqBO.getOrderSource()));
            }
        } else if ("1".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.PLAN_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getPlanItemName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode(), reqBO.getOrderSource()));
            } else if (FscInvoiceValueTypeEnum.ELECTRONIC.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSkuName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null, reqBO.getOrderSource()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId(), reqBO.getOrderSource()));
            }
        }
    }

    public String dealSpecificationsModel(String spec, String model, String materialBJ, String materialId, String orderSource) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)materialId) && materialId.startsWith("61")) {
            return "";
        }
        String specificationsModel = "";
        specificationsModel = !org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) ? spec + "|" + model : (!org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) ? spec : (!org.springframework.util.StringUtils.isEmpty((Object)model) ? model : materialBJ)))));
        if (!"2".equals(orderSource) && !org.springframework.util.StringUtils.isEmpty((Object)specificationsModel) && specificationsModel.length() > 40) {
            return specificationsModel.substring(0, 40);
        }
        return specificationsModel;
    }

    private void syncOrderStatus(List<Long> fscOrderIds) {
        fscOrderIds.forEach(fscOrderId -> {
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        });
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private void dealApproval(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, FscCreateFinanceBillOrderAndPayBusiRspBO rspBO) {
        for (Long l : reqBO.getFscOrderIds()) {
            FscOrderPO order = new FscOrderPO();
            order.setFscOrderId(l);
            order = this.fscOrderMapper.getModelBy(order);
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(l);
            List fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemList)) {
                throw new FscBusinessException("193008", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u67e5\u8be2\u7ed3\u7b97\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a\uff01");
            }
            int index = 1;
            for (FscOrderItemPO po : fscOrderItemList) {
                if (StringUtils.isNotBlank((CharSequence)po.getSpecificationsModel()) && po.getSpecificationsModel().length() > 120) {
                    throw new FscBusinessException("193004", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u7b2c" + index + "\u884c\u89c4\u683c\u578b\u53f7\u4e0d\u53ef\u8d85\u8fc7120\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u4e4b\u540e\u8fdb\u884c\u63d0\u4ea4\uff01");
                }
                ++index;
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(l);
            fscOrderPO.setOperatorId(reqBO.getUserId());
            fscOrderPO.setOperatorName(reqBO.getName());
            String operationNo = String.valueOf(reqBO.getOrgId());
            String[] org = this.proOrg.split(",");
            String[] pur = reqBO.getOrgPath().split("-");
            block2: for (String pro : org) {
                for (String t : pur) {
                    if (!pro.equals(t)) continue;
                    operationNo = pro;
                    continue block2;
                }
            }
            fscOrderPO.setOperationNo(operationNo);
            this.fscOrderMapper.updateById(fscOrderPO);
            if (reqBO.getWebSource() == null || !reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) continue;
            this.dealWorkFlow(order);
        }
    }

    private void checkOrderBillNum(Map<Long, FscOrderItemPO> itemMap, Integer receiveType) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setOrderItemIdSets(itemMap.keySet());
        fscOrderItemPO.setReceiveType(receiveType);
        List orderItemPOS = this.fscOrderItemMapper.getCheckList(fscOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)orderItemPOS)) {
            for (FscOrderItemPO orderItemPO : orderItemPOS) {
                FscOrderItemPO invoiceItem = itemMap.get(orderItemPO.getOrderItemId());
                orderItemPO.setNum(orderItemPO.getNum().subtract(orderItemPO.getAlreadyRefundNum()));
                orderItemPO.setAmt(orderItemPO.getAmt().subtract(orderItemPO.getAlreadyRefundAmt()));
                if (invoiceItem.getTotalNum().subtract(orderItemPO.getNum()).compareTo(invoiceItem.getNum()) < 0) {
                    throw new FscBusinessException("198888", "\u8ba2\u5355\u660e\u7ec6\u884c[" + invoiceItem.getOrderItemId() + "]\u672c\u6b21\u63d0\u7968\u6570\u91cf\u8d85\u8fc7\u53ef\u63d0\u7968\u6570\u91cf\uff01");
                }
                if (invoiceItem.getTotalAmt().subtract(orderItemPO.getAmt()).compareTo(invoiceItem.getAmt()) >= 0) continue;
                throw new FscBusinessException("198888", "\u8ba2\u5355\u660e\u7ec6\u884c[" + invoiceItem.getOrderItemId() + "]\u672c\u6b21\u63d0\u7968\u6570\u91cf\u8d85\u8fc7\u53ef\u63d0\u7968\u6570\u91cf\uff01");
            }
        }
    }

    private void checkTemp(FscCreateFinanceBillOrderBusiReqBO reqBO, FscOrderItemPO fscOrderItemPO, RelOrderBO relOrderBO, FscOrderInfoBO fscOrderInfoBO, List<FscCheckTempPO> list) {
        if ("1".equals(reqBO.getIsprofess()) && !FscConstants.FscOrderOperType.save.equals(reqBO.getOperType())) {
            FscCheckTempPO po;
            if (StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getProductDescription()) && FscCommonUtils.getLength((String)fscOrderItemPO.getProductDescription()) > 90) {
                po = new FscCheckTempPO();
                if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                    po.setObjNo(reqBO.getFscOrderNo());
                }
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(relOrderBO.getOrderId() + "");
                po.setOrderNo(fscOrderInfoBO.getOrderNo());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("0");
                po.setReason("\u5f00\u7968\u540d\u79f0\u5b57\u6bb5\u9650\u523690\u5b57\u7b26");
                list.add(po);
            }
            if (StringUtils.isBlank((CharSequence)fscOrderItemPO.getSpecificationsModel())) {
                po = new FscCheckTempPO();
                if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                    po.setObjNo(reqBO.getFscOrderNo());
                }
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(relOrderBO.getOrderId() + "");
                po.setOrderNo(fscOrderInfoBO.getOrderNo());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("1");
                po.setReason("\u89c4\u683c\u578b\u53f7\u4e3a\u7a7a");
                list.add(po);
            }
            if (StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSpecificationsModel()) && FscCommonUtils.getLength((String)fscOrderItemPO.getSpecificationsModel()) > 40) {
                po = new FscCheckTempPO();
                if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                    po.setObjNo(reqBO.getFscOrderNo());
                }
                po.setObjId(fscOrderItemPO.getFscOrderId());
                po.setOrderId(relOrderBO.getOrderId() + "");
                po.setOrderNo(fscOrderInfoBO.getOrderNo());
                po.setSkuName(fscOrderItemPO.getSkuName());
                po.setType("0");
                po.setReason("\u89c4\u683c\u578b\u53f7\u5b57\u6bb5\u957f\u5ea6\u9650\u523640\u5b57\u7b26");
                list.add(po);
            }
            this.fscCheckTempMapper.deleteByObjId(fscOrderItemPO.getFscOrderId());
        }
    }

    private void checkOliTaxCode(List<FscOrderItemPO> pos) {
        List<FscOrderItemPO> bos = pos.stream().filter(x -> !org.springframework.util.StringUtils.isEmpty((Object)x.getTaxCode()) && this.oilTaxCode.contains(x.getTaxCode()) && Objects.nonNull(x.getNum()) && x.getNum().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(bos)) {
            log.info("\u6210\u6cb9\u54c1\u660e\u7ec6\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString(bos));
            BigDecimal submitCount = this.calOliCount(bos);
            BigDecimal downCount = this.calOliCount(this.fscOrderItemMapper.queryDownOilTaxCode(Arrays.stream(this.oilTaxCode.split(",")).collect(Collectors.toList())));
            BigDecimal upCount = this.calOliCount(this.fscOrderItemMapper.queryUpOilTaxCode(Arrays.stream(this.oilTaxCode.split(",")).collect(Collectors.toList())));
            BigDecimal maxCount = upCount.subtract(downCount);
            if (submitCount.compareTo(maxCount) > 0) {
                throw new FscBusinessException("198888", "\u6210\u54c1\u6cb9\u5df2\u6536\u53d1\u7968" + upCount + "\u5347,\u5df2\u5f00\u53d1\u7968" + downCount + "\u5347,\u6700\u5927\u53ef\u5f00\u53d1\u7968" + maxCount + "\u5347\uff0c\u5f53\u524d\u5355\u636e" + submitCount + "\u5347\uff0c\u65e0\u6cd5\u6ee1\u8db3\u5f00\u7968\u8981\u6c42\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u5458\u5b8c\u6210\u6536\u7968\u5904\u7406\u540e\u518d\u7ee7\u7eed\u5f00\u7968\u3002");
            }
        }
    }

    private BigDecimal calOliCount(List<FscOrderItemPO> pos) {
        BigDecimal sgNum = pos.stream().filter(x -> "\u5347".equals(x.getUnit())).map(FscOrderItemPO::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal dunNum = pos.stream().filter(x -> "\u5428".equals(x.getUnit())).map(y -> y.getNum().multiply(BigDecimal.valueOf(1126L))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal tgNum = pos.stream().filter(x -> "\u6876".equals(x.getUnit())).map(y -> (Objects.nonNull(y.getSettleNum()) ? y.getSettleNum() : y.getNum()).multiply(BigDecimal.valueOf(1126L))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal gjNum = pos.stream().filter(x -> "\u516c\u65a4".equals(x.getUnit())).map(y -> y.getNum().multiply(BigDecimal.valueOf(1.126))).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sgNum.add(dunNum).add(tgNum).add(gjNum);
    }

    private FscShouldPayPO createShouldPay(FscOrderPO fscOrderPO, List<String> orderCodes, FscOrderInfoBO shouldPayOrderInfo, List<String> acceptOrderCodes, FscCreateFinanceBillOrderBusiReqBO reqBO) {
        ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
        fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
        fscShouldPayBO.setShouldPayAmount(reqBO.getTotalAmount());
        fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
        fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
        fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
        fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
        fscShouldPayBO.setPenaltyRatio(shouldPayOrderInfo.getPayBreakScale());
        fscShouldPayBO.setContractId(shouldPayOrderInfo.getFinanceContractId());
        fscShouldPayBO.setContractNo(shouldPayOrderInfo.getFinanceContractNo());
        fscShouldPayBO.setAgreementId(shouldPayOrderInfo.getProtocolId());
        fscShouldPayBO.setAgreementNo(shouldPayOrderInfo.getPlaAgreementCode());
        fscShouldPayBO.setOrderId(shouldPayOrderInfo.getOrderId());
        fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
        fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
        fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
        fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
        fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
        fscShouldPayBO.setOrderOperStr(String.valueOf(fscOrderPO.getOperatorId()));
        fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodes));
        fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
        fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
        fscShouldPayBO.setOperatorDeptId(Convert.toStr((Object)fscOrderPO.getOperatorDeptId()));
        fscShouldPayBO.setOperatorDeptName(fscOrderPO.getOperatorDeptName());
        fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
        fscShouldPayBO.setShouldPayMethod(Integer.valueOf(2));
        fscShouldPayBO.setAcceptOrderCode(String.join((CharSequence)",", acceptOrderCodes));
        fscShouldPayBO.setNodePayRatio(reqBO.getShouldPayRatio());
        fscShouldPayBOS.add(fscShouldPayBO);
        FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
        fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
        fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
        fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
        fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
        fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
        fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
        fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
        FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
        if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
        }
        return (FscShouldPayPO)fscPayShouldPayCreateAtomRspBO.getFscShouldPayPOS().get(0);
    }

    private FscCreateFinanceBillOrderAndPayBusiRspBO createPay(FscCreateFinanceBillOrderAndPayBusiReqBO busiReqBO, FscCreateFinanceBillOrderAndPayBusiRspBO createRspBO) {
        FscFinancePayBillCreateReqBO reqBO = busiReqBO.getPayReqBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        String operationNo = String.valueOf(busiReqBO.getOrgId());
        if ("0".equals(busiReqBO.getIsprofess())) {
            String[] org;
            for (String pro : org = this.proOrg.split(",")) {
                if (!busiReqBO.getOrgPath().contains(pro)) continue;
                operationNo = pro;
            }
        }
        FscShouldPayPO querVo = new FscShouldPayPO();
        List<Long> shouldPayIds = Collections.singletonList(busiReqBO.getFscShouldPayPO().getShouldPayId());
        querVo.setShouldPayIds(shouldPayIds);
        List poResult = this.fscShouldPayMapper.getList(querVo);
        if (CollectionUtils.isEmpty((Collection)poResult)) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        reqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> fscOrderPayItemBO.setShouldPayId(busiReqBO.getFscShouldPayPO().getShouldPayId()));
        this.updateShouldPay(reqBO, fscOrderId, poResult);
        this.insertOrder(reqBO, fscOrderId, operationNo, busiReqBO);
        this.insertAttachment(reqBO.getAttachmentList(), fscOrderId);
        reqBO.setBizTypeCode(busiReqBO.getOrderReqBO().getBizTypeCode());
        reqBO.setBizTypeName(busiReqBO.getOrderReqBO().getBizTypeName());
        this.insertFinanceInfo(reqBO, fscOrderId);
        List orderIdList = poResult.stream().map(FscShouldPayPO::getOrderId).collect(Collectors.toList());
        this.insertCapitalInfo(reqBO, fscOrderId);
        if (!CollectionUtils.isEmpty(orderIdList)) {
            PebExtOrderSettleTypeUpdateAbilityReqBO settleReqBO = new PebExtOrderSettleTypeUpdateAbilityReqBO();
            settleReqBO.setUserType(UocCoreConstant.UserType.PUR);
            settleReqBO.setSettleType(FscConstants.SettleType.INSPECTION);
            settleReqBO.setOrderIds(orderIdList);
            PebExtOrderSettleTypeUpdateAbilityRspBO orderUpdateRspBO = this.pebExtOrderSettleTypeUpdateAbilityService.dealOrderSettleType(settleReqBO);
            if (!"0000".equals(orderUpdateRspBO.getRespCode())) {
                log.error("\u540c\u6b65\u8ba2\u5355\u7ed3\u7b97\u7c7b\u578b\u5931\u8d25\uff1a{}", (Object)orderUpdateRspBO.getRespDesc());
            }
        }
        createRspBO.setFscOrderId(fscOrderId);
        createRspBO.setRespCode("0000");
        createRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return createRspBO;
    }

    private void insertCapitalInfo(FscFinancePayBillCreateReqBO reqBO, Long fscOrderId) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(fscOrderId);
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscFinanceCapitalInfoAtomReqBO atomReqBO = (FscFinanceCapitalInfoAtomReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscFinanceCapitalInfoAtomReqBO.class);
        atomReqBO.setObjId(fscOrderId);
        atomReqBO.setObjNo(orderPO.getOrderNo());
        atomReqBO.setObjType(Integer.valueOf(1));
        atomReqBO.setFscOrderPayItemBOS(reqBO.getFscOrderPayItemBOS());
        atomReqBO.setOperationType(Integer.valueOf(0));
        FscFinanceCapitalInfoAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealFinanceCapitalInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u5b58\u50a8\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
    }

    private void insertOrder(FscFinancePayBillCreateReqBO createReqBO, Long fscOrderId, String operationNo, FscCreateFinanceBillOrderAndPayBusiReqBO busiReqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        if (!org.springframework.util.StringUtils.isEmpty((Object)createReqBO.getOrderNo())) {
            fscOrderPO.setOrderNo(createReqBO.getOrderNo());
        } else {
            CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
            encodedSerialGetServiceReqBO.setCenter("FSC");
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
            encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
            encodedSerialGetServiceReqBO.setOrgType("-1");
            CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
            fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
            createReqBO.setOrderNo(fscOrderPO.getOrderNo());
        }
        FscShouldPayPO fscShouldPayPO = busiReqBO.getFscShouldPayPO();
        fscOrderPO.setOrderName(createReqBO.getOrderName());
        fscOrderPO.setPayerId(fscShouldPayPO.getPayerId());
        fscOrderPO.setPayerName(fscShouldPayPO.getPayerName());
        fscOrderPO.setPayeeId(fscShouldPayPO.getPayeeId());
        fscOrderPO.setPayeeName(fscShouldPayPO.getPayeeName());
        fscOrderPO.setPayeeAccountName(createReqBO.getPayeeAccountName());
        fscOrderPO.setPayeeBankAccount(createReqBO.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName(createReqBO.getPayeeBankName());
        if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPO.getPayeeAccountName()) || org.springframework.util.StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankAccount()) || org.springframework.util.StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankName())) {
            FscMerchantPayeePO fscMerchantPayeePO = new FscMerchantPayeePO();
            fscMerchantPayeePO.setSupplierId(fscShouldPayPO.getPayeeId());
            List fscMerchantPayeePOList = this.fscMerchantPayeeMapper.getList(fscMerchantPayeePO);
            if (!CollectionUtils.isEmpty((Collection)fscMerchantPayeePOList)) {
                fscMerchantPayeePO = (FscMerchantPayeePO)fscMerchantPayeePOList.get(0);
                fscOrderPO.setPayeeAccountName(fscMerchantPayeePO.getPayeeAccountName());
                fscOrderPO.setPayeeBankAccount(fscMerchantPayeePO.getPayeeBankAccount());
                fscOrderPO.setPayeeBankName(fscMerchantPayeePO.getPayeeBankName());
            } else {
                throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u672a\u914d\u7f6e\u6536\u6b3e\u8d26\u6237");
            }
        }
        fscOrderPO.setPayMethod(String.valueOf(fscShouldPayPO.getPayMethod()));
        fscOrderPO.setPayType(fscShouldPayPO.getPayType());
        fscOrderPO.setShouldPayType(fscShouldPayPO.getShouldPayType());
        fscOrderPO.setPayChannel(createReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateOperNo(busiReqBO.getUserName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(createReqBO.getTotalAmount());
        fscOrderPO.setContractNo(createReqBO.getContractNo());
        fscOrderPO.setContractId(createReqBO.getContractId());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        fscOrderPO.setPaidAmount(BigDecimal.ZERO);
        fscOrderPO.setPayingAmount(createReqBO.getTotalAmount());
        fscOrderPO.setToPayAmount(createReqBO.getTotalAmount());
        FscCreateFinanceBillOrderBusiReqBO orderBusiReqBO = busiReqBO.getOrderReqBO();
        fscOrderPO.setBuynerNo(orderBusiReqBO.getBuynerNo());
        fscOrderPO.setBuynerName(orderBusiReqBO.getBuynerName());
        fscOrderPO.setOrderType(orderBusiReqBO.getOrderType());
        fscOrderPO.setOrderSource(Integer.valueOf(orderBusiReqBO.getOrderSource()));
        fscOrderPO.setTradeMode(createReqBO.getTradeMode());
        fscOrderPO.setRemark(createReqBO.getRemark());
        fscOrderPO.setPaymentMethod(createReqBO.getPaymentMethod());
        fscOrderPO.setSettleType(orderBusiReqBO.getSettleType());
        if ("0".equals(createReqBO.getIsprofess())) {
            fscOrderPO.setOperatorId(busiReqBO.getUserId());
            fscOrderPO.setOperatorName(busiReqBO.getName());
            fscOrderPO.setOperationNo(operationNo);
            fscOrderPO.setOperationName(busiReqBO.getCompanyName());
        }
        if ("3".equals(createReqBO.getPayChannel())) {
            if (null != busiReqBO.getUserId()) {
                fscOrderPO.setPayOperId(busiReqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(busiReqBO.getName());
        }
        fscOrderPO.setSettlePlatform(Integer.valueOf(3));
        if ("1".equals(createReqBO.getSaveOrSubmit())) {
            fscOrderPO.setOrderState(FscConstants.FscPayOrderState.CANCEL);
        } else {
            fscOrderPO.setOrderState(Integer.valueOf(1));
        }
        String procKey = FscOrderFlowProcKeyEnum.DOWN_PAY.getDescr();
        fscOrderPO.setOrderFlowKey(procKey);
        this.fscOrderMapper.insert(fscOrderPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(fscOrderId);
        List invoicePOList = this.fscInvoiceMapper.getInvoiceByShouldPay(fscInvoicePO);
        if (CollectionUtils.isEmpty((Collection)invoicePOList)) {
            invoicePOList = this.fscInvoiceMapper.getInvoiceByAdvance(fscInvoicePO);
        }
        StringBuilder invoiceNo = new StringBuilder();
        StringBuilder invoiceCode = new StringBuilder();
        log.debug("invoicePoList:{}", (Object)JSONObject.toJSONString((Object)invoicePOList));
        if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
            boolean flag = false;
            for (FscInvoicePO po : invoicePOList) {
                if (po == null) continue;
                flag = true;
                invoiceNo.append(po.getInvoiceNo()).append(",");
                invoiceCode.append(po.getInvoiceCode()).append(",");
            }
            if (flag) {
                fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderId);
                fscOrderPO.setInvoiceNo(invoiceNo.toString());
                fscOrderPO.setInvoiceCode(invoiceCode.toString());
                this.fscOrderMapper.updateById(fscOrderPO);
            }
        }
    }

    private void updateShouldPay(FscFinancePayBillCreateReqBO busiReqBO, Long fscOrderId, List<FscShouldPayPO> poResult) {
        HashSet shouldPayType = new HashSet();
        HashSet payerIds = new HashSet();
        HashSet payeeIds = new HashSet();
        HashSet contractNos = new HashSet();
        HashSet payType = new HashSet();
        poResult.forEach(fscShouldPayPO -> {
            if (null != fscShouldPayPO.getShouldPayType()) {
                shouldPayType.add(fscShouldPayPO.getShouldPayType());
                busiReqBO.setShouldPayType(fscShouldPayPO.getShouldPayType());
            }
            if (null != fscShouldPayPO.getPayerId()) {
                payerIds.add(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerId(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerName(fscShouldPayPO.getPayerName());
            }
            if (null != fscShouldPayPO.getPayeeId()) {
                payeeIds.add(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeId(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeName(fscShouldPayPO.getPayeeName());
            }
            if (null != fscShouldPayPO.getPayType()) {
                payType.add(fscShouldPayPO.getPayType());
                busiReqBO.setPayType(fscShouldPayPO.getPayType());
            }
            if (org.springframework.util.StringUtils.hasText((String)fscShouldPayPO.getContractNo())) {
                contractNos.add(fscShouldPayPO.getContractNo());
                busiReqBO.setContractNo(fscShouldPayPO.getContractNo());
            }
            if (fscShouldPayPO.getContractId() != null) {
                busiReqBO.setContractId(fscShouldPayPO.getContractId());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)fscShouldPayPO.getBuyerNo())) {
                busiReqBO.setBuynerNo(fscShouldPayPO.getBuyerNo());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)fscShouldPayPO.getBuyerName())) {
                busiReqBO.setBuynerName(fscShouldPayPO.getBuyerName());
            }
        });
        if (shouldPayType.size() > 1) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payerIds.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payType.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5f0f\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (contractNos.size() > 1) {
            throw new FscBusinessException("194203", "\u5408\u540c\u7f16\u53f7\u5fc5\u987b\u552f\u4e00\uff01");
        }
        List orderIdList = poResult.stream().map(FscShouldPayPO::getOrderId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(orderIdList)) {
            FscShouldPayPO fscShouldPayPOReq = new FscShouldPayPO();
            fscShouldPayPOReq.setOrderIds(orderIdList);
            fscShouldPayPOReq.setPayeeId((Long)payeeIds.iterator().next());
            fscShouldPayPOReq.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_GRADING_PAY);
            List payPOList = this.fscShouldPayMapper.getListByOrderId(fscShouldPayPOReq);
            if (!CollectionUtils.isEmpty((Collection)payPOList)) {
                String orderNo = payPOList.stream().map(FscShouldPayPO::getObjectNo).filter(objectNo -> !org.springframework.util.StringUtils.isEmpty((Object)objectNo)).distinct().collect(Collectors.joining(","));
                orderNo = org.springframework.util.StringUtils.isEmpty((Object)orderNo) ? "\u6240\u9009\u4ed8\u6b3e\u4f9d\u636e\u7f16\u53f7" : orderNo;
                throw new FscBusinessException("194203", orderNo + "\u5df2\u901a\u8fc7\u7279\u6b8a\u4ed8\u6b3e\u4e1a\u52a1\u53d1\u8d77\u4ed8\u6b3e");
            }
        }
        Map shouldPayMap = poResult.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, Function.identity(), (k1, k2) -> k1));
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        for (FscOrderPayItemBO fscOrderPayItemBO : busiReqBO.getFscOrderPayItemBOS()) {
            FscPayItemSerialPO fscPayItemSerialPO;
            FscShouldPayPO fscShouldPayPO2 = new FscShouldPayPO();
            fscShouldPayPO2.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            fscShouldPayPO2.setPayAmount(fscOrderPayItemBO.getPayAmount());
            int count = this.fscShouldPayMapper.updateAmount(fscShouldPayPO2);
            if (count != 1) {
                throw new FscBusinessException("194203", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
            }
            FscShouldPayPO shouldPayPO = (FscShouldPayPO)shouldPayMap.get(fscOrderPayItemBO.getShouldPayId());
            fscShouldPayPO2.setObjectId(shouldPayPO.getObjectId());
            fscShouldPayPO2.setObjectType(shouldPayPO.getObjectType());
            fscShouldPayPO2.setOrderId(shouldPayPO.getOrderId());
            fscShouldPayPO2.setOrderCodeStr(shouldPayPO.getOrderCodeStr());
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setIsReduce(fscOrderPayItemBO.getIsReduce());
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            po.setPayAmount(fscOrderPayItemBO.getPayAmount());
            po.setExpType(fscOrderPayItemBO.getExpLineType());
            po.setExpTypeId(fscOrderPayItemBO.getExpTypeCode());
            if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPayItemBO.getShouldPayItemNo())) {
                po.setShouldPayItemNo(((FscShouldPayPO)shouldPayMap.get(fscOrderPayItemBO.getShouldPayId())).getShouldPayNo() + "-01");
            } else {
                po.setShouldPayItemNo(fscOrderPayItemBO.getShouldPayItemNo());
            }
            po.setShouldPayMethod(Integer.valueOf(2));
            po.setItemNo(fscOrderPayItemBO.getItemNo());
            fscOrderPayItemBO.setOrderPayItemId(po.getOrderPayItemId());
            List fscPayItemSerialPOList = this.fscPayItemSerialMapper.queryByShouldPayNo(fscOrderPayItemBO.getShouldPayNo());
            int serialNumber = 0;
            if (!CollectionUtils.isEmpty((Collection)fscPayItemSerialPOList)) {
                fscPayItemSerialPO = (FscPayItemSerialPO)fscPayItemSerialPOList.get(0);
                serialNumber = ((FscPayItemSerialPO)fscPayItemSerialPOList.get(0)).getSerialNumber();
                fscPayItemSerialPO.setSerialNumber(Integer.valueOf(++serialNumber));
                this.fscPayItemSerialMapper.update(fscPayItemSerialPO);
            } else {
                fscPayItemSerialPO = new FscPayItemSerialPO();
                fscPayItemSerialPO.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
                fscPayItemSerialPO.setShouldPayNo(fscOrderPayItemBO.getShouldPayNo());
                fscPayItemSerialPO.setSerialNumber(Integer.valueOf(++serialNumber));
                this.fscPayItemSerialMapper.insert(fscPayItemSerialPO);
            }
            fscOrderPayItemBO.setShouldPayItemNo(po.getShouldPayItemNo());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO.getPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        try {
            FscPayBillDetailAssemblyAtomReqBO assemblyAtomReqBO = (FscPayBillDetailAssemblyAtomReqBO)JSON.parseObject((String)JSONObject.toJSONString((Object)busiReqBO), FscPayBillDetailAssemblyAtomReqBO.class);
            assemblyAtomReqBO.setPayOrderId(fscOrderId);
            FscPayBillDetailAssemblyAtomRspBO fscPayBillDetailAssemblyAtomRspBO = this.fscPayBillDetailAssemblyAtomService.dealPayBillDetailAssembly(assemblyAtomReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
    }

    private void insertFinanceInfo(FscFinancePayBillCreateReqBO reqBO, Long fscOrderId) {
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)financePO);
        financePO.setFscOrderId(fscOrderId);
        financePO.setCreateTime(new Date());
        financePO.setCreateUserId(reqBO.getUserName());
        financePO.setCreateUserName(reqBO.getName());
        financePO.setFinanceUserId(reqBO.getUserName());
        financePO.setFinanceUserName(reqBO.getName());
        financePO.setExt1(reqBO.getSupplierErpNo());
        financePO.setPaySource(Integer.valueOf(1));
        financePO.setExt4(String.valueOf(financePO.getExchangeRate().stripTrailingZeros()));
        int count = this.fscOrderFinanceMapper.insert(financePO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        int count;
        if (CollectionUtils.isEmpty(attachmentBOList)) {
            return;
        }
        FscAttachmentPO deletePo = new FscAttachmentPO();
        deletePo.setFscOrderId(fscOrderId);
        deletePo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
        ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletePo);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS) && (count = this.fscAttachmentMapper.deleteBy(deletePo)) != fscAttachmentPOS.size()) {
            throw new FscBusinessException("198888", "\u5220\u9664\u4ed8\u6b3e\u5355\u9644\u4ef6\u5931\u8d25\uff01");
        }
        fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
        for (AttachmentBO attachmentBO : attachmentBOList) {
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPo);
            fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAYMENT);
            fscAttachmentPo.setObjId(fscOrderId);
            fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
            fscAttachmentPo.setFscOrderId(fscOrderId);
            fscAttachmentPOS.add(fscAttachmentPo);
        }
        count = this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        if (count != fscAttachmentPOS.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u5355\u9644\u4ef6\u5931\u8d25\uff01");
        }
    }

    private void checkExistProcess(Long fscOrderId) {
        int count = this.fscOrderMapper.selectStepIdCount(fscOrderId, FscConstants.AuditObjType.PAY_APPLY_ORDER);
        if (count > 0) {
            throw new FscBusinessException("191019", "\u8be5\u5355\u636e\u5df2\u63d0\u4ea4\u5ba1\u6279");
        }
    }
}

