/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.finance.FscEngineeringRefundInvoiceCreateBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringRefundInvoiceCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringRefundInvoiceCreateBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundFlowProcKeyEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationTempMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.dao.FscRefundSerialMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscInvoiceRefundRelationTempPo;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.fsc.po.FscRefundSerialPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscEngineeringRefundInvoiceCreateBusiServiceImpl
implements FscEngineeringRefundInvoiceCreateBusiService {
    private static final String BUSI_NAME = "\u9000\u7968\u4e3b\u5355\u521b\u5efa";
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Resource
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscInvoiceRefundRelationTempMapper fscInvoiceRefundRelationTempMapper;
    @Resource
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Resource
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Resource
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Resource
    private FscRefundSerialMapper fscRefundSerialMapper;
    @Resource
    private FscShouldPayMapper fscShouldPayMapper;
    @Resource
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Resource
    private FscInvoiceMapper fscInvoiceMapper;
    @Resource
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;

    @Override
    public FscEngineeringRefundInvoiceCreateBusiRspBO dealEngineeringRefundInvoiceCreate(FscEngineeringRefundInvoiceCreateBusiReqBO reqBO) {
        boolean updateFlag = Boolean.FALSE;
        FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
        fscOrderRefundPO.setRefundId(reqBO.getRefundId());
        fscOrderRefundPO = this.fscOrderRefundMapper.getModelBy(fscOrderRefundPO);
        if (Objects.nonNull(fscOrderRefundPO)) {
            updateFlag = Boolean.TRUE;
        }
        if (updateFlag) {
            FscOrderRelationPO deleteRelationPO = new FscOrderRelationPO();
            deleteRelationPO.setRefundId(reqBO.getRefundId());
            this.fscOrderRelationMapper.deleteBy(deleteRelationPO);
            FscOrderItemPO deleteItemPO = new FscOrderItemPO();
            deleteItemPO.setRefundId(reqBO.getRefundId());
            this.fscOrderItemMapper.deleteBy(deleteItemPO);
            FscAttachmentPO deleteAttachPO = new FscAttachmentPO();
            deleteAttachPO.setFscOrderId(reqBO.getRefundId());
            this.fscAttachmentMapper.deleteBy(deleteAttachPO);
            this.fscInvoiceRefundRelationMapper.deleteByRefundId(reqBO.getRefundId());
        }
        FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
        fscOrderRelationTempPO.setRefundId(reqBO.getRefundId());
        List fscOrderRelationTempPOList = this.fscOrderRelationTempMapper.getList(fscOrderRelationTempPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationTempPOList)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5f00\u7968\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u63d0\u4ea4\uff01");
        }
        FscInvoiceRefundRelationTempPo fscInvoiceRefundRelationTempPo = new FscInvoiceRefundRelationTempPo();
        fscInvoiceRefundRelationTempPo.setRefundId(reqBO.getRefundId());
        List fscInvoiceRefundRelationTempPOList = this.fscInvoiceRefundRelationTempMapper.getList(fscInvoiceRefundRelationTempPo);
        if (CollectionUtils.isEmpty((Collection)fscInvoiceRefundRelationTempPOList)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u53d1\u7968\u5173\u8054\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u63d0\u4ea4\uff01");
        }
        FscAttachmentTempPO fscAttachmentTempPO = new FscAttachmentTempPO();
        fscAttachmentTempPO.setFscOrderId(reqBO.getRefundId());
        List fscAttachmentTempPOList = this.fscAttachmentTempMapper.getList(fscAttachmentTempPO);
        this.checkShouldPay(reqBO, fscInvoiceRefundRelationTempPOList);
        this.checkAdjust(reqBO);
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getFinanceList(orderItemPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u63d0\u4ea4\uff01");
        }
        Map fscOrderItemPOMap = fscOrderItemPOList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        BigDecimal[] qualityAmt = new BigDecimal[]{BigDecimal.ZERO};
        Map invoiceRefundRelationTempPoMap = fscInvoiceRefundRelationTempPOList.stream().collect(Collectors.toMap(FscInvoiceRefundRelationTempPo::getDetailId, Function.identity(), (k1, k2) -> k1));
        ArrayList refundOrderItemPOList = new ArrayList();
        ArrayList updateItemPOList = new ArrayList();
        ArrayList updateRelationPOList = new ArrayList();
        fscOrderRelationTempPOList.forEach(e -> {
            if (Objects.isNull(e.getSettleAmt()) || e.getSettleAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new FscBusinessException("190000", "\u9000\u7968\u91d1\u989d\u4e0d\u80fd\u4e3a0\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u63d0\u4ea4\uff01");
            }
            if (CollectionUtils.isEmpty((Map)fscOrderItemPOMap) || !fscOrderItemPOMap.containsKey(e.getOrderId())) {
                throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355\u660e\u7ec6\u5339\u914d\u9519\u8bef\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u63d0\u4ea4\uff01");
            }
            if (CollectionUtils.isEmpty((Map)invoiceRefundRelationTempPoMap) || !invoiceRefundRelationTempPoMap.containsKey(e.getOrderId())) {
                throw new FscBusinessException("190000", "\u9000\u7968\u660e\u7ec6\u5339\u914d\u9519\u8bef\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u63d0\u4ea4\uff01");
            }
            FscOrderItemPO fscOrderItemPO = (FscOrderItemPO)JSON.parseObject((String)JSON.toJSONString(fscOrderItemPOMap.get(e.getOrderId())), FscOrderItemPO.class);
            fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderItemPO.setFscOrderId(null);
            fscOrderItemPO.setAmt(Objects.isNull(e.getSettleAmt()) ? BigDecimal.ZERO : e.getSettleAmt());
            fscOrderItemPO.setUntaxAmt(((FscInvoiceRefundRelationTempPo)invoiceRefundRelationTempPoMap.get(e.getOrderId())).getUntaxAmt());
            fscOrderItemPO.setTaxAmt(((FscInvoiceRefundRelationTempPo)invoiceRefundRelationTempPoMap.get(e.getOrderId())).getTaxAmt());
            fscOrderItemPO.setRefundId(reqBO.getRefundId());
            fscOrderItemPO.setNum(BigDecimal.ZERO);
            fscOrderItemPO.setInvoiceItemId(((FscOrderItemPO)fscOrderItemPOMap.get(e.getOrderId())).getId());
            fscOrderItemPO.setRefundAmt(fscOrderItemPO.getAmt());
            if (Objects.nonNull(fscOrderItemPO.getQualityAmt()) && fscOrderItemPO.getQualityAmt().compareTo(BigDecimal.ZERO) > 0) {
                fscOrderItemPO.setQualityAmt(fscOrderItemPO.getAmt());
                qualityAmt[0] = qualityAmt[0].add(fscOrderItemPO.getQualityAmt());
            }
            refundOrderItemPOList.add(fscOrderItemPO);
            FscOrderItemPO updatePO = new FscOrderItemPO();
            updatePO.setId(((FscOrderItemPO)fscOrderItemPOMap.get(e.getOrderId())).getId());
            updatePO.setRefundAmt(fscOrderItemPO.getAmt());
            updateItemPOList.add(updatePO);
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderRelationPO.setOrderId(e.getOrderId());
            fscOrderRelationPO.setRefundAmt(fscOrderItemPO.getAmt());
            updateRelationPOList.add(fscOrderRelationPO);
        });
        if (qualityAmt[0].compareTo(BigDecimal.ZERO) > 0) {
            reqBO.setIsQuality(FscConstants.IsQuality.YES);
            reqBO.setQualityAmt(qualityAmt[0]);
        }
        this.checkRefundAmt(reqBO, fscInvoiceRefundRelationTempPOList);
        BigDecimal refundAmount = fscInvoiceRefundRelationTempPOList.stream().map(FscInvoiceRefundRelationTempPo::getRefundAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        FscOrderRefundPO refundPO = this.buildRefundOrderInfo(reqBO, updateFlag, refundAmount);
        BigDecimal writeOffAmt = BigDecimal.ZERO;
        FscFinanceWriteOffPO fscFinanceWriteOffPO = this.fscFinanceWriteOffMapper.sumAmtByFscOrderId(reqBO.getFscOrderId());
        if (null != fscFinanceWriteOffPO && null != fscFinanceWriteOffPO.getWriteOffAmt()) {
            writeOffAmt = fscFinanceWriteOffPO.getWriteOffAmt();
        }
        BigDecimal paidShouldAmt = this.fscShouldPayMapper.sumShouldPayAmtByObjectId(reqBO.getFscOrderId());
        BigDecimal paidAmt = writeOffAmt.add(paidShouldAmt);
        refundPO.setActualPaidAmount(paidAmt);
        FscRefundFinancePO fscRefundFinancePO = (FscRefundFinancePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscRefundFinancePO.class);
        if (!updateFlag) {
            fscRefundFinancePO.setCreateUserId(reqBO.getUserId());
            fscRefundFinancePO.setCreateUserAccount(reqBO.getUserName());
            fscRefundFinancePO.setCreateUserName(reqBO.getName());
            fscRefundFinancePO.setCreateTime(new Date());
        }
        fscRefundFinancePO.setExt3(reqBO.getCwOrgId());
        fscRefundFinancePO.setUpdateUserId(reqBO.getUserId());
        fscRefundFinancePO.setUpdateUserName(reqBO.getName());
        fscRefundFinancePO.setUpdateTime(new Date());
        fscRefundFinancePO.setPushFinanceStatus(FscConstants.FscPushStatus.NO_PUSH);
        if (updateFlag) {
            this.fscRefundFinanceMapper.updateById(fscRefundFinancePO);
            this.fscOrderRefundMapper.updateById(refundPO);
        } else {
            this.fscRefundFinanceMapper.insert(fscRefundFinancePO);
            this.fscOrderRefundMapper.insert(refundPO);
        }
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationTempPOList)) {
            this.fscOrderRelationMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString((Object)fscOrderRelationTempPOList), FscOrderRelationPO.class));
        }
        if (!CollectionUtils.isEmpty(refundOrderItemPOList)) {
            this.fscOrderItemMapper.insertBatch(refundOrderItemPOList);
        }
        if (!CollectionUtils.isEmpty((Collection)fscInvoiceRefundRelationTempPOList)) {
            this.fscInvoiceRefundRelationMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString((Object)fscInvoiceRefundRelationTempPOList), FscInvoiceRefundRelationPO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentTempPOList)) {
            this.fscAttachmentMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString((Object)fscAttachmentTempPOList), FscAttachmentPO.class));
        }
        if (FscConstants.RefundOperationType.SUBMIT.equals(reqBO.getOperationType())) {
            int count;
            if (!CollectionUtils.isEmpty(updateItemPOList)) {
                count = this.fscOrderItemMapper.updateBatchRefundAmt(updateItemPOList);
                if (updateItemPOList.size() != count) {
                    throw new FscBusinessException("198888", "\u5b58\u5728\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u53ef\u9000\u7968\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
                }
            }
            if (!CollectionUtils.isEmpty(updateRelationPOList) && (count = this.fscOrderRelationMapper.updateBatchEngineeringRefundAmt(updateRelationPOList)) == 0) {
                throw new FscBusinessException("198888", "\u5b58\u5728\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u53ef\u9000\u7968\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            }
            this.handelSerialNo(reqBO);
            this.dealWorkFlow(refundPO);
        }
        FscEngineeringRefundInvoiceCreateBusiRspBO rspBO = new FscEngineeringRefundInvoiceCreateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkShouldPay(FscEngineeringRefundInvoiceCreateBusiReqBO reqBO, List<FscInvoiceRefundRelationTempPo> fscInvoiceRefundRelationTempPOList) {
        List detailIds = fscInvoiceRefundRelationTempPOList.stream().map(FscInvoiceRefundRelationTempPo::getDetailId).distinct().collect(Collectors.toList());
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setObjectId(reqBO.getFscOrderId());
        fscShouldPayPO.setOrderIds(detailIds);
        List fscShouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            return;
        }
        List payingList = fscShouldPayPOList.stream().filter(e -> Objects.nonNull(e.getPayingAmount()) && e.getPayingAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(payingList)) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u4ed8\u6b3e\u4e2d\u7684\u5e94\u4ed8\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u7968\u6d41\u7a0b\uff01");
        }
    }

    private void checkAdjust(FscEngineeringRefundInvoiceCreateBusiReqBO reqBO) {
        FscFinanceWriteOffAdjustPO fscFinanceWriteOffAdjustPO = new FscFinanceWriteOffAdjustPO();
        fscFinanceWriteOffAdjustPO.setFscOrderId(reqBO.getFscOrderId());
        List adjustPOList = this.fscFinanceWriteOffAdjustMapper.queryTransitList(fscFinanceWriteOffAdjustPO);
        if (!CollectionUtils.isEmpty((Collection)adjustPOList)) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u5728\u9014\u7684\u8865\u6838\u9500\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u7968\u6d41\u7a0b\uff01");
        }
    }

    private void checkRefundAmt(FscEngineeringRefundInvoiceCreateBusiReqBO reqBO, List<FscInvoiceRefundRelationTempPo> fscInvoiceRefundRelationTempPOList) {
        if (FscConstants.RefundReasonType.INVOICE_ERROR.equals(reqBO.getRefundReasonType())) {
            reqBO.setIsInvoiceChange(1);
            List invoiceIds = fscInvoiceRefundRelationTempPOList.stream().map(FscInvoiceRefundRelationTempPo::getInvoiceId).collect(Collectors.toList());
            FscInvoicePO searchInvoicePO = new FscInvoicePO();
            searchInvoicePO.setFscOrderId(reqBO.getFscOrderId());
            searchInvoicePO.setInvoiceIds(invoiceIds);
            List invoiceList = this.fscInvoiceMapper.getList(searchInvoicePO);
            Map<Long, BigDecimal> invoicePOMap = invoiceList.stream().collect(Collectors.toMap(FscInvoicePO::getInvoiceId, FscInvoicePO::getAmt, (k1, k2) -> k1));
            fscInvoiceRefundRelationTempPOList.forEach(e -> {
                if (CollectionUtils.isEmpty((Map)invoicePOMap) || !invoicePOMap.containsKey(e.getInvoiceId())) {
                    throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u539f\u53d1\u7968\u4fe1\u606f\uff0c\u53d1\u7968id\uff1a" + e.getInvoiceId());
                }
                if (e.getRefundAmt().compareTo((BigDecimal)invoicePOMap.get(e.getInvoiceId())) != 0) {
                    throw new FscBusinessException("198888", "\u5f53\u9000\u7968\u539f\u56e0\u4e3a\u201c\u53d1\u7968\u95ee\u9898\u201d\u65f6\uff0c\u9000\u7968\u7533\u8bf7\u9000\u7968\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u539f\u53d1\u7968\u91d1\u989d\uff01");
                }
            });
        }
    }

    private void handelSerialNo(FscEngineeringRefundInvoiceCreateBusiReqBO reqBO) {
        if (!StringUtils.isEmpty((Object)reqBO.getRefundNo())) {
            int index = reqBO.getRefundNo().indexOf("-");
            if (index == -1 || reqBO.getRefundNo().length() < index + 1) {
                throw new FscBusinessException("198888", "\u9000\u6b3e\u5355\u53f7\u683c\u5f0f\u5f02\u5e38\uff01");
            }
            String fscOrderNo = reqBO.getRefundNo().substring(0, index);
            String num = reqBO.getRefundNo().substring(index + 1);
            FscRefundSerialPO fscRefundSerialPO = new FscRefundSerialPO();
            if ("01".equals(num)) {
                fscRefundSerialPO.setFscOrderNo(fscOrderNo);
                fscRefundSerialPO.setNum(Integer.valueOf(1));
                int count = this.fscRefundSerialMapper.insert(fscRefundSerialPO);
                if (count == 0) {
                    throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u9000\u6b3e\u5355\u6d41\u6c34\u53f7\u5f02\u5e38\uff01");
                }
            } else {
                fscRefundSerialPO.setFscOrderNo(fscOrderNo);
                int count = this.fscRefundSerialMapper.updateNumByOrderNo(fscRefundSerialPO);
                if (count == 0) {
                    throw new FscBusinessException("198888", "\u66f4\u65b0\u7ed3\u7b97\u9000\u6b3e\u5355\u6d41\u6c34\u53f7\u5f02\u5e38\uff01");
                }
            }
        }
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusStartAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusStartAtomReqBO.setOrderFlowKey(refundPO.getOrderFlowKey());
        fscOrderStatusStartAtomReqBO.setOrderFlow(refundPO.getOrderFlow());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("startFlag", 0);
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealRefundStatusStart(fscOrderStatusStartAtomReqBO);
        if (!fscOrderStatusStartAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusStartAtomRspBO.getRespCode(), fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private FscOrderRefundPO buildRefundOrderInfo(FscEngineeringRefundInvoiceCreateBusiReqBO reqBO, boolean updateFlag, BigDecimal refundAmount) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO.setOrderFlow(FscConstants.OrderFlow.ENGINEERING_INVOICE);
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        BeanUtils.copyProperties((Object)orderPO, (Object)refundPO);
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO.setRefundNo(reqBO.getRefundNo());
        refundPO.setAgentDeptId(reqBO.getAgentDeptId());
        refundPO.setAgentDeptName(reqBO.getAgentDeptName());
        refundPO.setAgentUserId(reqBO.getAgentUserId());
        refundPO.setAgentUserName(reqBO.getAgentUserName());
        refundPO.setAuditStatus(FscConstants.AuditStatus.SAVE);
        refundPO.setRefundNote(reqBO.getRefundNote());
        refundPO.setRefundReason(reqBO.getRefundReason());
        refundPO.setRefundReasonType(reqBO.getRefundReasonType());
        refundPO.setTotalCharge(orderPO.getTotalCharge());
        refundPO.setCertification(reqBO.getCertification());
        if (!updateFlag) {
            refundPO.setCreateTime(new Date());
            refundPO.setCreateUserId(reqBO.getUserId());
            refundPO.setCreateUserName(reqBO.getName());
        }
        refundPO.setUpdateTime(new Date());
        refundPO.setRefundStatus(FscConstants.RefundInvoiceStatus.SAVE);
        refundPO.setPushStatus(FscConstants.RefundPushStatus.UN_PUSH);
        refundPO.setFscOrderNo(orderPO.getOrderNo());
        refundPO.setOrderFlow(FscConstants.OrderFlow.ENGINEERING_INVOICE_REFUND);
        refundPO.setSettlePlatform(orderPO.getSettlePlatform());
        refundPO.setOrderFlowKey(FscRefundFlowProcKeyEnum.ENGINEERING_INVOICE_REFUND.getDescr());
        refundPO.setIsQuality(reqBO.getIsQuality());
        refundPO.setQualityAmt(reqBO.getQualityAmt());
        refundPO.setIsInvoiceChange(reqBO.getIsInvoiceChange());
        refundPO.setRefundAmount(refundAmount);
        refundPO.setTradeMode(FscConstants.FscTradeMode.MATCHMAKING_MODE);
        if (FscConstants.RefundReasonType.INVOICE_ERROR.equals(reqBO.getRefundReasonType())) {
            refundPO.setIsInvoiceChange(Integer.valueOf(1));
        }
        return refundPO;
    }
}

