/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.finance.FscEngineeringReopenInvoiceBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillReopenInvoiceBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillReopenInvoiceBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderItemTempMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderItemTempPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscEngineeringReopenInvoiceBusiServiceImpl
implements FscEngineeringReopenInvoiceBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscEngineeringReopenInvoiceBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Resource
    private FscOrderItemTempMapper fscOrderItemTempMapper;
    @Resource
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Resource
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;

    @Override
    public FscBillReopenInvoiceBusiRspBO dealEngineeringInvoiceReopen(FscBillReopenInvoiceBusiReqBO reqBO) {
        boolean updateFlag = Boolean.FALSE;
        FscOrderPO orderPO = new FscOrderPO();
        if (Objects.nonNull(reqBO.getNewFscOrderId())) {
            orderPO.setFscOrderId(reqBO.getNewFscOrderId());
            orderPO = this.fscOrderMapper.getModelBy(orderPO);
            if (Objects.isNull(orderPO)) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5!");
            }
            updateFlag = Boolean.TRUE;
        } else {
            FscOrderPO beforeOrderPO = new FscOrderPO();
            beforeOrderPO.setFscOrderId(reqBO.getFscOrderId());
            orderPO = this.fscOrderMapper.getModelBy(beforeOrderPO);
            if (Objects.isNull(orderPO)) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5!");
            }
        }
        if (!updateFlag) {
            this.handleInsert(orderPO, reqBO);
        } else {
            this.handleUpdate(reqBO);
        }
        FscBillReopenInvoiceBusiRspBO rspBO = new FscBillReopenInvoiceBusiRspBO();
        if (FscConstants.FscOrderOperType.save.equals(reqBO.getOperType())) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(Collections.singletonList(reqBO.getNewFscOrderId()));
            fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.DRAFT);
            int count = this.fscOrderMapper.dealSave(fscOrderPO);
            if (count != 1) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u7ed3\u7b97\u4e3b\u5355\u72b6\u6001\u5931\u8d25\uff01");
            }
        } else {
            FscOrderStatusStartAtomReqBO atomReqBO = (FscOrderStatusStartAtomReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
            atomReqBO.setOrderFlow(orderPO.getOrderFlow());
            atomReqBO.setOrderId(reqBO.getNewFscOrderId());
            atomReqBO.setOperId(reqBO.getUserName());
            FscOrderStatusStartAtomRspBO atomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193008", atomRspBO.getRespDesc());
            }
        }
        rspBO.setFscOrderIds(Collections.singletonList(reqBO.getNewFscOrderId()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealReopenOrder(FscOrderPO orderPO, FscBillReopenInvoiceBusiReqBO reqBO) {
        orderPO.setOrderNo(reqBO.getFscOrderNo());
        orderPO.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
        orderPO.setRefundId(reqBO.getRefundId());
        orderPO.setCreateTime(new Date());
        orderPO.setCreateCompanyId(reqBO.getCompanyId());
        orderPO.setCreateCompanyName(reqBO.getCompanyName());
        orderPO.setCreateOrgId(reqBO.getOrgId());
        orderPO.setCreateOrgName(reqBO.getOrgName());
        orderPO.setCreateOperId(reqBO.getUserId());
        orderPO.setCreateOperName(reqBO.getName());
        orderPO.setInvoiceRemark(reqBO.getInvoiceRemark());
        orderPO.setSettlePlatform(reqBO.getSettlePlatform());
        orderPO.setRemark(reqBO.getRemark());
    }

    private void handleUpdate(FscBillReopenInvoiceBusiReqBO reqBO) {
        if (Objects.isNull(reqBO.getNewFscOrderId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2newFscOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscAttachmentPO deleteAttachmentPO = new FscAttachmentPO();
        deleteAttachmentPO.setFscOrderId(reqBO.getNewFscOrderId());
        this.fscAttachmentMapper.deleteBy(deleteAttachmentPO);
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(reqBO.getNewFscOrderId());
        this.fscOrderRelationMapper.deleteBy(fscOrderRelationPO);
        FscOrderRelationTempPO fscOrderRelationTempPO = new FscOrderRelationTempPO();
        fscOrderRelationTempPO.setFscOrderId(reqBO.getNewFscOrderId());
        List fscOrderRelationTempPOList = this.fscOrderRelationTempMapper.getList(fscOrderRelationTempPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationTempPOList)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5f00\u7968\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        FscAttachmentTempPO fscAttachmentTempPO = new FscAttachmentTempPO();
        fscAttachmentTempPO.setFscOrderId(reqBO.getNewFscOrderId());
        List fscAttachmentTempPOList = this.fscAttachmentTempMapper.getList(fscAttachmentTempPO);
        int count = this.fscOrderRelationMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString((Object)fscOrderRelationTempPOList), FscOrderRelationPO.class));
        if (count != fscOrderRelationTempPOList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentTempPOList) && (count = this.fscAttachmentMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString((Object)fscAttachmentTempPOList), FscAttachmentPO.class))) == 0) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u9644\u4ef6\u8868\u5931\u8d25\uff01");
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getNote())) {
            FscOrderFinancePO orderFinancePO = new FscOrderFinancePO();
            orderFinancePO.setFscOrderId(reqBO.getNewFscOrderId());
            orderFinancePO.setNote(reqBO.getNote());
            this.fscOrderFinanceMapper.updateById(orderFinancePO);
        }
    }

    private void handleInsert(FscOrderPO orderPO, FscBillReopenInvoiceBusiReqBO reqBO) {
        int count;
        this.dealReopenOrder(orderPO, reqBO);
        reqBO.setNewFscOrderId(orderPO.getFscOrderId());
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setRefundId(reqBO.getRefundId());
        List refundItemList = this.fscOrderItemMapper.getListNoPage(orderItemPO);
        if (CollectionUtils.isEmpty((Collection)refundItemList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
        }
        List orderIdList = refundItemList.stream().map(FscOrderItemPO::getOrderId).collect(Collectors.toList());
        orderItemPO = new FscOrderItemPO();
        orderItemPO.setOrderIds(orderIdList);
        orderItemPO.setFscOrderId(reqBO.getFscOrderId());
        List orderItemList = this.fscOrderItemMapper.getListNoPage(orderItemPO);
        if (CollectionUtils.isEmpty((Collection)orderItemList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
        }
        Map refundMap = refundItemList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        orderItemList.forEach(e -> {
            if (CollectionUtils.isEmpty((Map)refundMap) || !refundMap.containsKey(e.getOrderId())) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u539f\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            FscOrderItemPO refundItemPO = (FscOrderItemPO)refundMap.get(e.getOrderId());
            e.setAmt(refundItemPO.getAmt());
            e.setUntaxAmt(refundItemPO.getUntaxAmt());
            e.setTaxAmt(refundItemPO.getTaxAmt());
            e.setNum(refundItemPO.getNum());
            e.setQualityAmt(Objects.nonNull(e.getQualityAmt()) && e.getQualityAmt().compareTo(BigDecimal.ZERO) > 0 ? e.getAmt() : BigDecimal.ZERO);
            e.setId(Long.valueOf(Sequence.getInstance().nextId()));
            e.setFscOrderId(reqBO.getNewFscOrderId());
            e.setRefundAmt(BigDecimal.ZERO);
            e.setRefundId(null);
        });
        HashMap contractRemarkMap = new HashMap();
        ArrayList attachmentList = new ArrayList();
        if (!CollectionUtils.isEmpty(reqBO.getContractParamList())) {
            reqBO.getContractParamList().forEach(e -> {
                if (Objects.isNull(e.getContractId())) {
                    throw new FscBusinessException("198888", "\u9644\u4ef6\u548c\u5907\u6ce8\u5165\u53c2\u4e2d\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (Objects.nonNull(e.getContractRemark())) {
                    contractRemarkMap.put(e.getContractId(), e.getContractRemark());
                }
                if (!CollectionUtils.isEmpty((Collection)e.getAttachmentList())) {
                    e.getAttachmentList().forEach(attachmentBO -> {
                        FscAttachmentPO attachmentPO = (FscAttachmentPO)JSON.parseObject((String)JSON.toJSONString((Object)attachmentBO), FscAttachmentPO.class);
                        attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                        attachmentPO.setFscOrderId(reqBO.getNewFscOrderId());
                        attachmentPO.setObjId(e.getContractId());
                        attachmentPO.setObjType(FscConstants.AttachmentObjType.FSC_ORDER);
                        attachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER);
                        attachmentPO.setCreateUserId(reqBO.getUserId());
                        attachmentPO.setCreateUser(reqBO.getUserName());
                        attachmentPO.setCreateTime(new Date());
                        attachmentList.add(attachmentPO);
                    });
                }
            });
        }
        FscOrderRelationPO fscRelationPO = new FscOrderRelationPO();
        fscRelationPO.setFscOrderId(reqBO.getFscOrderId());
        fscRelationPO.setOrderIds(orderIdList);
        List relationList = this.fscOrderRelationMapper.getListNoPage(fscRelationPO);
        relationList.forEach(e -> {
            if (CollectionUtils.isEmpty((Map)refundMap) || !refundMap.containsKey(e.getOrderId())) {
                throw new FscBusinessException("198888", "\u83b7\u53d6\u539f\u7ed3\u7b97\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
            }
            FscOrderItemPO refundItemPO = (FscOrderItemPO)refundMap.get(e.getOrderId());
            e.setSettleAmt(refundItemPO.getAmt());
            e.setAmount(refundItemPO.getAmt());
            e.setQualityAmt(Objects.nonNull(e.getQualityAmt()) && e.getQualityAmt().compareTo(BigDecimal.ZERO) > 0 ? e.getSettleAmt() : BigDecimal.ZERO);
            e.setId(Long.valueOf(Sequence.getInstance().nextId()));
            e.setFscOrderId(reqBO.getNewFscOrderId());
            e.setRefundAmt(BigDecimal.ZERO);
            e.setRefundId(null);
            e.setContractRemark(null);
            if (!CollectionUtils.isEmpty((Map)contractRemarkMap) && contractRemarkMap.containsKey(e.getContractId())) {
                e.setContractRemark((String)contractRemarkMap.get(e.getContractId()));
            }
        });
        BigDecimal totalCharge = orderItemList.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        orderPO.setTotalCharge(totalCharge);
        orderPO.setToPayAmount(totalCharge);
        FscOrderInvoicePO orderInvoicePO = new FscOrderInvoicePO();
        orderInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        orderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(orderInvoicePO);
        FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)orderInvoicePO), FscOrderInvoicePO.class);
        fscOrderInvoicePo.setBillOperId(reqBO.getUserId().toString());
        fscOrderInvoicePo.setFscOrderId(orderPO.getFscOrderId());
        fscOrderInvoicePo.setBillOperName(reqBO.getName());
        fscOrderInvoicePo.setBillTime(new Date());
        fscOrderInvoicePo.setBillTimeStart(new Date());
        fscOrderInvoicePo.setAccountSetId(orderInvoicePO.getAccountSetId());
        fscOrderInvoicePo.setAccountSetName(orderInvoicePO.getAccountSetName());
        fscOrderInvoicePo.setInvoiceCategory(orderInvoicePO.getInvoiceCategory());
        orderPO.setBuyName(fscOrderInvoicePo.getBuyName());
        FscOrderFinancePO orderFinancePO = new FscOrderFinancePO();
        orderFinancePO.setFscOrderId(reqBO.getFscOrderId());
        orderFinancePO = this.fscOrderFinanceMapper.getModelBy(orderFinancePO);
        if (orderFinancePO != null) {
            orderFinancePO.setFscOrderId(orderPO.getFscOrderId());
            orderFinancePO.setCreateUserId(reqBO.getUserName());
            orderFinancePO.setCreateUserName(reqBO.getName());
            orderFinancePO.setCreateTime(new Date());
            orderFinancePO.setUpdateUserId(reqBO.getUserName());
            orderFinancePO.setUpdateUserName(reqBO.getName());
            orderFinancePO.setUpdateTime(new Date());
            orderFinancePO.setPushFinanceStatus(FscConstants.FscPushStatus.NO_PUSH);
            orderFinancePO.setPushFinanceRemark(null);
            orderFinancePO.setNote(reqBO.getNote());
            orderFinancePO.setFinanceAuditAccount(null);
            orderFinancePO.setFinanceAuditName(null);
            orderFinancePO.setPostingDate(null);
            orderFinancePO.setPostingStatus("0");
            orderFinancePO.setPaySource(null);
            orderFinancePO.setExt4(String.valueOf(orderFinancePO.getExchangeRate().stripTrailingZeros()));
            count = this.fscOrderFinanceMapper.insert(orderFinancePO);
            if (count != 1) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        if ((count = this.fscOrderInvoiceMapper.insert(fscOrderInvoicePo)) != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList<FscOrderPO> orderPOList = new ArrayList<FscOrderPO>();
        orderPOList.add(orderPO);
        count = this.fscOrderMapper.insertBatch(orderPOList);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        count = this.fscOrderItemMapper.insertBatch(orderItemList);
        if (count != orderItemList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        count = this.fscOrderRelationMapper.insertBatch(relationList);
        if (count != relationList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(attachmentList) && (count = this.fscAttachmentMapper.insertBatch(attachmentList)) == 0) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u9644\u4ef6\u8868\u5931\u8d25\uff01");
        }
        if (FscConstants.FscOrderOperType.save.equals(reqBO.getOperType())) {
            this.fscOrderItemTempMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString((Object)orderItemList), FscOrderItemTempPO.class));
            this.fscOrderRelationTempMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString((Object)relationList), FscOrderRelationTempPO.class));
            if (!CollectionUtils.isEmpty(attachmentList)) {
                this.fscAttachmentTempMapper.insertBatch(JSON.parseArray((String)JSON.toJSONString(attachmentList), FscAttachmentTempPO.class));
            }
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO.setReopenFscOrderId(orderPO.getFscOrderId());
        refundPO.setReopenFlag(FscConstants.ReopenFlag.YES);
        count = this.fscOrderRefundMapper.updateById(refundPO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u51b2\u9500\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }
}

