/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bill.ability.api.FscBillOrderFeedbackAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderFeedbackAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderFeedbackAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderFeedbackBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderFeedbackBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderFeedbackBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderFeedbackAbilityService"})
public class FscBillOrderFeedbackAbilityServiceImpl
implements FscBillOrderFeedbackAbilityService {
    @Autowired
    private FscBillOrderFeedbackBusiService fscBillOrderFeedbackBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderFeedback"})
    public FscBillOrderFeedbackAbilityRspBO dealOrderFeedback(@RequestBody FscBillOrderFeedbackAbilityReqBO reqBO) {
        this.verification(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPO);
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscBillOrderFeedbackBusiReqBO busiReqBO = (FscBillOrderFeedbackBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscBillOrderFeedbackBusiReqBO.class));
        if (null != fscOrder.getMakeType() && "2".equals(fscOrder.getOrderSource().toString())) {
            busiReqBO.setOrderSource(Integer.valueOf("2"));
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(fscOrder.getFscOrderId());
            List fscOrderItemPos = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemPos)) throw new FscBusinessException("191015", "\u67e5\u8be2\u7ed3\u7b97\u5355\u660e\u7ec6\u4e3a\u7a7a");
            List acceptIds = fscOrderItemPos.stream().map(FscOrderItemPO::getAcceptOrderId).collect(Collectors.toList());
            FscCheckResultPO fscCheckResultPO = new FscCheckResultPO();
            fscCheckResultPO.setAcceptOrderIds(acceptIds);
            List checkResults = this.fscCheckResultMapper.getList(fscCheckResultPO);
            if (CollectionUtils.isEmpty((Collection)checkResults)) throw new FscBusinessException("191015", "\u67e5\u8be2\u5bf9\u8d26\u7ed3\u679c\u4e3a\u7a7a");
            boolean allMatch = checkResults.stream().allMatch(fscCheckResult -> FscConstants.BillCheck.EQUALS.equals(fscCheckResult.getStatus()));
            if (!allMatch) {
                throw new FscBusinessException("191015", "\u5b58\u5728\u5bf9\u8d26\u4e0d\u4e00\u81f4\u8ba2\u5355\uff0c\u65e0\u6cd5\u53cd\u9988\uff0c\u8bf7\u786e\u8ba4");
            }
        } else if (!FscBillStatus.PENDING_FEEDBACK.getCode().equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("191015", "\u53ea\u6709\u5f85\u53cd\u9988\u72b6\u6001\u80fd\u591f\u53cd\u9988\u7ed3\u7b97\u5355");
        }
        busiReqBO.setOrderSource(fscOrder.getOrderSource());
        FscBillOrderFeedbackBusiRspBO busiRspBO = this.fscBillOrderFeedbackBusiService.dealOrderFeedback(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191015", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return new FscBillOrderFeedbackAbilityRspBO();
    }

    private void verification(FscBillOrderFeedbackAbilityReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscBillOrderFeedbackAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

