/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignApplyAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignApplyAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignApplyAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillSendPurFscOrderToYCAbilityBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApplyBusiRspBO;
import com.tydic.fsc.bo.InvoiceCmpResultBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.esb.FscBillTaxSendPurFscOrderToYCService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscInvoiceSignErrorMsgEnum;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePoolMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignApplyAbilityService"})
public class FscBillOrderInvoiceSignApplyAbilityServiceImpl
implements FscBillOrderInvoiceSignApplyAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscBillOrderInvoiceSignApplyBusiService fscBillOrderInvoiceSignApplyBusiService;
    private static BigDecimal TAX_AMOUNT_OTHER_CHECK = BigDecimal.ZERO;
    private static BigDecimal TOTAL_AMOUNT_EX_OTHER_CHECK = BigDecimal.ZERO;
    private static final String REPLACE_KEY = "#replace#";
    private static final String REPLACE_LIMIT_AMT = "##";
    private static final String ERROR_MSG_TITLE_BEGIN = "\u7ed3\u7b97\u5355";
    private static final String ERROR_MSG_TITLE_END = "\u4e0d\u7b26\u5408\u7b7e\u6536\u89c4\u5219\uff0c\u539f\u56e0\u5982\u4e0b\uff1a<br>";
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoicePoolMapper fscInvoicePoolMapper;
    @Autowired
    private FscBillTaxSendPurFscOrderToYCService fscBillTaxSendPurFscOrderToYCService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscPayVerificationAbilityService fscPayVerificationAbilityService;
    private static final Integer IN = 1;
    private static final Integer OUT = 2;
    @Value(value="${OPER_ORG_ID}")
    private String operOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderInvoiceSignApply"})
    public FscBillOrderInvoiceSignApplyAbilityRspBO dealOrderInvoiceSignApply(@RequestBody FscBillOrderInvoiceSignApplyAbilityReqBO reqBO) {
        FscBillOrderInvoiceSignApplyBusiRspBO fscBillOrderInvoiceSignApplyBusiRspBO;
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (!FscConstants.FscInvoiceOrderState.BILLED.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + fscOrderPO.getOrderState() + "]\u4e0d\u5141\u8bb8\u7b7e\u6536");
        }
        if (!"0".equals(reqBO.getAutoSignFlag()) && FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            this.valCmpResult(reqBO);
            this.checkCmpResult(reqBO.getInvoiceCmpResult(), fscOrderPO);
        }
        FscBillOrderInvoiceSignApplyBusiReqBO fscBillOrderInvoiceSignBusiReqBO = (FscBillOrderInvoiceSignApplyBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillOrderInvoiceSignApplyBusiReqBO.class));
        fscBillOrderInvoiceSignBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow()) && ("up_a".equals(reqBO.getSignSource()) || "up_b".equals(reqBO.getSignSource()))) {
            this.valUp(reqBO);
        }
        if (!"0000".equals((fscBillOrderInvoiceSignApplyBusiRspBO = this.fscBillOrderInvoiceSignApplyBusiService.dealOrderInvoiceSignApply(fscBillOrderInvoiceSignBusiReqBO)).getRespCode())) {
            throw new FscBusinessException("191019", fscBillOrderInvoiceSignApplyBusiRspBO.getRespDesc());
        }
        return new FscBillOrderInvoiceSignApplyAbilityRspBO();
    }

    private void checkCmpResult(InvoiceCmpResultBO invoiceCmpResultBO, FscOrderPO fscOrderPO) {
        this.checkCfcParam(invoiceCmpResultBO, fscOrderPO.getOrderSource());
        if (invoiceCmpResultBO.getCmpResultStr().contains(FscConstants.FscInvoiceVerifyResult.NO.toString())) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(ERROR_MSG_TITLE_BEGIN);
            errorMsg.append(fscOrderPO.getOrderNo());
            errorMsg.append(ERROR_MSG_TITLE_END);
            int strLen = invoiceCmpResultBO.getCmpResultStr().length();
            int seq = 1;
            for (int i = 0; i < strLen; ++i) {
                if (invoiceCmpResultBO.getCmpResultStr().charAt(i) == FscConstants.FscInvoiceVerifyResult.NO.toString().charAt(0)) {
                    errorMsg.append(seq);
                    errorMsg.append(FscInvoiceSignErrorMsgEnum.getInstance((Integer)seq).getDescr());
                    ++seq;
                }
                if (i == 5) break;
            }
            if (invoiceCmpResultBO.getAmountMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getAmountMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getUntaxAmtMargin().compareTo(TOTAL_AMOUNT_EX_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.UNTAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getUntaxAmtMargin().toString()).replace(REPLACE_LIMIT_AMT, TOTAL_AMOUNT_EX_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getTaxMargin().compareTo(TAX_AMOUNT_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.TAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getTaxMargin().toString()).replace(REPLACE_LIMIT_AMT, TAX_AMOUNT_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getItemNumMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.ITEM.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getItemNumMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getPoolCmpResultNum() > 0) {
                errorMsg.append(seq);
                errorMsg.append("\u3001\u8fdb\u9879\u53d1\u7968\u660e\u7ec6\u603b\u8ba1\u6709" + invoiceCmpResultBO.getPoolCmpResultNum() + "\u9879\u65e0\u6cd5\u5339\u914d\uff1b<br>");
                ++seq;
            }
            if (seq > 1) {
                throw new FscBusinessException("191035", errorMsg.toString());
            }
        }
    }

    private void val(FscBillOrderInvoiceSignApplyAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
    }

    private void valCmpResult(FscBillOrderInvoiceSignApplyAbilityReqBO reqBO) {
        if (null == reqBO.getInvoiceCmpResult()) {
            throw new FscBusinessException("191000", "\u5165\u53c2invoiceCmpResult\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getUntaxAmtMargin()) {
            throw new FscBusinessException("191000", "\u5165\u53c2untaxAmtMargin\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getTaxMargin()) {
            throw new FscBusinessException("191000", "\u5165\u53c2taxMargin\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getAmountMargin()) {
            throw new FscBusinessException("191000", "\u5165\u53c2amountMargin\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInvoiceCmpResult().getCmpResultStr())) {
            throw new FscBusinessException("191000", "\u5165\u53c2cmpResultStr\u4e3a\u7a7a");
        }
    }

    private void valUp(FscBillOrderInvoiceSignApplyAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getDeptId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[deptId]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getDeptName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[deptName]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPersonId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[personId]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPersonName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[personName]\u4e3a\u7a7a");
        }
        if (null == reqBO.getYcUserId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[ycUserId]\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPurWriteOffAmount())) {
            for (FscBillSendPurFscOrderToYCAbilityBO purBO : reqBO.getPurWriteOffAmount()) {
                if (null == purBO.getPayOrderId()) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[purWriteOffAmount]\u7684[payOrderId]\u4e3a\u7a7a");
                }
                if (purBO.getWriteOffAmount().compareTo(new BigDecimal(0)) > 0) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2[purWriteOffAmount]\u7684[writeOffAmount]\u4e3a\u7a7a");
            }
        }
    }

    private void checkCfcParam(InvoiceCmpResultBO invoiceCmpResultBO, Integer orderSource) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_check_" + orderSource);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        StringBuffer cmpResult = new StringBuffer(invoiceCmpResultBO.getCmpResultStr());
        char resultYesChar = FscConstants.FscInvoiceVerifyResult.YES.toString().charAt(0);
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceTitleCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BUY_NAME.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxpayerIdCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.TAX_NO.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAddressCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ADDRESS.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getPhoneCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.PHONE.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getBankCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BANK.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAccountCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ACCOUNT.getCode() - 1, resultYesChar);
        }
        invoiceCmpResultBO.setCmpResultStr(cmpResult.toString());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountCheck())) {
            invoiceCmpResultBO.setAmountMargin(BigDecimal.ZERO);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExCheck())) {
            invoiceCmpResultBO.setUntaxAmtMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck())) {
            BigDecimal diffUntaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck());
            TOTAL_AMOUNT_EX_OTHER_CHECK = diffUntaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountCheck())) {
            invoiceCmpResultBO.setTaxMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck())) {
            BigDecimal diffTaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck());
            TAX_AMOUNT_OTHER_CHECK = diffTaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
    }
}

