/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApplyBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignWriteOffBusiReqBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscStockOperAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceCheckResultMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceCheckResultPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderInvoiceSignApplyBusiServiceImpl
implements FscBillOrderInvoiceSignApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderInvoiceSignApplyBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceCheckResultMapper fscInvoiceCheckResultMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    private static final String BUSI_NAME = "\u53d1\u7968\u7b7e\u6536\u7533\u8bf7";
    @Autowired
    private FscStockOperAtomService fscStockOperAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;

    @Override
    public FscBillOrderInvoiceSignApplyBusiRspBO dealOrderInvoiceSignApply(FscBillOrderInvoiceSignApplyBusiReqBO reqBO) {
        FscOrderInvoicePO fscOrderInvoicePoSet = new FscOrderInvoicePO();
        if (null != reqBO.getUserId()) {
            fscOrderInvoicePoSet.setSignOperId(reqBO.getUserId().toString());
        }
        fscOrderInvoicePoSet.setSignOperName(reqBO.getName());
        fscOrderInvoicePoSet.setSignTime(new Date());
        fscOrderInvoicePoSet.setSignTimeStart(new Date());
        FscOrderInvoicePO fscOrderInvoicePowhere = new FscOrderInvoicePO();
        fscOrderInvoicePowhere.setFscOrderId(reqBO.getOrderId());
        this.fscOrderInvoiceMapper.updateBy(fscOrderInvoicePoSet, fscOrderInvoicePowhere);
        FscInvoiceCheckResultPO fscInvoiceCheckResultPO = new FscInvoiceCheckResultPO();
        fscInvoiceCheckResultPO.setFscOrderId(reqBO.getOrderId());
        this.fscInvoiceCheckResultMapper.deleteBy(fscInvoiceCheckResultPO);
        if (null != reqBO.getInvoiceCmpResult()) {
            fscInvoiceCheckResultPO.setAmountMargin(reqBO.getInvoiceCmpResult().getAmountMargin());
            fscInvoiceCheckResultPO.setCmpResult(reqBO.getInvoiceCmpResult().getCmpResultStr());
            fscInvoiceCheckResultPO.setIteNumMargin(reqBO.getInvoiceCmpResult().getItemNumMargin());
            fscInvoiceCheckResultPO.setUntaxAmtMargin(reqBO.getInvoiceCmpResult().getUntaxAmtMargin());
            fscInvoiceCheckResultPO.setTaxMargin(reqBO.getInvoiceCmpResult().getTaxMargin());
            fscInvoiceCheckResultPO.setCreateOperId(reqBO.getUserId());
            fscInvoiceCheckResultPO.setCreateOperName(reqBO.getName());
            fscInvoiceCheckResultPO.setCreateTime(new Date());
            fscInvoiceCheckResultPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscInvoiceCheckResultPO.setFscOrderId(reqBO.getOrderId());
            this.fscInvoiceCheckResultMapper.insert(fscInvoiceCheckResultPO);
        }
        this.fscOrderMapper.deleteOrderAmount(reqBO.getOrderId());
        if (!CollectionUtils.isEmpty(reqBO.getPurWriteOffAmount())) {
            BigDecimal writeOffAmount = new BigDecimal(0);
            for (FscBillOrderInvoiceSignWriteOffBusiReqBO writeOffBusiBO : reqBO.getPurWriteOffAmount()) {
                FscOrderPO tempPo = new FscOrderPO();
                tempPo.setFscOrderId(reqBO.getOrderId());
                tempPo.setShouldPayId(writeOffBusiBO.getPayOrderId());
                tempPo.setWriteOffAmount(writeOffBusiBO.getWriteOffAmount());
                this.fscOrderMapper.insert(tempPo);
                writeOffAmount = writeOffAmount.add(writeOffBusiBO.getWriteOffAmount());
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getOrderId());
            fscOrderPO.setWriteOffAmount(writeOffAmount);
            FscOrderPO set = new FscOrderPO();
            set.setWriteOffAmount(writeOffAmount);
            FscOrderPO where = new FscOrderPO();
            where.setFscOrderId(reqBO.getOrderId());
            this.fscOrderMapper.updateBy(set, where);
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        this.invokeUacTask(reqBO);
        return new FscBillOrderInvoiceSignApplyBusiRspBO();
    }

    private void invokeUacTask(FscBillOrderInvoiceSignApplyBusiReqBO reqBO) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setMenuId("fscOrderProcess");
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(reqBO.getOrderId().toString());
        approvalObjBO.setObjName("\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
    }
}

