/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.tydic.authority.busi.api.DycStationSelectService;
import com.tydic.authority.busi.bo.DycStationSelectReqBO;
import com.tydic.authority.busi.bo.DycStationSelectRspBO;
import com.tydic.fsc.bill.ability.api.FscBillPurchaseListPrintAbilityService;
import com.tydic.fsc.bill.ability.bo.FscPurchaseListPrintReqBO;
import com.tydic.fsc.bill.ability.bo.FscPurchaseListPrintRspBO;
import com.tydic.fsc.bill.ability.impl.FscBillListPrintServiceImpl;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.bo.FscOrderItemDetailBO;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.CheckUtils;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.common.ability.api.PebExtMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryRspBO;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPurchaseListPrintAbilityService"})
public class FscBillPurchaseListPrintAbilityServiceImpl
implements FscBillPurchaseListPrintAbilityService {
    private FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService;
    private FscBillListPrintServiceImpl fscBillListPrintServiceImpl;
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    private DycStationSelectService dycStationSelectService;
    private PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService;
    private FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService;
    private FscOrderRelationMapper fscOrderRelationMapper;
    private FscShouldPayMapper fscShouldPayMapper;

    @PostMapping(value={"billPurchaseListPrintAbilityService"})
    public FscPurchaseListPrintRspBO billPurchaseListPrintAbilityService(@RequestBody FscPurchaseListPrintReqBO reqBO) {
        if (CheckUtils.isBlank((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u5bfc\u51faPDF\u5931\u8d25\uff0c\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
        }
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        this.addPdfTable(document, reqBO);
        document.close();
        String url = this.fscBillListPrintServiceImpl.uploadFile("\u91c7\u8d2d\u7ed3\u7b97\u5355", byteArrayOutputStream);
        return new FscPurchaseListPrintRspBO(url);
    }

    private void addPdfTable(Document document, FscPurchaseListPrintReqBO reqBO) {
        ArrayList<PdfPTable> list = new ArrayList<PdfPTable>();
        FscComOrderDetailQueryAbilityReqBO orderDetailBo = new FscComOrderDetailQueryAbilityReqBO();
        orderDetailBo.setOrderId(reqBO.getOrderId());
        FscComOrderDetailQueryAbilityRspBO orderDetail = this.fscComOrderDetailQueryAbilityService.qryOrderDetail(orderDetailBo);
        if (!"0000".equals(orderDetail.getRespCode())) {
            throw new FscBusinessException("193005", orderDetail.getRespDesc());
        }
        FscOrderItemDetailQueryAbilityReqBO orderItemDetailBO = new FscOrderItemDetailQueryAbilityReqBO();
        orderItemDetailBO.setFscOrderIdList(Stream.of(reqBO.getOrderId()).collect(Collectors.toList()));
        FscOrderItemDetailQueryAbilityRspBO orderItem = this.fscOrderItemDetailQueryAbilityService.queryOrderItemDetail(orderItemDetailBO);
        List acceptOrderIdList = orderItem.getFscOrderItemDetailBOS().stream().map(FscOrderItemDetailBO::getAcceptOrderId).distinct().collect(Collectors.toList());
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setAcceptOrderIds(acceptOrderIdList);
        List shouldPayList = this.fscShouldPayMapper.getList(fscShouldPayPo);
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(reqBO.getOrderId());
        List orderRelationList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = (FscComApprovalprocessListQryAbilityReqBO)BeanUtil.copyProperties((Object)reqBO, FscComApprovalprocessListQryAbilityReqBO.class);
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        if (orderDetail.getReceiveType() == 1) {
            fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(7));
        } else {
            fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(6));
        }
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
            this.dealStationInfo(approvalList);
        }
        this.addHeadTable(list, orderDetail);
        this.addMiddleTable(list, orderDetail, orderRelationList, orderItem, shouldPayList);
        PdfUtils.addTableListToDoc((Document)document, list);
        PdfUtils.addAuditTable(list, approvalList);
    }

    private void addMiddleTable(List<PdfPTable> list, FscComOrderDetailQueryAbilityRspBO orderDetail, List<FscOrderRelationPO> orderRelationList, FscOrderItemDetailQueryAbilityRspBO orderItem, List<FscShouldPayPO> shouldPayList) {
        PdfPTable pageTable4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u91c7\u8d2d\u7ed3\u7b97\u7f16\u7801", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)orderDetail.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u91c7\u8d2d\u7ed3\u7b97\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)orderDetail.getOrderName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u4e1a\u52a1\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)this.dealOrderTypeEnum(orderDetail.getOrderType()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable4);
        PdfPTable pageTable5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u91c7\u8d2d\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)orderRelationList.stream().map(FscOrderRelationPO::getOrderNo).collect(Collectors.joining(",")), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u54c1\u724c", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u5b9e\u9645\u6536\u6b3e\u5355\u4f4d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)orderDetail.getPayeeName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable5);
        PdfPTable pageTable6 = PdfUtils.newPdfTable();
        List orderIds = orderRelationList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
        ArrayList<String> agreeList = new ArrayList<String>();
        for (Long l : orderIds) {
            PebExtMainOrderDetailQueryReqBO pebExtMainOrderDetailQueryReqBO = new PebExtMainOrderDetailQueryReqBO();
            pebExtMainOrderDetailQueryReqBO.setOrderId(l);
            PebExtMainOrderDetailQueryRspBO pebExtMainOrderDetailQuery = this.pebExtMainOrderDetailQueryAbilityService.getPebExtMainOrderDetailQuery(pebExtMainOrderDetailQueryReqBO);
            if (!"0000".equals(pebExtMainOrderDetailQuery.getRespCode()) || !CheckUtils.isNotBlank((Object)pebExtMainOrderDetailQuery) || !CheckUtils.isNotBlank((Object)pebExtMainOrderDetailQuery.getOrdAgreementRspBO())) continue;
            agreeList.add(pebExtMainOrderDetailQuery.getOrdAgreementRspBO().getAgreementName());
        }
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u9500\u552e\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)String.join((CharSequence)",", agreeList), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u4f9b\u5e94\u5546\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)orderDetail.getSupplierName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u5408\u540c\u672a\u6267\u884c\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable6);
        PdfPTable pageTable7 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u9884\u4ed8\u6b3e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)this.dealDecimal(shouldPayList.stream().filter(Objects::nonNull).map(FscShouldPayPO::getClaimAmt).reduce(BigDecimal.ZERO, BigDecimal::add), shouldPayList.stream().filter(Objects::nonNull).map(FscShouldPayPO::getWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u5269\u4f59\u7ed3\u7b97\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)this.dealDecimal(orderDetail.getTotalCharge(), orderDetail.getPaidAmount()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u7269\u6599\u7ed3\u7b97\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)orderDetail.getTotalCharge(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable7);
        List fscOrderItemDetailList = orderItem.getFscOrderItemDetailBOS();
        PdfPTable pageTable8 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u672c\u6b21\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)fscOrderItemDetailList.stream().map(FscOrderItemDetailBO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u672c\u6b21\u53d1\u7968\u7a0e\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)fscOrderItemDetailList.stream().map(FscOrderItemDetailBO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u672c\u6b21\u53d1\u7968\u91d1\u989d(\u542b\u7a0e)", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)orderDetail.getTotalCharge(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable8);
        PdfPTable pageTable9 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)"\u672c\u6b21\u6838\u9500\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)orderDetail.getWriteOffAmount(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)"\u5269\u4f59\u4ed8\u6b3e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)"findMe", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)"\u4ed8\u6b3e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)"findMe", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable8);
        PdfPTable pageTable10 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"\u5907\u6ce8", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)16, null);
        PdfPTable pageTable11 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)"\u5408\u540c\u6807\u7b7e", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)16, null);
        list.add(pageTable8);
    }

    public void dealStationInfo(List<FscApprovalprocessListBO> approvalList) {
        approvalList.get(0).setStationName("\u63d0\u4ea4\u4eba");
        for (int i = 0; i < approvalList.size() - 1; ++i) {
            DycStationSelectReqBO dycStationSelectReqBO = new DycStationSelectReqBO();
            dycStationSelectReqBO.setStationId(Long.valueOf(approvalList.get(i).getNextStationId()));
            DycStationSelectRspBO dycStationSelectRspBO = this.dycStationSelectService.stationSelectById(dycStationSelectReqBO);
            approvalList.get(i + 1).setStationId(approvalList.get(i).getNextStationId());
            if (!ObjectUtils.isEmpty((Object)dycStationSelectRspBO.getData())) {
                approvalList.get(i + 1).setStationName(dycStationSelectRspBO.getData().getStationName());
                continue;
            }
            approvalList.get(i + 1).setStationName(approvalList.get(i).getNextStationId());
        }
    }

    private void addHeadTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO orderDetail) {
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)23, null);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)("\u9644\u4ef6" + (orderDetail.getAttachmentList() == null ? 0 : orderDetail.getAttachmentList().size()) + "\u5f20"), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)1, null);
        tableList.add(titleTable1);
        PdfPTable pageTable2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable2, (Object)"\u91c7\u8d2d\u7ed3\u7b97\u5355", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)24, null);
        tableList.add(pageTable2);
        PdfPTable pageTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u90e8\u95e8\uff1a", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)orderDetail.getCreateOrgName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)orderDetail.getCreateOperName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        tableList.add(pageTable3);
    }

    private BigDecimal dealDecimal(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        if (bigDecimal1 == null) {
            bigDecimal1 = BigDecimal.ZERO;
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = BigDecimal.ZERO;
        }
        return bigDecimal1.subtract(bigDecimal2).setScale(2, 4);
    }

    private String dealOrderTypeEnum(Integer code) {
        FscOrderTypeEnum instance = FscOrderTypeEnum.getInstance((Integer)code);
        if (instance != null) {
            return instance.getCodeDesc();
        }
        return code.toString();
    }

    @Autowired
    public void setFscComOrderDetailQueryAbilityService(FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService) {
        this.fscComOrderDetailQueryAbilityService = fscComOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setFscBillListPrintServiceImpl(FscBillListPrintServiceImpl fscBillListPrintServiceImpl) {
        this.fscBillListPrintServiceImpl = fscBillListPrintServiceImpl;
    }

    @Autowired
    public void setFscComApprovalprocessListQryAbilityService(FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService) {
        this.fscComApprovalprocessListQryAbilityService = fscComApprovalprocessListQryAbilityService;
    }

    @Autowired
    public void setDycStationSelectService(DycStationSelectService dycStationSelectService) {
        this.dycStationSelectService = dycStationSelectService;
    }

    @Autowired
    public void setPebExtMainOrderDetailQueryAbilityService(PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService) {
        this.pebExtMainOrderDetailQueryAbilityService = pebExtMainOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setFscOrderItemDetailQueryAbilityService(FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService) {
        this.fscOrderItemDetailQueryAbilityService = fscOrderItemDetailQueryAbilityService;
    }

    @Autowired
    public void setFscOrderRelationMapper(FscOrderRelationMapper fscOrderRelationMapper) {
        this.fscOrderRelationMapper = fscOrderRelationMapper;
    }

    @Autowired
    public void setFscShouldPayMapper(FscShouldPayMapper fscShouldPayMapper) {
        this.fscShouldPayMapper = fscShouldPayMapper;
    }
}

