/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignApprovalAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignApprovalAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignApprovalAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignApprovalBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApprovalBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApprovalBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.InvoiceCmpResultBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscInvoiceSignErrorMsgEnum;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignApprovalAbilityService"})
public class FscBillOrderInvoiceSignApprovalAbilityServiceImpl
implements FscBillOrderInvoiceSignApprovalAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBillOrderInvoiceSignApprovalBusiService fscBillOrderInvoiceSignApprovalBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    private static final Integer IN = 1;
    private static final Integer OUT = 2;
    private static BigDecimal TAX_AMOUNT_OTHER_CHECK = BigDecimal.ZERO;
    private static BigDecimal TOTAL_AMOUNT_EX_OTHER_CHECK = BigDecimal.ZERO;
    private static final String REPLACE_KEY = "#replace#";
    private static final String REPLACE_LIMIT_AMT = "##";
    private static final String ERROR_MSG_TITLE_BEGIN = "\u7ed3\u7b97\u5355";
    private static final String ERROR_MSG_TITLE_END = "\u4e0d\u7b26\u5408\u7b7e\u6536\u89c4\u5219\uff0c\u539f\u56e0\u5982\u4e0b\uff1a<br>";

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderInvoiceSignApproval"})
    public FscBillOrderInvoiceSignApprovalAbilityRspBO dealOrderInvoiceSignApproval(@RequestBody FscBillOrderInvoiceSignApprovalAbilityReqBO reqBO) {
        FscBillOrderInvoiceSignApprovalBusiRspBO fscBillOrderInvoiceSignApprovalBusiRspBO;
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (fscOrderPO.getSignStation() == null) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u5ba1\u6279\u6743\u9650\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u8d26\u53f7\u65e0\u4e0b\u4e00\u6b65\u5ba1\u6279\u6743\u9650");
        }
        Boolean stationFlag = true;
        HashMap<String, Long> stationMap = new HashMap<String, Long>();
        for (Long s : reqBO.getStationsList()) {
            stationMap.put(s.toString(), s);
        }
        for (String s : fscOrderPO.getSignStation().split(",")) {
            if (stationMap.get(s) == null) continue;
            stationFlag = false;
        }
        if (stationFlag.booleanValue()) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u8d26\u53f7\u65e0\u4e0b\u4e00\u6b65\u5ba1\u6279\u6743\u9650");
        }
        if (!FscConstants.FscInvoiceOrderState.BILL_APPLY.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + fscOrderPO.getOrderState() + "]\u4e0d\u5141\u8bb8\u5ba1\u6279");
        }
        FscBillOrderInvoiceSignApprovalBusiReqBO fscBillOrderInvoiceSignApprovalBusiReqBO = (FscBillOrderInvoiceSignApprovalBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillOrderInvoiceSignApprovalBusiReqBO.class));
        fscBillOrderInvoiceSignApprovalBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            this.dealOrderCheck(fscBillOrderInvoiceSignApprovalBusiReqBO, fscOrderPO);
            this.dealStockFlag(fscBillOrderInvoiceSignApprovalBusiReqBO, fscOrderPO);
        }
        if (!"0000".equals((fscBillOrderInvoiceSignApprovalBusiRspBO = this.fscBillOrderInvoiceSignApprovalBusiService.dealOrderInvoiceSignApproval(fscBillOrderInvoiceSignApprovalBusiReqBO)).getRespCode())) {
            throw new FscBusinessException("191019", fscBillOrderInvoiceSignApprovalBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        FscBillOrderInvoiceSignApprovalAbilityRspBO abilityRspBO = new FscBillOrderInvoiceSignApprovalAbilityRspBO();
        abilityRspBO = (FscBillOrderInvoiceSignApprovalAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)fscBillOrderInvoiceSignApprovalBusiRspBO)), FscBillOrderInvoiceSignApprovalAbilityRspBO.class);
        return abilityRspBO;
    }

    private void checkCmpResult(InvoiceCmpResultBO invoiceCmpResultBO, FscOrderPO fscOrderPO) {
        this.checkCfcParam(invoiceCmpResultBO, fscOrderPO.getOrderSource());
        if (invoiceCmpResultBO.getCmpResultStr().contains(FscConstants.FscInvoiceVerifyResult.NO.toString())) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(ERROR_MSG_TITLE_BEGIN);
            errorMsg.append(fscOrderPO.getOrderNo());
            errorMsg.append(ERROR_MSG_TITLE_END);
            int strLen = invoiceCmpResultBO.getCmpResultStr().length();
            int seq = 1;
            for (int i = 0; i < strLen; ++i) {
                if (invoiceCmpResultBO.getCmpResultStr().charAt(i) == FscConstants.FscInvoiceVerifyResult.NO.toString().charAt(0)) {
                    errorMsg.append(seq);
                    errorMsg.append(FscInvoiceSignErrorMsgEnum.getInstance((Integer)seq).getDescr());
                    ++seq;
                }
                if (i == 5) break;
            }
            if (invoiceCmpResultBO.getAmountMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getAmountMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getUntaxAmtMargin().compareTo(TOTAL_AMOUNT_EX_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.UNTAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getUntaxAmtMargin().toString()).replace(REPLACE_LIMIT_AMT, TOTAL_AMOUNT_EX_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getTaxMargin().compareTo(TAX_AMOUNT_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.TAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getTaxMargin().toString()).replace(REPLACE_LIMIT_AMT, TAX_AMOUNT_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getItemNumMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.ITEM.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getItemNumMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getPoolCmpResultNum() > 0) {
                errorMsg.append(seq);
                errorMsg.append("\u3001\u8fdb\u9879\u53d1\u7968\u660e\u7ec6\u603b\u8ba1\u6709" + invoiceCmpResultBO.getPoolCmpResultNum() + "\u9879\u65e0\u6cd5\u5339\u914d\uff1b<br>");
                ++seq;
            }
            if (seq > 1) {
                throw new FscBusinessException("191035", errorMsg.toString());
            }
        }
    }

    private void val(FscBillOrderInvoiceSignApprovalAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscBillOrderInvoiceSignApprovalAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }

    private void dealAccountRule(FscBillOrderInvoiceSignApprovalBusiReqBO fscBillOrderInvoiceSignApprovalBusiReqBO, FscOrderPO fscOrderPO, FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO) {
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
            FscOrderInfoBO fscOrderInfoBO = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            if ((fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER) || fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE)) && fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                fscOrderInfoBO.setPayAccountDayRule(fscOrderInfoBO.getProPayAccountDayRule());
                fscOrderInfoBO.setPayNodeRule(fscOrderInfoBO.getProPayNodeRule());
                fscOrderInfoBO.setPayBreakScale(fscOrderInfoBO.getProPayBreakScale());
                fscOrderInfoBO.setModelContractId(fscOrderInfoBO.getProModelContractId());
                fscOrderInfoBO.setModelContractNo(fscOrderInfoBO.getProModelContractNo());
                fscOrderInfoBO.setPayAccountDay(fscOrderInfoBO.getProPayAccountDay());
            }
            if (FscConstants.MerchantPayAccountDayRule.SIGN.equals(fscOrderInfoBO.getPayAccountDayRule()) || FscConstants.MerchantPayNodeRule.SIGN.equals(fscOrderInfoBO.getPayNodeRule())) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
                fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
                fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
                fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO, fscOrderPO.getOrderSource()));
                fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(fscBillOrderInvoiceSignApprovalBusiReqBO.getOrderId());
                fscShouldPayBO.setInvoiceNo(signTemp.getInvoiceNo());
                fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                fscShouldPayBOS.add(fscShouldPayBO);
                fscBillOrderInvoiceSignApprovalBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
                fscBillOrderInvoiceSignApprovalBusiReqBO.setCreateShouldPayFlag(true);
            }
        }
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO, Integer orderSource) {
        Calendar now = Calendar.getInstance();
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }

    private void checkCfcParam(InvoiceCmpResultBO invoiceCmpResultBO, Integer orderSource) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_check_" + orderSource);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        StringBuffer cmpResult = new StringBuffer(invoiceCmpResultBO.getCmpResultStr());
        char resultYesChar = FscConstants.FscInvoiceVerifyResult.YES.toString().charAt(0);
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceTitleCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BUY_NAME.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxpayerIdCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.TAX_NO.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAddressCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ADDRESS.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getPhoneCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.PHONE.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getBankCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BANK.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAccountCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ACCOUNT.getCode() - 1, resultYesChar);
        }
        invoiceCmpResultBO.setCmpResultStr(cmpResult.toString());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountCheck())) {
            invoiceCmpResultBO.setAmountMargin(BigDecimal.ZERO);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExCheck())) {
            invoiceCmpResultBO.setUntaxAmtMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck())) {
            BigDecimal diffUntaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck());
            TOTAL_AMOUNT_EX_OTHER_CHECK = diffUntaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountCheck())) {
            invoiceCmpResultBO.setTaxMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck())) {
            BigDecimal diffTaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck());
            TAX_AMOUNT_OTHER_CHECK = diffTaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
    }

    private void dealStockFlag(FscBillOrderInvoiceSignApprovalBusiReqBO fscBillOrderInvoiceSignApprovalBusiReqBO, FscOrderPO fscOrderPO) {
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType())) {
            fscBillOrderInvoiceSignApprovalBusiReqBO.setNeedOperStockEnable(true);
            fscBillOrderInvoiceSignApprovalBusiReqBO.setStockFlag(IN);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
            fscBillOrderInvoiceSignApprovalBusiReqBO.setNeedOperStockEnable(true);
            fscBillOrderInvoiceSignApprovalBusiReqBO.setStockFlag(OUT);
        }
    }

    private void dealOrderCheck(FscBillOrderInvoiceSignApprovalBusiReqBO fscBillOrderInvoiceSignApprovalBusiReqBO, FscOrderPO fscOrderPO) {
        FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
        FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
        if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
            throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
        }
        this.dealAccountRule(fscBillOrderInvoiceSignApprovalBusiReqBO, fscOrderPO, fscAcceptOrderListQueryAtomRspBO);
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
            this.checkProSign(fscAcceptOrderListQueryAtomRspBO);
        }
    }

    private void checkProSign(FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO) {
        fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().forEach((acceptOrderId, fscOrderInfoBO) -> fscOrderInfoBO.getFscRelInfoBos().forEach(fscProFscRelInfoBo -> {
            if (FscConstants.FscRelType.PRO_INVOICE.equals(fscProFscRelInfoBo.getRelType()) && !FscConstants.FscRelStatus.SIGN.equals(fscProFscRelInfoBo.getRelState())) {
                throw new FscBusinessException("191019", "\u4e0a\u6e38\u7ed3\u7b97\u5355\u53d1\u7968\u672a\u7b7e\u6536\uff0c\u4e0b\u6e38\u4e0d\u5141\u8bb8\u7b7e\u6536");
            }
        }));
    }
}

