/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.google.common.base.Joiner;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.authority.busi.api.DycStationSelectService;
import com.tydic.authority.busi.bo.DycStationSelectReqBO;
import com.tydic.authority.busi.bo.DycStationSelectRspBO;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.fsc.bill.ability.api.FscBillListPrintService;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintRspBO;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.bo.FscOrderItemDetailBO;
import com.tydic.fsc.bo.OrderInvoiceBO;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.CheckUtils;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscStringUtils;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.common.ability.api.PebExtMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryRspBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillListPrintService"})
public class FscBillListPrintServiceImpl
implements FscBillListPrintService {
    private static final Logger log = LoggerFactory.getLogger(FscBillListPrintServiceImpl.class);
    private FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService;
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    private FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService;
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    private DycStationSelectService dycStationSelectService;
    private FscShouldPayMapper fscShouldPayMapper;
    private FscClaimDetailMapper fscClaimDetailMapper;
    private PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService;
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final int RECEIVE_TYPE = 2;

    @PostMapping(value={"fscBillListPrint"})
    public FscBillListPrintRspBO fscBillListPrint(@RequestBody FscBillListPrintReqBO reqBO) {
        if (CheckUtils.isBlank((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        String pdfUrl = this.createBillPdfPrint(reqBO);
        return new FscBillListPrintRspBO(pdfUrl, fscOrderPo.getOrderNo());
    }

    private String createBillPdfPrint(FscBillListPrintReqBO reqBO) {
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        List<PdfPTable> list = this.addPdfTable(reqBO);
        PdfUtils.addTableListToDoc((Document)document, list);
        document.close();
        return this.uploadFile("\u9500\u552e\u7ed3\u7b97\u5355", byteArrayOutputStream);
    }

    private List<PdfPTable> addPdfTable(FscBillListPrintReqBO reqBO) {
        FscComOrderDetailQueryAbilityReqBO orderDetailReqBO = new FscComOrderDetailQueryAbilityReqBO();
        orderDetailReqBO.setOrderId(reqBO.getOrderId());
        FscComOrderDetailQueryAbilityRspBO orderDetail = this.fscComOrderDetailQueryAbilityService.qryOrderDetail(orderDetailReqBO);
        ContractDetailQueryAbilityReqBO contractDetailBO = new ContractDetailQueryAbilityReqBO();
        contractDetailBO.setContractId(orderDetail.getContractId());
        ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailBO);
        FscOrderItemDetailQueryAbilityReqBO orderItemDetailBO = new FscOrderItemDetailQueryAbilityReqBO();
        orderItemDetailBO.setFscOrderIdList(Stream.of(reqBO.getOrderId()).collect(Collectors.toList()));
        FscOrderItemDetailQueryAbilityRspBO fscOrderItemDetailQueryAbilityRspBO = this.fscOrderItemDetailQueryAbilityService.queryOrderItemDetail(orderItemDetailBO);
        List fscOrderItemDetail = fscOrderItemDetailQueryAbilityRspBO.getFscOrderItemDetailBOS();
        List orderList = fscOrderItemDetail.stream().map(FscOrderItemDetailBO::getOrderId).distinct().collect(Collectors.toList());
        FscOrderItemDetailQueryAbilityReqBO itemDetailQueryAbilityReqBO = new FscOrderItemDetailQueryAbilityReqBO();
        itemDetailQueryAbilityReqBO.setOrderIds(orderList);
        FscOrderItemDetailQueryAbilityRspBO orderItemDetailQueryAbilityRspBO = this.fscOrderItemDetailQueryAbilityService.queryOrderItemDetailByOrderStatus(itemDetailQueryAbilityReqBO);
        List acceptOrderIdList = fscOrderItemDetail.stream().map(FscOrderItemDetailBO::getAcceptOrderId).distinct().collect(Collectors.toList());
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setAcceptOrderIds(acceptOrderIdList);
        List shouldPayList = this.fscShouldPayMapper.getList(fscShouldPayPo);
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = (FscComApprovalprocessListQryAbilityReqBO)BeanUtil.copyProperties((Object)reqBO, FscComApprovalprocessListQryAbilityReqBO.class);
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        if (orderDetail.getReceiveType() == 2) {
            fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(6));
        } else {
            fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(7));
        }
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
            this.dealStationInfo(approvalList);
        }
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, orderDetail);
        this.addMiddleTable(tableList, orderDetail, contractDetailQueryAbilityRspBO, fscOrderItemDetailQueryAbilityRspBO, orderItemDetailQueryAbilityRspBO);
        this.addFootTable(tableList, orderDetail, shouldPayList);
        PdfUtils.addAuditTable(tableList, approvalList);
        return tableList;
    }

    private void addHeadTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO orderDetail) {
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)orderDetail.getCreateOrgName(), (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)23, null);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)("\u9644\u4ef6" + (orderDetail.getAttachmentList() == null ? 0 : orderDetail.getAttachmentList().size()) + "\u5f20"), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)1, null);
        tableList.add(titleTable1);
        PdfPTable pageTable2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable2, (Object)"\u81ea\u8425\u9500\u552e\u7ed3\u7b97\u5355", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)24, null);
        tableList.add(pageTable2);
        PdfPTable pageTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u90e8\u95e8\uff1a", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)orderDetail.getCreateOrgName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u521b\u5efa\u65f6\u95f4\uff1a", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)DateUtil.dateToStrLong((Date)orderDetail.getCreateTime()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)orderDetail.getCreateOperName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable3);
    }

    private void addMiddleTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO orderDetail, ContractDetailQueryAbilityRspBO contractDetail, FscOrderItemDetailQueryAbilityRspBO orderItemDetail, FscOrderItemDetailQueryAbilityRspBO orderItemEffectDetail) {
        List orderItemDetailBOList = orderItemDetail.getFscOrderItemDetailBOS();
        PdfPTable pageTable4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u9500\u552e\u7ed3\u7b97\u7f16\u7801", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)orderDetail.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u9500\u552e\u7ed3\u7b97\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u7ed3\u7b97\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)this.dealOrderTypeEnum(orderDetail.getOrderType()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable4);
        PdfPTable pageTable5 = PdfUtils.newPdfTable();
        if (CheckUtils.isBlank((String)contractDetail.getContractCode())) {
            FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
            fscOrderRelationPo.setFscOrderId(orderDetail.getFscOrderId());
            List list = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
            PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u9500\u552e\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)list.stream().map(FscOrderRelationPO::getOrderNo).collect(Collectors.joining(",")), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            List collect = list.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
            ArrayList<String> agreeList = new ArrayList<String>();
            for (Long l : collect) {
                PebExtMainOrderDetailQueryReqBO pebExtMainOrderDetailQueryReqBO = new PebExtMainOrderDetailQueryReqBO();
                pebExtMainOrderDetailQueryReqBO.setOrderId(l);
                PebExtMainOrderDetailQueryRspBO pebExtMainOrderDetailQuery = this.pebExtMainOrderDetailQueryAbilityService.getPebExtMainOrderDetailQuery(pebExtMainOrderDetailQueryReqBO);
                if (!"0000".equals(pebExtMainOrderDetailQuery.getRespCode()) || !CheckUtils.isNotBlank((Object)pebExtMainOrderDetailQuery) || !CheckUtils.isNotBlank((Object)pebExtMainOrderDetailQuery.getOrdAgreementRspBO())) continue;
                agreeList.add(pebExtMainOrderDetailQuery.getOrdAgreementRspBO().getAgreementName());
            }
            PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u9500\u552e\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)String.join((CharSequence)",", agreeList), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        } else {
            PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u9500\u552e\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)FscStringUtils.convertValue((Object)contractDetail.getContractCode()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u9500\u552e\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)FscStringUtils.convertValue((Object)contractDetail.getContractName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        }
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u5ba2\u6237\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)(orderDetail.getOrderInvoiceInfo().size() > 0 ? FscStringUtils.convertValue((Object)((OrderInvoiceBO)orderDetail.getOrderInvoiceInfo().get(0)).getBuyName()) : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable5);
        PdfPTable pageTable6 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u5408\u540c\u542b\u7a0e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)orderDetail.getTotalCharge(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u5408\u540c\u672a\u6267\u884c\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u5546\u54c1\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable6);
        PdfPTable pageTable7 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u672c\u6b21\u6210\u672c\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)(orderItemDetailBOList.size() > 0 ? orderItemDetailBOList.stream().filter(Objects::nonNull).map(FscOrderItemDetailBO::getPurchaseUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add) : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u6536\u6b3e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)(orderItemDetailBOList.size() > 0 ? orderItemDetailBOList.stream().filter(Objects::nonNull).map(FscOrderItemDetailBO::getClaimAmt).reduce(BigDecimal.ZERO, BigDecimal::add) : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u672c\u6b21\u7ed3\u7b97\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)(orderItemDetailBOList.size() > 0 ? orderItemDetailBOList.stream().filter(Objects::nonNull).map(FscOrderItemDetailBO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add) : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable7);
        PdfPTable pageTable8 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u5269\u4f59\u8ba4\u9886\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)(orderItemDetailBOList.size() > 0 ? this.dealDecimal(orderItemDetailBOList.stream().filter(Objects::nonNull).map(FscOrderItemDetailBO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add), orderItemDetailBOList.stream().filter(Objects::nonNull).map(FscOrderItemDetailBO::getClaimAmt).reduce(BigDecimal.ZERO, BigDecimal::add)) : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u672c\u6b21\u6838\u9500\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)orderDetail.getWriteOffAmount(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u6bdb\u5229\u7387", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable8);
        PdfPTable pageTable9 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)(orderDetail.getOrderInvoiceInfo().size() > 0 ? ((OrderInvoiceBO)orderDetail.getOrderInvoiceInfo().get(0)).getTaxNo() : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)"\u5ba2\u6237\u5355\u4f4d\u5730\u5740\u7535\u8bdd", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)(orderDetail.getOrderInvoiceInfo().size() > 0 ? ((OrderInvoiceBO)orderDetail.getOrderInvoiceInfo().get(0)).getPhone() + "/" + ((OrderInvoiceBO)orderDetail.getOrderInvoiceInfo().get(0)).getAddress() : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)"\u5f00\u6237\u94f6\u884c\u94f6\u884c\u8d26\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)(orderDetail.getOrderInvoiceInfo().size() > 0 ? ((OrderInvoiceBO)orderDetail.getOrderInvoiceInfo().get(0)).getAccount() + "/" + ((OrderInvoiceBO)orderDetail.getOrderInvoiceInfo().get(0)).getBank() : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable9);
        PdfPTable pageTable10 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"\u53d1\u7968\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)(orderDetail.getOrderInvoiceInfo().size() > 0 ? ((OrderInvoiceBO)orderDetail.getOrderInvoiceInfo().get(0)).getInvoiceTypeStr() : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"\u4ef7\u683c\u65b9\u5f0f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"\u7a0e\u7387%", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable10);
        PdfPTable pageTable11 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)"\u672c\u6b21\u5f00\u7968\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)(orderItemDetailBOList.size() > 0 ? orderItemDetailBOList.stream().filter(Objects::nonNull).map(FscOrderItemDetailBO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add) : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)"\u672c\u6b21\u5f00\u7968\u7a0e\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)(orderItemDetailBOList.size() > 0 ? orderItemDetailBOList.stream().filter(Objects::nonNull).map(FscOrderItemDetailBO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add) : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)"\u672c\u6b21\u5f00\u7968\u91d1\u989d\uff08\u542b\u7a0e\uff09", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable11, (Object)(orderItemDetailBOList.size() > 0 ? orderItemDetailBOList.stream().filter(Objects::nonNull).map(FscOrderItemDetailBO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add) : " "), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable11);
        PdfPTable pageTable12 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable12, (Object)"\u7d2f\u8ba1\u7ed3\u7b97\u6210\u672c", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable12, (Object)(orderItemEffectDetail.getFscOrderItemDetailBOS().size() > 0 ? orderItemEffectDetail.getFscOrderItemDetailBOS().stream().filter(Objects::nonNull).map(FscOrderItemDetailBO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add) : ""), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable12, (Object)"\u7d2f\u8ba1\u6bdb\u5229", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable12, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable12, (Object)"\u7d2f\u8ba1\u5229\u6da6", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable12, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable12);
    }

    private void addFootTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO orderDetail, List<FscShouldPayPO> shouldPayList) {
        PdfPTable pageTable13 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable13, (Object)"\u6536\u6b3e\u6761\u4ef6", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable13, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(pageTable13);
        PdfPTable pageTable14 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)"\u5ba1\u6279\u5907\u6ce8", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(pageTable14);
        PdfPTable pageTable15 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)"\u5f00\u7968\u5907\u6ce8", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)orderDetail.getOrderDesc(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(pageTable15);
        PdfPTable pageTable16 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable16, (Object)"\u5408\u540c\u6807\u7b7e", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable16, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(pageTable16);
        if (shouldPayList.size() > 0) {
            for (int i = 0; i < shouldPayList.size(); ++i) {
                PdfPTable pageTable17 = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u9884\u6536\u6b3e\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u9884\u6536\u6b3e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u5df2\u6838\u9500\u91d1\u989d ", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u672a\u6838\u9500\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u672c\u6b21\u6838\u9500\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                tableList.add(pageTable17);
                FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
                fscClaimDetailPo.setObjectId(shouldPayList.get(i).getShouldPayId());
                List fscClaimDetailList = this.fscClaimDetailMapper.queryAll(fscClaimDetailPo);
                List collect = fscClaimDetailList.stream().map(FscClaimDetailPO::getClaimId).collect(Collectors.toList());
                PdfPTable pageTable18 = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)Joiner.on((String)",").join(collect), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)shouldPayList.get(i).getClaimAmt().setScale(2, 4), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)shouldPayList.get(i).getWriteOffAmount().setScale(2, 4), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)this.dealDecimal(shouldPayList.get(i).getShouldPayAmount(), shouldPayList.get(i).getWriteOffAmount()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                tableList.add(pageTable18);
            }
        } else {
            PdfPTable pageTable17 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u5e8f\u53f7 ", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u9884\u6536\u6b3e\u7f16\u53f7 ", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u9884\u6536\u6b3e\u91d1\u989d ", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u5df2\u6838\u9500\u91d1\u989d ", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u672a\u6838\u9500\u91d1\u989d ", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u672c\u6b21\u6838\u9500\u91d1\u989d ", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(pageTable17);
            PdfPTable pageTable18 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)"1", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(pageTable18);
        }
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    public void dealStationInfo(List<FscApprovalprocessListBO> approvalList) {
        approvalList.get(0).setStationName("\u63d0\u4ea4\u4eba");
        for (int i = 0; i < approvalList.size() - 1; ++i) {
            approvalList.get(i + 1).setStationId(approvalList.get(i).getNextStationId());
            DycStationSelectReqBO dycStationSelectReqBO = new DycStationSelectReqBO();
            dycStationSelectReqBO.setStationId(Long.valueOf(approvalList.get(i).getNextStationId()));
            DycStationSelectRspBO dycStationSelectRspBO = this.dycStationSelectService.stationSelectById(dycStationSelectReqBO);
            if (!ObjectUtils.isEmpty((Object)dycStationSelectRspBO.getData())) {
                approvalList.get(i + 1).setStationName(dycStationSelectRspBO.getData().getStationName());
                continue;
            }
            approvalList.get(i + 1).setStationName(approvalList.get(i).getNextStationId());
        }
        log.info("\u4e8c\u6b21\u5904\u7406\u4fe1\u606f\u4eba\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014:" + approvalList.toString());
    }

    private BigDecimal dealDecimal(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        if (bigDecimal1 == null) {
            bigDecimal1 = BigDecimal.ZERO;
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = BigDecimal.ZERO;
        }
        return bigDecimal1.subtract(bigDecimal2).setScale(2, 4);
    }

    private String dealOrderTypeEnum(Integer code) {
        FscOrderTypeEnum instance = FscOrderTypeEnum.getInstance((Integer)code);
        if (instance != null) {
            return instance.getCodeDesc();
        }
        return code.toString();
    }

    @Autowired
    public void setFscComOrderDetailQueryAbilityService(FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService) {
        this.fscComOrderDetailQueryAbilityService = fscComOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setContractDetailQueryAbilityService(ContractDetailQueryAbilityService contractDetailQueryAbilityService) {
        this.contractDetailQueryAbilityService = contractDetailQueryAbilityService;
    }

    @Autowired
    public void setFscOrderItemDetailQueryAbilityService(FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService) {
        this.fscOrderItemDetailQueryAbilityService = fscOrderItemDetailQueryAbilityService;
    }

    @Autowired
    public void setFscComApprovalprocessListQryAbilityService(FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService) {
        this.fscComApprovalprocessListQryAbilityService = fscComApprovalprocessListQryAbilityService;
    }

    @Autowired
    public void setDycStationSelectService(DycStationSelectService dycStationSelectService) {
        this.dycStationSelectService = dycStationSelectService;
    }

    @Autowired
    public void setFscShouldPayMapper(FscShouldPayMapper fscShouldPayMapper) {
        this.fscShouldPayMapper = fscShouldPayMapper;
    }

    @Autowired
    public void setFscClaimDetailMapper(FscClaimDetailMapper fscClaimDetailMapper) {
        this.fscClaimDetailMapper = fscClaimDetailMapper;
    }

    @Autowired
    public void setPebExtMainOrderDetailQueryAbilityService(PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService) {
        this.pebExtMainOrderDetailQueryAbilityService = pebExtMainOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setFscOrderRelationMapper(FscOrderRelationMapper fscOrderRelationMapper) {
        this.fscOrderRelationMapper = fscOrderRelationMapper;
    }

    @Autowired
    public void setFileClient(FileClient fileClient) {
        this.fileClient = fileClient;
    }
}

