/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceCheckAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscInvoicePoolBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.bo.InvoiceCmpResultBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePoolMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePoolPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceCheckAbilityService"})
public class FscBillOrderInvoiceCheckAbilityServiceImpl
implements FscBillOrderInvoiceCheckAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoicePoolMapper fscInvoicePoolMapper;
    private static final Integer DEFAULT_ORDER_NUM = 0;
    private static final String MISMATCHING = "000000";
    private final Long JD_SUPPLIER_ID = 100055L;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private Long jdIdFl;
    @Value(value="${SUPPLIER_SUNING_FL:202200512}")
    private Long snIdFl;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"dealOrderInvoiceCheck"})
    public FscBillOrderInvoiceCheckAbilityRspBO dealOrderInvoiceCheck(@RequestBody FscBillOrderInvoiceCheckAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (null == fscOrderPo) {
            throw new FscBusinessException("191016", "\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u4e3a\u7a7a");
        }
        if (!FscConstants.FscInvoiceOrderState.BILLED.equals(fscOrderPo.getOrderState()) && !FscConstants.FscInvoiceOrderState.BILL_REFUSE.equals(fscOrderPo.getOrderState())) {
            throw new FscBusinessException("191016", "\u5df2\u5f00\u7968\u6216\u8005\u91c7\u8d2d\u5ba1\u6279\u9a73\u56de\u72b6\u6001\u624d\u53ef\u6838\u5bf9\u53d1\u7968");
        }
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(reqBO.getOrderId());
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        FscBillOrderInvoiceCheckAbilityRspBO rspBO = (FscBillOrderInvoiceCheckAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderPo), FscBillOrderInvoiceCheckAbilityRspBO.class);
        rspBO.setOrderAmt(fscOrderPo.getTotalCharge());
        rspBO.setOrderNum(DEFAULT_ORDER_NUM);
        rspBO.setPageNo(reqBO.getPageNo());
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOS)) {
            rspBO.setOrderNum(Integer.valueOf(fscOrderRelationPOS.size()));
        }
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getOrderId());
        fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
        fscOrderItemPO = this.fscOrderItemMapper.getTaxAmtByFscOrder(fscOrderItemPO);
        if (null != fscOrderInvoicePo) {
            InvoiceBO preInvoiceBO = (InvoiceBO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderInvoicePo), InvoiceBO.class);
            preInvoiceBO.setAmt(fscOrderPo.getTotalCharge());
            preInvoiceBO.setUntaxAmt(fscOrderPo.getTotalCharge().subtract(fscOrderItemPO.getTaxAmtSum()));
            preInvoiceBO.setTaxAmt(fscOrderItemPO.getTaxAmtSum());
            rspBO.setPreInvoice(preInvoiceBO);
        }
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setFscOrderId(reqBO.getOrderId());
        List fscInvoiceList = this.fscInvoiceMapper.getSumAmtByFscOrderId(fscInvoicePo);
        if (!CollectionUtils.isEmpty((Collection)fscInvoiceList)) {
            fscInvoicePo = (FscInvoicePO)fscInvoiceList.get(0);
        }
        HashMap<Long, FscInvoicePO> fscInvoiceMap = new HashMap<Long, FscInvoicePO>();
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalUntaxAmt = BigDecimal.ZERO;
        BigDecimal taxAmt = BigDecimal.ZERO;
        for (FscInvoicePO invoice : fscInvoiceList) {
            totalAmt = totalAmt.add(invoice.getAmt());
            taxAmt = taxAmt.add(invoice.getTaxAmt());
            totalUntaxAmt = totalUntaxAmt.add(invoice.getUntaxAmt());
            fscInvoiceMap.put(invoice.getInvoiceId(), invoice);
        }
        fscInvoicePo.setAmt(totalAmt);
        fscInvoicePo.setUntaxAmt(totalUntaxAmt);
        fscInvoicePo.setTaxAmt(taxAmt);
        Integer poolCmpResultNum = 0;
        if (null != fscInvoicePo) {
            InvoiceBO afterInvoiceBO = (InvoiceBO)JSON.parseObject((String)JSON.toJSONString((Object)fscInvoicePo), InvoiceBO.class);
            if (this.JD_SUPPLIER_ID.equals(rspBO.getSupplierId()) && null != rspBO.getPreInvoice() || this.jdIdFl.equals(rspBO.getSupplierId()) && null != rspBO.getPreInvoice()) {
                InvoiceBO invoice = rspBO.getPreInvoice();
                afterInvoiceBO.setBuyName(invoice.getBuyName());
                afterInvoiceBO.setTaxNo(invoice.getTaxNo());
                afterInvoiceBO.setAddress(invoice.getAddress());
                afterInvoiceBO.setPhone(invoice.getPhone());
                afterInvoiceBO.setBank(invoice.getBank());
                afterInvoiceBO.setAccount(invoice.getAccount());
            }
            rspBO.setAfterInvoice(afterInvoiceBO);
            Page page = new Page();
            page.setPageNo(reqBO.getPagePoolNo().intValue());
            page.setPageSize(reqBO.getPagePoolSize().intValue());
            FscInvoicePO incomeInvoicePo = new FscInvoicePO();
            incomeInvoicePo.setFscOrderId(reqBO.getOrderId());
            List incomeInvoicePoList = this.fscInvoiceMapper.getListPage(incomeInvoicePo, page);
            rspBO.setRecordsPoolTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setPoolTotal(Integer.valueOf(page.getTotalPages()));
            ArrayList<InvoiceBO> supplierInvoices = new ArrayList<InvoiceBO>();
            ArrayList<FscInvoicePoolBO> poolInvoice = new ArrayList<FscInvoicePoolBO>();
            if (!CollectionUtils.isEmpty((Collection)incomeInvoicePoList)) {
                for (FscInvoicePO fscInvoicePOFor : incomeInvoicePoList) {
                    InvoiceBO supplierInvoiceItem = (InvoiceBO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscInvoicePOFor), InvoiceBO.class);
                    supplierInvoices.add(supplierInvoiceItem);
                    FscInvoicePoolPO fscInvoicePoolPO = new FscInvoicePoolPO();
                    fscInvoicePoolPO.setInvoiceNo(fscInvoicePOFor.getInvoiceNo());
                    fscInvoicePoolPO.setInvoiceCode(fscInvoicePOFor.getInvoiceCode());
                    fscInvoicePoolPO.setBillDate(fscInvoicePOFor.getBillDate());
                    fscInvoicePoolPO = this.fscInvoicePoolMapper.getModelBy(fscInvoicePoolPO);
                    FscInvoicePoolBO fscInvoicePoolBO = (FscInvoicePoolBO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscInvoicePoolPO), FscInvoicePoolBO.class);
                    if (null == fscInvoicePoolBO) {
                        fscInvoicePoolBO = new FscInvoicePoolBO();
                    }
                    if (fscInvoicePOFor.getAmt().compareTo(null == fscInvoicePoolBO.getAmt() ? BigDecimal.ZERO : fscInvoicePoolBO.getAmt()) != 0 || fscInvoicePOFor.getUntaxAmt().compareTo(null == fscInvoicePoolBO.getUntaxAmt() ? BigDecimal.ZERO : fscInvoicePoolBO.getUntaxAmt()) != 0 || fscInvoicePOFor.getTaxAmt().compareTo(null == fscInvoicePoolBO.getTaxAmt() ? BigDecimal.ZERO : fscInvoicePoolBO.getTaxAmt()) != 0) {
                        fscInvoicePoolBO.setPoolCmpResult(FscConstants.FscInvoiceVerifyResult.NO);
                        Integer n = poolCmpResultNum;
                        Integer n2 = poolCmpResultNum = Integer.valueOf(poolCmpResultNum + 1);
                    } else {
                        fscInvoicePoolBO.setPoolCmpResult(FscConstants.FscInvoiceVerifyResult.YES);
                    }
                    poolInvoice.add(fscInvoicePoolBO);
                }
                rspBO.setSupplierInvoices(supplierInvoices);
                rspBO.setPoolInvoice(poolInvoice);
            }
        }
        rspBO.setPoolCmpResultNum(poolCmpResultNum);
        this.cmpResult(rspBO, fscOrderPo);
        rspBO.getInvoiceCmpResult().setPoolCmpResultNum(poolCmpResultNum);
        return this.qryItem(reqBO, rspBO, fscOrderRelationPOS, fscOrderItemPO.getItemCount(), fscOrderPo.getOrderSource(), fscOrderInvoicePo, fscInvoiceMap);
    }

    private void val(FscBillOrderInvoiceCheckAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
    }

    private void cmpResult(FscBillOrderInvoiceCheckAbilityRspBO rspBO, FscOrderPO fscOrderPo) {
        InvoiceCmpResultBO invoiceCmpResultBO = new InvoiceCmpResultBO();
        if (null == rspBO.getPreInvoice() || null == rspBO.getAfterInvoice()) {
            invoiceCmpResultBO.setCmpResultStr(MISMATCHING);
            InvoiceBO invoiceBO = null;
            if (null != rspBO.getPreInvoice()) {
                invoiceBO = rspBO.getPreInvoice();
            }
            if (null != rspBO.getAfterInvoice()) {
                invoiceBO = rspBO.getAfterInvoice();
            }
            if (null != invoiceBO) {
                invoiceCmpResultBO.setUntaxAmtMargin(invoiceBO.getUntaxAmt());
                invoiceCmpResultBO.setTaxMargin(invoiceBO.getTaxAmt());
                invoiceCmpResultBO.setAmountMargin(invoiceBO.getAmt());
            }
        } else {
            StringBuffer cmpResultStr = new StringBuffer();
            if (this.JD_SUPPLIER_ID.equals(rspBO.getSupplierId()) || this.jdIdFl.equals(rspBO.getSupplierId())) {
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getBuyName(), rspBO.getPreInvoice().getBuyName()));
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getTaxNo(), rspBO.getPreInvoice().getTaxNo()));
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getAddress(), rspBO.getPreInvoice().getAddress()));
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getPhone(), rspBO.getPreInvoice().getPhone()));
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getBank(), rspBO.getPreInvoice().getBank()));
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getAccount(), rspBO.getPreInvoice().getAccount()));
            } else {
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getBuyName(), rspBO.getAfterInvoice().getBuyName()));
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getTaxNo(), rspBO.getAfterInvoice().getTaxNo()));
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getAddress(), rspBO.getAfterInvoice().getAddress()));
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getPhone(), rspBO.getAfterInvoice().getPhone()));
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getBank(), rspBO.getAfterInvoice().getBank()));
                cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getAccount(), rspBO.getAfterInvoice().getAccount()));
            }
            cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getAmt(), rspBO.getAfterInvoice().getAmt()));
            cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getTaxAmt(), rspBO.getAfterInvoice().getTaxAmt()));
            cmpResultStr.append(this.checkParam(rspBO.getPreInvoice().getUntaxAmt(), rspBO.getAfterInvoice().getUntaxAmt()));
            if (fscOrderPo.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                cmpResultStr.append(rspBO.getPoolCmpResultNum() > 0 ? FscConstants.FscInvoiceVerifyResult.NO : FscConstants.FscInvoiceVerifyResult.YES);
            }
            invoiceCmpResultBO.setCmpResultStr(cmpResultStr.toString());
            BigDecimal preAmt = null == rspBO.getPreInvoice().getAmt() ? BigDecimal.ZERO : rspBO.getPreInvoice().getAmt();
            BigDecimal afterAmt = null == rspBO.getAfterInvoice().getAmt() ? BigDecimal.ZERO : rspBO.getAfterInvoice().getAmt();
            invoiceCmpResultBO.setAmountMargin(this.subtract(preAmt, afterAmt));
            BigDecimal preTaxAmt = null == rspBO.getPreInvoice().getTaxAmt() ? BigDecimal.ZERO : rspBO.getPreInvoice().getTaxAmt();
            BigDecimal afterTaxAmt = null == rspBO.getAfterInvoice().getTaxAmt() ? BigDecimal.ZERO : rspBO.getAfterInvoice().getTaxAmt();
            invoiceCmpResultBO.setTaxMargin(this.subtract(preTaxAmt, afterTaxAmt));
            BigDecimal preUntaxAmt = null == rspBO.getPreInvoice().getUntaxAmt() ? BigDecimal.ZERO : rspBO.getPreInvoice().getUntaxAmt();
            BigDecimal afterUntaxAmt = null == rspBO.getAfterInvoice().getUntaxAmt() ? BigDecimal.ZERO : rspBO.getAfterInvoice().getUntaxAmt();
            invoiceCmpResultBO.setUntaxAmtMargin(this.subtract(preUntaxAmt, afterUntaxAmt));
        }
        rspBO.setInvoiceCmpResult(invoiceCmpResultBO);
    }

    private int checkParam(Object param1, Object param2) {
        int isMatch = FscConstants.FscInvoiceVerifyResult.NO;
        if (param1 instanceof String) {
            String pstr1 = (String)param1;
            String pstr2 = (String)param2;
            if (!StringUtils.isBlank((CharSequence)pstr1) && !StringUtils.isBlank((CharSequence)pstr2) && param1.equals(param2)) {
                isMatch = FscConstants.FscInvoiceVerifyResult.YES;
            }
        }
        if (param1 instanceof BigDecimal) {
            BigDecimal bstr1 = (BigDecimal)param1;
            BigDecimal bstr2 = (BigDecimal)param2;
            if (null != bstr1 && null != bstr2 && bstr1.compareTo(bstr2) == 0) {
                isMatch = FscConstants.FscInvoiceVerifyResult.YES;
            }
        }
        return isMatch;
    }

    private FscBillOrderInvoiceCheckAbilityRspBO qryItem(FscBillOrderInvoiceCheckAbilityReqBO reqBO, FscBillOrderInvoiceCheckAbilityRspBO rspBO, List<FscOrderRelationPO> fscOrderRelationPos, Integer orderItemCount, Integer orderSource, FscOrderInvoicePO preOrderInvoice, Map<Long, FscInvoicePO> fscInvoiceMap) {
        Map<Long, FscOrderRelationPO> fscOrderRelationPOMap = fscOrderRelationPos.stream().collect(Collectors.toMap(FscOrderRelationPO::getAcceptOrderId, o -> o));
        FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
        fscInvoiceItemPO.setFscOrderId(reqBO.getOrderId());
        Integer invoiceItemCount = this.fscInvoiceItemMapper.getCheckBy(fscInvoiceItemPO);
        ArrayList<Long> orderIds = new ArrayList<Long>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        FscOrderItemPO fscOrderItemPOSel = new FscOrderItemPO();
        fscOrderItemPOSel.setFscOrderId(reqBO.getOrderId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List fscOrderItemPOS = new ArrayList();
        if (FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderSource)) {
            fscOrderItemPOSel.setOrderBy("order_id, sku_id");
            fscOrderItemPOS = this.fscOrderItemMapper.getListPageWithGroupSkuAndOrder(fscOrderItemPOSel, page);
        } else {
            fscOrderItemPOSel.setOrderBy("order_item_id");
            fscOrderItemPOS = this.fscOrderItemMapper.getListPage(fscOrderItemPOSel, page);
        }
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        if (CollectionUtils.isEmpty(fscOrderItemPOS)) {
            return rspBO;
        }
        List preItems = JSON.parseArray((String)JSON.toJSONString(fscOrderItemPOS), InvoiceItemBO.class);
        preItems.forEach(invoiceItemBO -> {
            invoiceItemBO.setOrderCode(((FscOrderRelationPO)fscOrderRelationPOMap.get(invoiceItemBO.getAcceptOrderId())).getOrderNo());
            invoiceItemBO.setAcceptOrderNo(((FscOrderRelationPO)fscOrderRelationPOMap.get(invoiceItemBO.getAcceptOrderId())).getAcceptOrderNo());
            if (invoiceItemBO.getOrderItemId() != null) {
                invoiceItemBO.setLineNo(invoiceItemBO.getOrderItemId());
            }
        });
        rspBO.setPreItems(preItems);
        for (FscOrderItemPO orderItemPO : fscOrderItemPOS) {
            if (!orderIds.contains(orderItemPO.getOrderId())) {
                orderIds.add(orderItemPO.getOrderId());
            }
            if (skuIds.contains(orderItemPO.getSkuId())) continue;
            skuIds.add(orderItemPO.getSkuId());
        }
        fscInvoiceItemPO.setOrderIds(orderIds);
        fscInvoiceItemPO.setSkuIds(skuIds);
        List fscInvoiceItemPOS = new ArrayList();
        Page page1 = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderSource)) {
            fscInvoiceItemPO.setOrderBy("order_id, sku_id");
            fscInvoiceItemPOS = this.fscInvoiceItemMapper.getListPageWithGroupSkuAndOrder(fscInvoiceItemPO, page1);
        } else {
            fscInvoiceItemPO.setOrderBy("order_item_id");
            fscInvoiceItemPOS = this.fscInvoiceItemMapper.getListPageGroupByItem(fscInvoiceItemPO, page1);
        }
        HashMap<String, Object> fscInvoiceItemPoMap = new HashMap<String, Object>();
        for (Object fscInvoiceItem : fscInvoiceItemPOS) {
            String key = fscInvoiceItem.getOrderItemId().toString();
            if (FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderSource)) {
                key = fscInvoiceItem.getOrderId().toString() + fscInvoiceItem.getSkuId().toString();
            }
            fscInvoiceItemPoMap.put(key, fscInvoiceItem);
        }
        ArrayList<InvoiceItemBO> afterItems = new ArrayList<InvoiceItemBO>();
        for (FscOrderItemPO orderItemPO : fscOrderItemPOS) {
            FscInvoiceItemPO invoiceItemPO;
            String key = orderItemPO.getOrderItemId().toString();
            if (FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderSource)) {
                key = orderItemPO.getOrderId().toString() + orderItemPO.getSkuId().toString();
            }
            if (null == (invoiceItemPO = (FscInvoiceItemPO)fscInvoiceItemPoMap.get(key))) continue;
            InvoiceItemBO iiBO = (InvoiceItemBO)JSON.parseObject((String)JSON.toJSONString((Object)invoiceItemPO), InvoiceItemBO.class);
            iiBO.setOrderCode(fscOrderRelationPOMap.get(iiBO.getAcceptOrderId()).getOrderNo());
            iiBO.setAcceptOrderNo(fscOrderRelationPOMap.get(iiBO.getAcceptOrderId()).getAcceptOrderNo());
            FscInvoicePO aftOrderInvoice = fscInvoiceMap.get(invoiceItemPO.getInvoiceId());
            if (aftOrderInvoice != null) {
                iiBO.setBillDate(aftOrderInvoice.getBillDate());
                iiBO.setInvoiceCode(aftOrderInvoice.getInvoiceCode());
                iiBO.setInvoiceNo(aftOrderInvoice.getInvoiceNo());
            }
            if (iiBO.getOrderItemId() != null) {
                iiBO.setLineNo(iiBO.getOrderItemId());
            }
            afterItems.add(iiBO);
        }
        rspBO.setAfterItems(afterItems);
        BigDecimal itemNumMargin = new BigDecimal(invoiceItemCount - orderItemCount);
        rspBO.getInvoiceCmpResult().setItemNumMargin(itemNumMargin.abs());
        this.checkItem(rspBO, orderSource);
        return rspBO;
    }

    private void checkItem(FscBillOrderInvoiceCheckAbilityRspBO rspBO, Integer orderSource) {
        Map<Object, Object> afterMap = new HashMap();
        afterMap = FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderSource) ? rspBO.getAfterItems().stream().collect(Collectors.toMap(item -> "" + item.getOrderId() + item.getSkuId(), item -> item)) : rspBO.getAfterItems().stream().collect(Collectors.toMap(item -> "" + item.getOrderItemId(), item -> item));
        ArrayList<InvoiceItemBO> preItemList = new ArrayList<InvoiceItemBO>(rspBO.getAfterItems().size());
        ArrayList<InvoiceItemBO> afterItemList = new ArrayList<InvoiceItemBO>(rspBO.getAfterItems().size());
        for (InvoiceItemBO preItem : rspBO.getPreItems()) {
            InvoiceItemBO afterItem = null;
            afterItem = FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderSource) ? (InvoiceItemBO)afterMap.get("" + preItem.getOrderId() + preItem.getSkuId()) : (InvoiceItemBO)afterMap.get("" + preItem.getOrderItemId());
            if (afterItem == null) {
                afterItem = new InvoiceItemBO();
                afterItem.setIsMatch(FscConstants.FscInvoiceVerifyResult.NO);
            } else if (preItem.getUntaxAmt().compareTo(afterItem.getUntaxAmt().setScale(2, 4)) == 0 && preItem.getTaxAmt().compareTo(afterItem.getTaxAmt().setScale(2, 4)) == 0) {
                afterItem.setIsMatch(FscConstants.FscInvoiceVerifyResult.YES);
            } else {
                afterItem.setIsMatch(FscConstants.FscInvoiceVerifyResult.NO);
            }
            preItemList.add(preItem);
            afterItemList.add(afterItem);
        }
        rspBO.setPreItems(preItemList);
        rspBO.setAfterItems(afterItemList);
    }

    private BigDecimal subtract(BigDecimal minuend, BigDecimal subtrahend) {
        BigDecimal result = minuend.subtract(subtrahend);
        if (result.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return result.abs();
    }
}

