/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderApplyAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderToYCAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderToYCAbilityReqBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderApplyAbilityService"})
public class FscBillSendSaleFscOrderApplyAbilityServiceImpl
implements FscBillSendSaleFscOrderApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSendSaleFscOrderApplyAbilityServiceImpl.class);
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscBillSendSaleFscOrderToYCAbilityService fscBillSendSaleFscOrderToYCAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    private static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @PostMapping(value={"sendSaleFscOrderApply"})
    public FscBillSendSaleFscOrderApplyAbilityRspBO sendSaleFscOrderApply(@RequestBody FscBillSendSaleFscOrderApplyAbilityReqBO reqBO) {
        this.valid(reqBO);
        ArrayList<Long> pushOrderIds = new ArrayList<Long>();
        for (Long l : reqBO.getFscOrderIds()) {
            FscOrderPO order = new FscOrderPO();
            order.setFscOrderId(l);
            order = this.fscOrderMapper.getModelBy(order);
            if (FscOrderSendStateEnum.NO_AUDIT.getCode().equals(order.getSendState())) {
                throw new FscBusinessException("191000", order.getOrderNo() + "\u8be5\u7ed3\u7b97\u5355\u5df2\u5728\u5ba1\u6279\u4e2d");
            }
            if (FscConstants.FscInvoiceOrderState.BILLFAIL.equals(order.getOrderState())) {
                pushOrderIds.add(l);
                continue;
            }
            this.fscOrderMapper.deleteOrderSendTemp(l);
            FscOrderPO fscSendTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
            fscSendTemp.setFscOrderId(l);
            fscSendTemp.setYcDeptId(reqBO.getDeptId().toString());
            fscSendTemp.setYcDeptName(reqBO.getDeptName());
            fscSendTemp.setYcPersonId(reqBO.getPersonId().toString());
            fscSendTemp.setYcPersonName(reqBO.getPersonName());
            fscSendTemp.setBuynerNo(order.getBuynerNo());
            fscSendTemp.setBuynerName(order.getBuynerName());
            log.debug("========\u63a8\u9001\u9500\u552e\u5355\u7533\u8bf7\u4e34\u65f6\u4fdd\u5b58\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscSendTemp));
            this.fscOrderMapper.insertOrderSendTemp(fscSendTemp);
            this.invokeUacTask(reqBO, l);
            FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
            taskPo.setFscOrderId(l);
            List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setSignApplyTime(new Date());
            if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
                fscOrderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
            }
            fscOrderPO.setFscOrderId(l);
            fscOrderPO.setSendState(FscOrderSendStateEnum.NO_AUDIT.getCode());
            fscOrderPO.setSendApplyTime(new Date());
            fscOrderPO.setSendUserId(reqBO.getUserId());
            fscOrderPO.setSendUserName(reqBO.getName());
            fscOrderPO.setOperatorId(reqBO.getUserId());
            fscOrderPO.setOperatorName(reqBO.getName());
            String operationNo = String.valueOf(reqBO.getOrgId());
            String[] org = this.proOrg.split(",");
            String[] pur = reqBO.getOrgPath().split("-");
            block1: for (String pro : org) {
                for (String t : pur) {
                    if (!pro.equals(t)) continue;
                    operationNo = pro;
                    continue block1;
                }
            }
            fscOrderPO.setOperationNo(operationNo);
            UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            ArrayList<Long> operationNos = new ArrayList<Long>();
            operationNos.add(Long.parseLong(operationNo));
            abilityReqBO.setOrgIdList(operationNos);
            UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
            if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
                Map orgMap = rspBO.getOrgMap();
                fscOrderPO.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(Long.valueOf(fscOrderPO.getOperationNo()))).getOrgName());
            }
            this.fscOrderMapper.updateById(fscOrderPO);
            if (reqBO.getWebSource() == null || !reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) continue;
            this.dealWorkFlow(order);
        }
        if (!CollectionUtils.isEmpty(pushOrderIds)) {
            FscBillSendSaleFscOrderToYCAbilityReqBO ycAbilityReqBO = (FscBillSendSaleFscOrderToYCAbilityReqBO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillSendSaleFscOrderToYCAbilityReqBO.class);
            ycAbilityReqBO.setFscOrderIds(pushOrderIds);
            this.fscBillSendSaleFscOrderToYCAbilityService.sendSaleFscOrder(ycAbilityReqBO);
        }
        this.sendMq(reqBO.getFscOrderIds());
        return new FscBillSendSaleFscOrderApplyAbilityRspBO();
    }

    private void valid(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u53c2\u6570[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) {
            if (reqBO.getDeptId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[deptId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getDeptName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[deptName]\u4e3a\u7a7a");
            }
            if (reqBO.getPersonId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[personId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getPersonName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[personName]\u4e3a\u7a7a");
            }
            if (reqBO.getYcUserId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[ycUserId]\u4e3a\u7a7a");
            }
        }
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private void sendMq(List<Long> orderIds) {
        for (Long orderId : orderIds) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(orderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
    }

    private void invokeUacTask(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, Long l) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setMenuId("M001007");
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(l);
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(l.toString());
        approvalObjBO.setObjName("\u9500\u552e\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
    }

    private void valItem(FscOrderPO fscOrderPO) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
            for (FscOrderItemPO fscOrderItemPOFor : fscOrderItemPOList) {
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setOrderId(fscOrderItemPOFor.getOrderId());
                fscShouldPayPO.setBuyerNo(fscOrderPO.getBuynerNo());
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                statusList.add(FscConstants.ShouldPayStatus.TO_PAY);
                statusList.add(FscConstants.ShouldPayStatus.PART_PAY);
                statusList.add(FscConstants.ShouldPayStatus.PAYED);
                statusList.add(FscConstants.ShouldPayStatus.TO_RELIEF);
                fscShouldPayPO.setShouldPayStatusList(statusList);
                List fscShouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
                if (null == fscShouldPayPOList) continue;
                for (FscShouldPayPO fscShouldPayPOFor : fscShouldPayPOList) {
                    if (!FscConstants.ShouldObjectType.SALE_ORDER.equals(fscShouldPayPOFor.getObjectType()) && !FscConstants.ShouldObjectType.CHECK_ORDER.equals(fscShouldPayPOFor.getObjectType()) && !FscConstants.ShouldObjectType.DELIVER_ORDER.equals(fscShouldPayPOFor.getObjectType()) || !FscConstants.ShouldPayType.ADVANCE_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.PAYMENT_PRE_PAY.equals(fscShouldPayPOFor.getShouldPayType()) || fscShouldPayPOFor.getShouldPayAmount().compareTo(fscShouldPayPOFor.getClaimAmt()) <= 0) continue;
                    throw new FscBusinessException("191026", "\u7ed3\u7b97\u5355\u4e2d\u6709\u8ba2\u5355\u4e3a\u8fdb\u884c\u9884\u6536\u8ba4\u9886\uff0c\u8bf7\u5148\u8ba4\u9886\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u5f00\u7968\u3002");
                }
            }
        }
    }
}

