/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscOrderPayNoticeAbilityService;
import com.tydic.fsc.bill.ability.bo.FscOrderPayNoticeAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscOrderPayNoticeAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscOrderPayNoticeBusiService;
import com.tydic.fsc.bill.busi.bo.FscOrderPayNoticeBusiReqBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscOrderPayNoticeAbilityService"})
public class FscOrderPayNoticeAbilityServiceImpl
implements FscOrderPayNoticeAbilityService {
    @Autowired
    private FscOrderPayNoticeBusiService fscOrderPayNoticeBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;

    @PostMapping(value={"noticeOrderPay"})
    public FscOrderPayNoticeAbilityRspBO noticeOrderPay(@RequestBody FscOrderPayNoticeAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscOrderPO fscOrderPO = this.fscOrderMapper.qryByFscOrderId(reqBO.getFscOrderId());
        if (fscOrderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (StringUtils.isEmpty((Object)fscOrderPO.getBuynerNo())) {
            return new FscOrderPayNoticeAbilityRspBO();
        }
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        fscOrderIds.add(reqBO.getFscOrderId());
        List orderCodeList = this.fscOrderRelationMapper.getOrderCodeList(fscOrderIds);
        for (String orderCode : orderCodeList) {
            FscOrderPayNoticeBusiReqBO busiReqBO = new FscOrderPayNoticeBusiReqBO();
            busiReqBO.setOrderCode(orderCode);
            busiReqBO.setPayeeId(fscOrderPO.getPayeeId());
            busiReqBO.setPayerId(fscOrderPO.getPayerId());
            busiReqBO.setPayFlag(reqBO.getPayFlag());
            this.fscOrderPayNoticeBusiService.noticeOrderPay(busiReqBO);
        }
        FscOrderPayNoticeAbilityRspBO rspBO = new FscOrderPayNoticeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscOrderPayNoticeAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

