/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillOrderConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderConfirmBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderRejectAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderRejectAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderRejectAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBillOrderConfirmBusiServiceImpl
implements FscBillOrderConfirmBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderRejectAtomService fscOrderRejectAtomService;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    private static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";

    @Override
    public FscBillOrderConfirmBusiRspBO dealBillOrderConfirm(FscBillOrderConfirmBusiReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u53f7\u4fe1\u606f\uff01");
        }
        if (!fscOrderPo.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILL_UN_CONFIRMED)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u4e3a\u5df2\u63d0\u4ea4\u72b6\u6001");
        }
        FscOrderPO updatePo = new FscOrderPO();
        updatePo.setFscOrderId(reqBO.getFscOrderId());
        updatePo.setOperatorId(reqBO.getUserId());
        updatePo.setOperatorName(reqBO.getName());
        updatePo.setOperationTime(new Date());
        updatePo.setRejectReason(reqBO.getRejectReason());
        this.fscOrderMapper.updateById(updatePo);
        if (reqBO.getConfirmResult().equals(FscConstants.FscConfirmResult.CONFIRM)) {
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
            fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
            }
        } else if (reqBO.getConfirmResult().equals(FscConstants.FscConfirmResult.NOT_CONFIRM)) {
            FscOrderRejectAtomReqBO atomReqBO = new FscOrderRejectAtomReqBO();
            atomReqBO.setFscOrderId(fscOrderPo.getFscOrderId());
            atomReqBO.setOrderState(fscOrderPo.getOrderState());
            FscOrderRejectAtomRspBO atomRspBO = this.fscOrderRejectAtomService.dealOrderReject(atomReqBO);
            if (!atomRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
        }
        FscBillOrderConfirmBusiRspBO rspBO = new FscBillOrderConfirmBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }
}

