/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderToYCAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderToYCAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderToYCAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillSendSaleFscOrderApprovalBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderApprovalBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderApprovalBusiRspBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillSendSaleFscOrderApprovalBusiServiceImpl
implements FscBillSendSaleFscOrderApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSendSaleFscOrderApprovalBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscBillSendSaleFscOrderToYCAbilityService fscBillSendSaleFscOrderToYCAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    public static final String PASS = "0";
    private static final String BUSI_NAME = "\u4e1a\u8d22\u63a8\u9001\u5931\u8d25";
    private static final String APPROVAL_NAME = "\u5ba1\u6279\u901a\u8fc7";

    @Override
    public FscBillSendSaleFscOrderApprovalBusiRspBO sendSaleFscOrderApproval(FscBillSendSaleFscOrderApprovalBusiReqBO reqBO) {
        FscBillSendSaleFscOrderApprovalBusiRspBO rspBO = new FscBillSendSaleFscOrderApprovalBusiRspBO();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (StringUtils.isEmpty((Object)fscOrderPO.getSendStation())) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u5ba1\u6279\u5c97\u4f4d\u6570\u636e\u5f02\u5e38");
        }
        Boolean stationFlag = true;
        HashMap<String, Long> stationMap = new HashMap<String, Long>();
        for (Long s : reqBO.getStationsList()) {
            stationMap.put(s.toString(), s);
        }
        for (String s : fscOrderPO.getSendStation().split(",")) {
            if (stationMap.get(s) == null) continue;
            stationFlag = false;
        }
        if (stationFlag.booleanValue()) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u8d26\u53f7\u65e0\u4e0b\u4e00\u6b65\u5ba1\u6279\u6743\u9650");
        }
        UacNoTaskAuditOrderAuditRspBO approvalResult = this.getApprovalResult(reqBO);
        UacNoneInstanceBO noneInstanceBO = approvalResult.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getOrderId());
        orderPO.setSendOperTime(new Date());
        orderPO.setSendOperId((StringUtils.isEmpty((Object)fscOrderPO.getSendOperId()) ? "" : fscOrderPO.getSendOperId()) + reqBO.getUserId().toString() + ",");
        orderPO.setSendOperName(reqBO.getName());
        if (PASS.equals(auditResult)) {
            if (finish.booleanValue()) {
                orderPO.setSendState(FscOrderSendStateEnum.PASS.getCode());
                FscOrderPO sendTemp = this.fscOrderMapper.getOrderSendTemp(reqBO.getOrderId());
                FscBillSendSaleFscOrderToYCAbilityReqBO ycAbilityReqBO = new FscBillSendSaleFscOrderToYCAbilityReqBO();
                ArrayList<Long> fscOrderIdList = new ArrayList<Long>();
                fscOrderIdList.add(reqBO.getOrderId());
                ycAbilityReqBO.setUserId(sendTemp.getUserId());
                ycAbilityReqBO.setUserName(sendTemp.getUserName());
                ycAbilityReqBO.setName(sendTemp.getName());
                ycAbilityReqBO.setCompanyId(sendTemp.getCompanyId());
                ycAbilityReqBO.setCompanyName(sendTemp.getCompanyName());
                ycAbilityReqBO.setOrgId(sendTemp.getOrgId());
                ycAbilityReqBO.setOrgName(sendTemp.getOrgName());
                ycAbilityReqBO.setFscOrderIds(fscOrderIdList);
                ycAbilityReqBO.setDeptId(Long.valueOf(Long.parseLong(sendTemp.getYcDeptId())));
                ycAbilityReqBO.setDeptName(sendTemp.getYcDeptName());
                ycAbilityReqBO.setPersonId(Long.valueOf(Long.parseLong(sendTemp.getYcPersonId())));
                ycAbilityReqBO.setPersonName(sendTemp.getYcPersonName());
                ycAbilityReqBO.setYcUserId(Long.valueOf(Long.parseLong(sendTemp.getYcUserId())));
                ycAbilityReqBO.setBuynerNo(sendTemp.getBuynerNo());
                ycAbilityReqBO.setBuynerName(sendTemp.getBuynerName());
                FscBillSendSaleFscOrderToYCAbilityRspBO ycAbilityRspBO = this.fscBillSendSaleFscOrderToYCAbilityService.sendSaleFscOrder(ycAbilityReqBO);
                if (!"0000".equals(ycAbilityRspBO.getRespCode())) {
                    FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                    fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                    fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPO.getFscOrderId());
                    fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPO.getOrderState());
                    HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
                    try {
                        FscOrderPO updateReason = new FscOrderPO();
                        updateReason.setFscOrderId(fscOrderPO.getFscOrderId());
                        updateReason.setFailReason(ycAbilityRspBO.getRespDesc());
                        this.fscOrderMapper.updateById(updateReason);
                    }
                    catch (Exception e) {
                        log.error("\u5b58\u50a8\u65e5\u5fd7\u5931\u8d25\uff01" + e);
                    }
                    paramMap.put("skipFlag", FscConstants.BillOrderSkigFlag.SKIG_FLAG_ERROR);
                    fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
                    FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
                    if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                        throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
                    }
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
                taskPo.setFscOrderId(reqBO.getOrderId());
                List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
                if (CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                    throw new FscBusinessException("198888", "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5f02\u5e38");
                }
                List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
                orderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
            }
        } else {
            orderPO.setSendState(FscOrderSendStateEnum.REFUSE.getCode());
            orderPO.setOrderState(FscConstants.FscInvoiceOrderState.APPROVAL_REJECT);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        this.fscOrderMapper.updateById(orderPO);
        return rspBO;
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscBillSendSaleFscOrderApprovalBusiReqBO reqBO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getOrderId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL;
        String stepId = this.fscOrderMapper.selectStepId(reqBO.getOrderId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        auditReqBO.setStepId(stepId);
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }
}

