/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscBillOrderCreatePayAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreatePayAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreatePayAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreatePayBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreatePayBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreatePayBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderCreatePayAbilityService"})
public class FscBillOrderCreatePayAbilityServiceImpl
implements FscBillOrderCreatePayAbilityService {
    @Autowired
    private FscBillOrderCreatePayBusiService fscBillOrderCreatePayBusiService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;

    @PostMapping(value={"dealBillOrderPayCreate"})
    public FscBillOrderCreatePayAbilityRspBO dealBillOrderPayCreate(@RequestBody FscBillOrderCreatePayAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2fscOrderIds\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderIds(reqBO.getFscOrderIds());
        List list = this.fscOrderMapper.getList(orderPO);
        StringBuilder sb = new StringBuilder();
        for (FscOrderPO fscOrderPO : list) {
            if (!fscOrderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.SIGNED)) continue;
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            FscBillOrderCreatePayBusiReqBO busiReqBO = new FscBillOrderCreatePayBusiReqBO();
            this.dealAccountRule(busiReqBO, fscOrderPO, fscAcceptOrderListQueryAtomRspBO);
            busiReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            FscBillOrderCreatePayBusiRspBO busiRspBO = this.fscBillOrderCreatePayBusiService.dealBillOrderPayCreate(busiReqBO);
            if (busiRspBO.getRespCode().equals("0000")) continue;
            sb.append("\u7ed3\u7b97\u5355[").append(fscOrderPO.getOrderNo()).append("]\u64cd\u4f5c\u5931\u8d25\uff1a").append(busiRspBO.getRespDesc());
        }
        FscBillOrderCreatePayAbilityRspBO rspBO = new FscBillOrderCreatePayAbilityRspBO();
        if (StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespDesc("198888");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private void dealAccountRule(FscBillOrderCreatePayBusiReqBO reqBO, FscOrderPO fscOrderPO, FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO) {
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
            FscOrderInfoBO fscOrderInfoBO = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            if ((fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER) || fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE)) && fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                fscOrderInfoBO.setPayAccountDayRule(fscOrderInfoBO.getProPayAccountDayRule());
                fscOrderInfoBO.setPayNodeRule(fscOrderInfoBO.getProPayNodeRule());
                fscOrderInfoBO.setPayBreakScale(fscOrderInfoBO.getProPayBreakScale());
                fscOrderInfoBO.setModelContractId(fscOrderInfoBO.getProModelContractId());
                fscOrderInfoBO.setModelContractNo(fscOrderInfoBO.getProModelContractNo());
                fscOrderInfoBO.setPayAccountDay(fscOrderInfoBO.getProPayAccountDay());
                fscOrderInfoBO.setPayNodeAccountDays(fscOrderInfoBO.getProPaymentDays());
            }
            if (FscConstants.MerchantPayAccountDayRule.SIGN.equals(fscOrderInfoBO.getPayAccountDayRule()) || FscConstants.MerchantPayNodeRule.SIGN.equals(fscOrderInfoBO.getPayNodeRule())) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
                fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
                fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
                fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO, fscOrderPO.getOrderSource()));
                fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                String invoiceNo = this.fscInvoiceMapper.getInvoiceNoByFscOrderId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setInvoiceNo(invoiceNo);
                fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
                fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
                fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", fscAcceptOrderListQueryAtomRspBO.getOrderOperList()));
                fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", fscAcceptOrderListQueryAtomRspBO.getOrderCodeList()));
                fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                fscShouldPayBOS.add(fscShouldPayBO);
                reqBO.setFscShouldPayBOS(fscShouldPayBOS);
                reqBO.setCreateShouldPayFlag(true);
            }
        }
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO, Integer orderSource) {
        Calendar now = Calendar.getInstance();
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }
}

