/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.bill.ability.api.FscCheckResultQryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscCheckResultQryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscCheckResultQryAbilityRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.uoc.common.ability.api.PebExtSalesSingleDetailsQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsQueryRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscCheckResultQryAbilityService"})
public class FscCheckResultQryAbilityServiceImpl
implements FscCheckResultQryAbilityService {
    @Autowired
    private PebExtSalesSingleDetailsQueryAbilityService pebExtSalesSingleDetailsQueryAbilityService;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"dealEcomCheck"})
    public FscCheckResultQryAbilityRspBO dealEcomCheck(@RequestBody FscCheckResultQryAbilityReqBO reqBO) {
        if (reqBO.getOrderId() != null && reqBO.getSaleVoucherId() != null) {
            PebExtSalesSingleDetailsQueryReqBO pebExtSalesSingleDetailsQueryReqBO = new PebExtSalesSingleDetailsQueryReqBO();
            pebExtSalesSingleDetailsQueryReqBO.setOrderId(reqBO.getOrderId());
            pebExtSalesSingleDetailsQueryReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
            PebExtSalesSingleDetailsQueryRspBO pebExtSalesSingleDetailsQueryRspBO = this.pebExtSalesSingleDetailsQueryAbilityService.getSalesSingleDetailsQuery(pebExtSalesSingleDetailsQueryReqBO);
            if (!"0000".equals(pebExtSalesSingleDetailsQueryRspBO.getRespCode())) {
                throw new ZTBusinessException(pebExtSalesSingleDetailsQueryRspBO.getRespDesc());
            }
            List itemInfo = pebExtSalesSingleDetailsQueryRspBO.getItemInfo();
            if (!CollectionUtils.isEmpty((Collection)itemInfo)) {
                BigDecimal sumPurchaseCount = new BigDecimal("");
                BigDecimal sumAcceptanceCount = new BigDecimal("");
                itemInfo.forEach(e -> {
                    sumPurchaseCount.add(e.getPurchaseCount());
                    sumAcceptanceCount.add(e.getAcceptanceCount());
                });
                if (sumPurchaseCount.compareTo(sumAcceptanceCount) != 0) {
                    throw new ZTBusinessException("\u8be5\u8ba2\u5355\u4e0b\u7684\u5546\u54c1\u672a\u5168\u90e8\u5165\u5e93\uff0c\u8bf7\u5f85\u5165\u5e93\u5b8c\u6210\u518d\u64cd\u4f5c");
                }
            }
        }
        FscCheckResultPO fscCheckResultPo = new FscCheckResultPO();
        if (null != reqBO.getOperSn()) {
            fscCheckResultPo.setOperSn(reqBO.getOperSn());
        }
        if (null != reqBO.getCheckTimeStart()) {
            fscCheckResultPo.setCheckTimeStart(reqBO.getCheckTimeStart());
        }
        if (null != reqBO.getCheckTimeEnd()) {
            fscCheckResultPo.setCheckTimeEnd(reqBO.getCheckTimeEnd());
        }
        if (null != reqBO.getRelOrderList() && reqBO.getRelOrderList().size() != 0) {
            List acceptOrderIds = reqBO.getRelOrderList().stream().map(RelOrderBO::getAcceptOrderId).collect(Collectors.toList());
            fscCheckResultPo.setAcceptOrderIds(acceptOrderIds);
        }
        List fscCheckResultPos = this.fscCheckResultMapper.getList(fscCheckResultPo);
        List relOrderBos = JSON.parseArray((String)JSON.toJSONString((Object)fscCheckResultPos), RelOrderBO.class);
        Map<Long, RelOrderBO> relOrderBOMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(RelOrderBO::getAcceptOrderId, relOrderBO -> relOrderBO));
        List equalsReOrderBos = relOrderBos.stream().filter(relOrderBO -> FscConstants.BillCheck.EQUALS.equals(relOrderBO.getStatus())).map(relOrderBO -> {
            RelOrderBO relOrder = (RelOrderBO)relOrderBOMap.get(relOrderBO.getAcceptOrderId());
            relOrder.setMyAmount(relOrderBO.getAmount());
            relOrder.setAmount(relOrderBO.getAmount());
            relOrder.setSaleAmount(relOrderBO.getSaleAmount());
            return relOrder;
        }).collect(Collectors.toList());
        List notEqualsReOrderBos = relOrderBos.stream().filter(relOrderBO -> FscConstants.BillCheck.NOT_EQUALS.equals(relOrderBO.getStatus())).collect(Collectors.toList());
        BigDecimal equalsPurAmt = equalsReOrderBos.stream().map(RelOrderBO::getMyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal equalsSaleAmt = equalsReOrderBos.stream().map(RelOrderBO::getSaleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        FscCheckResultQryAbilityRspBO rspBO = new FscCheckResultQryAbilityRspBO();
        rspBO.setOrderNum(Integer.valueOf(relOrderBos.size()));
        rspBO.setOrderYesNum(Integer.valueOf(equalsReOrderBos.size()));
        rspBO.setRelOrderYesList(equalsReOrderBos);
        rspBO.setOrderNoNum(Integer.valueOf(notEqualsReOrderBos.size()));
        rspBO.setRelOrderNoList(notEqualsReOrderBos);
        rspBO.setOrderYesPurAmt(equalsPurAmt);
        rspBO.setOrderYesSaleAmt(equalsSaleAmt);
        int waitNum = reqBO.getRelOrderList().size() - equalsReOrderBos.size() - notEqualsReOrderBos.size();
        rspBO.setOrderWaitNum(Integer.valueOf(waitNum));
        return rspBO;
    }
}

