/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApplyBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignWriteOffBusiReqBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceCheckResultMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceCheckResultPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderInvoiceSignApplyBusiServiceImpl
implements FscBillOrderInvoiceSignApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderInvoiceSignApplyBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscInvoiceCheckResultMapper fscInvoiceCheckResultMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    private static final String BUSI_NAME = "\u53d1\u7968\u7b7e\u6536\u7533\u8bf7";
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscPayVerificationAbilityService fscPayVerificationAbilityService;

    @Override
    public FscBillOrderInvoiceSignApplyBusiRspBO dealOrderInvoiceSignApply(FscBillOrderInvoiceSignApplyBusiReqBO reqBO) {
        this.fscOrderMapper.deleteOrderSignTemp(reqBO.getOrderId());
        FscOrderPO fscSignTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
        fscSignTemp.setFscOrderId(reqBO.getOrderId());
        fscSignTemp.setYcDeptId(reqBO.getDeptId());
        fscSignTemp.setYcDeptName(reqBO.getDeptName());
        fscSignTemp.setYcPersonId(reqBO.getPersonId());
        fscSignTemp.setYcPersonName(reqBO.getPersonName());
        log.debug("========\u53d1\u7968\u7b7e\u6536\u7533\u8bf7\u4e34\u65f6\u4fdd\u5b58\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscSignTemp));
        this.fscOrderMapper.insertOrderSignTemp(fscSignTemp);
        FscInvoiceCheckResultPO fscInvoiceCheckResultPO = new FscInvoiceCheckResultPO();
        fscInvoiceCheckResultPO.setFscOrderId(reqBO.getOrderId());
        this.fscInvoiceCheckResultMapper.deleteBy(fscInvoiceCheckResultPO);
        if (null != reqBO.getInvoiceCmpResult()) {
            fscInvoiceCheckResultPO.setAmountMargin(reqBO.getInvoiceCmpResult().getAmountMargin());
            fscInvoiceCheckResultPO.setCmpResult(reqBO.getInvoiceCmpResult().getCmpResultStr());
            fscInvoiceCheckResultPO.setIteNumMargin(reqBO.getInvoiceCmpResult().getItemNumMargin());
            fscInvoiceCheckResultPO.setUntaxAmtMargin(reqBO.getInvoiceCmpResult().getUntaxAmtMargin());
            fscInvoiceCheckResultPO.setTaxMargin(reqBO.getInvoiceCmpResult().getTaxMargin());
            fscInvoiceCheckResultPO.setCreateOperId(reqBO.getUserId());
            fscInvoiceCheckResultPO.setCreateOperName(reqBO.getName());
            fscInvoiceCheckResultPO.setCreateTime(new Date());
            fscInvoiceCheckResultPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscInvoiceCheckResultPO.setFscOrderId(reqBO.getOrderId());
            this.fscInvoiceCheckResultMapper.insert(fscInvoiceCheckResultPO);
        }
        this.fscOrderMapper.deleteOrderAmount(reqBO.getOrderId());
        BigDecimal writeOffAmt = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(reqBO.getPurWriteOffAmount())) {
            for (FscBillOrderInvoiceSignWriteOffBusiReqBO writeOffBusiBO : reqBO.getPurWriteOffAmount()) {
                FscOrderPO tempPo = new FscOrderPO();
                tempPo.setFscOrderId(reqBO.getOrderId());
                tempPo.setShouldPayId(writeOffBusiBO.getPayOrderId());
                tempPo.setWriteOffAmount(writeOffBusiBO.getWriteOffAmount());
                writeOffAmt = writeOffAmt.add(writeOffBusiBO.getWriteOffAmount());
                this.fscOrderMapper.insertOrderAmount(tempPo);
            }
        }
        if (writeOffAmt.compareTo(BigDecimal.ZERO) == 0) {
            FscPayVerificationAbilityReqBO verificationAbilityReqBO = new FscPayVerificationAbilityReqBO();
            verificationAbilityReqBO.setFscOrderId(reqBO.getOrderId());
            verificationAbilityReqBO.setPageNo(Integer.valueOf(1));
            verificationAbilityReqBO.setPageSize(Integer.valueOf(1));
            FscPayVerificationAbilityRspBO verificationAbilityRspBO = this.fscPayVerificationAbilityService.queryPayVerificationPageList(verificationAbilityReqBO);
            if (verificationAbilityRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Collection)verificationAbilityRspBO.getRows())) {
                throw new FscBusinessException("191026", "\u7ed3\u7b97\u5355\u4e2d\u6709\u8ba2\u5355\u4e3a\u8fdb\u884c\u9884\u6536\u8ba4\u9886\uff0c\u8bf7\u5148\u8ba4\u9886\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u5f00\u7968\u3002");
            }
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        this.invokeUacTask(reqBO);
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(reqBO.getOrderId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        FscOrderPO set = new FscOrderPO();
        FscOrderPO where = new FscOrderPO();
        set.setSignApplyTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            where.setFscOrderId(reqBO.getOrderId());
            List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
            set.setSignStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
        }
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getOrderId());
        List invoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
            StringBuilder invoiceNo = new StringBuilder();
            StringBuilder invoiceCode = new StringBuilder();
            for (String[] i : invoicePOList) {
                invoiceNo.append(",").append(i.getInvoiceNo());
                invoiceCode.append(",").append(i.getInvoiceCode());
            }
            set.setInvoiceNo(invoiceNo.toString());
            set.setInvoiceCode(invoiceCode.toString());
            set.setBuyName(((FscInvoicePO)invoicePOList.get(0)).getBuyName());
        }
        set.setOperatorId(reqBO.getUserId());
        set.setOperatorName(reqBO.getName());
        String operationNo = String.valueOf(reqBO.getOrgId());
        String[] org = this.proOrg.split(",");
        String[] pur = reqBO.getOrgPath().split("-");
        block2: for (String pro : org) {
            for (String t : pur) {
                if (!pro.equals(t)) continue;
                operationNo = pro;
                continue block2;
            }
        }
        set.setOperationNo(operationNo);
        if (!StringUtils.isEmpty((Object)set.getOperationNo())) {
            UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            ArrayList<Long> operationNos = new ArrayList<Long>();
            operationNos.add(Long.parseLong(set.getOperationNo()));
            abilityReqBO.setOrgIdList(operationNos);
            UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
            if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
                Map orgMap = rspBO.getOrgMap();
                set.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(Long.valueOf(set.getOperationNo()))).getOrgName());
            }
        }
        this.fscOrderMapper.updateBy(set, where);
        return new FscBillOrderInvoiceSignApplyBusiRspBO();
    }

    private void invokeUacTask(FscBillOrderInvoiceSignApplyBusiReqBO reqBO) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setMenuId("M001004");
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(reqBO.getOrderId().toString());
        approvalObjBO.setObjName("\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
    }
}

