/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignApprovalBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApprovalBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApprovalBusiRspBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscStockOperAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCInvoiceItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCVerificationBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillTaxSendPurFscOrderToYCService;
import com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePoolMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePoolPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.DateUtil;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class FscBillOrderInvoiceSignApprovalBusiServiceImpl
implements FscBillOrderInvoiceSignApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderInvoiceSignApprovalBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    @Autowired
    private FscStockOperAtomService fscStockOperAtomService;
    @Autowired
    private FscBillTaxSendPurFscOrderToYCService fscBillTaxSendPurFscOrderToYCService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscPayVerificationAbilityService fscPayVerificationAbilityService;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoicePoolMapper fscInvoicePoolMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    private static final String BUSI_NAME = "\u53d1\u7968\u7b7e\u6536\u5ba1\u6279";
    public static final String PASS = "0";
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;

    @Override
    public FscBillOrderInvoiceSignApprovalBusiRspBO dealOrderInvoiceSignApproval(FscBillOrderInvoiceSignApprovalBusiReqBO reqBO) {
        FscBillOrderInvoiceSignApprovalBusiRspBO busiRspBO = new FscBillOrderInvoiceSignApprovalBusiRspBO();
        UacNoTaskAuditOrderAuditRspBO approvalResult = this.getApprovalResult(reqBO);
        UacNoneInstanceBO noneInstanceBO = approvalResult.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPO.getSignStation())) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u5ba1\u6279\u5c97\u4f4d\u6570\u636e\u5f02\u5e38");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getOrderId());
        orderPO.setSignOperId((org.springframework.util.StringUtils.isEmpty((Object)fscOrderPO.getSignOperId()) ? "" : fscOrderPO.getSignOperId()) + reqBO.getUserId().toString() + ",");
        orderPO.setSignOperName(reqBO.getName());
        orderPO.setSignOperTime(new Date());
        if (PASS.equals(auditResult)) {
            if (finish.booleanValue()) {
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getOrderId());
                fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
                paramMap.put("auditResult", FscConstants.AuditResultStatus.PASS);
                fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
                FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
                orderPO.setOrderState(Integer.valueOf(1003));
                FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(reqBO.getOrderId());
                if (signTemp == null) {
                    throw new FscBusinessException("193011", "\u53d1\u7968\u7b7e\u6536\u7533\u8bf7\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
                }
                FscOrderInvoicePO fscOrderInvoicePoSet = new FscOrderInvoicePO();
                if (null != signTemp.getUserId()) {
                    fscOrderInvoicePoSet.setSignOperId(signTemp.getUserId().toString());
                }
                fscOrderInvoicePoSet.setSignOperName(signTemp.getName());
                fscOrderInvoicePoSet.setSignTime(new Date());
                fscOrderInvoicePoSet.setSignTimeStart(new Date());
                FscOrderInvoicePO fscOrderInvoicePowhere = new FscOrderInvoicePO();
                fscOrderInvoicePowhere.setFscOrderId(signTemp.getFscOrderId());
                this.fscOrderInvoiceMapper.updateBy(fscOrderInvoicePoSet, fscOrderInvoicePowhere);
                List purWriteOffAmount = this.fscOrderMapper.getOrderAmount(reqBO.getOrderId());
                BigDecimal writeOffAmount = new BigDecimal(0);
                ArrayList<FscOrderPO> updatePayList = new ArrayList<FscOrderPO>();
                if (!CollectionUtils.isEmpty((Collection)purWriteOffAmount)) {
                    for (FscOrderPO po : purWriteOffAmount) {
                        FscOrderPO updatePo = new FscOrderPO();
                        updatePo.setFscOrderId(po.getShouldPayId());
                        updatePo.setWriteOffAmount(po.getWriteOffAmount());
                        updatePayList.add(updatePo);
                        writeOffAmount = writeOffAmount.add(po.getWriteOffAmount());
                    }
                }
                orderPO.setWriteOffAmountAdd(writeOffAmount);
                if (reqBO.getCreateShouldPayFlag().booleanValue()) {
                    this.createShouldPay(reqBO.getFscShouldPayBOS(), signTemp);
                }
                if (reqBO.getNeedOperStockEnable().booleanValue()) {
                    this.inStock(reqBO.getOrderId(), reqBO.getStockFlag());
                }
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setInvoiceNo(signTemp.getInvoiceNo());
                fscShouldPayPO.setFscOrderId(signTemp.getFscOrderId());
                this.fscShouldPayMapper.updateInvoiceNoByOrderId(fscShouldPayPO);
                this.syncOrderStatus(reqBO.getOrderId());
                FscInvoicePO fscInvoicePO = new FscInvoicePO();
                fscInvoicePO.setFscOrderId(reqBO.getOrderId());
                List invoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
                StringBuilder invoiceNo = new StringBuilder();
                StringBuilder invoiceCode = new StringBuilder();
                if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
                    for (FscInvoicePO po : invoicePOList) {
                        invoiceNo.append(po.getInvoiceNo()).append(",");
                        invoiceCode.append(po.getInvoiceCode()).append(",");
                    }
                }
                fscOrderPO.setInvoiceNo(invoiceNo.toString());
                fscOrderPO.setInvoiceCode(invoiceCode.toString());
                List<Long> billOrderIds = this.backFillBillInvoice(fscOrderPO);
                busiRspBO.setBillOrderIds(billOrderIds);
                this.checkPurSign(signTemp);
                for (FscOrderPO po : updatePayList) {
                    this.fscOrderMapper.updateWriteOffAmount(po);
                }
            } else {
                FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
                taskPo.setFscOrderId(reqBO.getOrderId());
                List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
                if (CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                    throw new FscBusinessException("198888", "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5f02\u5e38");
                }
                List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
                orderPO.setSignStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
            }
        } else {
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
            fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getOrderId());
            fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
            paramMap.put("auditResult", FscConstants.AuditResultStatus.REFUSE);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
            }
        }
        this.fscOrderMapper.updateById(orderPO);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        busiRspBO.setFinish(finish);
        return busiRspBO;
    }

    private void dealPrePayBillAndCreateShouldPay(Long orderId, FscOrderPO fscOrderPO, FscOrderPO signTemp) {
        FscOrderItemPO queryItemVo = new FscOrderItemPO();
        queryItemVo.setFscOrderId(orderId);
        List list = this.fscOrderItemMapper.getList(queryItemVo);
        List inspectionIds = list.stream().map(FscOrderItemPO::getAcceptOrderId).collect(Collectors.toList());
        FscShouldPayPO queryShouldPayVo = new FscShouldPayPO();
        queryShouldPayVo.setInspectionIdList(inspectionIds);
        queryShouldPayVo.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_FREEZE);
        List shouldPayPOList = this.fscShouldPayMapper.getList(queryShouldPayVo);
        HashSet<String> acceptOrderCodeList = new HashSet<String>();
        BigDecimal shouldPayAmount = BigDecimal.ZERO;
        for (FscShouldPayPO fscShouldPayPO : shouldPayPOList) {
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_INVALID);
            acceptOrderCodeList.add(fscShouldPayPO.getAcceptOrderCode());
            shouldPayAmount = shouldPayAmount.add(fscShouldPayPO.getShouldPayAmount());
        }
        this.fscShouldPayMapper.updateStatusByBatch(shouldPayPOList);
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
        fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PREP);
        fscShouldPayBO.setShouldPayAmount(shouldPayAmount);
        fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
        fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
        fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
        fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
        fscShouldPayBO.setContractId(fscOrderPO.getContractId());
        fscShouldPayBO.setContractNo(fscOrderPO.getContractNo());
        fscShouldPayBO.setOrderId(((FscShouldPayPO)shouldPayPOList.get(0)).getOrderId());
        fscShouldPayBO.setAcceptOrderCode(StringUtils.join(acceptOrderCodeList, (String)","));
        ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
        fscShouldPayBOS.add(fscShouldPayBO);
        FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
        fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        fscPayShouldPayCreateAtomReqBO.setUserId(signTemp.getUserId());
        fscPayShouldPayCreateAtomReqBO.setName(signTemp.getName());
        fscPayShouldPayCreateAtomReqBO.setUserName(signTemp.getUserName());
        fscPayShouldPayCreateAtomReqBO.setCompanyId(signTemp.getCompanyId());
        fscPayShouldPayCreateAtomReqBO.setCompanyName(signTemp.getCompanyName());
        fscPayShouldPayCreateAtomReqBO.setOrgId(signTemp.getOrgId());
        fscPayShouldPayCreateAtomReqBO.setOrgName(signTemp.getOrgName());
        FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
        if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
        }
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.SIGN);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscOrderPO signTemp) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(signTemp.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(signTemp.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(signTemp.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(signTemp.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(signTemp.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(signTemp.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(signTemp.getOrgName());
            List acceptOrderCodes = this.fscShouldPayMapper.selectAcceptOrderCode(signTemp.getFscOrderId());
            String acceptOrderCode = Joiner.on((String)",").join((Iterable)acceptOrderCodes);
            for (FscShouldPayBO bo : fscShouldPayBOS) {
                bo.setAcceptOrderCode(acceptOrderCode);
            }
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private void inStock(Long fscOrderId, Integer stockFlag) {
        FscStockOperAtomReqBO fscStockOperAtomReqBO = new FscStockOperAtomReqBO();
        fscStockOperAtomReqBO.setOperType(stockFlag);
        fscStockOperAtomReqBO.setFscOrderId(fscOrderId);
        FscStockOperAtomRspBO fscStockOperAtomRspBO = this.fscStockOperAtomService.dealStockOper(fscStockOperAtomReqBO);
        if (!"0000".equals(fscStockOperAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscStockOperAtomRspBO.getRespDesc());
        }
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscBillOrderInvoiceSignApprovalBusiReqBO reqBO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getOrderId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.ORDER_APPROVAL;
        String stepId = this.fscOrderMapper.selectStepId(reqBO.getOrderId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        auditReqBO.setStepId(stepId);
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (org.springframework.util.StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private void checkPurSign(FscOrderPO signTemp) {
        FscPushLogPO queryVo = new FscPushLogPO();
        queryVo.setObjectId(signTemp.getFscOrderId());
        FscPushLogPO lastPushLog = this.fscPushLogMapper.getLastPushLog(queryVo);
        if (lastPushLog != null && lastPushLog.getStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            return;
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(signTemp.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscDicDictionaryExernalPO dicDictionaryExernalPO = new FscDicDictionaryExernalPO();
        dicDictionaryExernalPO.setExernalSysCode("YC");
        List fscDicDictionaryExernalPOList = this.fscDicDictionaryExernalMapper.getListByCondition(dicDictionaryExernalPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(signTemp.getFscOrderId());
        List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(signTemp.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        BigDecimal untaxAmt = new BigDecimal(0);
        BigDecimal taxAmt = new BigDecimal(0);
        BigDecimal orderWriteOffAmt = new BigDecimal(0);
        for (FscInvoicePO fscInvoicePOFor : fscInvoicePOList) {
            untaxAmt = untaxAmt.add(null == fscInvoicePOFor.getUntaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getUntaxAmt());
            taxAmt = taxAmt.add(null == fscInvoicePOFor.getTaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getTaxAmt());
            orderWriteOffAmt = orderWriteOffAmt.add(fscInvoicePOFor.getAmt());
        }
        String orderSource = fscOrderPO.getOrderType() + "";
        List fscTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_ORDER_SOURCE")).filter(p -> p.getCode().equals(orderSource)).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fscTypeList)) {
            throw new FscBusinessException("193128", "\u7ed3\u7b97\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
        }
        UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscOrderPO.getPayeeId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
        if (!umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") || ObjectUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO())) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscBillTaxSendPurFscOrderToYCReqBO fscBillTaxSendPurFscOrderToYCReqBO = new FscBillTaxSendPurFscOrderToYCReqBO();
        FscBillTaxSendPurFscOrderToYCBO purchaseSettlement = new FscBillTaxSendPurFscOrderToYCBO();
        purchaseSettlement.setORG_ID(this.operOrgId);
        purchaseSettlement.setORG_NAME(this.operOrgName);
        purchaseSettlement.setDEPT_ID(signTemp.getYcDeptId());
        purchaseSettlement.setDEPT_NAME(signTemp.getYcDeptName());
        purchaseSettlement.setPERSON_ID(signTemp.getYcUserId());
        purchaseSettlement.setPERSON_NAME(signTemp.getYcPersonName());
        purchaseSettlement.setSETTLE_NUMBER(fscOrderPO.getOrderNo());
        purchaseSettlement.setSETTLE_NAME(fscOrderPO.getOrderNo());
        purchaseSettlement.setSETTLE_TYPE((String)fscTypeList.get(0));
        purchaseSettlement.setCONTRACT_NUMBER(fscOrderPO.getContractNo());
        if (!StringUtils.isEmpty((CharSequence)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())) {
            purchaseSettlement.setVENDOR_NUMBER(Long.valueOf(Long.parseLong(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())));
        }
        purchaseSettlement.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
        purchaseSettlement.setSETTLE_DATE(DateUtil.dateToStr((Date)new Date()));
        purchaseSettlement.setSETTLE_AMT(null == fscOrderPO.getTotalCharge() ? BigDecimal.ZERO : fscOrderPO.getTotalCharge().setScale(2, 4));
        purchaseSettlement.setINVOICE_AMT_WITHOUT_TAX(null == untaxAmt ? BigDecimal.ZERO : untaxAmt);
        purchaseSettlement.setTAX_AMT(null == taxAmt ? BigDecimal.ZERO : taxAmt);
        purchaseSettlement.setTESCO_ID(signTemp.getFscOrderId());
        fscBillTaxSendPurFscOrderToYCReqBO.setPurchaseSettlement(purchaseSettlement);
        ArrayList<FscBillTaxSendPurFscOrderToYCInvoiceItemBO> invoiceList = new ArrayList<FscBillTaxSendPurFscOrderToYCInvoiceItemBO>();
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
            for (FscInvoicePO fscInvoicePOFor : fscInvoicePOList) {
                FscBillTaxSendPurFscOrderToYCInvoiceItemBO fscInvoiceItemBO = new FscBillTaxSendPurFscOrderToYCInvoiceItemBO();
                List invoiceTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_INVOICE_TYPE")).filter(p -> p.getCode().equals(fscInvoicePOFor.getInvoiceType())).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
                if (CollectionUtils.isEmpty((Collection)invoiceTypeList)) {
                    throw new FscBusinessException("193128", "\u53d1\u7968\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
                }
                FscInvoicePoolPO fscInvoicePoolPO = new FscInvoicePoolPO();
                fscInvoicePoolPO.setInvoiceNo(fscInvoicePOFor.getInvoiceNo());
                fscInvoicePoolPO.setInvoiceCode(fscInvoicePOFor.getInvoiceCode());
                fscInvoicePoolPO.setBillDate(fscInvoicePOFor.getBillDate());
                fscInvoicePoolPO = this.fscInvoicePoolMapper.getModelBy(fscInvoicePoolPO);
                if (null == fscInvoicePoolPO) {
                    fscInvoicePoolPO = new FscInvoicePoolPO();
                }
                fscInvoiceItemBO.setINVOICE_TYPE((String)invoiceTypeList.get(0));
                fscInvoiceItemBO.setINVOICE_ID(fscInvoicePoolPO.getId() + "");
                fscInvoiceItemBO.setINVOICE_NUM(fscInvoicePOFor.getInvoiceNo());
                fscInvoiceItemBO.setDRAWER_NAME(fscInvoicePOFor.getCreateOperName());
                fscInvoiceItemBO.setINVOICE_DATE(DateUtil.dateToStr((Date)fscInvoicePOFor.getCreateTime()));
                fscInvoiceItemBO.setTAX_RATE(AmountUtils.calcTaxRate((BigDecimal)fscInvoicePOFor.getTaxAmt(), (BigDecimal)fscInvoicePOFor.getUntaxAmt()).toString());
                fscInvoiceItemBO.setINVOICE_AMOUNT(null == fscInvoicePOFor.getUntaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getUntaxAmt().setScale(2, 4));
                fscInvoiceItemBO.setTAX_AMOUNT(null == fscInvoicePOFor.getTaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getTaxAmt().setScale(2, 4));
                fscInvoiceItemBO.setTOTAL_AMOUNT(null == fscInvoicePOFor.getAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getAmt().setScale(2, 4));
                fscInvoiceItemBO.setREST_AMOUNT(fscInvoiceItemBO.getTOTAL_AMOUNT().subtract(null == fscInvoiceItemBO.getSETTLE_AMOUNT() ? BigDecimal.ZERO : fscInvoiceItemBO.getSETTLE_AMOUNT()).setScale(2, 4));
                fscInvoiceItemBO.setSETTLE_AMOUNT(null == fscInvoicePOFor.getAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getAmt().setScale(2, 4));
                fscInvoiceItemBO.setTESCO_ID(fscInvoicePOFor.getInvoiceId());
                invoiceList.add(fscInvoiceItemBO);
            }
        }
        fscBillTaxSendPurFscOrderToYCReqBO.setInvoice(invoiceList);
        ArrayList<FscBillTaxSendPurFscOrderToYCVerificationBO> advanceCharge = new ArrayList<FscBillTaxSendPurFscOrderToYCVerificationBO>();
        BigDecimal writeOffAmt = new BigDecimal(0);
        List ycAbilityBOList = this.fscOrderMapper.getOrderAmount(signTemp.getFscOrderId());
        if (!CollectionUtils.isEmpty((Collection)ycAbilityBOList)) {
            for (FscOrderPO writeOffamt : ycAbilityBOList) {
                FscOrderPO fscOrderPOPay = this.fscOrderMapper.qryByFscOrderId(writeOffamt.getShouldPayId());
                if (null == fscOrderPOPay) {
                    throw new FscBusinessException("191026", "\u9884\u4ed8\u6b3e\u4e0d\u5b58\u5728");
                }
                if (!FscConstants.FscPayOrderState.PAIED.equals(fscOrderPOPay.getOrderState())) {
                    throw new FscBusinessException("198888", "\u4ed8\u6b3e\u672a\u5b8c\u6210\uff0c\u8bf7\u786e\u8ba4\u540e\u63d0\u4ea4");
                }
                if (null == fscOrderPOPay.getPaidAmount()) {
                    fscOrderPOPay.setPaidAmount(new BigDecimal(0));
                }
                if (fscOrderPOPay.getPaidAmount().subtract(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount()).compareTo(null == writeOffamt.getWriteOffAmount() ? BigDecimal.ZERO : writeOffamt.getWriteOffAmount()) < 0) {
                    throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u5355\u5269\u4f59\u6838\u9500\u91d1\u989d");
                }
                writeOffAmt = writeOffAmt.add(null == writeOffamt.getWriteOffAmount() ? BigDecimal.ZERO : writeOffamt.getWriteOffAmount());
                FscBillTaxSendPurFscOrderToYCVerificationBO verificationBO = new FscBillTaxSendPurFscOrderToYCVerificationBO();
                verificationBO.setPREPAY_NUMBER(fscOrderPOPay.getOrderNo());
                verificationBO.setPREPAY_NAME(fscOrderPOPay.getOrderNo());
                verificationBO.setAMOUNT(fscOrderPOPay.getPaidAmount().setScale(2, 4));
                verificationBO.setAMOUNT_APPLIED(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount().setScale(2, 4));
                verificationBO.setAMOUNT_UNAPPLIED(fscOrderPOPay.getPaidAmount().subtract(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount()).setScale(2, 4));
                verificationBO.setAPPLY_AMOUNT(writeOffamt.getWriteOffAmount().setScale(2, 4));
                verificationBO.setTESCO_ID(fscOrderPOPay.getFscOrderId());
                advanceCharge.add(verificationBO);
            }
        }
        if (orderWriteOffAmt.compareTo(writeOffAmt) < 0) {
            throw new FscBusinessException("191026", "\u6240\u6709\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u603b\u91d1\u989d");
        }
        if (fscOrderPO.getTotalCharge().compareTo(writeOffAmt) < 0) {
            throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u7b97\u91d1\u989d");
        }
        if (writeOffAmt.compareTo(BigDecimal.ZERO) == 0) {
            FscPayVerificationAbilityReqBO verificationAbilityReqBO = new FscPayVerificationAbilityReqBO();
            verificationAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            verificationAbilityReqBO.setPageNo(Integer.valueOf(1));
            verificationAbilityReqBO.setPageSize(Integer.valueOf(1));
            FscPayVerificationAbilityRspBO verificationAbilityRspBO = this.fscPayVerificationAbilityService.queryPayVerificationPageList(verificationAbilityReqBO);
            if (verificationAbilityRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Collection)verificationAbilityRspBO.getRows())) {
                throw new FscBusinessException("191026", "\u7ed3\u7b97\u5355\u4e2d\u6709\u8ba2\u5355\u4e3a\u8fdb\u884c\u9884\u6536\u8ba4\u9886\uff0c\u8bf7\u5148\u8ba4\u9886\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u5f00\u7968\u3002");
            }
        }
        fscBillTaxSendPurFscOrderToYCReqBO.setAdvanceCharge(advanceCharge);
        fscBillTaxSendPurFscOrderToYCReqBO.setPurchaseSettlement(purchaseSettlement);
        fscBillTaxSendPurFscOrderToYCReqBO.setYcUserId(Long.valueOf(Long.parseLong(signTemp.getYcUserId())));
        FscBillDealPushLogAbilityReqBO abilityReqBO = new FscBillDealPushLogAbilityReqBO();
        abilityReqBO.setCreateTime(new Date());
        abilityReqBO.setObjectId(fscOrderPO.getFscOrderId());
        abilityReqBO.setObjectNo(fscOrderPO.getOrderNo());
        abilityReqBO.setType(FscConstants.FscPushType.SETTLE);
        abilityReqBO.setObjData(JSONObject.toJSONString((Object)fscBillTaxSendPurFscOrderToYCReqBO));
        FscBillTaxSendPurFscOrderToYCRspBO fscBillTaxSendPurFscOrderToYCRspBO = this.fscBillTaxSendPurFscOrderToYCService.sendPurFscOrder(fscBillTaxSendPurFscOrderToYCReqBO);
        if (!fscBillTaxSendPurFscOrderToYCRspBO.getRespCode().equals("0000")) {
            abilityReqBO.setStatus(FscConstants.FscPushStatus.FAIL);
            this.fscBillAddPushLogAbilityService.savePushLog(abilityReqBO);
            throw new FscBusinessException("191026", "\u63a8\u9001\u4e1a\u8d22\u5931\u8d25\uff01" + fscBillTaxSendPurFscOrderToYCRspBO.getRespDesc());
        }
        abilityReqBO.setStatus(FscConstants.FscPushStatus.SUCCESS);
        this.fscBillAddPushLogAbilityService.savePushLog(abilityReqBO);
    }

    private List<Long> backFillBillInvoice(FscOrderPO fscOrderPO) {
        List<Long> billOrderIds = new ArrayList<Long>();
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBO.setRelId(fscOrderPO.getFscOrderId());
        uocInspectionDetailsListPageQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
        uocInspectionDetailsListPageQueryReqBO.setTabId(Integer.valueOf(80013));
        uocInspectionDetailsListPageQueryReqBO.setPageSize(1000000);
        UocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
        if (!CollectionUtils.isEmpty((Collection)inspectionDetailsList.getRows())) {
            UocInspectionDetailsListBO uocInspectionDetailsListBO = (UocInspectionDetailsListBO)inspectionDetailsList.getRows().get(0);
            billOrderIds = FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(uocInspectionDetailsListBO.getPayType()) && FscConstants.MerchantPayNodeRule.SIGN.equals(uocInspectionDetailsListBO.getProPayNodeRule()) ? this.fscOrderMapper.getBillOrderIdsByShouldPay(fscOrderPO) : this.fscOrderMapper.getBillOrderIdsByAdvance(fscOrderPO);
        }
        if (!CollectionUtils.isEmpty(billOrderIds)) {
            for (Long billOrderId : billOrderIds) {
                FscOrderPO billOrder = new FscOrderPO();
                billOrder.setFscOrderId(billOrderId);
                billOrder.setInvoiceNo(fscOrderPO.getInvoiceNo());
                billOrder.setInvoiceCode(fscOrderPO.getInvoiceCode());
                this.fscOrderMapper.updateById(fscOrderPO);
            }
        }
        return billOrderIds;
    }
}

