/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignWriteOffBusiReqBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscStockOperAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceCheckResultMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceCheckResultPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderInvoiceSignBusiServiceImpl
implements FscBillOrderInvoiceSignBusiService {
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceCheckResultMapper fscInvoiceCheckResultMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    private static final String BUSI_NAME = "\u53d1\u7968\u7b7e\u6536";
    @Autowired
    private FscStockOperAtomService fscStockOperAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Value(value="${SIGN_FLAG:true}")
    private Boolean signFlag;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;

    @Override
    public FscBillOrderInvoiceSignBusiRspBO dealOrderInvoiceSign(FscBillOrderInvoiceSignBusiReqBO reqBO) {
        FscBillOrderInvoiceSignBusiRspBO busiRspBO = new FscBillOrderInvoiceSignBusiRspBO();
        FscOrderInvoicePO fscOrderInvoicePoSet = new FscOrderInvoicePO();
        if (null != reqBO.getUserId()) {
            fscOrderInvoicePoSet.setSignOperId(reqBO.getUserId().toString());
        }
        fscOrderInvoicePoSet.setSignOperName(reqBO.getName());
        fscOrderInvoicePoSet.setSignTime(new Date());
        fscOrderInvoicePoSet.setSignTimeStart(new Date());
        FscOrderInvoicePO fscOrderInvoicePowhere = new FscOrderInvoicePO();
        fscOrderInvoicePowhere.setFscOrderId(reqBO.getOrderId());
        this.fscOrderInvoiceMapper.updateBy(fscOrderInvoicePoSet, fscOrderInvoicePowhere);
        if (null != reqBO.getInvoiceCmpResult()) {
            FscInvoiceCheckResultPO fscInvoiceCheckResultPO = new FscInvoiceCheckResultPO();
            fscInvoiceCheckResultPO.setAmountMargin(reqBO.getInvoiceCmpResult().getAmountMargin());
            fscInvoiceCheckResultPO.setCmpResult(reqBO.getInvoiceCmpResult().getCmpResultStr());
            fscInvoiceCheckResultPO.setIteNumMargin(reqBO.getInvoiceCmpResult().getItemNumMargin());
            fscInvoiceCheckResultPO.setUntaxAmtMargin(reqBO.getInvoiceCmpResult().getUntaxAmtMargin());
            fscInvoiceCheckResultPO.setTaxMargin(reqBO.getInvoiceCmpResult().getTaxMargin());
            fscInvoiceCheckResultPO.setCreateOperId(reqBO.getUserId());
            fscInvoiceCheckResultPO.setCreateOperName(reqBO.getName());
            fscInvoiceCheckResultPO.setCreateTime(new Date());
            fscInvoiceCheckResultPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscInvoiceCheckResultPO.setFscOrderId(reqBO.getOrderId());
            this.fscInvoiceCheckResultMapper.insert(fscInvoiceCheckResultPO);
        }
        if (reqBO.getCreateShouldPayFlag().booleanValue()) {
            this.createShouldPay(reqBO.getFscShouldPayBOS(), reqBO);
        }
        if (reqBO.getNeedOperStockEnable().booleanValue()) {
            this.inStock(reqBO.getOrderId(), reqBO.getStockFlag());
        }
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setInvoiceNo(reqBO.getInvoiceNo());
        fscShouldPayPO.setFscOrderId(reqBO.getOrderId());
        this.fscShouldPayMapper.updateInvoiceNoByOrderId(fscShouldPayPO);
        if (!CollectionUtils.isEmpty(reqBO.getPurWriteOffAmount())) {
            BigDecimal writeOffAmount = new BigDecimal(0);
            for (FscBillOrderInvoiceSignWriteOffBusiReqBO writeOffBusiBO : reqBO.getPurWriteOffAmount()) {
                FscShouldPayPO fscShouldPayPOUpdate = new FscShouldPayPO();
                fscShouldPayPOUpdate.setShouldPayId(writeOffBusiBO.getPayOrderId());
                fscShouldPayPOUpdate.setWriteOffAmount(writeOffBusiBO.getWriteOffAmount());
                this.fscShouldPayMapper.updateById(fscShouldPayPOUpdate);
                writeOffAmount = writeOffAmount.add(writeOffBusiBO.getWriteOffAmount());
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getOrderId());
            fscOrderPO.setWriteOffAmount(writeOffAmount);
            FscOrderPO set = new FscOrderPO();
            set.setWriteOffAmount(writeOffAmount);
            FscOrderPO where = new FscOrderPO();
            where.setFscOrderId(reqBO.getOrderId());
            this.fscOrderMapper.updateBy(set, where);
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getOrderId());
        List invoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        StringBuilder invoiceNo = new StringBuilder();
        StringBuilder invoiceCode = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
            for (FscInvoicePO po : invoicePOList) {
                invoiceNo.append(po.getInvoiceNo()).append(",");
                invoiceCode.append(po.getInvoiceCode()).append(",");
            }
        }
        fscOrderPO.setInvoiceNo(invoiceNo.toString());
        fscOrderPO.setInvoiceCode(invoiceCode.toString());
        List<Long> billOrderIds = this.backFillBillInvoice(fscOrderPO);
        busiRspBO.setBillOrderIds(billOrderIds);
        FscOrderItemPO queryItemVo = new FscOrderItemPO();
        queryItemVo.setFscOrderId(reqBO.getOrderId());
        List list = this.fscOrderItemMapper.getList(queryItemVo);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List<Long> inspectionIds = list.stream().map(FscOrderItemPO::getAcceptOrderId).collect(Collectors.toList());
            this.dealPrePayBillAndCreateShouldPay(reqBO, inspectionIds, fscOrderPO);
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode()) && this.signFlag.booleanValue()) {
            throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        this.syncOrderStatus(reqBO.getOrderId());
        return busiRspBO;
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.SIGN);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscBillOrderInvoiceSignBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            List acceptOrderCodes = this.fscShouldPayMapper.selectAcceptOrderCode(reqBO.getOrderId());
            String acceptOrderCode = Joiner.on((String)",").join((Iterable)acceptOrderCodes);
            for (FscShouldPayBO bo : fscShouldPayBOS) {
                bo.setAcceptOrderCode(acceptOrderCode);
            }
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private void inStock(Long fscOrderId, Integer stockFlag) {
        FscStockOperAtomReqBO fscStockOperAtomReqBO = new FscStockOperAtomReqBO();
        fscStockOperAtomReqBO.setOperType(stockFlag);
        fscStockOperAtomReqBO.setFscOrderId(fscOrderId);
        FscStockOperAtomRspBO fscStockOperAtomRspBO = this.fscStockOperAtomService.dealStockOper(fscStockOperAtomReqBO);
        if (!"0000".equals(fscStockOperAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscStockOperAtomRspBO.getRespDesc());
        }
    }

    private void dealPrePayBillAndCreateShouldPay(FscBillOrderInvoiceSignBusiReqBO reqBO, List<Long> inspectionIds, FscOrderPO fscOrderPO) {
        FscShouldPayPO queryShouldPayVo = new FscShouldPayPO();
        queryShouldPayVo.setInspectionIdList(inspectionIds);
        queryShouldPayVo.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_FREEZE);
        List shouldPayPOList = this.fscShouldPayMapper.getList(queryShouldPayVo);
        if (!CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            HashMap<Long, FscShouldPayBO> shouldPayPOMap = new HashMap<Long, FscShouldPayBO>();
            for (Object fscShouldPayPO : shouldPayPOList) {
                FscShouldPayBO shouldPay;
                if (shouldPayPOMap.get(fscShouldPayPO.getOrderId()) == null) {
                    shouldPay = new FscShouldPayBO();
                    BeanUtils.copyProperties((Object)fscShouldPayPO, (Object)shouldPay);
                    shouldPay.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                    shouldPay.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
                    shouldPay.setObjectNo(fscOrderPO.getOrderNo());
                    shouldPay.setObjectId(fscOrderPO.getFscOrderId());
                    shouldPay.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                    shouldPayPOMap.put(shouldPay.getOrderId(), shouldPay);
                } else {
                    shouldPay = (FscShouldPayBO)shouldPayPOMap.get(fscShouldPayPO.getOrderId());
                    shouldPay.setShouldPayAmount(shouldPay.getShouldPayAmount().add(fscShouldPayPO.getShouldPayAmount()));
                }
                fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_INVALID);
            }
            this.fscShouldPayMapper.updateStatusByBatch(shouldPayPOList);
            ArrayList fscShouldPayBOS = new ArrayList();
            for (Long key : shouldPayPOMap.keySet()) {
                fscShouldPayBOS.add(shouldPayPOMap.get(key));
            }
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private List<Long> backFillBillInvoice(FscOrderPO fscOrderPO) {
        List<Long> billOrderIds = new ArrayList<Long>();
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBO.setRelId(fscOrderPO.getFscOrderId());
        uocInspectionDetailsListPageQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
        uocInspectionDetailsListPageQueryReqBO.setTabId(Integer.valueOf(80013));
        uocInspectionDetailsListPageQueryReqBO.setPageSize(1000000);
        UocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
        if (!CollectionUtils.isEmpty((Collection)inspectionDetailsList.getRows())) {
            UocInspectionDetailsListBO uocInspectionDetailsListBO = (UocInspectionDetailsListBO)inspectionDetailsList.getRows().get(0);
            billOrderIds = FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(uocInspectionDetailsListBO.getPayType()) && FscConstants.MerchantPayNodeRule.SIGN.equals(uocInspectionDetailsListBO.getPayNodeRule()) ? this.fscOrderMapper.getBillOrderIdsByShouldPay(fscOrderPO) : this.fscOrderMapper.getBillOrderIdsByAdvance(fscOrderPO);
        }
        if (!CollectionUtils.isEmpty(billOrderIds)) {
            for (Long billOrderId : billOrderIds) {
                FscOrderPO billOrder = new FscOrderPO();
                billOrder.setFscOrderId(billOrderId);
                billOrder.setInvoiceNo(fscOrderPO.getInvoiceNo());
                billOrder.setInvoiceCode(fscOrderPO.getInvoiceCode());
                this.fscOrderMapper.updateById(billOrder);
            }
        }
        return billOrderIds;
    }
}

