/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignToYCBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignToYCBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignToYCBusiRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCInvoiceItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCVerificationBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillTaxSendPurFscOrderToYCService;
import com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePoolMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePoolPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.DateUtil;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class FscBillOrderInvoiceSignToYCBusiServiceImpl
implements FscBillOrderInvoiceSignToYCBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderInvoiceSignToYCBusiServiceImpl.class);
    @Autowired
    private FscBillTaxSendPurFscOrderToYCService fscBillTaxSendPurFscOrderToYCService;
    @Autowired
    private FscPayVerificationAbilityService fscPayVerificationAbilityService;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoicePoolMapper fscInvoicePoolMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;

    @Override
    public FscBillOrderInvoiceSignToYCBusiRspBO dealOrderInvoiceSignToYC(FscBillOrderInvoiceSignToYCBusiReqBO reqBO) {
        FscBillOrderInvoiceSignToYCBusiRspBO busiRspBO = new FscBillOrderInvoiceSignToYCBusiRspBO();
        FscOrderPO signTemp = this.fscOrderMapper.getOrderSignTemp(reqBO.getOrderId());
        FscPushLogPO queryVo = new FscPushLogPO();
        queryVo.setObjectId(signTemp.getFscOrderId());
        FscPushLogPO lastPushLog = this.fscPushLogMapper.getLastPushLog(queryVo);
        if (lastPushLog != null && lastPushLog.getStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u91c7\u8d2d\u7ed3\u7b97\u5355\u5df2\u6210\u529f\u63a8\u9001\u8fc7");
            return busiRspBO;
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(signTemp.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscDicDictionaryExernalPO dicDictionaryExernalPO = new FscDicDictionaryExernalPO();
        dicDictionaryExernalPO.setExernalSysCode("YC");
        List fscDicDictionaryExernalPOList = this.fscDicDictionaryExernalMapper.getListByCondition(dicDictionaryExernalPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(signTemp.getFscOrderId());
        List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(signTemp.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        BigDecimal untaxAmt = new BigDecimal(0);
        BigDecimal taxAmt = new BigDecimal(0);
        BigDecimal orderWriteOffAmt = new BigDecimal(0);
        for (FscInvoicePO fscInvoicePOFor : fscInvoicePOList) {
            untaxAmt = untaxAmt.add(null == fscInvoicePOFor.getUntaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getUntaxAmt());
            taxAmt = taxAmt.add(null == fscInvoicePOFor.getTaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getTaxAmt());
            orderWriteOffAmt = orderWriteOffAmt.add(fscInvoicePOFor.getAmt());
        }
        String orderSource = fscOrderPO.getOrderType() + "";
        List fscTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_ORDER_SOURCE")).filter(p -> p.getCode().equals(orderSource)).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fscTypeList)) {
            throw new FscBusinessException("193128", "\u7ed3\u7b97\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
        }
        UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscOrderPO.getPayeeId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
        if (!umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") || ObjectUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO())) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscBillTaxSendPurFscOrderToYCReqBO fscBillTaxSendPurFscOrderToYCReqBO = new FscBillTaxSendPurFscOrderToYCReqBO();
        FscBillTaxSendPurFscOrderToYCBO purchaseSettlement = new FscBillTaxSendPurFscOrderToYCBO();
        purchaseSettlement.setORG_ID(this.operOrgId);
        purchaseSettlement.setORG_NAME(this.operOrgName);
        purchaseSettlement.setDEPT_ID(signTemp.getYcDeptId());
        purchaseSettlement.setDEPT_NAME(signTemp.getYcDeptName());
        purchaseSettlement.setPERSON_ID(signTemp.getYcUserId());
        purchaseSettlement.setPERSON_NAME(signTemp.getYcPersonName());
        purchaseSettlement.setSETTLE_NUMBER(fscOrderPO.getOrderNo());
        purchaseSettlement.setSETTLE_NAME(fscOrderPO.getOrderNo());
        purchaseSettlement.setSETTLE_TYPE((String)fscTypeList.get(0));
        purchaseSettlement.setCONTRACT_NUMBER(fscOrderPO.getContractNo());
        if (!StringUtils.isEmpty((CharSequence)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())) {
            purchaseSettlement.setVENDOR_NUMBER(Long.valueOf(Long.parseLong(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())));
        }
        purchaseSettlement.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
        purchaseSettlement.setSETTLE_DATE(DateUtil.dateToStr((Date)new Date()));
        purchaseSettlement.setSETTLE_AMT(null == fscOrderPO.getTotalCharge() ? BigDecimal.ZERO : fscOrderPO.getTotalCharge().setScale(2, 4));
        purchaseSettlement.setINVOICE_AMT_WITHOUT_TAX(null == untaxAmt ? BigDecimal.ZERO : untaxAmt);
        purchaseSettlement.setTAX_AMT(null == taxAmt ? BigDecimal.ZERO : taxAmt);
        purchaseSettlement.setTESCO_ID(signTemp.getFscOrderId());
        fscBillTaxSendPurFscOrderToYCReqBO.setPurchaseSettlement(purchaseSettlement);
        ArrayList<FscBillTaxSendPurFscOrderToYCInvoiceItemBO> invoiceList = new ArrayList<FscBillTaxSendPurFscOrderToYCInvoiceItemBO>();
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
            for (FscInvoicePO fscInvoicePOFor : fscInvoicePOList) {
                FscBillTaxSendPurFscOrderToYCInvoiceItemBO fscInvoiceItemBO = new FscBillTaxSendPurFscOrderToYCInvoiceItemBO();
                List invoiceTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_INVOICE_TYPE")).filter(p -> p.getCode().equals(fscInvoicePOFor.getInvoiceType())).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
                if (CollectionUtils.isEmpty((Collection)invoiceTypeList)) {
                    throw new FscBusinessException("193128", "\u53d1\u7968\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
                }
                FscInvoicePoolPO fscInvoicePoolPO = new FscInvoicePoolPO();
                fscInvoicePoolPO.setInvoiceNo(fscInvoicePOFor.getInvoiceNo());
                fscInvoicePoolPO.setInvoiceCode(fscInvoicePOFor.getInvoiceCode());
                fscInvoicePoolPO.setBillDate(fscInvoicePOFor.getBillDate());
                fscInvoicePoolPO = this.fscInvoicePoolMapper.getModelBy(fscInvoicePoolPO);
                if (null == fscInvoicePoolPO) {
                    fscInvoicePoolPO = new FscInvoicePoolPO();
                }
                fscInvoiceItemBO.setINVOICE_TYPE((String)invoiceTypeList.get(0));
                fscInvoiceItemBO.setINVOICE_ID(fscInvoicePoolPO.getId() + "");
                fscInvoiceItemBO.setINVOICE_NUM(fscInvoicePOFor.getInvoiceNo());
                fscInvoiceItemBO.setDRAWER_NAME(fscInvoicePOFor.getCreateOperName());
                fscInvoiceItemBO.setINVOICE_DATE(DateUtil.dateToStr((Date)fscInvoicePOFor.getCreateTime()));
                fscInvoiceItemBO.setTAX_RATE(AmountUtils.calcTaxRate((BigDecimal)fscInvoicePOFor.getTaxAmt(), (BigDecimal)fscInvoicePOFor.getUntaxAmt()).toString());
                fscInvoiceItemBO.setINVOICE_AMOUNT(null == fscInvoicePOFor.getUntaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getUntaxAmt().setScale(2, 4));
                fscInvoiceItemBO.setTAX_AMOUNT(null == fscInvoicePOFor.getTaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getTaxAmt().setScale(2, 4));
                fscInvoiceItemBO.setTOTAL_AMOUNT(null == fscInvoicePOFor.getAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getAmt().setScale(2, 4));
                fscInvoiceItemBO.setREST_AMOUNT(fscInvoiceItemBO.getTOTAL_AMOUNT().subtract(null == fscInvoiceItemBO.getSETTLE_AMOUNT() ? BigDecimal.ZERO : fscInvoiceItemBO.getSETTLE_AMOUNT()).setScale(2, 4));
                fscInvoiceItemBO.setSETTLE_AMOUNT(null == fscInvoicePOFor.getAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getAmt().setScale(2, 4));
                fscInvoiceItemBO.setTESCO_ID(fscInvoicePOFor.getInvoiceId());
                invoiceList.add(fscInvoiceItemBO);
            }
        }
        fscBillTaxSendPurFscOrderToYCReqBO.setInvoice(invoiceList);
        ArrayList<FscBillTaxSendPurFscOrderToYCVerificationBO> advanceCharge = new ArrayList<FscBillTaxSendPurFscOrderToYCVerificationBO>();
        BigDecimal writeOffAmt = new BigDecimal(0);
        List ycAbilityBOList = this.fscOrderMapper.getOrderAmount(signTemp.getFscOrderId());
        if (!CollectionUtils.isEmpty((Collection)ycAbilityBOList)) {
            for (FscOrderPO writeOffamt : ycAbilityBOList) {
                FscOrderPO fscOrderPOPay = this.fscOrderMapper.qryByFscOrderId(writeOffamt.getShouldPayId());
                if (null == fscOrderPOPay) {
                    throw new FscBusinessException("191026", "\u9884\u4ed8\u6b3e\u4e0d\u5b58\u5728");
                }
                if (!FscConstants.FscPayOrderState.PAIED.equals(fscOrderPOPay.getOrderState())) {
                    throw new FscBusinessException("198888", "\u4ed8\u6b3e\u672a\u5b8c\u6210\uff0c\u8bf7\u786e\u8ba4\u540e\u63d0\u4ea4");
                }
                if (null == fscOrderPOPay.getPaidAmount()) {
                    fscOrderPOPay.setPaidAmount(new BigDecimal(0));
                }
                if (fscOrderPOPay.getPaidAmount().subtract(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount()).compareTo(null == writeOffamt.getWriteOffAmount() ? BigDecimal.ZERO : writeOffamt.getWriteOffAmount()) < 0) {
                    throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u5355\u5269\u4f59\u6838\u9500\u91d1\u989d");
                }
                writeOffAmt = writeOffAmt.add(null == writeOffamt.getWriteOffAmount() ? BigDecimal.ZERO : writeOffamt.getWriteOffAmount());
                FscBillTaxSendPurFscOrderToYCVerificationBO verificationBO = new FscBillTaxSendPurFscOrderToYCVerificationBO();
                verificationBO.setPREPAY_NUMBER(fscOrderPOPay.getOrderNo());
                verificationBO.setPREPAY_NAME(fscOrderPOPay.getOrderNo());
                verificationBO.setAMOUNT(fscOrderPOPay.getPaidAmount().setScale(2, 4));
                verificationBO.setAMOUNT_APPLIED(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount().setScale(2, 4));
                verificationBO.setAMOUNT_UNAPPLIED(fscOrderPOPay.getPaidAmount().subtract(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount()).setScale(2, 4));
                verificationBO.setAPPLY_AMOUNT(writeOffamt.getWriteOffAmount().setScale(2, 4));
                verificationBO.setTESCO_ID(fscOrderPOPay.getFscOrderId());
                advanceCharge.add(verificationBO);
            }
        }
        if (orderWriteOffAmt.compareTo(writeOffAmt) < 0) {
            throw new FscBusinessException("191026", "\u6240\u6709\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u603b\u91d1\u989d");
        }
        if (fscOrderPO.getTotalCharge().compareTo(writeOffAmt) < 0) {
            throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u7b97\u91d1\u989d");
        }
        fscBillTaxSendPurFscOrderToYCReqBO.setAdvanceCharge(advanceCharge);
        fscBillTaxSendPurFscOrderToYCReqBO.setPurchaseSettlement(purchaseSettlement);
        fscBillTaxSendPurFscOrderToYCReqBO.setYcUserId(Long.valueOf(Long.parseLong(signTemp.getYcUserId())));
        FscBillDealPushLogAbilityReqBO abilityReqBO = new FscBillDealPushLogAbilityReqBO();
        abilityReqBO.setCreateTime(new Date());
        abilityReqBO.setObjectId(fscOrderPO.getFscOrderId());
        abilityReqBO.setObjectNo(fscOrderPO.getOrderNo());
        abilityReqBO.setType(FscConstants.FscPushType.SETTLE);
        abilityReqBO.setObjData(JSONObject.toJSONString((Object)fscBillTaxSendPurFscOrderToYCReqBO));
        FscBillTaxSendPurFscOrderToYCRspBO fscBillTaxSendPurFscOrderToYCRspBO = this.fscBillTaxSendPurFscOrderToYCService.sendPurFscOrder(fscBillTaxSendPurFscOrderToYCReqBO);
        if (!fscBillTaxSendPurFscOrderToYCRspBO.getRespCode().equals("0000")) {
            abilityReqBO.setStatus(FscConstants.FscPushStatus.FAIL);
            this.fscBillAddPushLogAbilityService.savePushLog(abilityReqBO);
            throw new FscBusinessException("191026", "\u63a8\u9001\u4e1a\u8d22\u5931\u8d25\uff01" + fscBillTaxSendPurFscOrderToYCRspBO.getRespDesc());
        }
        abilityReqBO.setStatus(FscConstants.FscPushStatus.SUCCESS);
        this.fscBillAddPushLogAbilityService.savePushLog(abilityReqBO);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }
}

