/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.tydic.fsc.bill.ability.api.DycFscBillnvoiceAddAbilityService;
import com.tydic.fsc.bill.ability.bo.DycFscBillnvoiceAddReqBO;
import com.tydic.fsc.bill.ability.bo.DycFscBillnvoiceAddRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceAddAbilityBO;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.DycFscBillnvoiceAddAbilityService"})
public class DycFscBillnvoiceAddAbilityServiceImpl
implements DycFscBillnvoiceAddAbilityService {
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @PostMapping(value={"synchInvoice"})
    public DycFscBillnvoiceAddRspBO synchInvoice(@RequestBody DycFscBillnvoiceAddReqBO reqBO) {
        DycFscBillnvoiceAddRspBO rspBO = new DycFscBillnvoiceAddRspBO();
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang.StringUtils.isBlank((String)reqBO.getUrl())) {
            throw new FscBusinessException("191000", "\u6a21\u677f\u5730\u5740[url]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("191000", "\u9500\u552e\u5355id[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            URL url = new URL(reqBO.getUrl());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            InputStream fis = conn.getInputStream();
            HSSFWorkbook workbook = new HSSFWorkbook(fis);
            Sheet sheet = workbook.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            ArrayList<FscBillInvoiceAddAbilityBO> bos = new ArrayList<FscBillInvoiceAddAbilityBO>();
            BigDecimal big = BigDecimal.ZERO;
            for (int i = 0; i < lastRowNum - 1; ++i) {
                FscBillInvoiceAddAbilityBO bo = new FscBillInvoiceAddAbilityBO();
                Row row = sheet.getRow(i + 10);
                bo.setInvoiceType(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(0)));
                if ("\u5168\u7535\u7968".equals(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(1)))) {
                    bo.setInvoiceCategory(Integer.valueOf(3));
                } else if ("\u7eb8\u8d28\u53d1\u7968".equals(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(1)))) {
                    bo.setInvoiceCategory(Integer.valueOf(1));
                } else if ("\u7535\u5b50\u53d1\u7968".equals(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(1)))) {
                    bo.setInvoiceCategory(Integer.valueOf(2));
                }
                bo.setInvoiceCode(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(2)));
                bo.setInvoiceNo(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(3)));
                if (DycFscBillnvoiceAddAbilityServiceImpl.validDateStr(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(4)), null)) {
                    bo.setBillDate(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(4)));
                } else {
                    rspBO.setRespDesc("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u8005\u4e3a\u7a7a");
                    rspBO.setRespCode("193019");
                }
                bo.setAmt(new BigDecimal(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(5))));
                big = big.add(bo.getAmt());
                bo.setUntaxAmt(new BigDecimal(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(6))));
                bo.setTaxAmt(new BigDecimal(DycFscBillnvoiceAddAbilityServiceImpl.getCellValue(row.getCell(7))));
                bos.add(bo);
            }
            if (!CollectionUtils.isEmpty(bos)) {
                FscOrderPO fscOrderPo = new FscOrderPO();
                fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
                fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
                if (fscOrderPo == null) {
                    throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f!");
                }
                if (fscOrderPo.getTotalCharge().compareTo(big) != 0) {
                    throw new FscBusinessException("191000", "\u6a21\u677f\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u7ed3\u7b97\u5355\u542b\u7a0e\u91d1\u989d\u5408\u8ba1");
                }
                FscInvoicePO po = new FscInvoicePO();
                po.setFscOrderId(reqBO.getFscOrderId());
                this.fscInvoiceMapper.deleteBy(po);
                List list = bos.stream().map(tenantPO -> (FscInvoicePO)BeanMapper.map((Object)tenantPO, FscInvoicePO.class)).collect(Collectors.toList());
                for (FscInvoicePO fscpo : list) {
                    fscpo.setStatus(Integer.valueOf(1));
                    fscpo.setFscOrderId(reqBO.getFscOrderId());
                    fscpo.setCreateTime(new Date());
                    fscpo.setCreateOperId(reqBO.getUserId() + "");
                    fscpo.setCreateOperName(reqBO.getUserName());
                    fscpo.setCreateOrgId(reqBO.getOrgId());
                    fscpo.setCreateOrgName(reqBO.getOrgName());
                    fscpo.setCreateCompanyId(reqBO.getCompanyId());
                    fscpo.setCreateCompanyName(reqBO.getCompanyName());
                }
                this.fscInvoiceMapper.insertBatch(list);
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(e.getMessage());
            e.printStackTrace();
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static String getCellValue(Cell cell) {
        String cellValue = "";
        if (!StringUtils.isEmpty((Object)cell)) {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())).toString();
                        break;
                    }
                    DataFormatter dataFormatter = new DataFormatter();
                    cellValue = dataFormatter.formatCellValue(cell);
                    break;
                }
                case STRING: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case BOOLEAN: {
                    cellValue = cell.getBooleanCellValue() + "";
                    break;
                }
                case FORMULA: {
                    cellValue = cell.getCellFormula() + "";
                    break;
                }
                case BLANK: {
                    cellValue = "";
                    break;
                }
                case ERROR: {
                    cellValue = "\u975e\u6cd5\u5b57\u7b26";
                    break;
                }
                default: {
                    cellValue = "\u672a\u77e5\u7c7b\u578b";
                }
            }
        }
        return cellValue;
    }

    public static boolean validDateStr(String dateStr, String pattern) {
        if (StringUtil.isEmpty((String)pattern)) {
            pattern = "yyyy-MM-dd";
        }
        try {
            LocalDate.parse(dateStr, new DateTimeFormatterBuilder().appendPattern(pattern).parseStrict().toFormatter());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

