/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.cfc.ability.api.CfcUniteParamQryAutoBillEnableDetailAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryAutoBillEnableDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryAutoBillEnableDetailAbilityRspBO;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillSendPurFscOrderToYCAbilityBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscPhasePayListBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.InvoiceCmpResultBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCInvoiceItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendPurFscOrderToYCVerificationBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.esb.FscBillTaxSendPurFscOrderToYCService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscInvoiceSignErrorMsgEnum;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePoolMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePoolPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignAbilityService"})
public class FscBillOrderInvoiceSignAbilityServiceImpl
implements FscBillOrderInvoiceSignAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderInvoiceSignAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscBillOrderInvoiceSignBusiService fscBillOrderInvoiceSignBusiService;
    @Value(value="${fsc.main.electricity.pro.org:100100}")
    private String electricityOrg;
    private static String SYS_LIMIT_SIGN_CMP_AMT = "3";
    private static BigDecimal TAX_AMOUNT_OTHER_CHECK = BigDecimal.ZERO;
    private static BigDecimal TOTAL_AMOUNT_EX_OTHER_CHECK = BigDecimal.ZERO;
    private static final String REPLACE_KEY = "#replace#";
    private static final String REPLACE_LIMIT_AMT = "##";
    private static final String ERROR_MSG_TITLE_BEGIN = "\u7ed3\u7b97\u5355";
    private static final String ERROR_MSG_TITLE_END = "\u4e0d\u7b26\u5408\u7b7e\u6536\u89c4\u5219\uff0c\u539f\u56e0\u5982\u4e0b\uff1a<br>";
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoicePoolMapper fscInvoicePoolMapper;
    @Autowired
    private FscBillTaxSendPurFscOrderToYCService fscBillTaxSendPurFscOrderToYCService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscPayVerificationAbilityService fscPayVerificationAbilityService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private CfcUniteParamQryAutoBillEnableDetailAbilityService cfcUniteParamQryAutoBillEnableDetailAbilityService;
    private static final Integer IN = 1;
    private static final Integer OUT = 2;
    @Value(value="${OPER_ORG_ID}")
    private String operOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderInvoiceSign"})
    public FscBillOrderInvoiceSignAbilityRspBO dealOrderInvoiceSign(@RequestBody FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        FscBillOrderInvoiceSignBusiRspBO fscBillOrderInvoiceSignBusiRspBO;
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (!FscConstants.FscInvoiceOrderState.BILLED.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + fscOrderPO.getOrderState() + "]\u4e0d\u5141\u8bb8\u7b7e\u6536");
        }
        if (!"0".equals(reqBO.getAutoSignFlag()) && FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            this.valCmpResult(reqBO);
            this.checkCmpResult(reqBO.getInvoiceCmpResult(), fscOrderPO);
        }
        FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO = (FscBillOrderInvoiceSignBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillOrderInvoiceSignBusiReqBO.class));
        fscBillOrderInvoiceSignBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            this.dealOrderCheck(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO, reqBO);
            this.dealStockFlag(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO);
            if ("up_a".equals(reqBO.getSignSource()) || "up_b".equals(reqBO.getSignSource())) {
                this.valUp(reqBO);
                this.checkPurSign(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO, reqBO);
            }
        }
        if (!"0000".equals((fscBillOrderInvoiceSignBusiRspBO = this.fscBillOrderInvoiceSignBusiService.dealOrderInvoiceSign(fscBillOrderInvoiceSignBusiReqBO)).getRespCode())) {
            throw new FscBusinessException("191019", fscBillOrderInvoiceSignBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return new FscBillOrderInvoiceSignAbilityRspBO();
    }

    private void checkCmpResult(InvoiceCmpResultBO invoiceCmpResultBO, FscOrderPO fscOrderPO) {
        this.checkCfcParam(invoiceCmpResultBO, fscOrderPO.getOrderSource());
        if (invoiceCmpResultBO.getCmpResultStr().contains(FscConstants.FscInvoiceVerifyResult.NO.toString())) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(ERROR_MSG_TITLE_BEGIN);
            errorMsg.append(fscOrderPO.getOrderNo());
            errorMsg.append(ERROR_MSG_TITLE_END);
            int strLen = invoiceCmpResultBO.getCmpResultStr().length();
            int seq = 1;
            for (int i = 0; i < strLen; ++i) {
                if (invoiceCmpResultBO.getCmpResultStr().charAt(i) == FscConstants.FscInvoiceVerifyResult.NO.toString().charAt(0)) {
                    errorMsg.append(seq);
                    errorMsg.append(FscInvoiceSignErrorMsgEnum.getInstance((Integer)seq).getDescr());
                    ++seq;
                }
                if (i == 5) break;
            }
            if (invoiceCmpResultBO.getAmountMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getAmountMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getUntaxAmtMargin().compareTo(TOTAL_AMOUNT_EX_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.UNTAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getUntaxAmtMargin().toString()).replace(REPLACE_LIMIT_AMT, TOTAL_AMOUNT_EX_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getTaxMargin().compareTo(TAX_AMOUNT_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.TAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getTaxMargin().toString()).replace(REPLACE_LIMIT_AMT, TAX_AMOUNT_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getItemNumMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.ITEM.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getItemNumMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getPoolCmpResultNum() != null && invoiceCmpResultBO.getPoolCmpResultNum() > 0) {
                errorMsg.append(seq);
                errorMsg.append("\u3001\u8fdb\u9879\u53d1\u7968\u660e\u7ec6\u603b\u8ba1\u6709" + invoiceCmpResultBO.getPoolCmpResultNum() + "\u9879\u65e0\u6cd5\u5339\u914d\uff1b<br>");
                ++seq;
            }
            if (seq > 1) {
                throw new FscBusinessException("191035", errorMsg.toString());
            }
        }
    }

    private void val(FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
    }

    private void valCmpResult(FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        if (null == reqBO.getInvoiceCmpResult()) {
            throw new FscBusinessException("191000", "\u5165\u53c2invoiceCmpResult\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getUntaxAmtMargin()) {
            throw new FscBusinessException("191000", "\u5165\u53c2untaxAmtMargin\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getTaxMargin()) {
            throw new FscBusinessException("191000", "\u5165\u53c2taxMargin\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getAmountMargin()) {
            throw new FscBusinessException("191000", "\u5165\u53c2amountMargin\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInvoiceCmpResult().getCmpResultStr())) {
            throw new FscBusinessException("191000", "\u5165\u53c2cmpResultStr\u4e3a\u7a7a");
        }
    }

    private void valUp(FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getDeptId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[deptId]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getDeptName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[deptName]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPersonId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[personId]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPersonName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[personName]\u4e3a\u7a7a");
        }
        if (null == reqBO.getYcUserId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[ycUserId]\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getWriteOffList())) {
            for (FscBillSendPurFscOrderToYCAbilityBO purBO : reqBO.getWriteOffList()) {
                if (null == purBO.getPayOrderId()) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[purWriteOffAmount]\u7684[payOrderId]\u4e3a\u7a7a");
                }
                if (null == purBO.getShouldPayId()) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[purWriteOffAmount]\u7684[shouldPayId]\u4e3a\u7a7a");
                }
                if (purBO.getWriteOffAmount().compareTo(new BigDecimal(0)) <= 0) {
                    throw new FscBusinessException("191000", "\u5165\u53c2[purWriteOffAmount]\u7684[writeOffAmount]\u4e3a\u7a7a");
                }
                if (purBO.getPayItemId() != null) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2[purWriteOffAmount]\u7684[payItemId]\u4e3a\u7a7a");
            }
        }
    }

    private void sendMq(FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }

    private void dealAccountRule(FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, Set<String> orderCodeList, Set<String> orderOperList) {
        if (fscOrderPO.getSettleType() != null && fscOrderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            return;
        }
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
            FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            log.debug("++++++++++fscOrderInfoBO:{}", (Object)JSON.toJSONString((Object)fscOrderInfoBO));
            if ((fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER) || fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE)) && fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                fscOrderInfoBO.setPayAccountDayRule(fscOrderInfoBO.getProPayAccountDayRule());
                fscOrderInfoBO.setPayNodeRule(fscOrderInfoBO.getProPayNodeRule());
                fscOrderInfoBO.setPayBreakScale(fscOrderInfoBO.getProPayBreakScale());
                fscOrderInfoBO.setModelContractId(fscOrderInfoBO.getProModelContractId());
                fscOrderInfoBO.setModelContractNo(fscOrderInfoBO.getProModelContractNo());
                fscOrderInfoBO.setPayAccountDay(fscOrderInfoBO.getProPayAccountDay());
                fscOrderInfoBO.setPayNodeAccountDays(fscOrderInfoBO.getProPaymentDays());
                fscOrderInfoBO.setPayRule(fscOrderInfoBO.getProPayRule());
            }
            if (FscConstants.MerchantPayAccountDayRule.SIGN.equals(fscOrderInfoBO.getPayAccountDayRule()) || FscConstants.MerchantPayNodeRule.SIGN.equals(fscOrderInfoBO.getPayNodeRule())) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
                fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
                fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
                fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
                fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
                fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO, fscOrderPO.getOrderSource()));
                fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                fscShouldPayBO.setInvoiceNo(fscBillOrderInvoiceSignBusiReqBO.getInvoiceNo());
                fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
                fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
                fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                fscShouldPayBO.setOperatorDeptId(Convert.toStr((Object)fscOrderPO.getOperatorDeptId()));
                fscShouldPayBO.setOperatorDeptName(fscOrderPO.getOperatorDeptName());
                fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                fscShouldPayBO.setShouldPayMethod(Integer.valueOf(2));
                fscShouldPayBOS.add(fscShouldPayBO);
                fscBillOrderInvoiceSignBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
                fscBillOrderInvoiceSignBusiReqBO.setCreateShouldPayFlag(true);
            }
        } else if (FscConstants.FscPayType.FSC_PAY_TYPE_STAGE.equals(fscOrderPO.getPayType())) {
            FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                fscOrderInfoBO.setPayList(fscOrderInfoBO.getProPayList());
            }
            boolean flag = false;
            ArrayList<FscPhasePayListBO> payListBOS = new ArrayList<FscPhasePayListBO>();
            if (CollectionUtils.isEmpty((Collection)fscOrderInfoBO.getPayList())) {
                return;
            }
            for (FscPhasePayListBO payListBO : fscOrderInfoBO.getPayList()) {
                if (payListBO.getPayNode() != 4 || payListBO.getNodePayRatio().compareTo(BigDecimal.ZERO) <= 0) continue;
                payListBOS.add(payListBO);
                flag = true;
            }
            if (flag) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                for (FscPhasePayListBO fscPhasePayListBO : payListBOS) {
                    FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                    fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                    fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                    fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                    fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                    fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                    fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge().multiply(fscPhasePayListBO.getNodePayRatio()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                    fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                    fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                    fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                    fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                    fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                    fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
                    fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
                    fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
                    fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
                    fscShouldPayBO.setShouldPayDate(this.calShouldPayDateNew(fscPhasePayListBO.getNodePayCycle() == null ? 0 : Integer.parseInt(fscPhasePayListBO.getNodePayCycle())));
                    fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                    fscShouldPayBO.setInvoiceNo(fscBillOrderInvoiceSignBusiReqBO.getInvoiceNo());
                    fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                    fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                    fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                    fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
                    fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
                    fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                    fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                    fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                    fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                    fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                    fscShouldPayBO.setShouldPayMethod(fscPhasePayListBO.getPayType());
                    fscShouldPayBOS.add(fscShouldPayBO);
                }
                fscBillOrderInvoiceSignBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
                fscBillOrderInvoiceSignBusiReqBO.setCreateShouldPayFlag(true);
            }
        }
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO, Integer orderSource) {
        Calendar now = Calendar.getInstance();
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }

    private Date calShouldPayDateNew(Integer payDays) {
        Calendar now = Calendar.getInstance();
        now.add(5, payDays);
        return now.getTime();
    }

    private void checkCfcParam(InvoiceCmpResultBO invoiceCmpResultBO, Integer orderSource) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_check_" + orderSource);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        StringBuffer cmpResult = new StringBuffer(invoiceCmpResultBO.getCmpResultStr());
        char resultYesChar = FscConstants.FscInvoiceVerifyResult.YES.toString().charAt(0);
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceTitleCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BUY_NAME.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxpayerIdCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.TAX_NO.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAddressCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ADDRESS.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getPhoneCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.PHONE.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getBankCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BANK.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAccountCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ACCOUNT.getCode() - 1, resultYesChar);
        }
        invoiceCmpResultBO.setCmpResultStr(cmpResult.toString());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountCheck())) {
            invoiceCmpResultBO.setAmountMargin(BigDecimal.ZERO);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExCheck())) {
            invoiceCmpResultBO.setUntaxAmtMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck())) {
            BigDecimal diffUntaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck());
            TOTAL_AMOUNT_EX_OTHER_CHECK = diffUntaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountCheck())) {
            invoiceCmpResultBO.setTaxMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck())) {
            BigDecimal diffTaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck());
            TAX_AMOUNT_OTHER_CHECK = diffTaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
    }

    private void dealStockFlag(FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO) {
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType())) {
            fscBillOrderInvoiceSignBusiReqBO.setNeedOperStockEnable(true);
            fscBillOrderInvoiceSignBusiReqBO.setStockFlag(IN);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
            fscBillOrderInvoiceSignBusiReqBO.setNeedOperStockEnable(true);
            fscBillOrderInvoiceSignBusiReqBO.setStockFlag(OUT);
        }
    }

    private void dealOrderCheck(FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO, FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap();
        if (fscOrderPO.getSettleType() == null || fscOrderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            this.dealAccountRule(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO, fscOrderInfoBoMap, fscAcceptOrderListQueryAtomRspBO.getOrderCodeList(), fscAcceptOrderListQueryAtomRspBO.getOrderOperList());
        } else {
            FscSaleOrderListQueryAtomReqBO atomReqBO = new FscSaleOrderListQueryAtomReqBO();
            atomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(atomReqBO);
            if (!"0000".equals(fscSaleOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscSaleOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            this.dealAccountRule(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO, fscOrderInfoBoMap, fscSaleOrderListQueryAtomRspBO.getOrderCodeList(), fscSaleOrderListQueryAtomRspBO.getOrderOperList());
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
            this.checkProSign(fscOrderInfoBoMap, reqBO, fscOrderPO);
        }
    }

    private void checkProSign(Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, FscBillOrderInvoiceSignAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        CfcUniteParamQryAutoBillEnableDetailAbilityReqBO abilityReqBO = new CfcUniteParamQryAutoBillEnableDetailAbilityReqBO();
        abilityReqBO.setCenter("FSC");
        abilityReqBO.setBusiType(fscOrderPO.getOrderType().toString());
        if (fscOrderPO.getOrderSource().toString().equals("1")) {
            abilityReqBO.setGroupCode("AOTU_BILL_APPLY");
            abilityReqBO.setBusiType(fscOrderPO.getOrderSource().toString());
        } else {
            abilityReqBO.setGroupCode("AOTU_BILL_ENABLE");
        }
        abilityReqBO.setOrgIgWeb(fscOrderPO.getPayerId());
        log.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u662f\u5426\u5e26\u52a8\u4e0a\u6e38\u914d\u7f6e\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityReqBO));
        CfcUniteParamQryAutoBillEnableDetailAbilityRspBO abilityRspBO = this.cfcUniteParamQryAutoBillEnableDetailAbilityService.qryAutoBillEnableDetail(abilityReqBO);
        log.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u662f\u5426\u5e26\u52a8\u4e0a\u6e38\u914d\u7f6e\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u662f\u5426\u5e26\u52a8\u4e0a\u6e38\u5931\u8d25\uff01" + abilityRspBO.getRespDesc());
        }
        if (abilityRspBO.getAutoBillEnable().booleanValue()) {
            fscOrderInfoBoMap.forEach((acceptOrderId, fscOrderInfoBO) -> fscOrderInfoBO.getFscRelInfoBos().forEach(fscProFscRelInfoBo -> {
                if (FscConstants.FscRelType.PRO_INVOICE.equals(fscProFscRelInfoBo.getRelType()) && !FscConstants.FscRelStatus.SIGN.equals(fscProFscRelInfoBo.getRelState())) {
                    throw new FscBusinessException("191019", "\u4e0a\u6e38\u7ed3\u7b97\u5355\u53d1\u7968\u672a\u7b7e\u6536\uff0c\u4e0b\u6e38\u4e0d\u5141\u8bb8\u7b7e\u6536");
                }
            }));
        }
    }

    private void checkPurSign(FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO, FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        FscPushLogPO queryVo = new FscPushLogPO();
        queryVo.setObjectId(fscOrderPO.getFscOrderId());
        FscPushLogPO lastPushLog = this.fscPushLogMapper.getLastPushLog(queryVo);
        if (lastPushLog != null && lastPushLog.getStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            return;
        }
        FscDicDictionaryExernalPO dicDictionaryExernalPO = new FscDicDictionaryExernalPO();
        dicDictionaryExernalPO.setExernalSysCode("YC");
        List fscDicDictionaryExernalPOList = this.fscDicDictionaryExernalMapper.getListByCondition(dicDictionaryExernalPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getOrderId());
        List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        BigDecimal untaxAmt = new BigDecimal(0);
        BigDecimal taxAmt = new BigDecimal(0);
        BigDecimal orderWriteOffAmt = new BigDecimal(0);
        for (FscOrderItemPO fscOrderItemPOFor : fscOrderItemPOList) {
            untaxAmt = untaxAmt.add(null == fscOrderItemPOFor.getUntaxAmt() ? BigDecimal.ZERO : fscOrderItemPOFor.getUntaxAmt());
            taxAmt = taxAmt.add(null == fscOrderItemPOFor.getTaxAmt() ? BigDecimal.ZERO : fscOrderItemPOFor.getTaxAmt());
            orderWriteOffAmt = orderWriteOffAmt.add(fscOrderItemPOFor.getAmt());
        }
        String orderSource = fscOrderPO.getOrderType() + "";
        List fscTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_ORDER_SOURCE")).filter(p -> p.getCode().equals(orderSource)).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fscTypeList)) {
            throw new FscBusinessException("193128", "\u7ed3\u7b97\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
        }
        UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscOrderPO.getPayeeId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
        if (!umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") || ObjectUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO())) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscBillTaxSendPurFscOrderToYCReqBO fscBillTaxSendPurFscOrderToYCReqBO = new FscBillTaxSendPurFscOrderToYCReqBO();
        FscBillTaxSendPurFscOrderToYCBO purchaseSettlement = new FscBillTaxSendPurFscOrderToYCBO();
        purchaseSettlement.setORG_ID(this.operOrgId);
        purchaseSettlement.setORG_NAME(this.operOrgName);
        purchaseSettlement.setDEPT_ID(reqBO.getDeptId());
        purchaseSettlement.setDEPT_NAME(reqBO.getDeptName());
        purchaseSettlement.setPERSON_ID(reqBO.getYcUserId() + "");
        purchaseSettlement.setPERSON_NAME(reqBO.getPersonName());
        purchaseSettlement.setSETTLE_NUMBER(fscOrderPO.getOrderNo());
        StringBuilder SETTLE_NAME = new StringBuilder(fscOrderPO.getOrderNo());
        if (!CollectionUtils.isEmpty((Collection)fscOrderItemPOList) && "1".equals(fscOrderPO.getOrderSource() + "") && StringUtils.isNotEmpty((CharSequence)fscOrderPO.getOperationNo()) && !this.electricityOrg.equals(fscOrderPO.getOperationNo())) {
            SETTLE_NAME = new StringBuilder("");
            for (Object item : fscOrderItemPOList) {
                if (SETTLE_NAME.toString().contains(item.getOrderCode())) continue;
                SETTLE_NAME.append(item.getOrderCode()).append(",");
            }
            if (SETTLE_NAME.toString().length() > 3000) {
                SETTLE_NAME = new StringBuilder(SETTLE_NAME.substring(0, 3000));
            }
            if (SETTLE_NAME.toString().endsWith(",")) {
                SETTLE_NAME = new StringBuilder(SETTLE_NAME.substring(0, SETTLE_NAME.length() - 1));
            }
        }
        purchaseSettlement.setSETTLE_NAME(SETTLE_NAME.toString());
        purchaseSettlement.setSETTLE_TYPE((String)fscTypeList.get(0));
        purchaseSettlement.setCONTRACT_NUMBER(fscOrderPO.getContractNo());
        if (!StringUtils.isEmpty((CharSequence)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())) {
            purchaseSettlement.setVENDOR_NUMBER(Long.valueOf(Long.parseLong(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())));
        }
        purchaseSettlement.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
        purchaseSettlement.setSETTLE_DATE(DateUtil.dateToStr((Date)new Date()));
        purchaseSettlement.setSETTLE_AMT(null == fscOrderPO.getTotalCharge() ? BigDecimal.ZERO : fscOrderPO.getTotalCharge().setScale(2, 4));
        purchaseSettlement.setINVOICE_AMT_WITHOUT_TAX(null == untaxAmt ? BigDecimal.ZERO : untaxAmt);
        purchaseSettlement.setTAX_AMT(null == taxAmt ? BigDecimal.ZERO : taxAmt);
        purchaseSettlement.setTESCO_ID(reqBO.getOrderId());
        fscBillTaxSendPurFscOrderToYCReqBO.setPurchaseSettlement(purchaseSettlement);
        ArrayList<Object> invoiceList = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
            for (FscInvoicePO fscInvoicePOFor : fscInvoicePOList) {
                FscBillTaxSendPurFscOrderToYCInvoiceItemBO fscInvoiceItemBO = new FscBillTaxSendPurFscOrderToYCInvoiceItemBO();
                List invoiceTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_INVOICE_TYPE")).filter(p -> p.getCode().equals(fscInvoicePOFor.getInvoiceType())).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(invoiceTypeList)) {
                    throw new FscBusinessException("193128", "\u53d1\u7968\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
                }
                FscInvoicePoolPO fscInvoicePoolPO = new FscInvoicePoolPO();
                fscInvoicePoolPO.setInvoiceNo(fscInvoicePOFor.getInvoiceNo());
                fscInvoicePoolPO.setInvoiceCode(fscInvoicePOFor.getInvoiceCode());
                fscInvoicePoolPO.setBillDate(fscInvoicePOFor.getBillDate());
                fscInvoicePoolPO = this.fscInvoicePoolMapper.getModelBy(fscInvoicePoolPO);
                if (null == fscInvoicePoolPO) {
                    fscInvoicePoolPO = new FscInvoicePoolPO();
                }
                fscInvoiceItemBO.setINVOICE_TYPE((String)invoiceTypeList.get(0));
                fscInvoiceItemBO.setINVOICE_ID(fscInvoicePoolPO.getId() + "");
                fscInvoiceItemBO.setINVOICE_NUM(fscInvoicePOFor.getInvoiceNo());
                fscInvoiceItemBO.setDRAWER_NAME(fscInvoicePOFor.getCreateOperName());
                fscInvoiceItemBO.setINVOICE_DATE(DateUtil.dateToStr((Date)fscInvoicePOFor.getCreateTime()));
                fscInvoiceItemBO.setTAX_RATE(AmountUtils.calcTaxRate((BigDecimal)fscInvoicePOFor.getTaxAmt(), (BigDecimal)fscInvoicePOFor.getUntaxAmt()).toString());
                fscInvoiceItemBO.setINVOICE_AMOUNT(null == fscInvoicePOFor.getUntaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getUntaxAmt().setScale(2, 4));
                fscInvoiceItemBO.setTAX_AMOUNT(null == fscInvoicePOFor.getTaxAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getTaxAmt().setScale(2, 4));
                fscInvoiceItemBO.setTOTAL_AMOUNT(null == fscInvoicePOFor.getAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getAmt().setScale(2, 4));
                fscInvoiceItemBO.setREST_AMOUNT(fscInvoiceItemBO.getTOTAL_AMOUNT().subtract(null == fscInvoiceItemBO.getSETTLE_AMOUNT() ? BigDecimal.ZERO : fscInvoiceItemBO.getSETTLE_AMOUNT()).setScale(2, 4));
                fscInvoiceItemBO.setSETTLE_AMOUNT(null == fscInvoicePOFor.getAmt() ? BigDecimal.ZERO : fscInvoicePOFor.getAmt().setScale(2, 4));
                fscInvoiceItemBO.setTESCO_ID(fscInvoicePOFor.getInvoiceId());
                invoiceList.add(fscInvoiceItemBO);
            }
        }
        fscBillTaxSendPurFscOrderToYCReqBO.setInvoice(invoiceList);
        ArrayList<FscBillTaxSendPurFscOrderToYCVerificationBO> advanceCharge = new ArrayList<FscBillTaxSendPurFscOrderToYCVerificationBO>();
        BigDecimal writeOffAmt = new BigDecimal(0);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getWriteOffList())) {
            for (FscBillSendPurFscOrderToYCAbilityBO writeOffamt : reqBO.getWriteOffList()) {
                FscOrderPO fscOrderPOPay = this.fscOrderMapper.qryByFscOrderId(writeOffamt.getPayOrderId());
                if (null == fscOrderPOPay) {
                    throw new FscBusinessException("191026", "\u9884\u4ed8\u6b3e\u4e0d\u5b58\u5728");
                }
                if (!FscConstants.FscPayOrderState.PAIED.equals(fscOrderPOPay.getOrderState())) {
                    throw new FscBusinessException("198888", "\u4ed8\u6b3e\u672a\u5b8c\u6210\uff0c\u8bf7\u786e\u8ba4\u540e\u63d0\u4ea4");
                }
                if (null == fscOrderPOPay.getPaidAmount()) {
                    fscOrderPOPay.setPaidAmount(new BigDecimal(0));
                }
                if (fscOrderPOPay.getPaidAmount().subtract(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount()).compareTo(null == writeOffamt.getWriteOffAmount() ? BigDecimal.ZERO : writeOffamt.getWriteOffAmount()) < 0) {
                    throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u5355\u5269\u4f59\u6838\u9500\u91d1\u989d");
                }
                writeOffAmt = writeOffAmt.add(null == writeOffamt.getWriteOffAmount() ? BigDecimal.ZERO : writeOffamt.getWriteOffAmount());
                FscBillTaxSendPurFscOrderToYCVerificationBO verificationBO = new FscBillTaxSendPurFscOrderToYCVerificationBO();
                verificationBO.setPREPAY_NUMBER(fscOrderPOPay.getOrderNo());
                verificationBO.setPREPAY_NAME(fscOrderPOPay.getOrderNo());
                verificationBO.setAMOUNT(fscOrderPOPay.getPaidAmount().setScale(2, 4));
                verificationBO.setAMOUNT_APPLIED(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount().setScale(2, 4));
                verificationBO.setAMOUNT_UNAPPLIED(fscOrderPOPay.getPaidAmount().subtract(null == fscOrderPOPay.getWriteOffAmount() ? BigDecimal.ZERO : fscOrderPOPay.getWriteOffAmount()).setScale(2, 4));
                verificationBO.setAPPLY_AMOUNT(writeOffamt.getWriteOffAmount().setScale(2, 4));
                verificationBO.setTESCO_ID(fscOrderPOPay.getFscOrderId());
                advanceCharge.add(verificationBO);
            }
        }
        if (orderWriteOffAmt.compareTo(writeOffAmt) < 0) {
            throw new FscBusinessException("191026", "\u6240\u6709\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u603b\u91d1\u989d");
        }
        if (fscOrderPO.getTotalCharge().compareTo(writeOffAmt) < 0) {
            throw new FscBusinessException("191026", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7ed3\u7b97\u91d1\u989d");
        }
        if (writeOffAmt.compareTo(BigDecimal.ZERO) == 0) {
            FscPayVerificationAbilityReqBO verificationAbilityReqBO = new FscPayVerificationAbilityReqBO();
            verificationAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            verificationAbilityReqBO.setPageNo(Integer.valueOf(1));
            verificationAbilityReqBO.setPageSize(Integer.valueOf(1));
            FscPayVerificationAbilityRspBO verificationAbilityRspBO = this.fscPayVerificationAbilityService.queryPayVerificationPageList(verificationAbilityReqBO);
            if (verificationAbilityRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Collection)verificationAbilityRspBO.getRows())) {
                throw new FscBusinessException("191026", "\u7ed3\u7b97\u5355\u4e2d\u6709\u8ba2\u5355\u4e3a\u8fdb\u884c\u9884\u6536\u8ba4\u9886\uff0c\u8bf7\u5148\u8ba4\u9886\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u5f00\u7968\u3002");
            }
        }
        fscBillTaxSendPurFscOrderToYCReqBO.setAdvanceCharge(advanceCharge);
        fscBillTaxSendPurFscOrderToYCReqBO.setPurchaseSettlement(purchaseSettlement);
        fscBillTaxSendPurFscOrderToYCReqBO.setYcUserId(reqBO.getYcUserId());
        FscBillTaxSendPurFscOrderToYCRspBO fscBillTaxSendPurFscOrderToYCRspBO = this.fscBillTaxSendPurFscOrderToYCService.sendPurFscOrder(fscBillTaxSendPurFscOrderToYCReqBO);
        FscBillDealPushLogAbilityReqBO abilityReqBO = new FscBillDealPushLogAbilityReqBO();
        abilityReqBO.setCreateTime(new Date());
        abilityReqBO.setObjectId(fscOrderPO.getFscOrderId());
        abilityReqBO.setObjectNo(fscOrderPO.getOrderNo());
        abilityReqBO.setType(FscConstants.FscPushType.SETTLE);
        abilityReqBO.setObjData(JSONObject.toJSONString((Object)fscBillTaxSendPurFscOrderToYCReqBO));
        if (!fscBillTaxSendPurFscOrderToYCRspBO.getRespCode().equals("0000")) {
            abilityReqBO.setStatus(FscConstants.FscPushStatus.FAIL);
            this.fscBillAddPushLogAbilityService.savePushLog(abilityReqBO);
            throw new FscBusinessException("191026", "\u63a8\u9001\u4e1a\u8d22\u5931\u8d25\uff01" + fscBillTaxSendPurFscOrderToYCRspBO.getRespDesc());
        }
        abilityReqBO.setStatus(FscConstants.FscPushStatus.SUCCESS);
        this.fscBillAddPushLogAbilityService.savePushLog(abilityReqBO);
    }
}

