/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderApplyAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderToYCAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderToYCAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillSendSaleFscOrderApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderApplyBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderApplyAbilityService"})
public class FscBillSendSaleFscOrderApplyAbilityServiceImpl
implements FscBillSendSaleFscOrderApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSendSaleFscOrderApplyAbilityServiceImpl.class);
    @Autowired
    private FscBillSendSaleFscOrderApplyBusiService fscBillSendSaleFscOrderApplyBusiService;
    @Autowired
    private FscBillSendSaleFscOrderToYCAbilityService fscBillSendSaleFscOrderToYCAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @FscDuplicateCommitLimit
    @PostMapping(value={"sendSaleFscOrderApply"})
    public FscBillSendSaleFscOrderApplyAbilityRspBO sendSaleFscOrderApply(@RequestBody FscBillSendSaleFscOrderApplyAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscBillSendSaleFscOrderApplyBusiReqBO busiReqBO = (FscBillSendSaleFscOrderApplyBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillSendSaleFscOrderApplyBusiReqBO.class));
        FscBillSendSaleFscOrderApplyBusiRspBO busiRspBO = this.fscBillSendSaleFscOrderApplyBusiService.dealSendSaleFscOrderApply(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            return (FscBillSendSaleFscOrderApplyAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscBillSendSaleFscOrderApplyAbilityRspBO.class);
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getPushOrderIds())) {
            FscBillSendSaleFscOrderToYCAbilityReqBO sendReqBO = new FscBillSendSaleFscOrderToYCAbilityReqBO();
            sendReqBO.setFscOrderIds(busiRspBO.getPushOrderIds());
            this.fscBillSendSaleFscOrderToYCAbilityService.sendSaleFscOrder(sendReqBO);
        }
        this.sendMq(reqBO.getFscOrderIds());
        return new FscBillSendSaleFscOrderApplyAbilityRspBO();
    }

    private void valid(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u53c2\u6570[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) {
            if (reqBO.getDeptId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[deptId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getDeptName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[deptName]\u4e3a\u7a7a");
            }
            if (reqBO.getPersonId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[personId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getPersonName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[personName]\u4e3a\u7a7a");
            }
            if (reqBO.getYcUserId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[ycUserId]\u4e3a\u7a7a");
            }
        }
    }

    private void sendMq(List<Long> orderIds) {
        for (Long orderId : orderIds) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(orderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
    }

    private void valItem(FscOrderPO fscOrderPO) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
            for (FscOrderItemPO fscOrderItemPOFor : fscOrderItemPOList) {
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setOrderId(fscOrderItemPOFor.getOrderId());
                fscShouldPayPO.setBuyerNo(fscOrderPO.getBuynerNo());
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                statusList.add(FscConstants.ShouldPayStatus.TO_PAY);
                statusList.add(FscConstants.ShouldPayStatus.PART_PAY);
                statusList.add(FscConstants.ShouldPayStatus.PAYED);
                statusList.add(FscConstants.ShouldPayStatus.TO_RELIEF);
                fscShouldPayPO.setShouldPayStatusList(statusList);
                List fscShouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
                if (null == fscShouldPayPOList) continue;
                for (FscShouldPayPO fscShouldPayPOFor : fscShouldPayPOList) {
                    if (!FscConstants.ShouldObjectType.SALE_ORDER.equals(fscShouldPayPOFor.getObjectType()) && !FscConstants.ShouldObjectType.CHECK_ORDER.equals(fscShouldPayPOFor.getObjectType()) && !FscConstants.ShouldObjectType.DELIVER_ORDER.equals(fscShouldPayPOFor.getObjectType()) || !FscConstants.ShouldPayType.ADVANCE_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.PAYMENT_PRE_PAY.equals(fscShouldPayPOFor.getShouldPayType()) || fscShouldPayPOFor.getShouldPayAmount().compareTo(fscShouldPayPOFor.getClaimAmt()) <= 0) continue;
                    throw new FscBusinessException("191026", "\u7ed3\u7b97\u5355\u4e2d\u6709\u8ba2\u5355\u4e3a\u8fdb\u884c\u9884\u6536\u8ba4\u9886\uff0c\u8bf7\u5148\u8ba4\u9886\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u5f00\u7968\u3002");
                }
            }
        }
    }
}

