/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.atom.api.FscPushYcMemInvoiceAtomService;
import com.tydic.fsc.bill.atom.bo.FscPushYcMemInvoiceAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscPushYcMemInvoiceAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCInvoiceItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCSettlementInfoBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillTaxSendSaleFscOrderToYCVerificationBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillTaxSendSaleFscOrderToYCService;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscWriteOffMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscWriteOffPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPushYcMemInvoiceAtomServiceImpl
implements FscPushYcMemInvoiceAtomService {
    @Autowired
    FscBillTaxSendSaleFscOrderToYCService fscBillTaxSendSaleFscOrderToYCService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;
    @Value(value="${fsc.invoice.priceMode:N}")
    private String priceMode;
    @Value(value="${fsc.member.invoice.taxCode.itemDescription:\u4f1a\u5458\u8d39}")
    private String itemDescription;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscWriteOffMapper fscWriteOffMapper;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;

    @Override
    public FscPushYcMemInvoiceAtomRspBO dealPushMemInvoice(FscPushYcMemInvoiceAtomReqBO reqBO) {
        FscOrderPO orderPo = new FscOrderPO();
        orderPo.setFscOrderId(reqBO.getFscOrderId());
        orderPo = this.fscOrderMapper.getModelBy(orderPo);
        if (orderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        FscOrderInvoicePO orderInvoicePo = new FscOrderInvoicePO();
        orderInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        orderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(orderInvoicePo);
        if (orderInvoicePo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5f00\u7968\u4fe1\u606f\uff01");
        }
        FscOrderItemPO orderItemPo = new FscOrderItemPO();
        orderItemPo.setFscOrderId(reqBO.getFscOrderId());
        orderItemPo = this.fscOrderItemMapper.getModelBy(orderItemPo);
        if (orderItemPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5f00\u7968\u660e\u7ec6\u4fe1\u606f\uff01");
        }
        FscDicDictionaryExernalPO dicDictionaryExernalPO = new FscDicDictionaryExernalPO();
        dicDictionaryExernalPO.setExernalSysCode("YC");
        List fscDicDictionaryExernalPOList = this.fscDicDictionaryExernalMapper.getListByCondition(dicDictionaryExernalPO);
        Integer orderSource = orderPo.getOrderType();
        List fscTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_ORDER_SOURCE")).filter(p -> p.getCode().equals(orderSource + "")).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
        String invoiceType = orderInvoicePo.getInvoiceType();
        List invoiceTypeList = fscDicDictionaryExernalPOList.stream().filter(p -> p.getPCode().equals("FSC_INVOICE_TYPE_SALE")).filter(p -> p.getCode().equals(invoiceType)).map(FscDicDictionaryExernalPO::getExernalCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fscTypeList)) {
            throw new FscBusinessException("193128", "\u7ed3\u7b97\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
        }
        if (CollectionUtils.isEmpty(invoiceTypeList)) {
            throw new FscBusinessException("193128", "\u53d1\u7968\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
        }
        FscBillTaxSendSaleFscOrderToYCSettlementInfoBO saleSettlementInfo = new FscBillTaxSendSaleFscOrderToYCSettlementInfoBO();
        saleSettlementInfo.setORG_ID(this.operOrgId);
        saleSettlementInfo.setORG_NAME(this.operOrgName);
        saleSettlementInfo.setDEPT_ID(orderPo.getYcDeptId() + "");
        saleSettlementInfo.setDEPT_NAME(orderPo.getYcDeptName());
        saleSettlementInfo.setCHARGEMAN_ID(orderPo.getYcUserId() + "");
        saleSettlementInfo.setCHARGEMAN_NAME(orderPo.getYcUserName());
        saleSettlementInfo.setSETTLE_NUMBER(orderPo.getOrderNo());
        saleSettlementInfo.setSETTLE_NAME(orderPo.getOrderName());
        saleSettlementInfo.setOE_CNT_NUMBER(orderPo.getContractNo());
        saleSettlementInfo.setOE_CNT_NAME("");
        saleSettlementInfo.setSETTLE_TYPE((String)fscTypeList.get(0));
        saleSettlementInfo.setTWO_CUSTOMER_NAME(null);
        saleSettlementInfo.setOE_CNT_IN_TAX_AMT(null);
        saleSettlementInfo.setTHIS_SETTLE_AMT(orderPo.getTotalCharge().setScale(2, 4));
        saleSettlementInfo.setINVOICE_TYPE((String)invoiceTypeList.get(0));
        saleSettlementInfo.setIDENTIFICATION_NUMBER(orderInvoicePo.getTaxNo());
        saleSettlementInfo.setCUSTOMER_ADRESS_PHONE(orderInvoicePo.getAddress().trim() + " " + orderInvoicePo.getPhone().trim());
        saleSettlementInfo.setBANK_ACCOUNT_INFO(orderInvoicePo.getBank().trim() + " " + orderInvoicePo.getAccount().trim());
        saleSettlementInfo.setSETTLE_DATE(DateUtil.dateToStr((Date)new Date()));
        saleSettlementInfo.setINVOICE_REMARKS(orderPo.getRemark());
        saleSettlementInfo.setTESCO_SETTLE_ID(orderPo.getFscOrderId());
        saleSettlementInfo.setTESCO_EMAIL(orderInvoicePo.getReceiveEmail());
        saleSettlementInfo.setTESCO_ID(orderPo.getFscOrderId());
        saleSettlementInfo.setTAX_RATE(orderItemPo.getTaxRate().multiply(new BigDecimal(100)));
        saleSettlementInfo.setPRICE_MODE(this.priceMode);
        saleSettlementInfo.setTHIS_BILL_AMT_IN_TAX(orderPo.getTotalCharge().setScale(2, 4));
        saleSettlementInfo.setTHIS_BILL_AMT_NO_TAX(saleSettlementInfo.getTHIS_BILL_AMT_IN_TAX().subtract(orderItemPo.getTaxAmt()));
        saleSettlementInfo.setTHIS_BILL_TAX_AMT(orderItemPo.getTaxAmt());
        saleSettlementInfo.setTHIS_COST_AMT(BigDecimal.ZERO);
        saleSettlementInfo.setTHIS_COST_AMT_IN_TAX(BigDecimal.ZERO);
        FscGetErpCustInfoReqBO custInfoReqBO = new FscGetErpCustInfoReqBO();
        custInfoReqBO.setCustomerName(orderInvoicePo.getBuyName());
        FscGetErpCustInfoRspBO erpCustInfo = this.fscGetErpCustInfoService.getErpCustInfo(custInfoReqBO);
        if (!erpCustInfo.getRespCode().equals("0000")) {
            throw new FscBusinessException(erpCustInfo.getRespCode(), erpCustInfo.getRespDesc());
        }
        saleSettlementInfo.setCUSTOMER_ID(erpCustInfo.getCustAccountId());
        saleSettlementInfo.setCUSTOMER_NAME(erpCustInfo.getCustAccountName());
        ArrayList<FscBillTaxSendSaleFscOrderToYCInvoiceItemBO> invoiceItemBOList = new ArrayList<FscBillTaxSendSaleFscOrderToYCInvoiceItemBO>();
        FscBillTaxSendSaleFscOrderToYCInvoiceItemBO fscInvoiceItemBO = new FscBillTaxSendSaleFscOrderToYCInvoiceItemBO();
        fscInvoiceItemBO.setITEM_DESCRIPTION(this.itemDescription);
        fscInvoiceItemBO.setITEM_NUMBER(orderItemPo.getModel());
        fscInvoiceItemBO.setUNIT_OF_UOM(orderItemPo.getUnit());
        fscInvoiceItemBO.setQUANTITY(orderItemPo.getNum());
        fscInvoiceItemBO.setUNIT_PRICE_NO_TAX(orderItemPo.getPrice().divide(BigDecimal.ONE.add(orderItemPo.getTaxRate()), 8, 4));
        fscInvoiceItemBO.setUNIT_PRICE_WITH_TAX(orderItemPo.getPrice());
        fscInvoiceItemBO.setCOST(BigDecimal.ZERO);
        fscInvoiceItemBO.setTOTAL_AMT_WITH_TAX(orderItemPo.getAmt().setScale(2, 4));
        fscInvoiceItemBO.setTOTAL_AMT_NO_TAX(orderItemPo.getUntaxAmt().setScale(2, 4));
        fscInvoiceItemBO.setTAX_AMT(fscInvoiceItemBO.getTOTAL_AMT_WITH_TAX().subtract(fscInvoiceItemBO.getTOTAL_AMT_NO_TAX()));
        fscInvoiceItemBO.setCONTRACT_NUMBER(orderPo.getOrderNo());
        fscInvoiceItemBO.setVENDOR_NAME(orderPo.getSupplierName());
        fscInvoiceItemBO.setTAX_CLASS(orderItemPo.getTaxCode());
        fscInvoiceItemBO.setTESCO_ID(orderItemPo.getId());
        fscInvoiceItemBO.setTESCO_ORDER_ID(orderItemPo.getOrderId());
        fscInvoiceItemBO.setTESCO_COMMODITY_ID(orderItemPo.getSkuId());
        fscInvoiceItemBO.setTESCO_COMMODITY_NAME(orderItemPo.getSkuName());
        fscInvoiceItemBO.setTESCO_ACCEPT_ID(orderItemPo.getAcceptOrderId());
        invoiceItemBOList.add(fscInvoiceItemBO);
        ArrayList<FscBillTaxSendSaleFscOrderToYCVerificationBO> saleSettlementPaymentInfo = new ArrayList<FscBillTaxSendSaleFscOrderToYCVerificationBO>();
        ArrayList<FscClaimDetailPO> claimList = new ArrayList<FscClaimDetailPO>();
        ArrayList<FscWriteOffPO> writeOffList = new ArrayList<FscWriteOffPO>();
        ArrayList<FscOrderWriteRelationPO> writeRelationList = new ArrayList<FscOrderWriteRelationPO>();
        orderPo.setOrderId(orderItemPo.getOrderId());
        this.buildSettlementInfo(saleSettlementPaymentInfo, orderPo, claimList, writeOffList, writeRelationList);
        saleSettlementInfo.setTHIS_WRITE_OFF_AMT(orderPo.getWriteOffAmount());
        FscBillTaxSendSaleFscOrderToYCReqBO sendSaleFscOrderToYCReqBO = new FscBillTaxSendSaleFscOrderToYCReqBO();
        sendSaleFscOrderToYCReqBO.setSaleSettlementInfo(saleSettlementInfo);
        sendSaleFscOrderToYCReqBO.setSaleSettlementMaterial(invoiceItemBOList);
        sendSaleFscOrderToYCReqBO.setSaleSettlementPaymentInfo(saleSettlementPaymentInfo);
        FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
        logAbilityReqBO.setCreateTime(new Date());
        logAbilityReqBO.setObjectId(orderPo.getFscOrderId());
        logAbilityReqBO.setObjectNo(orderPo.getOrderNo());
        logAbilityReqBO.setType(FscConstants.FscPushType.SETTLE);
        logAbilityReqBO.setObjData(JSONObject.toJSONString((Object)sendSaleFscOrderToYCReqBO));
        logAbilityReqBO.setStatus(FscConstants.FscPushStatus.SUCCESS);
        FscBillTaxSendSaleFscOrderToYCRspBO fscBillTaxSendSaleFscOrderToYCRspBO = this.fscBillTaxSendSaleFscOrderToYCService.sendSaleFscOrder(sendSaleFscOrderToYCReqBO);
        if (!fscBillTaxSendSaleFscOrderToYCRspBO.getRespCode().equals("0000")) {
            logAbilityReqBO.setStatus(FscConstants.FscPushStatus.FAIL);
        } else {
            this.saveWriteOff(claimList, writeOffList, orderPo, writeRelationList);
        }
        this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
        return (FscPushYcMemInvoiceAtomRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fscBillTaxSendSaleFscOrderToYCRspBO), FscPushYcMemInvoiceAtomRspBO.class));
    }

    private void buildSettlementInfo(List<FscBillTaxSendSaleFscOrderToYCVerificationBO> saleSettlementPaymentInfo, FscOrderPO fscOrderPO, List<FscClaimDetailPO> claimList, List<FscWriteOffPO> writeOffList, List<FscOrderWriteRelationPO> writeRelationList) {
        FscClaimDetailPO fscClaimDetailPo = new FscClaimDetailPO();
        fscClaimDetailPo.setOrderIds(Collections.singleton(fscOrderPO.getOrderId()));
        List claimDetailList = this.fscClaimDetailMapper.getWriteOffPay(fscClaimDetailPo);
        if (CollectionUtils.isEmpty((Collection)claimDetailList)) {
            throw new BusinessException("198888", "\u8ba4\u9886\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        BigDecimal fscOrderItemWriteOffAmount = new BigDecimal(0);
        for (FscClaimDetailPO claimDetailPO : claimDetailList) {
            if (null == claimDetailPO.getWriteOffAmount()) {
                claimDetailPO.setWriteOffAmount(new BigDecimal(0));
            }
            FscBillTaxSendSaleFscOrderToYCVerificationBO verificationBO = new FscBillTaxSendSaleFscOrderToYCVerificationBO();
            BigDecimal noWriteOffAmount = claimDetailPO.getClaimAmt().subtract(claimDetailPO.getWriteOffAmount());
            FscWriteOffPO fscWriteOffPO = new FscWriteOffPO();
            fscWriteOffPO.setWriteOffId(Long.valueOf(Sequence.getInstance().nextId()));
            fscWriteOffPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscWriteOffPO.setFscOrderNo(fscOrderPO.getOrderNo());
            fscWriteOffPO.setClaimId(claimDetailPO.getClaimId());
            fscWriteOffPO.setHandleUserId(claimDetailPO.getHandleUserId());
            fscWriteOffPO.setHandleUserName(claimDetailPO.getHandleUserName());
            fscWriteOffPO.setHandleDeptId(claimDetailPO.getHandleDeptId());
            fscWriteOffPO.setHandleDeptName(claimDetailPO.getHandleDeptName());
            fscWriteOffPO.setClaimType(claimDetailPO.getClaimType());
            fscWriteOffPO.setOrderId(claimDetailPO.getOrderId());
            fscWriteOffPO.setOrderCode(claimDetailPO.getOrderCode());
            fscWriteOffPO.setBuynerNo(fscOrderPO.getBuynerNo());
            fscWriteOffPO.setBuynerName(fscOrderPO.getBuynerName());
            fscWriteOffPO.setTotalCharge(fscOrderPO.getTotalCharge().setScale(2, 4));
            fscWriteOffPO.setOrderAmount(fscOrderPO.getTotalCharge().setScale(2, 4));
            fscWriteOffPO.setPayerId(fscOrderPO.getPayerId());
            fscWriteOffPO.setPayerName(fscOrderPO.getPayerName());
            fscWriteOffPO.setWriteOffDate(new Date());
            fscWriteOffPO.setStatus(Integer.valueOf(1));
            fscWriteOffPO.setThisAmount(claimDetailPO.getClaimAmt());
            fscWriteOffPO.setWriteOffAmount(claimDetailPO.getClaimAmt());
            FscOrderWriteRelationPO fscOrderWriteRelationPO = new FscOrderWriteRelationPO();
            fscOrderWriteRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderWriteRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscOrderWriteRelationPO.setClaimDetailId(claimDetailPO.getClaimDetailId());
            fscOrderWriteRelationPO.setClaimId(claimDetailPO.getClaimId());
            fscOrderWriteRelationPO.setClaimAmt(claimDetailPO.getClaimAmt());
            fscOrderWriteRelationPO.setWriteOffAmount(claimDetailPO.getClaimAmt());
            fscOrderWriteRelationPO.setWriteOffDate(new Date());
            fscOrderWriteRelationPO.setClaimNo(claimDetailPO.getClaimNo());
            FscOrderPO payPo = new FscOrderPO();
            payPo.setFscOrderId(claimDetailPO.getOrderId());
            payPo = this.fscOrderMapper.getModelBy(payPo);
            fscOrderWriteRelationPO.setObjectNo(payPo.getOrderNo());
            writeRelationList.add(fscOrderWriteRelationPO);
            verificationBO.setRECEIPT_NUMBER(claimDetailPO.getDetailNo());
            verificationBO.setAMOUNT(claimDetailPO.getClaimAmt());
            verificationBO.setAMOUNT_APPLIED(claimDetailPO.getWriteOffAmount());
            verificationBO.setAMOUNT_UNAPPLIED(noWriteOffAmount);
            verificationBO.setAPPLY_AMOUNT(claimDetailPO.getClaimAmt());
            verificationBO.setTESCO_ID(claimDetailPO.getClaimDetailId());
            claimDetailPO.setWriteOffAmount(claimDetailPO.getClaimAmt());
            claimDetailPO.setWriteOffDate(new Date());
            fscOrderItemWriteOffAmount = fscOrderItemWriteOffAmount.add(verificationBO.getAPPLY_AMOUNT());
            claimList.add(claimDetailPO);
            writeOffList.add(fscWriteOffPO);
            saleSettlementPaymentInfo.add(verificationBO);
        }
        fscOrderPO.setWriteOffAmount(fscOrderItemWriteOffAmount);
    }

    private void saveWriteOff(List<FscClaimDetailPO> claimList, List<FscWriteOffPO> writeOffList, FscOrderPO orderPo, List<FscOrderWriteRelationPO> writeRelationList) {
        if (!CollectionUtils.isEmpty(claimList)) {
            this.fscClaimDetailMapper.updateWriteOffAmountBatchById(claimList);
        }
        if (!CollectionUtils.isEmpty(writeOffList)) {
            this.fscWriteOffMapper.insertBatch(writeOffList);
        }
        if (!CollectionUtils.isEmpty(writeRelationList)) {
            this.fscOrderWriteRelationMapper.insertBatch(writeRelationList);
        }
        this.fscOrderMapper.updateWriteOffAmount(orderPo);
    }
}

