/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillInvoiceStageSplitBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceStageSplitBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceStageSplitBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscPhasePayListBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.uoc.base.constants.UocCoreConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillInvoiceStageSplitBusiServiceImpl
implements FscBillInvoiceStageSplitBusiService {
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;

    @Override
    public FscBillInvoiceStageSplitBusiRspBO dealInvoiceStageSplit(FscBillInvoiceStageSplitBusiReqBO reqBO) {
        FscAcceptOrderListQueryAtomRspBO atomRspBO;
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u7ed3\u7b97\u5355id[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscOrderRelationPO relationPo = new FscOrderRelationPO();
        relationPo.setFscOrderId(reqBO.getFscOrderId());
        List list = this.fscOrderRelationMapper.getList(relationPo);
        Map fscOrderInfoBoMap = new HashMap();
        if (fscOrderPo.getSettleType() == null || fscOrderPo.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscAcceptOrderListQueryAtomReqBO atomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            atomReqBO.setRelId(fscOrderPo.getFscOrderId());
            atomRspBO = this.fscAcceptOrderListQueryAtomService.query(atomReqBO);
            if (!atomRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)atomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
        } else {
            return new FscBillInvoiceStageSplitBusiRspBO();
        }
        fscOrderInfoBoMap = atomRspBO.getFscOrderInfoBoMap();
        BigDecimal shouldPayRadio = BigDecimal.ZERO;
        List payList = new ArrayList();
        Iterator<Object> iterator = fscOrderInfoBoMap.keySet().iterator();
        if (iterator.hasNext()) {
            Long key = (Long)iterator.next();
            FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)fscOrderInfoBoMap.get(key);
            if (fscOrderPo.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE)) {
                if (!CollectionUtils.isEmpty((Collection)fscOrderInfoBO.getPayList())) {
                    payList = fscOrderInfoBO.getPayList();
                }
            } else if (!CollectionUtils.isEmpty((Collection)fscOrderInfoBO.getProPayList())) {
                payList = fscOrderInfoBO.getProPayList();
            }
        }
        if (!CollectionUtils.isEmpty(payList)) {
            for (FscPhasePayListBO payListBO : payList) {
                if (!payListBO.getPayNode().equals(UocCoreConstant.PayNode.SP)) continue;
                shouldPayRadio = payListBO.getNodePayRatio();
            }
        }
        ArrayList<FscOrderRelationPO> updateList = new ArrayList<FscOrderRelationPO>();
        if (shouldPayRadio.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal shouldPayAmount = fscOrderPo.getTotalCharge().multiply(shouldPayRadio).divide(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
            for (FscOrderRelationPO fscOrderRelationPO : list) {
                if (shouldPayAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal settleAmt = fscOrderRelationPO.getSettleAmt().subtract(fscOrderRelationPO.getAmount());
                if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                if (settleAmt.compareTo(shouldPayAmount) >= 0) {
                    fscOrderRelationPO.setAmount(shouldPayAmount);
                    shouldPayAmount = BigDecimal.ZERO;
                } else if (settleAmt.compareTo(shouldPayAmount) < 0) {
                    fscOrderRelationPO.setAmount(fscOrderRelationPO.getSettleAmt());
                    shouldPayAmount = shouldPayAmount.subtract(fscOrderRelationPO.getAmount());
                }
                updateList.add(fscOrderRelationPO);
            }
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.fscOrderRelationMapper.updateAmountBatch(updateList);
        }
        FscBillInvoiceStageSplitBusiRspBO rspBO = new FscBillInvoiceStageSplitBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

