/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.tydic.fsc.bill.busi.api.FscBillSendSaleFscOrderApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderApplyBusiRspBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocPebQryOrderDetailAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrderItemRspBO;
import com.tydic.uoc.common.ability.bo.UocQryOrderItemAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocQryOrderItemListAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillSendSaleFscOrderApplyBusiServiceImpl
implements FscBillSendSaleFscOrderApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSendSaleFscOrderApplyBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private UocPebQryOrderDetailAbilityService uocPebQryOrderDetailAbilityService;

    @Override
    public FscBillSendSaleFscOrderApplyBusiRspBO dealSendSaleFscOrderApply(FscBillSendSaleFscOrderApplyBusiReqBO reqBO) {
        ArrayList<Long> pushOrderIds = new ArrayList<Long>();
        FscBillSendSaleFscOrderApplyBusiRspBO rspBO = new FscBillSendSaleFscOrderApplyBusiRspBO();
        for (Long l : reqBO.getFscOrderIds()) {
            FscOrderPO order = new FscOrderPO();
            order.setFscOrderId(l);
            order = this.fscOrderMapper.getModelBy(order);
            if (FscOrderSendStateEnum.NO_AUDIT.getCode().equals(order.getSendState())) {
                throw new FscBusinessException("191000", order.getOrderNo() + "\u8be5\u7ed3\u7b97\u5355\u5df2\u5728\u5ba1\u6279\u4e2d");
            }
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(order.getFscOrderId());
            List fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemList)) {
                throw new FscBusinessException("193008", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u67e5\u8be2\u7ed3\u7b97\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a\uff01");
            }
            int index = 1;
            for (FscOrderItemPO po : fscOrderItemList) {
                if (StringUtils.isNotBlank((CharSequence)po.getSpecificationsModel()) && po.getSpecificationsModel().length() > 120) {
                    throw new FscBusinessException("193004", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u7b2c" + index + "\u884c\u89c4\u683c\u578b\u53f7\u4e0d\u53ef\u8d85\u8fc7120\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u4e4b\u540e\u8fdb\u884c\u63d0\u4ea4\uff01");
                }
                ++index;
            }
            if (FscConstants.FscInvoiceOrderState.BILLFAIL.equals(order.getOrderState())) {
                pushOrderIds.add(l);
                continue;
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            this.fscOrderMapper.deleteOrderSendTemp(l);
            FscOrderPO fscSendTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
            fscSendTemp.setFscOrderId(l);
            fscSendTemp.setYcDeptId(reqBO.getDeptId().toString());
            fscSendTemp.setYcDeptName(reqBO.getDeptName());
            fscSendTemp.setYcPersonId(reqBO.getPersonId().toString());
            fscSendTemp.setYcPersonName(reqBO.getPersonName());
            fscSendTemp.setBuynerNo(order.getBuynerNo());
            fscSendTemp.setBuynerName(order.getBuynerName());
            log.debug("========\u63a8\u9001\u9500\u552e\u5355\u7533\u8bf7\u4e34\u65f6\u4fdd\u5b58\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscSendTemp));
            this.fscOrderMapper.insertOrderSendTemp(fscSendTemp);
            boolean individuallyPay = !order.getReceiveType().equals(FscConstants.FscOrderReceiveType.INDIVIDUAL);
            Boolean uacFlag = this.invokeUacTask(reqBO, l, individuallyPay);
            if (uacFlag.booleanValue() && individuallyPay) {
                throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
            }
            if (uacFlag.booleanValue()) {
                fscOrderPO.setSendState(FscOrderSendStateEnum.NOT_AUDIT.getCode());
                fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.APPROVAL_PASS);
                pushOrderIds.add(l);
            }
            if (!uacFlag.booleanValue()) {
                FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
                taskPo.setFscOrderId(l);
                List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
                fscOrderPO.setSignApplyTime(new Date());
                if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                    List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
                    fscOrderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
                }
                fscOrderPO.setSendState(FscOrderSendStateEnum.NO_AUDIT.getCode());
                fscOrderPO.setSendApplyTime(new Date());
                fscOrderPO.setSendUserId(reqBO.getUserId());
                fscOrderPO.setSendUserName(reqBO.getName());
            }
            fscOrderPO.setFscOrderId(l);
            fscOrderPO.setOperatorId(reqBO.getUserId());
            fscOrderPO.setOperatorName(reqBO.getName());
            fscOrderPO.setOperatorDeptId(reqBO.getDeptId());
            fscOrderPO.setOperatorDeptName(reqBO.getDeptName());
            if (order.getOperationTime() == null) {
                fscOrderPO.setOperationTime(new Date());
            }
            String operationNo = String.valueOf(reqBO.getOrgId());
            String[] org = this.proOrg.split(",");
            String[] pur = reqBO.getOrgPath().split("-");
            block2: for (String pro : org) {
                for (String t : pur) {
                    if (!pro.equals(t)) continue;
                    operationNo = pro;
                    continue block2;
                }
            }
            fscOrderPO.setOperationNo(operationNo);
            UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            ArrayList<Long> operationNos = new ArrayList<Long>();
            operationNos.add(Long.parseLong(operationNo));
            abilityReqBO.setOrgIdList(operationNos);
            UmcEnterpriseOrgNameListQryAbilityRspBO abilityRspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
            if (abilityRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)abilityRspBO.getOrgMap())) {
                Map orgMap = abilityRspBO.getOrgMap();
                fscOrderPO.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(Long.valueOf(fscOrderPO.getOperationNo()))).getOrgName());
            }
            if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN) && !order.getOrderState().equals(FscConstants.FscInvoiceOrderState.UNBILLED)) {
                this.validSendAndPurchaseCount(order, fscOrderItemList);
                this.dealWorkFlow(order);
            } else if (reqBO.getWebSource() != null && !order.getOrderState().equals(FscConstants.FscInvoiceOrderState.UNBILLED)) {
                this.dealWorkFlow(order);
            }
            if (FscConstants.FscInvoiceOrderState.APPROVAL_REJECT.equals(order.getOrderState())) {
                fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.AUDITING);
            }
            this.fscOrderMapper.updateById(fscOrderPO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPushOrderIds(pushOrderIds);
        return rspBO;
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private void validSendAndPurchaseCount(FscOrderPO order, List<FscOrderItemPO> fscOrderItemList) {
        if (Objects.nonNull(order.getOrderSource()) && !"2".equals(String.valueOf(order.getOrderSource()))) {
            return;
        }
        if (Objects.isNull(order.getPurchaserId())) {
            return;
        }
        ArrayList errorInfoList = new ArrayList();
        List<Long> orderIdList = fscOrderItemList.stream().map(FscOrderItemPO::getOrderId).distinct().collect(Collectors.toList());
        UocQryOrderItemAbilityReqBO uocQryOrderItemAbilityReqBO = new UocQryOrderItemAbilityReqBO();
        uocQryOrderItemAbilityReqBO.setOrderIdList(orderIdList);
        UocQryOrderItemListAbilityRspBO uocQryOrderItemListAbilityRspBO = this.uocPebQryOrderDetailAbilityService.qryOrderItemList(uocQryOrderItemAbilityReqBO);
        orderIdList.forEach(orderId -> {
            if (CollectionUtils.isEmpty((Map)uocQryOrderItemListAbilityRspBO.getOrderErpPushStateMap()) || Objects.isNull(uocQryOrderItemListAbilityRspBO.getOrderErpPushStateMap().get(orderId)) || 1 != (Integer)uocQryOrderItemListAbilityRspBO.getOrderErpPushStateMap().get(orderId)) {
                return;
            }
            if (CollectionUtils.isEmpty((Map)uocQryOrderItemListAbilityRspBO.getOrderItemMap()) || CollectionUtils.isEmpty((Collection)((Collection)uocQryOrderItemListAbilityRspBO.getOrderItemMap().get(orderId)))) {
                return;
            }
            List itemRspBOList = (List)uocQryOrderItemListAbilityRspBO.getOrderItemMap().get(orderId);
            StringBuilder sb = new StringBuilder();
            ArrayList skuIdList = new ArrayList();
            itemRspBOList.forEach(item -> {
                BigDecimal receiptCount = new BigDecimal(item.getExtField5());
                if (receiptCount.compareTo(BigDecimal.ZERO) > 0 && item.getArriveCount().subtract(item.getReturnCount()).compareTo(receiptCount) != 0 && Objects.nonNull(item.getSkuId())) {
                    skuIdList.add(String.valueOf(item.getSkuId()));
                }
            });
            if (!CollectionUtils.isEmpty(skuIdList)) {
                String orderNo = StringUtils.isNotBlank((CharSequence)((UocOrderItemRspBO)itemRspBOList.get(0)).getSaleVoucherNo()) ? ((UocOrderItemRspBO)itemRspBOList.get(0)).getSaleVoucherNo() : orderId.toString();
                sb.append("\u8ba2\u5355").append(orderNo).append("\u4e2d\uff0c\u5546\u54c1\uff1a");
                String skuIdInfo = String.join((CharSequence)"\uff0c", skuIdList);
                sb.append(skuIdInfo).append("\uff1b");
                errorInfoList.add(sb.toString());
            }
        });
        if (!CollectionUtils.isEmpty(errorInfoList)) {
            String errorInfo = String.join((CharSequence)"\uff1b", errorInfoList);
            throw new FscBusinessException("193008", errorInfo + "\u5b9e\u9645\u5165\u5e93\u6570\u91cf\u4e0e\u4f9b\u5e94\u5546\u59a5\u6295\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5728ERP\u8c03\u6574\u51fa\u5165\u5e93\u6570\u91cf\u6216\u5728\u5546\u57ce\u8fdb\u884c\u8ba2\u5355\u5f02\u5e38\u53d8\u66f4\u8c03\u6574\u5b9e\u9645\u5230\u8d27\u6570\u91cf\uff01");
        }
    }

    private Boolean invokeUacTask(FscBillSendSaleFscOrderApplyBusiReqBO reqBO, Long l, Boolean individuallyPay) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(l);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (individuallyPay.booleanValue()) {
            if (FscOrderSourceEnum.ELECTRIC_AREA.getCode().equals(fscOrderPO.getOrderSource()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
                auditCreateReqBO.setMenuId("FSC_ARGEE_DOWN_ORDER_INVOICE_PROCESS");
            } else {
                auditCreateReqBO.setMenuId("M001007");
            }
        } else {
            auditCreateReqBO.setMenuId("M001008");
        }
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(l);
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(l.toString());
        approvalObjBO.setObjName("\u9500\u552e\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        return uacNoTaskAuditCreateRspBO.getNotFindFlag();
    }
}

