/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscOrderWriteRelationListAbilityService;
import com.tydic.fsc.bill.ability.bo.FscOrderWriteRelationListAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscOrderWriteRelationListAbilityRspBO;
import com.tydic.fsc.bo.FscOrderWriteRelationBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscPurWriteOffMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscPurWriteOffPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscOrderWriteRelationListAbilityService"})
public class FscOrderWriteRelationListAbilityServiceImpl
implements FscOrderWriteRelationListAbilityService {
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPurWriteOffMapper fscPurWriteOffMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"getRelationList"})
    public FscOrderWriteRelationListAbilityRspBO getRelationList(@RequestBody FscOrderWriteRelationListAbilityReqBO reqBO) {
        FscOrderWriteRelationListAbilityRspBO rspBO = new FscOrderWriteRelationListAbilityRspBO();
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u7ed3\u7b97\u5355id[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO modelBy = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (reqBO.getIsprofess().equals("0") || "2".equals(modelBy.getOrderSource().toString())) {
            List orderIds;
            List fscOrderPOS;
            FscOrderWriteRelationPO fscOrderWriteRelationPO = new FscOrderWriteRelationPO();
            fscOrderWriteRelationPO.setFscOrderId(reqBO.getFscOrderId());
            List list = this.fscOrderWriteRelationMapper.getList(fscOrderWriteRelationPO);
            List rows = JSON.parseArray((String)JSONObject.toJSONString((Object)list), FscOrderWriteRelationBO.class);
            if (!CollectionUtils.isEmpty((Collection)rows) && ((FscOrderWriteRelationBO)rows.get(0)).getOrderId() != null && !CollectionUtils.isEmpty((Collection)(fscOrderPOS = this.fscOrderMapper.getFscOrderByOrderIds(orderIds = rows.stream().filter(e -> e.getOrderId() != null).map(e -> e.getOrderId()).collect(Collectors.toList()))))) {
                Map fscOrderPOMap = fscOrderPOS.stream().collect(Collectors.toMap(e -> e.getOrderId(), Function.identity(), (e1, e2) -> e2));
                for (FscOrderWriteRelationBO bo : rows) {
                    if (!fscOrderPOMap.containsKey(bo.getOrderId())) continue;
                    bo.setPayOperName(((FscOrderPO)fscOrderPOMap.get(bo.getOrderId())).getPayOperName());
                    bo.setPayOrderId(((FscOrderPO)fscOrderPOMap.get(bo.getOrderId())).getFscOrderId());
                    bo.setPayOrderNo(((FscOrderPO)fscOrderPOMap.get(bo.getOrderId())).getOrderNo());
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRows(rows);
            rspBO.setRecordsTotal(Integer.valueOf(rows.size()));
        } else if ("1".equals(reqBO.getIsprofess())) {
            FscPurWriteOffPO fscPurWriteOffPO = new FscPurWriteOffPO();
            fscPurWriteOffPO.setFscOrderId(reqBO.getFscOrderId());
            List list = this.fscPurWriteOffMapper.getWriteOffList(fscPurWriteOffPO);
            if (CollectionUtils.isEmpty((Collection)list)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
            ArrayList<FscOrderWriteRelationBO> rows = new ArrayList<FscOrderWriteRelationBO>();
            for (FscPurWriteOffPO po : list) {
                FscOrderWriteRelationBO relationBO = new FscOrderWriteRelationBO();
                relationBO.setPayOrderNo(po.getPayOrderNo());
                relationBO.setOrderId(po.getOrderId());
                relationBO.setOrderCode(po.getOrderCode());
                relationBO.setPayOperName(po.getPayOperName());
                relationBO.setClaimAmt(po.getPayAmount());
                relationBO.setWriteOffAmount(po.getWriteOffAmount());
                relationBO.setRemainAmount(po.getPayAmount().subtract(po.getWriteOffAmount() == null ? BigDecimal.ZERO : po.getWriteOffAmount()));
                relationBO.setPayItemId(po.getPayItemId());
                relationBO.setShouldPayId(po.getShouldPayId());
                rows.add(relationBO);
            }
            rspBO.setRows(rows);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRecordsTotal(Integer.valueOf(rows.size()));
        }
        return rspBO;
    }
}

