/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bill.ability.api.FscPayClaimListQueryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscPayClaimListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscPayClaimListQueryAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscPayClaimListQueryBusiService;
import com.tydic.fsc.bill.busi.bo.FscPayClaimListQueryBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPayClaimListQueryBusiRspBO;
import com.tydic.fsc.bo.FscPayClaimBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscPayClaimListQueryAbilityService"})
public class FscPayClaimListQueryAbilityServiceImpl
implements FscPayClaimListQueryAbilityService {
    @Autowired
    private FscPayClaimListQueryBusiService fscPayClaimListQueryBusiService;
    @Value(value="${recvClaim.deleteManagerRole:tenant:10000:caiwujiaose}")
    private String deleteManagerRole;

    @PostMapping(value={"qryPayClaimList"})
    public FscPayClaimListQueryAbilityRspBO qryPayClaimList(@RequestBody FscPayClaimListQueryAbilityReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscPayClaimListQueryBusiReqBO busiReqBO = (FscPayClaimListQueryBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscPayClaimListQueryBusiReqBO.class));
        FscPayClaimListQueryBusiRspBO busiRspBO = this.fscPayClaimListQueryBusiService.qryPayClaimList(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("\u5931\u8d25", busiRspBO.getRespDesc());
        }
        String rspString = JSON.toJSONString((Object)((Object)busiRspBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscPayClaimListQueryAbilityRspBO rspBO = (FscPayClaimListQueryAbilityRspBO)JSON.parseObject((String)rspString, FscPayClaimListQueryAbilityRspBO.class);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAuthPermission()) && reqBO.getAuthPermission().contains(this.deleteManagerRole)) {
            rspBO.setCanDeletePay(Boolean.valueOf(true));
        } else {
            rspBO.setCanDeletePay(Boolean.valueOf(false));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getClaimIds()) && ObjectUtil.isNotEmpty((Object)rspBO.getRows())) {
            Map<Long, FscPayClaimBO> fscClaimMap = rspBO.getRows().stream().collect(Collectors.toMap(FscPayClaimBO::getClaimId, e -> e));
            ArrayList<FscPayClaimBO> claimList = new ArrayList<FscPayClaimBO>();
            for (Long claimId : reqBO.getClaimIds()) {
                if (!ObjectUtil.isNotEmpty((Object)fscClaimMap.get(claimId))) continue;
                claimList.add(fscClaimMap.get(claimId));
            }
            rspBO.setRows(claimList);
        }
        return rspBO;
    }
}

